/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.geom.plane;

import com.jogamp.opengl.math.FloatUtil;
import jogamp.graph.geom.plane.Path2D;
import jogamp.graph.geom.plane.PathIterator;

public class Crossing {
    static final float DELTA = 1.0E-5f;
    static final float ROOT_DELTA = 1.0E-10f;
    public static final int CROSSING = 255;
    static final int UNKNOWN = 254;

    public static int solveQuad(float[] fArray, float[] fArray2) {
        float f2 = fArray[2];
        float f3 = fArray[1];
        float f4 = fArray[0];
        int n2 = 0;
        if ((double)f2 == 0.0) {
            if ((double)f3 == 0.0) {
                return -1;
            }
            fArray2[n2++] = -f4 / f3;
        } else {
            float f5 = f3 * f3 - 4.0f * f2 * f4;
            if ((double)f5 < 0.0) {
                return 0;
            }
            f5 = FloatUtil.sqrt(f5);
            fArray2[n2++] = (-f3 + f5) / (f2 * 2.0f);
            if ((double)f5 != 0.0) {
                fArray2[n2++] = (-f3 - f5) / (f2 * 2.0f);
            }
        }
        return Crossing.fixRoots(fArray2, n2);
    }

    public static int solveCubic(float[] fArray, float[] fArray2) {
        float f2 = fArray[3];
        if (f2 == 0.0f) {
            return Crossing.solveQuad(fArray, fArray2);
        }
        float f3 = fArray[2] / f2;
        float f4 = fArray[1] / f2;
        float f5 = fArray[0] / f2;
        int n2 = 0;
        float f6 = (f3 * f3 - 3.0f * f4) / 9.0f;
        float f7 = (2.0f * f3 * f3 * f3 - 9.0f * f3 * f4 + 27.0f * f5) / 54.0f;
        float f8 = f6 * f6 * f6;
        float f9 = f7 * f7;
        float f10 = -f3 / 3.0f;
        if (f9 < f8) {
            float f11 = FloatUtil.acos(f7 / FloatUtil.sqrt(f8)) / 3.0f;
            float f12 = -2.0f * FloatUtil.sqrt(f6);
            fArray2[n2++] = f12 * FloatUtil.cos(f11) + f10;
            fArray2[n2++] = f12 * FloatUtil.cos(f11 + 2.0943952f) + f10;
            fArray2[n2++] = f12 * FloatUtil.cos(f11 - 2.0943952f) + f10;
        } else {
            float f13 = FloatUtil.pow(FloatUtil.abs(f7) + FloatUtil.sqrt(f9 - f8), 0.33333334f);
            if ((double)f7 > 0.0) {
                f13 = -f13;
            }
            if (-1.0E-10f < f13 && f13 < 1.0E-10f) {
                fArray2[n2++] = f10;
            } else {
                float f14 = f6 / f13;
                fArray2[n2++] = f13 + f14 + f10;
                float f15 = f9 - f8;
                if (-1.0E-10f < f15 && f15 < 1.0E-10f) {
                    fArray2[n2++] = -(f13 + f14) / 2.0f + f10;
                }
            }
        }
        return Crossing.fixRoots(fArray2, n2);
    }

    static int fixRoots(float[] fArray, int n2) {
        int n3 = 0;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if (Crossing.isZero(fArray[i2] - fArray[i3])) continue block0;
            }
            fArray[n3++] = fArray[i2];
        }
        return n3;
    }

    public static int crossLine(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f6 < f2 && f6 < f4 || f6 > f2 && f6 > f4 || f7 > f3 && f7 > f5 || f2 == f4) {
            return 0;
        }
        if (!(f7 < f3 && f7 < f5 || !((f5 - f3) * (f6 - f2) / (f4 - f2) <= f7 - f3))) {
            return 0;
        }
        if (f6 == f2) {
            return f2 < f4 ? 0 : -1;
        }
        if (f6 == f4) {
            return f2 < f4 ? 1 : 0;
        }
        return f2 < f4 ? 1 : -1;
    }

    public static int crossQuad(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f8 < f2 && f8 < f4 && f8 < f6 || f8 > f2 && f8 > f4 && f8 > f6 || f9 > f3 && f9 > f5 && f9 > f7 || f2 == f4 && f4 == f6) {
            return 0;
        }
        if (f9 < f3 && f9 < f5 && f9 < f7 && f8 != f2 && f8 != f6) {
            if (f2 < f6) {
                return f2 < f8 && f8 < f6 ? 1 : 0;
            }
            return f6 < f8 && f8 < f2 ? -1 : 0;
        }
        QuadCurve quadCurve = new QuadCurve(f2, f3, f4, f5, f6, f7);
        float f10 = f8 - f2;
        float f11 = f9 - f3;
        float[] fArray = new float[3];
        int n2 = quadCurve.solvePoint(fArray, f10);
        return quadCurve.cross(fArray, n2, f11, f11);
    }

    public static int crossCubic(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (f10 < f2 && f10 < f4 && f10 < f6 && f10 < f8 || f10 > f2 && f10 > f4 && f10 > f6 && f10 > f8 || f11 > f3 && f11 > f5 && f11 > f7 && f11 > f9 || f2 == f4 && f4 == f6 && f6 == f8) {
            return 0;
        }
        if (f11 < f3 && f11 < f5 && f11 < f7 && f11 < f9 && f10 != f2 && f10 != f8) {
            if (f2 < f8) {
                return f2 < f10 && f10 < f8 ? 1 : 0;
            }
            return f8 < f10 && f10 < f2 ? -1 : 0;
        }
        CubicCurve cubicCurve = new CubicCurve(f2, f3, f4, f5, f6, f7, f8, f9);
        float f12 = f10 - f2;
        float f13 = f11 - f3;
        float[] fArray = new float[3];
        int n2 = cubicCurve.solvePoint(fArray, f12);
        return cubicCurve.cross(fArray, n2, f13, f13);
    }

    public static int crossPath(PathIterator pathIterator, float f2, float f3) {
        int n2 = 0;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    if (f5 != f7 || f4 != f6) {
                        n2 += Crossing.crossLine(f5, f4, f7, f6, f2, f3);
                    }
                    f7 = f5 = fArray[0];
                    f6 = f4 = fArray[1];
                    break;
                }
                case 1: {
                    float f8 = f5;
                    float f9 = f4;
                    f5 = fArray[0];
                    f4 = fArray[1];
                    n2 += Crossing.crossLine(f8, f9, f5, f4, f2, f3);
                    break;
                }
                case 2: {
                    float f10 = f5;
                    float f11 = f4;
                    f5 = fArray[2];
                    f4 = fArray[3];
                    n2 += Crossing.crossQuad(f10, f11, fArray[0], fArray[1], f5, f4, f2, f3);
                    break;
                }
                case 3: {
                    float f12 = f5;
                    float f13 = f4;
                    f5 = fArray[4];
                    f4 = fArray[5];
                    n2 += Crossing.crossCubic(f12, f13, fArray[0], fArray[1], fArray[2], fArray[3], f5, f4, f2, f3);
                    break;
                }
                case 4: {
                    if (f4 == f6 && f5 == f7) break;
                    float f14 = f5;
                    float f15 = f4;
                    f5 = f7;
                    f4 = f6;
                    n2 += Crossing.crossLine(f14, f15, f5, f4, f2, f3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled Segment Type: " + n3);
                }
            }
            if (f2 == f5 && f3 == f4) {
                n2 = 0;
                f4 = f6;
                break;
            }
            pathIterator.next();
        }
        if (f4 != f6) {
            n2 += Crossing.crossLine(f5, f4, f7, f6, f2, f3);
        }
        return n2;
    }

    public static int crossShape(Path2D path2D, float f2, float f3) {
        if (!path2D.getBounds2D().contains(f2, f3)) {
            return 0;
        }
        return Crossing.crossPath(path2D.iterator(null), f2, f3);
    }

    public static boolean isZero(float f2) {
        return -1.0E-5f < f2 && f2 < 1.0E-5f;
    }

    static void sortBound(float[] fArray, int n2) {
        for (int i2 = 0; i2 < n2 - 4; i2 += 4) {
            int n3 = i2;
            for (int i3 = i2 + 4; i3 < n2; i3 += 4) {
                if (!(fArray[n3] > fArray[i3])) continue;
                n3 = i3;
            }
            if (n3 == i2) continue;
            float f2 = fArray[i2];
            fArray[i2] = fArray[n3];
            fArray[n3] = f2;
            f2 = fArray[i2 + 1];
            fArray[i2 + 1] = fArray[n3 + 1];
            fArray[n3 + 1] = f2;
            f2 = fArray[i2 + 2];
            fArray[i2 + 2] = fArray[n3 + 2];
            fArray[n3 + 2] = f2;
            f2 = fArray[i2 + 3];
            fArray[i2 + 3] = fArray[n3 + 3];
            fArray[n3 + 3] = f2;
        }
    }

    static int crossBound(float[] fArray, int n2, float f2, float f3) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        for (n3 = 2; n3 < n2; n3 += 4) {
            if (fArray[n3] < f2) {
                ++n4;
                continue;
            }
            if (fArray[n3] > f3) {
                ++n5;
                continue;
            }
            return 255;
        }
        if (n5 == 0) {
            return 0;
        }
        if (n4 != 0) {
            Crossing.sortBound(fArray, n2);
            n3 = fArray[2] > f3 ? 1 : 0;
            for (int i2 = 6; i2 < n2; i2 += 4) {
                int n6;
                int n7 = n6 = fArray[i2] > f3 ? 1 : 0;
                if (n3 != n6 && fArray[i2 + 1] != fArray[i2 - 3]) {
                    return 255;
                }
                n3 = n6;
            }
        }
        return 254;
    }

    public static int intersectLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f8 < f2 && f8 < f4 || f6 > f2 && f6 > f4 || f7 > f3 && f7 > f5) {
            return 0;
        }
        if (!(f9 < f3) || !(f9 < f5)) {
            float f10;
            float f11;
            if (f2 == f4) {
                return 255;
            }
            if (f2 < f4) {
                f11 = f2 < f6 ? f6 : f2;
                f10 = f4 < f8 ? f4 : f8;
            } else {
                f11 = f4 < f6 ? f6 : f4;
                f10 = f2 < f8 ? f2 : f8;
            }
            float f12 = (f5 - f3) / (f4 - f2);
            float f13 = f12 * (f11 - f2) + f3;
            float f14 = f12 * (f10 - f2) + f3;
            if (f13 < f7 && f14 < f7) {
                return 0;
            }
            if (!(f13 > f9) || !(f14 > f9)) {
                return 255;
            }
        }
        if (f2 == f4) {
            return 0;
        }
        if (f6 == f2) {
            return f2 < f4 ? 0 : -1;
        }
        if (f6 == f4) {
            return f2 < f4 ? 1 : 0;
        }
        if (f2 < f4) {
            return f2 < f6 && f6 < f4 ? 1 : 0;
        }
        return f4 < f6 && f6 < f2 ? -1 : 0;
    }

    public static int intersectQuad(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        int n2;
        if (f10 < f2 && f10 < f4 && f10 < f6 || f8 > f2 && f8 > f4 && f8 > f6 || f9 > f3 && f9 > f5 && f9 > f7) {
            return 0;
        }
        if (f11 < f3 && f11 < f5 && f11 < f7 && f8 != f2 && f8 != f6) {
            if (f2 < f6) {
                return f2 < f8 && f8 < f6 ? 1 : 0;
            }
            return f6 < f8 && f8 < f2 ? -1 : 0;
        }
        QuadCurve quadCurve = new QuadCurve(f2, f3, f4, f5, f6, f7);
        float f12 = f8 - f2;
        float f13 = f9 - f3;
        float f14 = f10 - f2;
        float f15 = f11 - f3;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n3 = quadCurve.solvePoint(fArray, f12);
        int n4 = quadCurve.solvePoint(fArray2, f14);
        if (n3 == 0 && n4 == 0) {
            return 0;
        }
        float f16 = f12 - 1.0E-5f;
        float f17 = f14 + 1.0E-5f;
        float[] fArray3 = new float[28];
        int n5 = 0;
        n5 = quadCurve.addBound(fArray3, n5, fArray, n3, f16, f17, false, 0);
        n5 = quadCurve.addBound(fArray3, n5, fArray2, n4, f16, f17, false, 1);
        n4 = quadCurve.solveExtrem(fArray2);
        n5 = quadCurve.addBound(fArray3, n5, fArray2, n4, f16, f17, true, 2);
        if (f8 < f2 && f2 < f10) {
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 4.0f;
        }
        if (f8 < f6 && f6 < f10) {
            fArray3[n5++] = 1.0f;
            fArray3[n5++] = quadCurve.ax;
            fArray3[n5++] = quadCurve.ay;
            fArray3[n5++] = 5.0f;
        }
        if ((n2 = Crossing.crossBound(fArray3, n5, f13, f15)) != 254) {
            return n2;
        }
        return quadCurve.cross(fArray, n3, f13, f15);
    }

    public static int intersectCubic(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        int n2;
        if (f12 < f2 && f12 < f4 && f12 < f6 && f12 < f8 || f10 > f2 && f10 > f4 && f10 > f6 && f10 > f8 || f11 > f3 && f11 > f5 && f11 > f7 && f11 > f9) {
            return 0;
        }
        if (f13 < f3 && f13 < f5 && f13 < f7 && f13 < f9 && f10 != f2 && f10 != f8) {
            if (f2 < f8) {
                return f2 < f10 && f10 < f8 ? 1 : 0;
            }
            return f8 < f10 && f10 < f2 ? -1 : 0;
        }
        CubicCurve cubicCurve = new CubicCurve(f2, f3, f4, f5, f6, f7, f8, f9);
        float f14 = f10 - f2;
        float f15 = f11 - f3;
        float f16 = f12 - f2;
        float f17 = f13 - f3;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n3 = cubicCurve.solvePoint(fArray, f14);
        int n4 = cubicCurve.solvePoint(fArray2, f16);
        if (n3 == 0 && n4 == 0) {
            return 0;
        }
        float f18 = f14 - 1.0E-5f;
        float f19 = f16 + 1.0E-5f;
        float[] fArray3 = new float[40];
        int n5 = 0;
        n5 = cubicCurve.addBound(fArray3, n5, fArray, n3, f18, f19, false, 0);
        n5 = cubicCurve.addBound(fArray3, n5, fArray2, n4, f18, f19, false, 1);
        n4 = cubicCurve.solveExtremX(fArray2);
        n5 = cubicCurve.addBound(fArray3, n5, fArray2, n4, f18, f19, true, 2);
        n4 = cubicCurve.solveExtremY(fArray2);
        n5 = cubicCurve.addBound(fArray3, n5, fArray2, n4, f18, f19, true, 4);
        if (f10 < f2 && f2 < f12) {
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 0.0f;
            fArray3[n5++] = 6.0f;
        }
        if (f10 < f8 && f8 < f12) {
            fArray3[n5++] = 1.0f;
            fArray3[n5++] = cubicCurve.ax;
            fArray3[n5++] = cubicCurve.ay;
            fArray3[n5++] = 7.0f;
        }
        if ((n2 = Crossing.crossBound(fArray3, n5, f15, f17)) != 254) {
            return n2;
        }
        return cubicCurve.cross(fArray, n3, f15, f17);
    }

    public static int intersectPath(PathIterator pathIterator, float f2, float f3, float f4, float f5) {
        int n2;
        int n3 = 0;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float[] fArray = new float[6];
        float f10 = f2;
        float f11 = f3;
        float f12 = f2 + f4;
        float f13 = f3 + f5;
        while (!pathIterator.isDone()) {
            n2 = 0;
            int n4 = pathIterator.currentSegment(fArray);
            switch (n4) {
                case 0: {
                    if (f7 != f9 || f6 != f8) {
                        n2 = Crossing.intersectLine(f7, f6, f9, f8, f10, f11, f12, f13);
                    }
                    f9 = f7 = fArray[0];
                    f8 = f6 = fArray[1];
                    break;
                }
                case 1: {
                    float f14 = f7;
                    float f15 = f6;
                    f7 = fArray[0];
                    f6 = fArray[1];
                    n2 = Crossing.intersectLine(f14, f15, f7, f6, f10, f11, f12, f13);
                    break;
                }
                case 2: {
                    float f16 = f7;
                    float f17 = f6;
                    f7 = fArray[2];
                    f6 = fArray[3];
                    n2 = Crossing.intersectQuad(f16, f17, fArray[0], fArray[1], f7, f6, f10, f11, f12, f13);
                    break;
                }
                case 3: {
                    float f18 = f7;
                    float f19 = f6;
                    f7 = fArray[4];
                    f6 = fArray[5];
                    n2 = Crossing.intersectCubic(f18, f19, fArray[0], fArray[1], fArray[2], fArray[3], f7, f6, f10, f11, f12, f13);
                    break;
                }
                case 4: {
                    if (f6 != f8 || f7 != f9) {
                        n2 = Crossing.intersectLine(f7, f6, f9, f8, f10, f11, f12, f13);
                    }
                    f7 = f9;
                    f6 = f8;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled Segment Type: " + n4);
                }
            }
            if (n2 == 255) {
                return 255;
            }
            n3 += n2;
            pathIterator.next();
        }
        if (f6 != f8) {
            n2 = Crossing.intersectLine(f7, f6, f9, f8, f10, f11, f12, f13);
            if (n2 == 255) {
                return 255;
            }
            n3 += n2;
        }
        return n3;
    }

    public static int intersectShape(Path2D path2D, float f2, float f3, float f4, float f5) {
        if (!path2D.getBounds2D().intersects2DRegion(f2, f3, f4, f5)) {
            return 0;
        }
        return Crossing.intersectPath(path2D.iterator(null), f2, f3, f4, f5);
    }

    public static boolean isInsideNonZero(int n2) {
        return n2 != 0;
    }

    public static boolean isInsideEvenOdd(int n2) {
        return (n2 & 1) != 0;
    }

    public static class QuadCurve {
        float ax;
        float ay;
        float bx;
        float by;
        float Ax;
        float Ay;
        float Bx;
        float By;

        public QuadCurve(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.ax = f6 - f2;
            this.ay = f7 - f3;
            this.bx = f4 - f2;
            this.by = f5 - f3;
            this.Bx = this.bx + this.bx;
            this.Ax = this.ax - this.Bx;
            this.By = this.by + this.by;
            this.Ay = this.ay - this.By;
        }

        int cross(float[] fArray, int n2, float f2, float f3) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f4;
                float f5 = fArray[i2];
                if (f5 < -1.0E-5f || f5 > 1.00001f) continue;
                if (f5 < 1.0E-5f) {
                    if (!((double)f2 < 0.0)) continue;
                    float f6 = (double)this.bx != 0.0 ? this.bx : this.ax - this.bx;
                    if (!((double)f6 < 0.0)) continue;
                    --n3;
                    continue;
                }
                if (f5 > 0.99999f) {
                    if (!(f2 < this.ay)) continue;
                    float f7 = this.ax != this.bx ? this.ax - this.bx : this.bx;
                    if (!((double)f7 > 0.0)) continue;
                    ++n3;
                    continue;
                }
                float f8 = f5 * (f5 * this.Ay + this.By);
                if (!(f8 > f3) || (f4 = f5 * this.Ax + this.bx) > -1.0E-5f && f4 < 1.0E-5f) continue;
                n3 += (double)f4 > 0.0 ? 1 : -1;
            }
            return n3;
        }

        int solvePoint(float[] fArray, float f2) {
            float[] fArray2 = new float[]{-f2, this.Bx, this.Ax};
            return Crossing.solveQuad(fArray2, fArray);
        }

        int solveExtrem(float[] fArray) {
            int n2 = 0;
            if ((double)this.Ax != 0.0) {
                fArray[n2++] = -this.Bx / (this.Ax + this.Ax);
            }
            if ((double)this.Ay != 0.0) {
                fArray[n2++] = -this.By / (this.Ay + this.Ay);
            }
            return n2;
        }

        int addBound(float[] fArray, int n2, float[] fArray2, int n3, float f2, float f3, boolean bl, int n4) {
            for (int i2 = 0; i2 < n3; ++i2) {
                float f4;
                float f5 = fArray2[i2];
                if (!(f5 > -1.0E-5f) || !(f5 < 1.00001f) || !(f2 <= (f4 = f5 * (f5 * this.Ax + this.Bx))) || !(f4 <= f3)) continue;
                fArray[n2++] = f5;
                fArray[n2++] = f4;
                fArray[n2++] = f5 * (f5 * this.Ay + this.By);
                fArray[n2++] = n4;
                if (!bl) continue;
                ++n4;
            }
            return n2;
        }
    }

    public static class CubicCurve {
        float ax;
        float ay;
        float bx;
        float by;
        float cx;
        float cy;
        float Ax;
        float Ay;
        float Bx;
        float By;
        float Cx;
        float Cy;
        float Ax3;
        float Bx2;

        public CubicCurve(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this.ax = f8 - f2;
            this.ay = f9 - f3;
            this.bx = f4 - f2;
            this.by = f5 - f3;
            this.cx = f6 - f2;
            this.cy = f7 - f3;
            this.Cx = this.bx + this.bx + this.bx;
            this.Bx = this.cx + this.cx + this.cx - this.Cx - this.Cx;
            this.Ax = this.ax - this.Bx - this.Cx;
            this.Cy = this.by + this.by + this.by;
            this.By = this.cy + this.cy + this.cy - this.Cy - this.Cy;
            this.Ay = this.ay - this.By - this.Cy;
            this.Ax3 = this.Ax + this.Ax + this.Ax;
            this.Bx2 = this.Bx + this.Bx;
        }

        int cross(float[] fArray, int n2, float f2, float f3) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f4 = fArray[i2];
                if (f4 < -1.0E-5f || f4 > 1.00001f) continue;
                if (f4 < 1.0E-5f) {
                    if (!((double)f2 < 0.0)) continue;
                    float f5 = (double)this.bx != 0.0 ? this.bx : (this.cx != this.bx ? this.cx - this.bx : this.ax - this.cx);
                    if (!((double)f5 < 0.0)) continue;
                    --n3;
                    continue;
                }
                if (f4 > 0.99999f) {
                    if (!(f2 < this.ay)) continue;
                    float f6 = this.ax != this.cx ? this.ax - this.cx : (this.cx != this.bx ? this.cx - this.bx : this.bx);
                    if (!((double)f6 > 0.0)) continue;
                    ++n3;
                    continue;
                }
                float f7 = f4 * (f4 * (f4 * this.Ay + this.By) + this.Cy);
                if (!(f7 > f3)) continue;
                float f8 = f4 * (f4 * this.Ax3 + this.Bx2) + this.Cx;
                if (f8 > -1.0E-5f && f8 < 1.0E-5f) {
                    f8 = f4 * (this.Ax3 + this.Ax3) + this.Bx2;
                    if (f8 < -1.0E-5f || f8 > 1.0E-5f) continue;
                    f8 = this.ax;
                }
                n3 += (double)f8 > 0.0 ? 1 : -1;
            }
            return n3;
        }

        int solvePoint(float[] fArray, float f2) {
            float[] fArray2 = new float[]{-f2, this.Cx, this.Bx, this.Ax};
            return Crossing.solveCubic(fArray2, fArray);
        }

        int solveExtremX(float[] fArray) {
            float[] fArray2 = new float[]{this.Cx, this.Bx2, this.Ax3};
            return Crossing.solveQuad(fArray2, fArray);
        }

        int solveExtremY(float[] fArray) {
            float[] fArray2 = new float[]{this.Cy, this.By + this.By, this.Ay + this.Ay + this.Ay};
            return Crossing.solveQuad(fArray2, fArray);
        }

        int addBound(float[] fArray, int n2, float[] fArray2, int n3, float f2, float f3, boolean bl, int n4) {
            for (int i2 = 0; i2 < n3; ++i2) {
                float f4;
                float f5 = fArray2[i2];
                if (!(f5 > -1.0E-5f) || !(f5 < 1.00001f) || !(f2 <= (f4 = f5 * (f5 * (f5 * this.Ax + this.Bx) + this.Cx))) || !(f4 <= f3)) continue;
                fArray[n2++] = f5;
                fArray[n2++] = f4;
                fArray[n2++] = f5 * (f5 * (f5 * this.Ay + this.By) + this.Cy);
                fArray[n2++] = n4;
                if (!bl) continue;
                ++n4;
            }
            return n2;
        }
    }
}

