/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.geom.plane;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.geom.plane.NoninvertibleTransformException;
import jogamp.graph.geom.plane.Path2D;

public class AffineTransform
implements Cloneable {
    static final String determinantIsZero = "Determinant is zero";
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_MASK_ROTATION = 24;
    static final int TYPE_UNKNOWN = -1;
    static final float ZERO = 1.0E-10f;
    float m00;
    float m10;
    float m01;
    float m11;
    float m02;
    float m12;
    transient int type;

    public AffineTransform() {
        this.setToIdentity();
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.type = affineTransform.type;
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
    }

    public AffineTransform(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.type = -1;
        this.m00 = f2;
        this.m10 = f3;
        this.m01 = f4;
        this.m11 = f5;
        this.m02 = f6;
        this.m12 = f7;
    }

    public AffineTransform(float[] fArray) {
        this.type = -1;
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 4) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
    }

    public int getType() {
        float f2;
        float f3;
        if (this.type != -1) {
            return this.type;
        }
        int n2 = 0;
        if ((double)(this.m00 * this.m01 + this.m10 * this.m11) != 0.0) {
            return n2 |= 0x20;
        }
        if ((double)this.m02 != 0.0 || (double)this.m12 != 0.0) {
            n2 |= 1;
        } else if ((double)this.m00 == 1.0 && (double)this.m11 == 1.0 && (double)this.m01 == 0.0 && (double)this.m10 == 0.0) {
            n2 = 0;
            return n2;
        }
        if ((double)(this.m00 * this.m11 - this.m01 * this.m10) < 0.0) {
            n2 |= 0x40;
        }
        if ((f3 = this.m00 * this.m00 + this.m10 * this.m10) != (f2 = this.m01 * this.m01 + this.m11 * this.m11)) {
            n2 |= 4;
        } else if ((double)f3 != 1.0) {
            n2 |= 2;
        }
        if ((double)this.m00 == 0.0 && (double)this.m11 == 0.0 || (double)this.m10 == 0.0 && (double)this.m01 == 0.0 && ((double)this.m00 < 0.0 || (double)this.m11 < 0.0)) {
            n2 |= 8;
        } else if ((double)this.m01 != 0.0 || (double)this.m10 != 0.0) {
            n2 |= 0x10;
        }
        return n2;
    }

    public final float getScaleX() {
        return this.m00;
    }

    public final float getScaleY() {
        return this.m11;
    }

    public final float getShearX() {
        return this.m01;
    }

    public final float getShearY() {
        return this.m10;
    }

    public final float getTranslateX() {
        return this.m02;
    }

    public final float getTranslateY() {
        return this.m12;
    }

    public final boolean isIdentity() {
        return this.getType() == 0;
    }

    public final void getMatrix(float[] fArray) {
        fArray[0] = this.m00;
        fArray[1] = this.m10;
        fArray[2] = this.m01;
        fArray[3] = this.m11;
        if (fArray.length > 4) {
            fArray[4] = this.m02;
            fArray[5] = this.m12;
        }
    }

    public final float getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public final AffineTransform setTransform(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.type = -1;
        this.m00 = f2;
        this.m10 = f3;
        this.m01 = f4;
        this.m11 = f5;
        this.m02 = f6;
        this.m12 = f7;
        return this;
    }

    public final AffineTransform setTransform(AffineTransform affineTransform) {
        this.type = affineTransform.type;
        this.setTransform(affineTransform.m00, affineTransform.m10, affineTransform.m01, affineTransform.m11, affineTransform.m02, affineTransform.m12);
        return this;
    }

    public final AffineTransform setToIdentity() {
        this.type = 0;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        return this;
    }

    public final AffineTransform setToTranslation(float f2, float f3) {
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m10 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = f2;
        this.m12 = f3;
        this.type = f2 == 0.0f && f3 == 0.0f ? 0 : 1;
        return this;
    }

    public final AffineTransform setToScale(float f2, float f3) {
        this.m00 = f2;
        this.m11 = f3;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.type = f2 != 1.0f || f3 != 1.0f ? -1 : 0;
        return this;
    }

    public final AffineTransform setToShear(float f2, float f3) {
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = f2;
        this.m10 = f3;
        this.type = f2 != 0.0f || f3 != 0.0f ? -1 : 0;
        return this;
    }

    public final AffineTransform setToRotation(float f2) {
        float f3 = FloatUtil.sin(f2);
        float f4 = FloatUtil.cos(f2);
        if (FloatUtil.abs(f4) < 1.0E-10f) {
            f4 = 0.0f;
            f3 = f3 > 0.0f ? 1.0f : -1.0f;
        } else if (FloatUtil.abs(f3) < 1.0E-10f) {
            f3 = 0.0f;
            f4 = f4 > 0.0f ? 1.0f : -1.0f;
        }
        this.m00 = this.m11 = f4;
        this.m01 = -f3;
        this.m10 = f3;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        this.type = -1;
        return this;
    }

    public final AffineTransform setToRotation(float f2, float f3, float f4) {
        this.setToRotation(f2);
        this.m02 = f3 * (1.0f - this.m00) + f4 * this.m10;
        this.m12 = f4 * (1.0f - this.m00) - f3 * this.m10;
        this.type = -1;
        return this;
    }

    public final AffineTransform translate(float f2, float f3, AffineTransform affineTransform) {
        return this.concatenate(affineTransform.setToTranslation(f2, f3));
    }

    public final AffineTransform scale(float f2, float f3, AffineTransform affineTransform) {
        return this.concatenate(affineTransform.setToScale(f2, f3));
    }

    public final AffineTransform shear(float f2, float f3, AffineTransform affineTransform) {
        return this.concatenate(affineTransform.setToShear(f2, f3));
    }

    public final AffineTransform rotate(float f2, AffineTransform affineTransform) {
        return this.concatenate(affineTransform.setToRotation(f2));
    }

    public final AffineTransform rotate(float f2, float f3, float f4, AffineTransform affineTransform) {
        return this.concatenate(affineTransform.setToRotation(f2, f3, f4));
    }

    public static final AffineTransform multiply(AffineTransform affineTransform, AffineTransform affineTransform2) {
        return new AffineTransform(affineTransform2.m00 * affineTransform.m00 + affineTransform2.m10 * affineTransform.m01, affineTransform2.m00 * affineTransform.m10 + affineTransform2.m10 * affineTransform.m11, affineTransform2.m01 * affineTransform.m00 + affineTransform2.m11 * affineTransform.m01, affineTransform2.m01 * affineTransform.m10 + affineTransform2.m11 * affineTransform.m11, affineTransform2.m02 * affineTransform.m00 + affineTransform2.m12 * affineTransform.m01 + affineTransform.m02, affineTransform2.m02 * affineTransform.m10 + affineTransform2.m12 * affineTransform.m11 + affineTransform.m12);
    }

    public final AffineTransform concatenate(AffineTransform affineTransform) {
        this.type = -1;
        this.setTransform(affineTransform.m00 * this.m00 + affineTransform.m10 * this.m01, affineTransform.m00 * this.m10 + affineTransform.m10 * this.m11, affineTransform.m01 * this.m00 + affineTransform.m11 * this.m01, affineTransform.m01 * this.m10 + affineTransform.m11 * this.m11, affineTransform.m02 * this.m00 + affineTransform.m12 * this.m01 + this.m02, affineTransform.m02 * this.m10 + affineTransform.m12 * this.m11 + this.m12);
        return this;
    }

    public final AffineTransform preConcatenate(AffineTransform affineTransform) {
        this.type = -1;
        this.setTransform(this.m00 * affineTransform.m00 + this.m10 * affineTransform.m01, this.m00 * affineTransform.m10 + this.m10 * affineTransform.m11, this.m01 * affineTransform.m00 + this.m11 * affineTransform.m01, this.m01 * affineTransform.m10 + this.m11 * affineTransform.m11, this.m02 * affineTransform.m00 + this.m12 * affineTransform.m01 + affineTransform.m02, this.m02 * affineTransform.m10 + this.m12 * affineTransform.m11 + affineTransform.m12);
        return this;
    }

    public final AffineTransform createInverse() throws NoninvertibleTransformException {
        float f2 = this.getDeterminant();
        if (FloatUtil.abs(f2) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        return new AffineTransform(this.m11 / f2, -this.m10 / f2, -this.m01 / f2, this.m00 / f2, (this.m01 * this.m12 - this.m11 * this.m02) / f2, (this.m10 * this.m02 - this.m00 * this.m12) / f2);
    }

    public final AABBox transform(AABBox aABBox, AABBox aABBox2) {
        float[] fArray = aABBox.getLow();
        float[] fArray2 = aABBox.getHigh();
        aABBox2.setSize(fArray[0] * this.m00 + fArray[1] * this.m01 + this.m02, fArray[0] * this.m10 + fArray[1] * this.m11 + this.m12, fArray[2], fArray2[0] * this.m00 + fArray2[1] * this.m01 + this.m02, fArray2[0] * this.m10 + fArray2[1] * this.m11 + this.m12, fArray2[2]);
        return aABBox2;
    }

    public final Vertex transform(Vertex vertex, Vertex vertex2) {
        float f2 = vertex.getX();
        float f3 = vertex.getY();
        vertex2.setCoord(f2 * this.m00 + f3 * this.m01 + this.m02, f2 * this.m10 + f3 * this.m11 + this.m12, vertex.getZ());
        return vertex2;
    }

    public final void transform(Vertex[] vertexArray, int n2, Vertex[] vertexArray2, int n3, int n4) {
        while (--n4 >= 0) {
            Vertex vertex = vertexArray[n2++];
            Vertex vertex2 = vertexArray2[n3];
            if (vertex2 == null) {
                throw new IllegalArgumentException("dst[" + n3 + "] is null");
            }
            float f2 = vertex.getX();
            float f3 = vertex.getY();
            vertex2.setCoord(f2 * this.m00 + f3 * this.m01 + this.m02, f2 * this.m10 + f3 * this.m11 + this.m12, vertex.getZ());
            vertexArray2[n3++] = vertex2;
        }
    }

    public final float[] transform(float[] fArray, float[] fArray2) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        fArray2[0] = f2 * this.m00 + f3 * this.m01 + this.m02;
        fArray2[1] = f2 * this.m10 + f3 * this.m11 + this.m12;
        return fArray2;
    }

    public final void transform(float[] fArray, int n2, float[] fArray2, int n3) {
        float f2 = fArray[n2 + 0];
        float f3 = fArray[n2 + 1];
        fArray2[n3 + 0] = f2 * this.m00 + f3 * this.m01 + this.m02;
        fArray2[n3 + 1] = f2 * this.m10 + f3 * this.m11 + this.m12;
    }

    public final void transform(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        int n5 = 2;
        if (fArray == fArray2 && n2 < n3 && n3 < n2 + n4 * 2) {
            n2 = n2 + n4 * 2 - 2;
            n3 = n3 + n4 * 2 - 2;
            n5 = -2;
        }
        while (--n4 >= 0) {
            float f2 = fArray[n2 + 0];
            float f3 = fArray[n2 + 1];
            fArray2[n3 + 0] = f2 * this.m00 + f3 * this.m01 + this.m02;
            fArray2[n3 + 1] = f2 * this.m10 + f3 * this.m11 + this.m12;
            n2 += n5;
            n3 += n5;
        }
    }

    public final Vertex deltaTransform(Vertex vertex, Vertex vertex2) {
        float f2 = vertex.getX();
        float f3 = vertex.getY();
        vertex2.setCoord(f2 * this.m00 + f3 * this.m01, f2 * this.m10 + f3 * this.m11, vertex.getZ());
        return vertex2;
    }

    public final void deltaTransform(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        while (--n4 >= 0) {
            float f2 = fArray[n2++];
            float f3 = fArray[n2++];
            fArray2[n3++] = f2 * this.m00 + f3 * this.m01;
            fArray2[n3++] = f2 * this.m10 + f3 * this.m11;
        }
    }

    public final Vertex inverseTransform(Vertex vertex, Vertex vertex2) throws NoninvertibleTransformException {
        float f2 = this.getDeterminant();
        if (FloatUtil.abs(f2) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        float f3 = vertex.getX() - this.m02;
        float f4 = vertex.getY() - this.m12;
        vertex2.setCoord((f3 * this.m11 - f4 * this.m01) / f2, (f4 * this.m00 - f3 * this.m10) / f2, vertex.getZ());
        return vertex2;
    }

    public final void inverseTransform(float[] fArray, int n2, float[] fArray2, int n3, int n4) throws NoninvertibleTransformException {
        float f2 = this.getDeterminant();
        if (FloatUtil.abs(f2) < 1.0E-10f) {
            throw new NoninvertibleTransformException(determinantIsZero);
        }
        while (--n4 >= 0) {
            float f3 = fArray[n2++] - this.m02;
            float f4 = fArray[n2++] - this.m12;
            fArray2[n3++] = (f3 * this.m11 - f4 * this.m01) / f2;
            fArray2[n3++] = (f4 * this.m00 - f3 * this.m10) / f2;
        }
    }

    public final Path2D createTransformedShape(Path2D path2D) {
        if (path2D == null) {
            return null;
        }
        return path2D.createTransformedShape(this);
    }

    public final String toString() {
        return this.getClass().getName() + "[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    public final AffineTransform clone() {
        try {
            return (AffineTransform)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AffineTransform) {
            AffineTransform affineTransform = (AffineTransform)object;
            return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
        }
        return false;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }
}

