/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.tt.engine;

import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.tt.engine.GraphicsState;
import jogamp.graph.font.typecast.tt.engine.Parser;

public class Interpreter {
    private Parser parser = null;
    private final GraphicsState gs = new GraphicsState();
    private final Point[][] zone = new Point[2][];
    private int[] stack = null;
    private int[] store = null;
    private final int[] cvt = new int[256];
    private int[] functionMap = null;
    private int stackIndex = 0;
    private boolean inFuncDef = false;

    public Interpreter(int n2, int n3, int n4) {
        this.zone[0] = new Point[256];
        this.zone[1] = new Point[256];
        this.stack = new int[n2];
        this.store = new int[n3];
        this.functionMap = new int[n4];
    }

    private void _abs() {
        int n2 = this.pop();
        if (n2 >= 0) {
            this.push(n2);
        } else {
            this.push(-n2);
        }
    }

    private void _add() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 + n2);
    }

    private void _alignpts() {
        this.pop();
        this.pop();
    }

    private void _alignrp() {
        while (this.gs.loop-- > 0) {
            this.pop();
        }
        this.gs.loop = 1;
    }

    private void _and() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 != 0 && n2 != 0 ? 1 : 0);
    }

    private void _call() {
        this.execute(this.functionMap[this.pop()]);
    }

    private void _ceiling() {
        int n2 = this.pop();
        if (n2 >= 0) {
            this.push((n2 & 0xFFC0) + ((n2 & 0x3F) != 0 ? 64 : 0));
        } else {
            this.push(n2 & 0xFFC0);
        }
    }

    private void _cindex() {
        this.push(this.stack[this.stackIndex - this.pop()]);
    }

    private void _clear() {
        this.stackIndex = 0;
    }

    private void _debug() {
        this.pop();
    }

    private void _deltac1() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _deltac2() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _deltac3() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _deltap1() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _deltap2() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _deltap3() {
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
            this.pop();
        }
    }

    private void _depth() {
        this.push(this.stackIndex);
    }

    private void _div() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 / n2 >> 6);
    }

    private void _dup() {
        int n2 = this.pop();
        this.push(n2);
        this.push(n2);
    }

    private int _else(int n2) {
        return this.parser.handleElse(n2);
    }

    private void _eq() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 == n2 ? 1 : 0);
    }

    private void _even() {
        this.pop();
        this.push(0);
    }

    private void _fdef(int n2) {
        this.functionMap[this.pop()] = n2;
        this.inFuncDef = true;
    }

    private void _flipoff() {
        this.gs.auto_flip = false;
    }

    private void _flipon() {
        this.gs.auto_flip = true;
    }

    private void _flippt() {
        while (this.gs.loop-- > 0) {
            int n2 = this.pop();
            this.zone[this.gs.zp0][n2].onCurve = !this.zone[this.gs.zp0][n2].onCurve;
        }
        this.gs.loop = 1;
    }

    private void _fliprgoff() {
        int n2;
        int n3 = this.pop();
        for (int i2 = n2 = this.pop(); i2 <= n3; ++i2) {
            this.zone[1][i2].onCurve = false;
        }
    }

    private void _fliprgon() {
        int n2;
        int n3 = this.pop();
        for (int i2 = n2 = this.pop(); i2 <= n3; ++i2) {
            this.zone[1][i2].onCurve = true;
        }
    }

    private void _floor() {
        int n2 = this.pop();
        if (n2 >= 0) {
            this.push(n2 & 0xFFC0);
        } else {
            this.push((n2 & 0xFFC0) - ((n2 & 0x3F) != 0 ? 64 : 0));
        }
    }

    private void _gc(short s) {
        this.pop();
        this.push(0);
    }

    private void _getinfo() {
        this.pop();
        this.push(0);
    }

    private void _gfv() {
        this.push(this.gs.freedom_vector[0]);
        this.push(this.gs.freedom_vector[1]);
    }

    private void _gpv() {
        this.push(this.gs.projection_vector[0]);
        this.push(this.gs.projection_vector[1]);
    }

    private void _gt() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 > n2 ? 1 : 0);
    }

    private void _gteq() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 >= n2 ? 1 : 0);
    }

    private void _idef() {
        this.pop();
        this.inFuncDef = true;
    }

    private int _if(int n2) {
        return this.parser.handleIf(this.pop() != 0, n2);
    }

    private void _instctrl() {
        int n2 = this.pop();
        int n3 = this.pop();
        if (n2 == 1) {
            this.gs.instruction_control |= n3;
        } else if (n2 == 2) {
            this.gs.instruction_control |= n3;
        }
    }

    private void _ip() {
        this.pop();
    }

    private void _isect() {
        this.pop();
        this.pop();
        this.pop();
        this.pop();
        this.pop();
    }

    private void _iup(short s) {
    }

    private int _jmpr(int n2) {
        return n2 + (this.pop() - 1);
    }

    private int _jrof(int n2) {
        boolean bl = this.pop() != 0;
        int n3 = this.pop();
        if (!bl) {
            n2 += n3 - 1;
        }
        return n2;
    }

    private int _jrot(int n2) {
        boolean bl = this.pop() != 0;
        int n3 = this.pop();
        if (bl) {
            n2 += n3 - 1;
        }
        return n2;
    }

    private void _loopcall() {
        this.pop();
        int n2 = this.pop();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.execute(this.functionMap[i2]);
        }
    }

    private void _lt() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 < n2 ? 1 : 0);
    }

    private void _lteq() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 <= n2 ? 1 : 0);
    }

    private void _max() {
        int n2;
        int n3 = this.pop();
        this.push(n3 > (n2 = this.pop()) ? n3 : n2);
    }

    private void _md(short s) {
        this.pop();
        this.pop();
        this.push(0);
    }

    private void _mdap(short s) {
        this.pop();
    }

    private void _mdrp(short s) {
        this.pop();
    }

    private void _miap(short s) {
        this.pop();
        this.pop();
    }

    private void _min() {
        int n2;
        int n3 = this.pop();
        this.push(n3 < (n2 = this.pop()) ? n3 : n2);
    }

    private void _mindex() {
        int n2 = this.pop();
        int n3 = this.stack[this.stackIndex - n2];
        for (int i2 = this.stackIndex - n2; i2 < this.stackIndex - 1; ++i2) {
            this.stack[i2] = this.stack[i2 + 1];
        }
        this.stack[this.stackIndex - 1] = n3;
    }

    private void _mirp(short s) {
        this.pop();
        this.pop();
    }

    private void _mppem() {
        this.push(0);
    }

    private void _mps() {
        this.push(0);
    }

    private void _msirp(short s) {
        this.pop();
        this.pop();
    }

    private void _mul() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n2 * n3 >> 6);
    }

    private void _neg() {
        this.push(-this.pop());
    }

    private void _neq() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 != n2 ? 1 : 0);
    }

    private void _not() {
        this.push(this.pop() != 0 ? 0 : 1);
    }

    private void _nround(short s) {
        this.pop();
        this.push(0);
    }

    private void _odd() {
        this.pop();
        this.push(0);
    }

    private void _or() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 != 0 || n2 != 0 ? 1 : 0);
    }

    private void _push(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.push(nArray[i2]);
        }
    }

    private void _rcvt() {
        this.push(this.cvt[this.pop()]);
    }

    private void _rdtg() {
        this.gs.round_state = 3;
    }

    private void _roff() {
        this.gs.round_state = 5;
    }

    private void _roll() {
        int n2 = this.pop();
        int n3 = this.pop();
        int n4 = this.pop();
        this.push(n3);
        this.push(n2);
        this.push(n4);
    }

    private void _round(short s) {
        this.pop();
        this.push(0);
    }

    private void _rs() {
        this.push(this.store[this.pop()]);
    }

    private void _rtdg() {
        this.gs.round_state = 2;
    }

    private void _rtg() {
        this.gs.round_state = 1;
    }

    private void _rthg() {
        this.gs.round_state = 0;
    }

    private void _rutg() {
        this.gs.round_state = 4;
    }

    private void _s45round() {
        this.pop();
    }

    private void _scanctrl() {
        this.gs.scan_control = this.pop();
    }

    private void _scantype() {
        this.pop();
    }

    private void _scfs() {
        this.pop();
        this.pop();
    }

    private void _scvtci() {
        this.gs.control_value_cut_in = this.pop();
    }

    private void _sdb() {
        this.gs.delta_base = this.pop();
    }

    private void _sdpvtl(short s) {
        this.pop();
        this.pop();
    }

    private void _sds() {
        this.gs.delta_shift = this.pop();
    }

    private void _sfvfs() {
        this.gs.freedom_vector[1] = this.pop();
        this.gs.freedom_vector[0] = this.pop();
    }

    private void _sfvtca(short s) {
        if (s == 1) {
            this.gs.freedom_vector[0] = 16384;
            this.gs.freedom_vector[1] = 0;
        } else {
            this.gs.freedom_vector[0] = 0;
            this.gs.freedom_vector[1] = 16384;
        }
    }

    private void _sfvtl(short s) {
        this.pop();
        this.pop();
        this.gs.freedom_vector[0] = 0;
        this.gs.freedom_vector[1] = 0;
    }

    private void _sfvtpv() {
        this.gs.freedom_vector[0] = this.gs.projection_vector[0];
        this.gs.freedom_vector[1] = this.gs.projection_vector[1];
    }

    private void _shc(short s) {
        this.pop();
    }

    private void _shp(short s) {
        while (this.gs.loop-- > 0) {
            this.pop();
            if (s != 0) continue;
        }
        this.gs.loop = 1;
    }

    private void _shpix() {
        this.pop();
        while (this.gs.loop-- > 0) {
            this.pop();
        }
        this.gs.loop = 1;
    }

    private void _shz(short s) {
        this.pop();
    }

    private void _sloop() {
        this.gs.loop = this.pop();
    }

    private void _smd() {
        this.gs.minimum_distance = this.pop();
    }

    private void _spvfs() {
        this.gs.projection_vector[1] = this.pop();
        this.gs.projection_vector[0] = this.pop();
    }

    private void _spvtca(short s) {
        if (s == 1) {
            this.gs.projection_vector[0] = 16384;
            this.gs.projection_vector[1] = 0;
        } else {
            this.gs.projection_vector[0] = 0;
            this.gs.projection_vector[1] = 16384;
        }
    }

    private void _spvtl(short s) {
        this.pop();
        this.pop();
        this.gs.projection_vector[0] = 0;
        this.gs.projection_vector[1] = 0;
    }

    private void _sround() {
        this.pop();
    }

    private void _srp0() {
        this.gs.rp0 = this.pop();
    }

    private void _srp1() {
        this.gs.rp1 = this.pop();
    }

    private void _srp2() {
        this.gs.rp2 = this.pop();
    }

    private void _ssw() {
        this.gs.single_width_value = this.pop();
    }

    private void _sswci() {
        this.gs.single_width_cut_in = this.pop();
    }

    private void _sub() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n3 - n2);
    }

    private void _svtca(short s) {
        if (s == 1) {
            this.gs.projection_vector[0] = 16384;
            this.gs.projection_vector[1] = 0;
            this.gs.freedom_vector[0] = 16384;
            this.gs.freedom_vector[1] = 0;
        } else {
            this.gs.projection_vector[0] = 0;
            this.gs.projection_vector[1] = 16384;
            this.gs.freedom_vector[0] = 0;
            this.gs.freedom_vector[1] = 16384;
        }
    }

    private void _swap() {
        int n2 = this.pop();
        int n3 = this.pop();
        this.push(n2);
        this.push(n3);
    }

    private void _szp0() {
        this.gs.zp0 = this.pop();
    }

    private void _szp1() {
        this.gs.zp1 = this.pop();
    }

    private void _szp2() {
        this.gs.zp2 = this.pop();
    }

    private void _szps() {
        this.gs.zp1 = this.gs.zp2 = this.pop();
        this.gs.zp0 = this.gs.zp2;
    }

    private void _utp() {
        this.pop();
    }

    private void _wcvtf() {
        int n2;
        this.cvt[this.pop()] = n2 = this.pop();
    }

    private void _wcvtp() {
        int n2;
        this.cvt[this.pop()] = n2 = this.pop();
    }

    private void _ws() {
        this.store[this.pop()] = this.pop();
    }

    public void execute(int n2) {
        while (n2 < (n2 & 0xFFFF0000 | this.parser.getISLength(n2 >> 16))) {
            short s = this.parser.getOpcode(n2);
            if (this.inFuncDef) {
                if (s == 45) {
                    this.inFuncDef = false;
                }
                n2 = this.parser.advanceIP(n2);
                continue;
            }
            if (s >= 224) {
                this._mirp((short)(s & 0x1F));
            } else if (s >= 192) {
                this._mdrp((short)(s & 0x1F));
            } else if (s >= 184) {
                this._push(this.parser.getPushData(n2));
            } else if (s >= 176) {
                this._push(this.parser.getPushData(n2));
            } else if (s >= 142) {
                this._instctrl();
            } else if (s >= 141) {
                this._scantype();
            } else if (s >= 140) {
                this._min();
            } else if (s >= 139) {
                this._max();
            } else if (s >= 138) {
                this._roll();
            } else if (s >= 137) {
                this._idef();
            } else if (s >= 136) {
                this._getinfo();
            } else if (s >= 134) {
                this._sdpvtl((short)(s & 1));
            } else if (s >= 133) {
                this._scanctrl();
            } else if (s >= 130) {
                this._fliprgoff();
            } else if (s >= 129) {
                this._fliprgon();
            } else if (s >= 128) {
                this._flippt();
            } else if (s < 127 && s < 126) {
                if (s >= 125) {
                    this._rdtg();
                } else if (s >= 124) {
                    this._rutg();
                } else if (s >= 122) {
                    this._roff();
                } else if (s >= 121) {
                    n2 = this._jrof(n2);
                } else if (s >= 120) {
                    n2 = this._jrot(n2);
                } else if (s >= 119) {
                    this._s45round();
                } else if (s >= 118) {
                    this._sround();
                } else if (s >= 117) {
                    this._deltac3();
                } else if (s >= 116) {
                    this._deltac2();
                } else if (s >= 115) {
                    this._deltac1();
                } else if (s >= 114) {
                    this._deltap3();
                } else if (s >= 113) {
                    this._deltap2();
                } else if (s >= 112) {
                    this._wcvtf();
                } else if (s >= 108) {
                    this._nround((short)(s & 3));
                } else if (s >= 104) {
                    this._round((short)(s & 3));
                } else if (s >= 103) {
                    this._ceiling();
                } else if (s >= 102) {
                    this._floor();
                } else if (s >= 101) {
                    this._neg();
                } else if (s >= 100) {
                    this._abs();
                } else if (s >= 99) {
                    this._mul();
                } else if (s >= 98) {
                    this._div();
                } else if (s >= 97) {
                    this._sub();
                } else if (s >= 96) {
                    this._add();
                } else if (s >= 95) {
                    this._sds();
                } else if (s >= 94) {
                    this._sdb();
                } else if (s >= 93) {
                    this._deltap1();
                } else if (s >= 92) {
                    this._not();
                } else if (s >= 91) {
                    this._or();
                } else if (s >= 90) {
                    this._and();
                } else if (s < 89) {
                    if (s >= 88) {
                        n2 = this._if(n2);
                    } else if (s >= 87) {
                        this._even();
                    } else if (s >= 86) {
                        this._odd();
                    } else if (s >= 85) {
                        this._neq();
                    } else if (s >= 84) {
                        this._eq();
                    } else if (s >= 83) {
                        this._gteq();
                    } else if (s >= 82) {
                        this._gt();
                    } else if (s >= 81) {
                        this._lteq();
                    } else if (s >= 80) {
                        this._lt();
                    } else if (s >= 79) {
                        this._debug();
                    } else if (s >= 78) {
                        this._flipoff();
                    } else if (s >= 77) {
                        this._flipon();
                    } else if (s >= 76) {
                        this._mps();
                    } else if (s >= 75) {
                        this._mppem();
                    } else if (s >= 73) {
                        this._md((short)(s & 1));
                    } else if (s >= 72) {
                        this._scfs();
                    } else if (s >= 70) {
                        this._gc((short)(s & 1));
                    } else if (s >= 69) {
                        this._rcvt();
                    } else if (s >= 68) {
                        this._wcvtp();
                    } else if (s >= 67) {
                        this._rs();
                    } else if (s >= 66) {
                        this._ws();
                    } else if (s >= 65) {
                        this._push(this.parser.getPushData(n2));
                    } else if (s >= 64) {
                        this._push(this.parser.getPushData(n2));
                    } else if (s >= 62) {
                        this._miap((short)(s & 1));
                    } else if (s >= 61) {
                        this._rtdg();
                    } else if (s >= 60) {
                        this._alignrp();
                    } else if (s >= 57) {
                        this._ip();
                    } else if (s >= 58) {
                        this._msirp((short)(s & 1));
                    } else if (s >= 56) {
                        this._shpix();
                    } else if (s >= 54) {
                        this._shz((short)(s & 1));
                    } else if (s >= 52) {
                        this._shc((short)(s & 1));
                    } else if (s >= 50) {
                        this._shp((short)(s & 1));
                    } else if (s >= 48) {
                        this._iup((short)(s & 1));
                    } else if (s >= 46) {
                        this._mdap((short)(s & 1));
                    } else {
                        if (s >= 45) {
                            return;
                        }
                        if (s >= 44) {
                            this._fdef(n2 + 1);
                        } else if (s >= 43) {
                            this._call();
                        } else if (s >= 42) {
                            this._loopcall();
                        } else if (s >= 41) {
                            this._utp();
                        } else if (s >= 39) {
                            this._alignpts();
                        } else if (s >= 38) {
                            this._mindex();
                        } else if (s >= 37) {
                            this._cindex();
                        } else if (s >= 36) {
                            this._depth();
                        } else if (s >= 35) {
                            this._swap();
                        } else if (s >= 34) {
                            this._clear();
                        } else if (s >= 33) {
                            this.pop();
                        } else if (s >= 32) {
                            this._dup();
                        } else if (s >= 31) {
                            this._ssw();
                        } else if (s >= 30) {
                            this._sswci();
                        } else if (s >= 29) {
                            this._scvtci();
                        } else if (s >= 28) {
                            n2 = this._jmpr(n2);
                        } else if (s >= 27) {
                            n2 = this._else(n2);
                        } else if (s >= 26) {
                            this._smd();
                        } else if (s >= 25) {
                            this._rthg();
                        } else if (s >= 24) {
                            this._rtg();
                        } else if (s >= 23) {
                            this._sloop();
                        } else if (s >= 22) {
                            this._szps();
                        } else if (s >= 21) {
                            this._szp2();
                        } else if (s >= 20) {
                            this._szp1();
                        } else if (s >= 19) {
                            this._szp0();
                        } else if (s >= 18) {
                            this._srp2();
                        } else if (s >= 17) {
                            this._srp1();
                        } else if (s >= 16) {
                            this._srp0();
                        } else if (s >= 15) {
                            this._isect();
                        } else if (s >= 14) {
                            this._sfvtpv();
                        } else if (s >= 13) {
                            this._gfv();
                        } else if (s >= 12) {
                            this._gpv();
                        } else if (s >= 11) {
                            this._sfvfs();
                        } else if (s >= 10) {
                            this._spvfs();
                        } else if (s >= 8) {
                            this._sfvtl((short)(s & 1));
                        } else if (s >= 6) {
                            this._spvtl((short)(s & 1));
                        } else if (s >= 4) {
                            this._sfvtca((short)(s & 1));
                        } else if (s >= 2) {
                            this._spvtca((short)(s & 1));
                        } else if (s >= 0) {
                            this._svtca((short)(s & 1));
                        }
                    }
                }
            }
            n2 = this.parser.advanceIP(n2);
        }
    }

    public Point[][] getZones() {
        return this.zone;
    }

    private int pop() {
        return this.stack[--this.stackIndex];
    }

    private void push(int n2) {
        this.stack[this.stackIndex++] = n2;
    }

    public void runCvtProgram() {
        this.execute(65536);
    }

    public void runFontProgram() {
        this.execute(0);
    }

    public void runGlyphProgram() {
        if ((this.gs.instruction_control & 1) == 0) {
            this.execute(131072);
        }
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }
}

