/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.t2;

import java.util.ArrayList;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.ot.table.CharstringType2;

public class T2Interpreter {
    private static final int ARGUMENT_STACK_LIMIT = 48;
    private static final int SUBR_STACK_LIMIT = 10;
    private static final int TRANSIENT_ARRAY_ELEMENT_COUNT = 32;
    private final Number[] _argStack = new Number[48];
    private int _argStackIndex = 0;
    private final int[] _subrStack = new int[10];
    private int _subrStackIndex = 0;
    private final Number[] _transientArray = new Number[32];
    private ArrayList<Point> _points;

    private void _rmoveto() {
        int n2 = this.popArg().intValue();
        int n3 = this.popArg().intValue();
        this.clearArg();
        Point point = this.getLastPoint();
        this.moveTo(point.x + n3, point.y + n2);
    }

    private void _hmoveto() {
        int n2 = this.popArg().intValue();
        this.clearArg();
        Point point = this.getLastPoint();
        this.moveTo(point.x + n2, point.y);
    }

    private void _vmoveto() {
        int n2 = this.popArg().intValue();
        this.clearArg();
        Point point = this.getLastPoint();
        this.moveTo(point.x, point.y + n2);
    }

    private void _rlineto() {
        int n2;
        int n3 = this.getArgCount() / 2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n3 - n2 - 1] = this.popArg().intValue();
            nArray[n3 - n2 - 1] = this.popArg().intValue();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = this.getLastPoint();
            this.lineTo(point.x + nArray[n2], point.y + nArray2[n2]);
        }
        this.clearArg();
    }

    private void _hlineto() {
        int n2;
        int n3 = this.getArgCount();
        Number[] numberArray = new Number[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            numberArray[n3 - n2 - 1] = this.popArg();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = this.getLastPoint();
            if (n2 % 2 == 0) {
                this.lineTo(point.x + numberArray[n2].intValue(), point.y);
                continue;
            }
            this.lineTo(point.x, point.y + numberArray[n2].intValue());
        }
        this.clearArg();
    }

    private void _vlineto() {
        int n2;
        int n3 = this.getArgCount();
        Number[] numberArray = new Number[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            numberArray[n3 - n2 - 1] = this.popArg();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = this.getLastPoint();
            if (n2 % 2 == 0) {
                this.lineTo(point.x, point.y + numberArray[n2].intValue());
                continue;
            }
            this.lineTo(point.x + numberArray[n2].intValue(), point.y);
        }
        this.clearArg();
    }

    private void _rrcurveto() {
        int n2;
        int n3 = this.getArgCount() / 6;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray6[n3 - n2 - 1] = this.popArg().intValue();
            nArray5[n3 - n2 - 1] = this.popArg().intValue();
            nArray4[n3 - n2 - 1] = this.popArg().intValue();
            nArray3[n3 - n2 - 1] = this.popArg().intValue();
            nArray2[n3 - n2 - 1] = this.popArg().intValue();
            nArray[n3 - n2 - 1] = this.popArg().intValue();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = this.getLastPoint();
            int n4 = point.x + nArray[n2];
            int n5 = point.y + nArray2[n2];
            int n6 = n4 + nArray3[n2];
            int n7 = n5 + nArray4[n2];
            int n8 = n6 + nArray5[n2];
            int n9 = n7 + nArray6[n2];
            this.curveTo(n4, n5, n6, n7, n8, n9);
        }
        this.clearArg();
    }

    private void _hhcurveto() {
        int n2;
        int n3 = this.getArgCount() / 4;
        int n4 = 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray4[n3 - n2 - 1] = this.popArg().intValue();
            nArray3[n3 - n2 - 1] = this.popArg().intValue();
            nArray2[n3 - n2 - 1] = this.popArg().intValue();
            nArray[n3 - n2 - 1] = this.popArg().intValue();
        }
        if (this.getArgCount() == 1) {
            n4 = this.popArg().intValue();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = this.getLastPoint();
            int n5 = point.x + nArray[n2];
            int n6 = point.y + (n2 == 0 ? n4 : 0);
            int n7 = n5 + nArray2[n2];
            int n8 = n6 + nArray3[n2];
            int n9 = n7 + nArray4[n2];
            int n10 = n8;
            this.curveTo(n5, n6, n7, n8, n9, n10);
        }
        this.clearArg();
    }

    private void _hvcurveto() {
        if (this.getArgCount() % 8 <= 1) {
            int n2;
            int n3 = this.getArgCount() / 8;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            int[] nArray3 = new int[n3];
            int[] nArray4 = new int[n3];
            int[] nArray5 = new int[n3];
            int[] nArray6 = new int[n3];
            int[] nArray7 = new int[n3];
            int[] nArray8 = new int[n3];
            int n4 = 0;
            if (this.getArgCount() % 8 == 1) {
                n4 = this.popArg().intValue();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                nArray8[n3 - n2 - 1] = this.popArg().intValue();
                nArray7[n3 - n2 - 1] = this.popArg().intValue();
                nArray6[n3 - n2 - 1] = this.popArg().intValue();
                nArray5[n3 - n2 - 1] = this.popArg().intValue();
                nArray4[n3 - n2 - 1] = this.popArg().intValue();
                nArray3[n3 - n2 - 1] = this.popArg().intValue();
                nArray2[n3 - n2 - 1] = this.popArg().intValue();
                nArray[n3 - n2 - 1] = this.popArg().intValue();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Point point = this.getLastPoint();
                int n5 = point.x + nArray[n2];
                int n6 = point.y;
                int n7 = n5 + nArray2[n2];
                int n8 = n6 + nArray3[n2];
                int n9 = n7;
                int n10 = n8 + nArray4[n2];
                int n11 = n9;
                int n12 = n10 + nArray5[n2];
                int n13 = n11 + nArray6[n2];
                int n14 = n12 + nArray7[n2];
                int n15 = n13 + nArray8[n2];
                int n16 = n14 + n4;
                this.curveTo(n5, n6, n7, n8, n9, n10);
                this.curveTo(n11, n12, n13, n14, n15, n16);
            }
        } else {
            int n17;
            int n18 = this.getArgCount() / 8;
            int[] nArray = new int[n18];
            int[] nArray9 = new int[n18];
            int[] nArray10 = new int[n18];
            int[] nArray11 = new int[n18];
            int[] nArray12 = new int[n18];
            int[] nArray13 = new int[n18];
            int[] nArray14 = new int[n18];
            int[] nArray15 = new int[n18];
            int n19 = 0;
            if (this.getArgCount() % 8 == 1) {
                n19 = this.popArg().intValue();
            }
            for (n17 = 0; n17 < n18; ++n17) {
                nArray15[n18 - n17 - 1] = this.popArg().intValue();
                nArray14[n18 - n17 - 1] = this.popArg().intValue();
                nArray13[n18 - n17 - 1] = this.popArg().intValue();
                nArray12[n18 - n17 - 1] = this.popArg().intValue();
                nArray11[n18 - n17 - 1] = this.popArg().intValue();
                nArray10[n18 - n17 - 1] = this.popArg().intValue();
                nArray9[n18 - n17 - 1] = this.popArg().intValue();
                nArray[n18 - n17 - 1] = this.popArg().intValue();
            }
            this.popArg();
            this.popArg();
            this.popArg();
            this.popArg();
            for (n17 = 0; n17 < n18; ++n17) {
                Point point = this.getLastPoint();
                int n20 = point.x;
                int n21 = point.y + nArray[n17];
                int n22 = n20 + nArray9[n17];
                int n23 = n21 + nArray10[n17];
                int n24 = n22 + nArray11[n17];
                int n25 = n23;
                int n26 = n24 + nArray12[n17];
                int n27 = n25;
                int n28 = n26 + nArray13[n17];
                int n29 = n27 + nArray14[n17];
                int n30 = n28 + n19;
                int n31 = n29 + nArray15[n17];
                this.curveTo(n20, n21, n22, n23, n24, n25);
                this.curveTo(n26, n27, n28, n29, n30, n31);
            }
        }
        this.clearArg();
    }

    private void _rcurveline() {
        int n2;
        int n3 = (this.getArgCount() - 2) / 6;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n4 = this.popArg().intValue();
        int n5 = this.popArg().intValue();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray6[n3 - n2 - 1] = this.popArg().intValue();
            nArray5[n3 - n2 - 1] = this.popArg().intValue();
            nArray4[n3 - n2 - 1] = this.popArg().intValue();
            nArray3[n3 - n2 - 1] = this.popArg().intValue();
            nArray2[n3 - n2 - 1] = this.popArg().intValue();
            nArray[n3 - n2 - 1] = this.popArg().intValue();
        }
        n2 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            Point point = this.getLastPoint();
            int n7 = point.x + nArray[i2];
            int n8 = point.y + nArray2[i2];
            int n9 = n7 + nArray3[i2];
            int n10 = n8 + nArray4[i2];
            n2 = n9 + nArray5[i2];
            n6 = n10 + nArray6[i2];
            this.curveTo(n7, n8, n9, n10, n2, n6);
        }
        this.lineTo(n2 + n5, n6 + n4);
        this.clearArg();
    }

    private void _rlinecurve() {
        int n2;
        int n3;
        int n4 = (this.getArgCount() - 6) / 2;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int n5 = this.popArg().intValue();
        int n6 = this.popArg().intValue();
        int n7 = this.popArg().intValue();
        int n8 = this.popArg().intValue();
        int n9 = this.popArg().intValue();
        int n10 = this.popArg().intValue();
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n4 - n3 - 1] = this.popArg().intValue();
            nArray[n4 - n3 - 1] = this.popArg().intValue();
        }
        n3 = 0;
        int n11 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            Point point = this.getLastPoint();
            n3 = point.x + nArray[n2];
            n11 = point.y + nArray2[n2];
            this.lineTo(n3, n11);
        }
        n2 = n3 + n10;
        int n12 = n11 + n9;
        int n13 = n2 + n8;
        int n14 = n12 + n7;
        int n15 = n13 + n6;
        int n16 = n14 + n5;
        this.curveTo(n2, n12, n13, n14, n15, n16);
        this.clearArg();
    }

    private void _vhcurveto() {
        if (this.getArgCount() % 8 <= 1) {
            int n2;
            int n3 = this.getArgCount() / 8;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            int[] nArray3 = new int[n3];
            int[] nArray4 = new int[n3];
            int[] nArray5 = new int[n3];
            int[] nArray6 = new int[n3];
            int[] nArray7 = new int[n3];
            int[] nArray8 = new int[n3];
            int n4 = 0;
            if (this.getArgCount() % 8 == 1) {
                n4 = this.popArg().intValue();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                nArray8[n3 - n2 - 1] = this.popArg().intValue();
                nArray7[n3 - n2 - 1] = this.popArg().intValue();
                nArray6[n3 - n2 - 1] = this.popArg().intValue();
                nArray5[n3 - n2 - 1] = this.popArg().intValue();
                nArray4[n3 - n2 - 1] = this.popArg().intValue();
                nArray3[n3 - n2 - 1] = this.popArg().intValue();
                nArray2[n3 - n2 - 1] = this.popArg().intValue();
                nArray[n3 - n2 - 1] = this.popArg().intValue();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Point point = this.getLastPoint();
                int n5 = point.x;
                int n6 = point.y + nArray[n2];
                int n7 = n5 + nArray2[n2];
                int n8 = n6 + nArray3[n2];
                int n9 = n7 + nArray4[n2];
                int n10 = n8;
                int n11 = n9 + nArray5[n2];
                int n12 = n10;
                int n13 = n11 + nArray6[n2];
                int n14 = n12 + nArray7[n2];
                int n15 = n13 + n4;
                int n16 = n14 + nArray8[n2];
                this.curveTo(n5, n6, n7, n8, n9, n10);
                this.curveTo(n11, n12, n13, n14, n15, n16);
            }
        }
        this.clearArg();
    }

    private void _vvcurveto() {
        this.clearArg();
    }

    private void _flex() {
        this.clearArg();
    }

    private void _hflex() {
        this.clearArg();
    }

    private void _hflex1() {
        this.clearArg();
    }

    private void _flex1() {
        this.clearArg();
    }

    private void _endchar() {
        this.endContour();
        this.clearArg();
    }

    private void _hstem() {
        this.clearArg();
    }

    private void _vstem() {
        this.clearArg();
    }

    private void _hstemhm() {
        this.clearArg();
    }

    private void _vstemhm() {
        this.clearArg();
    }

    private void _hintmask() {
        this.clearArg();
    }

    private void _cntrmask() {
        this.clearArg();
    }

    private void _abs() {
        double d2 = this.popArg().doubleValue();
        this.pushArg(Math.abs(d2));
    }

    private void _add() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 + d2);
    }

    private void _sub() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 - d2);
    }

    private void _div() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 / d2);
    }

    private void _neg() {
        double d2 = this.popArg().doubleValue();
        this.pushArg(-d2);
    }

    private void _random() {
        this.pushArg(1.0 - Math.random());
    }

    private void _mul() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 * d2);
    }

    private void _sqrt() {
        double d2 = this.popArg().doubleValue();
        this.pushArg(Math.sqrt(d2));
    }

    private void _drop() {
        this.popArg();
    }

    private void _exch() {
        Number number = this.popArg();
        Number number2 = this.popArg();
        this.pushArg(number);
        this.pushArg(number2);
    }

    private void _index() {
        int n2;
        int n3 = this.popArg().intValue();
        Number[] numberArray = new Number[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            numberArray[n2] = this.popArg();
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.pushArg(numberArray[n2]);
        }
        this.pushArg(numberArray[n3]);
    }

    private void _roll() {
        int n2;
        int n3 = this.popArg().intValue();
        int n4 = this.popArg().intValue();
        Number[] numberArray = new Number[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            numberArray[n2] = this.popArg();
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            this.pushArg(numberArray[(n4 + n2 + n3) % n4]);
        }
    }

    private void _dup() {
        Number number = this.popArg();
        this.pushArg(number);
        this.pushArg(number);
    }

    private void _put() {
        Number number;
        int n2 = this.popArg().intValue();
        this._transientArray[n2] = number = this.popArg();
    }

    private void _get() {
        int n2 = this.popArg().intValue();
        this.pushArg(this._transientArray[n2]);
    }

    private void _and() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 != 0.0 && d2 != 0.0 ? 1 : 0);
    }

    private void _or() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 != 0.0 || d2 != 0.0 ? 1 : 0);
    }

    private void _not() {
        double d2 = this.popArg().doubleValue();
        this.pushArg(d2 != 0.0 ? 0 : 1);
    }

    private void _eq() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        this.pushArg(d3 == d2 ? 1 : 0);
    }

    private void _ifelse() {
        double d2 = this.popArg().doubleValue();
        double d3 = this.popArg().doubleValue();
        Number number = this.popArg();
        Number number2 = this.popArg();
        this.pushArg(d3 <= d2 ? (Number)number2 : (Number)number);
    }

    private void _callsubr() {
    }

    private void _callgsubr() {
    }

    private void _return() {
    }

    public Point[] execute(CharstringType2 charstringType2) {
        this._points = new ArrayList();
        charstringType2.resetIP();
        block51: while (charstringType2.moreBytes()) {
            while (charstringType2.isOperandAtIndex()) {
                this.pushArg(charstringType2.nextOperand());
            }
            int n2 = charstringType2.nextByte();
            if (n2 == 12) {
                n2 = charstringType2.nextByte();
                switch (n2) {
                    case 3: {
                        this._and();
                        continue block51;
                    }
                    case 4: {
                        this._or();
                        continue block51;
                    }
                    case 5: {
                        this._not();
                        continue block51;
                    }
                    case 9: {
                        this._abs();
                        continue block51;
                    }
                    case 10: {
                        this._add();
                        continue block51;
                    }
                    case 11: {
                        this._sub();
                        continue block51;
                    }
                    case 12: {
                        this._div();
                        continue block51;
                    }
                    case 14: {
                        this._neg();
                        continue block51;
                    }
                    case 15: {
                        this._eq();
                        continue block51;
                    }
                    case 18: {
                        this._drop();
                        continue block51;
                    }
                    case 20: {
                        this._put();
                        continue block51;
                    }
                    case 21: {
                        this._get();
                        continue block51;
                    }
                    case 22: {
                        this._ifelse();
                        continue block51;
                    }
                    case 23: {
                        this._random();
                        continue block51;
                    }
                    case 24: {
                        this._mul();
                        continue block51;
                    }
                    case 26: {
                        this._sqrt();
                        continue block51;
                    }
                    case 27: {
                        this._dup();
                        continue block51;
                    }
                    case 28: {
                        this._exch();
                        continue block51;
                    }
                    case 29: {
                        this._index();
                        continue block51;
                    }
                    case 30: {
                        this._roll();
                        continue block51;
                    }
                    case 34: {
                        this._hflex();
                        continue block51;
                    }
                    case 35: {
                        this._flex();
                        continue block51;
                    }
                    case 36: {
                        this._hflex1();
                        continue block51;
                    }
                    case 37: {
                        this._flex1();
                        continue block51;
                    }
                }
                return null;
            }
            switch (n2) {
                case 1: {
                    this._hstem();
                    continue block51;
                }
                case 3: {
                    this._vstem();
                    continue block51;
                }
                case 4: {
                    this._vmoveto();
                    continue block51;
                }
                case 5: {
                    this._rlineto();
                    continue block51;
                }
                case 6: {
                    this._hlineto();
                    continue block51;
                }
                case 7: {
                    this._vlineto();
                    continue block51;
                }
                case 8: {
                    this._rrcurveto();
                    continue block51;
                }
                case 10: {
                    this._callsubr();
                    continue block51;
                }
                case 11: {
                    this._return();
                    continue block51;
                }
                case 14: {
                    this._endchar();
                    continue block51;
                }
                case 18: {
                    this._hstemhm();
                    continue block51;
                }
                case 19: {
                    this._hintmask();
                    continue block51;
                }
                case 20: {
                    this._cntrmask();
                    continue block51;
                }
                case 21: {
                    this._rmoveto();
                    continue block51;
                }
                case 22: {
                    this._hmoveto();
                    continue block51;
                }
                case 23: {
                    this._vstemhm();
                    continue block51;
                }
                case 24: {
                    this._rcurveline();
                    continue block51;
                }
                case 25: {
                    this._rlinecurve();
                    continue block51;
                }
                case 26: {
                    this._vvcurveto();
                    continue block51;
                }
                case 27: {
                    this._hhcurveto();
                    continue block51;
                }
                case 29: {
                    this._callgsubr();
                    continue block51;
                }
                case 30: {
                    this._vhcurveto();
                    continue block51;
                }
                case 31: {
                    this._hvcurveto();
                    continue block51;
                }
            }
            return null;
        }
        Point[] pointArray = new Point[this._points.size()];
        this._points.toArray(pointArray);
        return pointArray;
    }

    private int getArgCount() {
        return this._argStackIndex;
    }

    private Number popArg() {
        return this._argStack[--this._argStackIndex];
    }

    private void pushArg(Number number) {
        this._argStack[this._argStackIndex++] = number;
    }

    private int popSubr() {
        return this._subrStack[--this._subrStackIndex];
    }

    private void pushSubr(int n2) {
        this._subrStack[this._subrStackIndex++] = n2;
    }

    private void clearArg() {
        this._argStackIndex = 0;
    }

    private Point getLastPoint() {
        int n2 = this._points.size();
        if (n2 > 0) {
            return this._points.get(n2 - 1);
        }
        return new Point(0, 0, true, false);
    }

    private void moveTo(int n2, int n3) {
        this.endContour();
        this._points.add(new Point(n2, n3, true, false));
    }

    private void lineTo(int n2, int n3) {
        this._points.add(new Point(n2, n3, true, false));
    }

    private void curveTo(int n2, int n3, int n4, int n5, int n6, int n7) {
        this._points.add(new Point(n2, n3, false, false));
        this._points.add(new Point(n4, n5, false, false));
        this._points.add(new Point(n6, n7, true, false));
    }

    private void endContour() {
        Point point = this.getLastPoint();
        if (point != null) {
            point.endOfContour = true;
        }
    }
}

