/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class PostTable
implements Table {
    private static final String[] macGlyphName = new String[]{".notdef", "null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral'", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "increment", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "middot", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "overscore", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", ""};
    private final DirectoryEntry de;
    private final int version;
    private final int italicAngle;
    private final short underlinePosition;
    private final short underlineThickness;
    private final int isFixedPitch;
    private final int minMemType42;
    private final int maxMemType42;
    private final int minMemType1;
    private final int maxMemType1;
    private int numGlyphs;
    private int[] glyphNameIndex;
    private String[] psGlyphName;

    protected PostTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readInt();
        this.italicAngle = dataInput.readInt();
        this.underlinePosition = dataInput.readShort();
        this.underlineThickness = dataInput.readShort();
        this.isFixedPitch = dataInput.readInt();
        this.minMemType42 = dataInput.readInt();
        this.maxMemType42 = dataInput.readInt();
        this.minMemType1 = dataInput.readInt();
        this.maxMemType1 = dataInput.readInt();
        if (this.version == 131072) {
            int n2;
            this.numGlyphs = dataInput.readUnsignedShort();
            this.glyphNameIndex = new int[this.numGlyphs];
            for (n2 = 0; n2 < this.numGlyphs; ++n2) {
                this.glyphNameIndex[n2] = dataInput.readUnsignedShort();
            }
            n2 = this.highestGlyphNameIndex();
            if (n2 > 257) {
                this.psGlyphName = new String[n2 -= 257];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = dataInput.readUnsignedByte();
                    byte[] byArray = new byte[n3];
                    dataInput.readFully(byArray);
                    this.psGlyphName[i2] = new String(byArray);
                }
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    private int highestGlyphNameIndex() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.numGlyphs; ++i2) {
            if (n2 >= this.glyphNameIndex[i2]) continue;
            n2 = this.glyphNameIndex[i2];
        }
        return n2;
    }

    public String getGlyphName(int n2) {
        if (this.version == 131072) {
            return this.glyphNameIndex[n2] > 257 ? this.psGlyphName[this.glyphNameIndex[n2] - 258] : macGlyphName[this.glyphNameIndex[n2]];
        }
        return null;
    }

    private boolean isMacGlyphName(int n2) {
        if (this.version == 131072) {
            return this.glyphNameIndex[n2] <= 257;
        }
        return false;
    }

    @Override
    public int getType() {
        return 1886352244;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'post' Table - PostScript Metrics\n---------------------------------\n").append("\n        'post' version:        ").append(Fixed.floatValue(this.version)).append("\n        italicAngle:           ").append(Fixed.floatValue(this.italicAngle)).append("\n        underlinePosition:     ").append(this.underlinePosition).append("\n        underlineThickness:    ").append(this.underlineThickness).append("\n        isFixedPitch:          ").append(this.isFixedPitch).append("\n        minMemType42:          ").append(this.minMemType42).append("\n        maxMemType42:          ").append(this.maxMemType42).append("\n        minMemType1:           ").append(this.minMemType1).append("\n        maxMemType1:           ").append(this.maxMemType1);
        if (this.version == 131072) {
            int n2;
            stringBuilder.append("\n\n        Format 2.0:  Non-Standard (for PostScript) TrueType Glyph Set.\n");
            stringBuilder.append("        numGlyphs:      ").append(this.numGlyphs).append("\n");
            for (n2 = 0; n2 < this.numGlyphs; ++n2) {
                stringBuilder.append("        Glyf ").append(n2).append(" -> ");
                if (this.isMacGlyphName(n2)) {
                    stringBuilder.append("Mac Glyph # ").append(this.glyphNameIndex[n2]).append(", '").append(macGlyphName[this.glyphNameIndex[n2]]).append("'\n");
                    continue;
                }
                stringBuilder.append("PSGlyf Name # ").append(this.glyphNameIndex[n2] - 257).append(", name= '").append(this.psGlyphName[this.glyphNameIndex[n2] - 258]).append("'\n");
            }
            stringBuilder.append("\n        Full List of PSGlyf Names\n        ------------------------\n");
            for (n2 = 0; n2 < this.psGlyphName.length; ++n2) {
                stringBuilder.append("        PSGlyf Name # ").append(n2 + 1).append(": ").append(this.psGlyphName[n2]).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }
}

