/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class NameRecord {
    private final short _platformId;
    private final short _encodingId;
    private final short _languageId;
    private final short _nameId;
    private final short _stringLength;
    private final short _stringOffset;
    private String _record;

    protected NameRecord(DataInput dataInput) throws IOException {
        this._platformId = dataInput.readShort();
        this._encodingId = dataInput.readShort();
        this._languageId = dataInput.readShort();
        this._nameId = dataInput.readShort();
        this._stringLength = dataInput.readShort();
        this._stringOffset = dataInput.readShort();
    }

    public short getEncodingId() {
        return this._encodingId;
    }

    public short getLanguageId() {
        return this._languageId;
    }

    public short getNameId() {
        return this._nameId;
    }

    public short getPlatformId() {
        return this._platformId;
    }

    public StringBuilder getRecordString(StringBuilder stringBuilder) {
        stringBuilder.append(this._record);
        return stringBuilder;
    }

    protected void loadString(DataInput dataInput) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        dataInput.skipBytes(this._stringOffset);
        if (this._platformId == 0) {
            for (int i2 = 0; i2 < this._stringLength / 2; ++i2) {
                stringBuilder.append(dataInput.readChar());
            }
        } else if (this._platformId == 1) {
            for (int i3 = 0; i3 < this._stringLength; ++i3) {
                stringBuilder.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 2) {
            for (int i4 = 0; i4 < this._stringLength; ++i4) {
                stringBuilder.append((char)dataInput.readByte());
            }
        } else if (this._platformId == 3) {
            for (int i5 = 0; i5 < this._stringLength / 2; ++i5) {
                char c2 = dataInput.readChar();
                stringBuilder.append(c2);
            }
        }
        this._record = stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("             Platform ID:       ").append(this._platformId).append("\n             Specific ID:       ").append(this._encodingId).append("\n             Language ID:       ").append(this._languageId).append("\n             Name ID:           ").append(this._nameId).append("\n             Length:            ").append(this._stringLength).append("\n             Offset:            ").append(this._stringOffset).append("\n\n").append(this._record);
        return stringBuilder.toString();
    }
}

