/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.GaspRange;
import jogamp.graph.font.typecast.ot.table.Table;

public class GaspTable
implements Table {
    private final DirectoryEntry de;
    private final int version;
    private final int numRanges;
    private final GaspRange[] gaspRange;

    protected GaspTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readUnsignedShort();
        this.numRanges = dataInput.readUnsignedShort();
        this.gaspRange = new GaspRange[this.numRanges];
        for (int i2 = 0; i2 < this.numRanges; ++i2) {
            this.gaspRange[i2] = new GaspRange(dataInput);
        }
    }

    @Override
    public int getType() {
        return 1734439792;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'gasp' Table - Grid-fitting And Scan-conversion Procedure\n---------------------------------------------------------");
        stringBuilder.append("\n  'gasp' version:      ").append(this.version);
        stringBuilder.append("\n  numRanges:           ").append(this.numRanges);
        for (int i2 = 0; i2 < this.numRanges; ++i2) {
            stringBuilder.append("\n\n  gasp Range ").append(i2).append("\n");
            stringBuilder.append(this.gaspRange[i2].toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }
}

