/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.DsigEntry;
import jogamp.graph.font.typecast.ot.table.SignatureBlock;
import jogamp.graph.font.typecast.ot.table.Table;

public class DsigTable
implements Table {
    private final DirectoryEntry de;
    private final int version;
    private final int numSigs;
    private final int flag;
    private final DsigEntry[] dsigEntry;
    private final SignatureBlock[] sigBlocks;

    protected DsigTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n2;
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readInt();
        this.numSigs = dataInput.readUnsignedShort();
        this.flag = dataInput.readUnsignedShort();
        this.dsigEntry = new DsigEntry[this.numSigs];
        this.sigBlocks = new SignatureBlock[this.numSigs];
        for (n2 = 0; n2 < this.numSigs; ++n2) {
            this.dsigEntry[n2] = new DsigEntry(dataInput);
        }
        for (n2 = 0; n2 < this.numSigs; ++n2) {
            this.sigBlocks[n2] = new SignatureBlock(dataInput);
        }
    }

    @Override
    public int getType() {
        return 1146308935;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("DSIG\n");
        for (int i2 = 0; i2 < this.numSigs; ++i2) {
            stringBuilder.append(this.sigBlocks[i2].toString());
        }
        return stringBuilder.toString();
    }
}

