/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    private final int _segCountX2;
    private final int _searchRange;
    private final int _entrySelector;
    private final int _rangeShift;
    private final int[] _endCode;
    private final int[] _startCode;
    private final int[] _idDelta;
    private final int[] _idRangeOffset;
    private final int[] _glyphIdArray;
    private final int _segCount;

    protected CmapFormat4(DataInput dataInput) throws IOException {
        super(dataInput);
        int n2;
        this._format = 4;
        this._segCountX2 = dataInput.readUnsignedShort();
        this._segCount = this._segCountX2 / 2;
        this._endCode = new int[this._segCount];
        this._startCode = new int[this._segCount];
        this._idDelta = new int[this._segCount];
        this._idRangeOffset = new int[this._segCount];
        this._searchRange = dataInput.readUnsignedShort();
        this._entrySelector = dataInput.readUnsignedShort();
        this._rangeShift = dataInput.readUnsignedShort();
        for (n2 = 0; n2 < this._segCount; ++n2) {
            this._endCode[n2] = dataInput.readUnsignedShort();
        }
        dataInput.readUnsignedShort();
        for (n2 = 0; n2 < this._segCount; ++n2) {
            this._startCode[n2] = dataInput.readUnsignedShort();
        }
        for (n2 = 0; n2 < this._segCount; ++n2) {
            this._idDelta[n2] = dataInput.readUnsignedShort();
        }
        for (n2 = 0; n2 < this._segCount; ++n2) {
            this._idRangeOffset[n2] = dataInput.readUnsignedShort();
        }
        n2 = (this._length - (8 * this._segCount + 16)) / 2;
        this._glyphIdArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this._glyphIdArray[i2] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public int getRangeCount() {
        return this._segCount;
    }

    @Override
    public CmapFormat.Range getRange(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this._segCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CmapFormat.Range(this._startCode[n2], this._endCode[n2]);
    }

    @Override
    public int mapCharCode(int n2) {
        try {
            for (int i2 = 0; i2 < this._segCount; ++i2) {
                if (this._endCode[i2] < n2) continue;
                if (this._startCode[i2] <= n2) {
                    if (this._idRangeOffset[i2] > 0) {
                        return this._glyphIdArray[this._idRangeOffset[i2] / 2 + (n2 - this._startCode[i2]) - (this._segCount - i2)];
                    }
                    return (this._idDelta[i2] + n2) % 65536;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + ", segCountX2: " + this._segCountX2 + ", searchRange: " + this._searchRange + ", entrySelector: " + this._entrySelector + ", rangeShift: " + this._rangeShift + ", endCodeLen: " + this._endCode.length + ", startCodeLen: " + this._endCode.length + ", idDeltaLen: " + this._idDelta.length + ", idRangeOffsetLen: " + this._idRangeOffset.length;
    }
}

