/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.mac;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.mac.ResourceReference;

public class ResourceType {
    private final int type;
    private final int count;
    private final int offset;
    private final ResourceReference[] references;

    protected ResourceType(DataInput dataInput) throws IOException {
        this.type = dataInput.readInt();
        this.count = dataInput.readUnsignedShort() + 1;
        this.offset = dataInput.readUnsignedShort();
        this.references = new ResourceReference[this.count];
    }

    protected void readRefs(DataInput dataInput) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.references[i2] = new ResourceReference(dataInput);
        }
    }

    protected void readNames(DataInput dataInput) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.references[i2].readName(dataInput);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return "" + (char)(this.type >> 24 & 0xFF) + (char)(this.type >> 16 & 0xFF) + (char)(this.type >> 8 & 0xFF) + (char)(this.type & 0xFF);
    }

    public int getCount() {
        return this.count;
    }

    public int getOffset() {
        return this.offset;
    }

    public ResourceReference getReference(int n2) {
        return this.references[n2];
    }
}

