/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32Bitfield
implements Bitfield {
    private static final int UNIT_SIZE = 32;
    private int storage = 0;

    @Override
    public int size() {
        return 32;
    }

    @Override
    public final void clearField(boolean bl) {
        this.storage = bl ? -1 : 0;
    }

    private static final void check(int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 >= n2) {
            throw new IndexOutOfBoundsException("Bitnum should be within [0.." + (n2 - 1) + "], but is " + n3);
        }
    }

    @Override
    public final int get32(int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n3);
        }
        Int32Bitfield.check(32 - n3 + 1, n2);
        int n4 = 32 - n2;
        if (32 == n4) {
            int n5 = Bitfield.Util.getBitMask(n3);
            return n5 & this.storage;
        }
        int n6 = Math.min(n3, n4);
        int n7 = (1 << n6) - 1;
        return n7 & this.storage >>> n2;
    }

    @Override
    public final void put32(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n3);
        }
        Int32Bitfield.check(32 - n3 + 1, n2);
        int n5 = 32 - n2;
        if (32 == n5) {
            int n6 = Bitfield.Util.getBitMask(n3);
            this.storage = ~n6 & this.storage | n6 & n4;
        } else {
            int n7 = Math.min(n3, n5);
            int n8 = (1 << n7) - 1;
            this.storage = ~(n8 << n2) & this.storage | (n8 & n4) << n2;
        }
    }

    @Override
    public final int copy32(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        int n5 = this.get32(n2, n4);
        this.put32(n3, n4, n5);
        return n5;
    }

    @Override
    public final boolean get(int n2) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n2);
        return 0 != (this.storage & 1 << n2);
    }

    @Override
    public final boolean put(int n2, boolean bl) throws IndexOutOfBoundsException {
        boolean bl2;
        Int32Bitfield.check(32, n2);
        int n3 = 1 << n2;
        boolean bl3 = bl2 = 0 != (this.storage & n3);
        if (bl2 != bl) {
            this.storage = bl ? (this.storage |= n3) : (this.storage &= ~n3);
        }
        return bl2;
    }

    @Override
    public final void set(int n2) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n2);
        int n3 = 1 << n2;
        this.storage |= n3;
    }

    @Override
    public final void clear(int n2) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n2);
        int n3 = 1 << n2;
        this.storage &= ~n3;
    }

    @Override
    public final boolean copy(int n2, int n3) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n2);
        Int32Bitfield.check(32, n3);
        boolean bl = 0 != (this.storage & 1 << n2);
        int n4 = 1 << n3;
        this.storage = bl ? (this.storage |= n4) : (this.storage &= ~n4);
        return bl;
    }

    @Override
    public int bitCount() {
        return Bitfield.Util.bitCount(this.storage);
    }
}

