/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    static /* synthetic */ Class class$jline$ClassNameCompletor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter filter) throws IOException {
        super(ClassNameCompletor.getClassNames(), filter);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = (class$jline$ClassNameCompletor == null ? (class$jline$ClassNameCompletor = ClassNameCompletor.class$("jline.ClassNameCompletor")) : class$jline$ClassNameCompletor).getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassNameCompletor.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ClassNameCompletor.class$("javax.swing.JFrame")) : class$javax$swing$JFrame};
        for (int i2 = 0; i2 < systemClasses.length; ++i2) {
            URLConnection uc;
            URL classURL = systemClasses[i2].getResource("/" + systemClasses[i2].getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes = new HashSet<String>();
        Iterator i3 = urls.iterator();
        while (i3.hasNext()) {
            URL url = (URL)i3.next();
            File file = new File(url.getFile());
            if (file.isDirectory()) {
                Set files = ClassNameCompletor.getClassFiles(file.getAbsolutePath(), new HashSet(), file, new int[]{200});
                classes.addAll(files);
                continue;
            }
            if (file == null || !file.isFile()) continue;
            JarFile jf = new JarFile(file);
            Enumeration<JarEntry> e2 = jf.entries();
            while (e2.hasMoreElements()) {
                String name;
                JarEntry entry = e2.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                classes.add(name);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        Iterator i4 = classes.iterator();
        while (i4.hasNext()) {
            String name = (String)i4.next();
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root, Set holder, File directory, int[] maxDirectories) {
        int n2 = maxDirectories[0];
        maxDirectories[0] = n2 - 1;
        if (n2 < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        for (int i2 = 0; files != null && i2 < files.length; ++i2) {
            String name = files[i2].getAbsolutePath();
            if (!name.startsWith(root)) continue;
            if (files[i2].isDirectory()) {
                ClassNameCompletor.getClassFiles(root, holder, files[i2], maxDirectories);
                continue;
            }
            if (!files[i2].getName().endsWith(".class")) continue;
            holder.add(files[i2].getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

