/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import jline.CompletionHandler;
import jline.ConsoleReader;
import jline.CursorBuffer;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader, List candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            String bufString = buf.toString();
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates, this.eagerNewlines);
        reader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, String value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    /*
     * WARNING - void declaration
     */
    public static final void printCandidates(ConsoleReader reader, Collection candidates, boolean eagerNewlines) throws IOException {
        HashSet distinct = new HashSet(candidates);
        if (distinct.size() > reader.getAutoprintThreshhold()) {
            int yesOpt;
            if (!eagerNewlines) {
                reader.printNewline();
            }
            reader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates.size())) + " ");
            reader.flushConsole();
            String string = loc.getString("display-candidates-no");
            String noOpt = loc.getString("display-candidates-yes");
            while ((yesOpt = reader.readCharacter(new char[]{noOpt.charAt(0), string.charAt(0)})) != -1) {
                void c2;
                if (c2.startsWith(new String(new char[]{(char)yesOpt}))) {
                    reader.printNewline();
                    return;
                }
                if (noOpt.startsWith(new String(new char[]{(char)yesOpt}))) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates.size()) {
            void var6_7;
            ArrayList yesOpt = new ArrayList();
            Iterator copy = candidates.iterator();
            while (copy.hasNext()) {
                void next;
                Object i2 = copy.next();
                if (next.contains(i2)) continue;
                next.add(i2);
            }
            candidates = var6_7;
        }
        reader.printNewline();
        reader.printColumns(candidates);
    }

    private final String getUnambiguousCompletions(List candidates) {
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuffer candidate = new StringBuffer();
        for (int i2 = 0; i2 < first.length() && this.startsWith(first.substring(0, i2 + 1), strings); ++i2) {
            candidate.append(first.charAt(i2));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates) {
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            if (candidates[i2].startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

