/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyObject;
import org.python.core.util.StringUtil;

public class JDBC20DataHandler
extends FilterDataHandler {
    public JDBC20DataHandler(DataHandler datahandler) {
        super(datahandler);
    }

    public void setJDBCObject(PreparedStatement stmt2, int index, PyObject object, int type) throws SQLException {
        if (DataHandler.checkNull(stmt2, index, object, type)) {
            return;
        }
        switch (type) {
            case 2005: {
                if (object instanceof PyFile) {
                    object = ((PyFile)object).read();
                }
                String clob = (String)object.__tojava__(String.class);
                int length = clob.length();
                InputStream stream = new ByteArrayInputStream(StringUtil.toBytes(clob));
                stream = new BufferedInputStream(stream);
                stmt2.setBinaryStream(index, stream, length);
                break;
            }
            case 2004: {
                byte[] lob = null;
                Object jobject = null;
                jobject = object instanceof PyFile ? object.__tojava__(InputStream.class) : object.__tojava__(Object.class);
                if (jobject instanceof InputStream) {
                    lob = JDBC20DataHandler.read((InputStream)jobject);
                } else if (jobject instanceof byte[]) {
                    lob = (byte[])jobject;
                }
                if (lob != null) {
                    stmt2.setBytes(index, lob);
                    break;
                }
            }
            default: {
                super.setJDBCObject(stmt2, index, object, type);
            }
        }
    }

    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case 2: 
            case 3: {
                try {
                    BigDecimal bd = set.getBigDecimal(col);
                    obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                }
                catch (SQLException e2) {
                    obj = super.getPyObject(set, col, type);
                }
                break;
            }
            case 2005: {
                Reader reader = set.getCharacterStream(col);
                obj = reader == null ? Py.None : Py.newUnicode(JDBC20DataHandler.read(reader));
                break;
            }
            case 2004: {
                Blob blob = set.getBlob(col);
                obj = blob == null ? Py.None : Py.java2py(JDBC20DataHandler.read(blob.getBinaryStream()));
                break;
            }
            case 2003: {
                Array array = set.getArray(col);
                obj = array == null ? Py.None : Py.java2py(array.getArray());
                break;
            }
            default: {
                return super.getPyObject(set, col, type);
            }
        }
        return set.wasNull() || obj == null ? Py.None : obj;
    }
}

