/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import java.io.IOException;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;

public class RTPPacketSender
implements PacketConsumer {
    RTPPushDataSource dest = null;
    RTPConnector connector = null;
    OutputDataStream outstream = null;

    public RTPPacketSender(RTPPushDataSource dest) {
        this.dest = dest;
        this.outstream = dest.getInputStream();
    }

    public RTPPacketSender(RTPConnector connector) throws IOException {
        this.connector = connector;
        this.outstream = connector.getDataOutputStream();
    }

    public RTPPacketSender(OutputDataStream os2) {
        this.outstream = os2;
    }

    public void sendTo(Packet p) throws IOException {
        if (this.outstream == null) {
            throw new IOException();
        }
        this.outstream.write(p.data, 0, p.length);
    }

    public void closeConsumer() {
    }

    public RTPConnector getConnector() {
        return this.connector;
    }

    public String consumerString() {
        String s = "RTPPacketSender for " + this.dest;
        return s;
    }
}

