/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.amovie;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicController;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.MediaTimeBase;
import com.sun.media.SeekFailedEvent;
import com.sun.media.amovie.ActiveMovie;
import com.sun.media.amovie.EventThread;
import com.sun.media.amovie.jdk12CreateThreadAction;
import com.sun.media.content.video.mpeg.Handler;
import com.sun.media.controls.FormatAdapter;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.WindowUtil;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.PlugInManager;
import javax.media.RateChangeEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class AMController
extends BasicController {
    final int MINVOLUME = -10000;
    ActiveMovie amovie = null;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    private Integer closeLock = new Integer(0);
    private Integer sourceLock = new Integer(1);
    private boolean closed = false;
    private TimeBase amTimeBase = null;
    private int appletWindowHandle = 0;
    int pwidth = -1;
    int pheight = -1;
    int outWidth;
    int outHeight;
    private int width;
    private int height;
    boolean peerExists = false;
    private boolean muted = false;
    private boolean outputSizeSet = false;
    private EventThread eventThread = null;
    private boolean isFileStream = false;
    private boolean isRandomAccess = false;
    private boolean isSeekable = false;
    private boolean hasAudio = false;
    private boolean hasVideo = false;
    private boolean deallocated = false;
    private boolean sourceIsOn = false;
    private javax.media.protocol.DataSource source = null;
    private PullSourceStream stream = null;
    private SourceStream originalStream = null;
    private String mpegFile = null;
    private Handler player;
    private Component visualComponent = null;
    private boolean seekFailed = false;
    private Time timeWhenMediaStopped = null;
    private boolean mediaTimeChanged = false;
    private Time requestedMediaTime = new Time(0L);
    private Time lastMediaTime = new Time(0L);
    private int nextRead = 0;
    private boolean inEOM = false;
    private VideoFormat videoFormat = null;
    private AudioFormat audioFormat = null;
    private String id = "JavaActiveMovie_" + this.hashCode();
    private boolean blockedOnRead = false;
    private Thread blockThread = null;
    private boolean abortingRealize = false;
    private boolean setRatePending = false;
    private float setRateValue = 1.0f;
    private GainControl gc = null;
    private Control[] controls = null;
    private FormatControl audioControl = null;
    private FormatControl videoControl = null;
    private static boolean libraryLoaded = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    static /* synthetic */ Class class$com$sun$media$amovie$EventThread;
    static /* synthetic */ Class class$com$sun$media$amovie$AMController;

    public AMController(Handler handler) {
        String library = "jmam";
        if (!libraryLoaded) {
            try {
                JMFSecurityManager.loadLibrary(library);
                libraryLoaded = true;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to load native MPEG library");
            }
        }
        this.player = handler;
    }

    public void setSource(javax.media.protocol.DataSource s) throws IncompatibleSourceException {
        if (!(s instanceof PullDataSource)) {
            throw new IncompatibleSourceException("MPEG Controller requires a PullDataSource");
        }
        this.source = s;
        String excMessage = null;
        if (s.getContentType().equalsIgnoreCase("audio.mpeg") || s.getContentType().equalsIgnoreCase("audio/mpeg")) {
            AudioFormat mp3 = new AudioFormat("mpeglayer3");
            AudioFormat linear = new AudioFormat("LINEAR");
            Vector v = PlugInManager.getPlugInList(mp3, linear, 2);
            if (!(v == null || v.size() <= 0 || v.size() == 1 && ((String)v.elementAt(0)).equals("com.ibm.media.codec.audio.ACMCodec"))) {
                excMessage = "Handler doesn't play MPEG Audio";
            } else {
                MediaLocator ml = s.getLocator();
                if (ml == null) {
                    excMessage = "No media locator, cannot handle stream";
                } else {
                    String url = ml.toString();
                    if (url != null && url.endsWith(".mp2")) {
                        excMessage = "Handler doesn't play MPEG Layer 2 audio";
                    } else if (!ml.getProtocol().equals("file")) {
                        excMessage = "Handler only plays local MPEG Audio files";
                    }
                }
            }
        }
        if (excMessage != null) {
            throw new IncompatibleSourceException("MPEG Handler: " + excMessage);
        }
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        super.setTimeBase(tb);
        if (tb != null && tb != this.amTimeBase) {
            Log.warning("the mpeg handler cannot handle the given timebase.");
        }
        this.amTimeBase = tb;
    }

    public TimeBase getTimeBase() {
        if (this.amTimeBase == null) {
            this.amTimeBase = new AMTimeBase(this);
        }
        return this.amTimeBase;
    }

    public boolean isConfigurable() {
        return false;
    }

    private void updateControls(ActiveMovie amovie) {
        if (this.hasAudio) {
            this.audioFormat = new AudioFormat("mpegaudio");
        }
        if (this.hasVideo) {
            Dimension size = new Dimension(amovie.getVideoWidth(), amovie.getVideoHeight());
            this.videoFormat = new VideoFormat("mpeg", size, -1, Format.byteArray, -1.0f);
        }
    }

    public Control[] getControls() {
        int n2 = 0;
        if (this.hasAudio) {
            ++n2;
        }
        if (this.audioFormat != null) {
            ++n2;
        }
        if (this.videoFormat != null) {
            ++n2;
        }
        this.controls = new Control[n2];
        n2 = 0;
        if (this.hasAudio) {
            if (this.gc == null) {
                this.gc = new GCA();
            }
            this.controls[n2++] = this.gc;
        }
        if (this.audioFormat != null) {
            if (this.audioControl == null) {
                this.audioControl = new FormatAdapter(this.audioFormat, new Format[]{this.audioFormat}, true, false, false);
            }
            this.controls[n2++] = this.audioControl;
        }
        if (this.videoFormat != null) {
            if (this.videoControl == null) {
                this.videoControl = new FormatAdapter(this.videoFormat, new Format[]{this.videoFormat}, true, false, false);
            }
            this.controls[n2++] = this.videoControl;
        }
        return this.controls;
    }

    private ActiveMovie createActiveMovie(javax.media.protocol.DataSource s) {
        PullSourceStream[] streams;
        URL url = null;
        if (s == null) {
            return null;
        }
        MediaLocator ml = s.getLocator();
        if (ml != null) {
            try {
                url = ml.getURL();
            }
            catch (MalformedURLException e2) {
                ml = null;
            }
        }
        if (ml != null && ml.getProtocol().equals("file")) {
            this.mpegFile = DataSource.getFileName(ml);
            this.isFileStream = true;
            this.isRandomAccess = true;
            this.isSeekable = true;
            ActiveMovie am = new ActiveMovie(this, this.mpegFile);
            this.hasVideo = am.hasVideo();
            this.hasAudio = am.hasAudio();
            this.updateControls(am);
            return am;
        }
        if (s.getContentType().equalsIgnoreCase("audio.mpeg") || s.getContentType().equalsIgnoreCase("audio/mpeg")) {
            return null;
        }
        if (s instanceof PullDataSource && (streams = ((PullDataSource)s).getStreams()) != null && streams.length > 0) {
            this.stream = streams[0];
            this.originalStream = this.stream;
            if (this.stream instanceof Seekable) {
                this.isSeekable = true;
                if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                    this.isRandomAccess = true;
                }
                if (ml != null && ml.getProtocol().startsWith("http") && url != null) {
                    this.isRandomAccess = false;
                }
            }
            ActiveMovie am = new ActiveMovie(this, this.stream, this.isRandomAccess, this.originalStream.getContentLength());
            this.hasVideo = am.hasVideo();
            this.hasAudio = am.hasAudio();
            this.updateControls(am);
            return am;
        }
        return null;
    }

    public int canRead(int bytes) {
        return bytes;
    }

    public long canSeek(long seekTo) {
        return seekTo;
    }

    public long seek(long seekTo) {
        if (this.abortingRealize) {
            return 0L;
        }
        Integer n2 = this.sourceLock;
        synchronized (n2) {
            if (this.stream instanceof Seekable && this.sourceIsOn) {
                if (((Seekable)((Object)this.stream)).tell() == seekTo) {
                    long l2 = seekTo;
                    return l2;
                }
                if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                    long seeked;
                    long l3 = seeked = ((Seekable)((Object)this.stream)).seek(seekTo);
                    return l3;
                }
                if (seekTo == 0L) {
                    long l4 = ((Seekable)((Object)this.stream)).seek(seekTo);
                    return l4;
                }
            }
        }
        return 0L;
    }

    public int read(byte[] data, int offset, int length) {
        if (this.abortingRealize) {
            return -1;
        }
        if (this.nextRead == -2) {
            this.nextRead = 0;
            return -2;
        }
        Integer n2 = this.sourceLock;
        synchronized (n2) {
            if (this.stream != null && this.sourceIsOn) {
                try {
                    int readBytes;
                    int n3 = readBytes = this.stream.read(data, offset, length);
                    return n3;
                }
                catch (IOException ioe) {
                    this.sendEvent(new ConnectionErrorEvent(this, ioe.getMessage()));
                    int n4 = -1;
                    return n4;
                }
            }
            int n5 = -1;
            return n5;
        }
    }

    protected boolean doRealize() {
        this.abortingRealize = false;
        if (this.amovie != null) {
            if (this.amTimeBase instanceof AMTimeBase) {
                this.amTimeBase = null;
            }
            this.amovie.kill();
            this.amovie.dispose();
            this.amovie = null;
        }
        this.startSource(true, true);
        Integer n2 = this.closeLock;
        synchronized (n2) {
            this.amovie = this.createActiveMovie(this.source);
            if (this.amovie == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.amovie.isRealized()) {
                this.amovie = null;
                boolean bl = false;
                return bl;
            }
            if (this.abortingRealize) {
                this.doDeallocate();
                this.amovie.dispose();
                this.amovie = null;
                boolean bl = false;
                return bl;
            }
        }
        try {
            this.amovie.amStopWhenReady();
            this.amovie.doneRealize();
            if (this.amTimeBase == null) {
                this.amTimeBase = new AMTimeBase(this);
            }
            this.setMediaLength((long)(this.amovie.getDuration() * 1.0E9));
            this.amovie.setVisible(0);
            this.startSource(false, false);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    protected void abortRealize() {
        this.abortingRealize = true;
        this.startSource(false, true);
    }

    protected void abortPrefetch() {
        this.startSource(false, true);
    }

    protected boolean doPrefetch() {
        if (this.amovie == null && !this.doRealize()) {
            return false;
        }
        if (this.amovie != null && this.visualComponent != null && this.peerExists) {
            this.setOwner(this.visualComponent);
        }
        return true;
    }

    protected final void doStart() {
        if (this.amovie == null) {
            this.doPrefetch();
        }
        this.startSource(true, false);
        this.amovie.restart();
        if (this.setRatePending) {
            this.amovie.setRate(this.setRateValue);
            this.setRatePending = false;
            if ((float)this.amovie.getRate() != this.setRateValue) {
                this.sendEvent(new RateChangeEvent(this, (float)this.amovie.getRate()));
            }
        }
        if (this.mediaTimeChanged) {
            int returnVal = this.trySetMediaTime(this.requestedMediaTime);
            if (returnVal == 1) {
                super.stop();
                this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
            if (returnVal == 2) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
        }
        this.mediaTimeChanged = false;
        GainControl gc2 = this.player.getGainControl();
        if (gc2 != null) {
            this.amovie.setVolume((int)(gc2.getDB() * 100.0f));
        }
        this.amovie.amRun();
        if (!this.peerExists) {
            this.amovie.setVisible(0);
        }
        if (gc2 != null) {
            this.muteChange(gc2.getMute());
        }
        if (this.eventThread == null) {
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor cons = jdk12CreateThreadAction.cons;
                    this.eventThread = (EventThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$amovie$EventThread == null ? (class$com$sun$media$amovie$EventThread = AMController.class$("com.sun.media.amovie.EventThread")) : class$com$sun$media$amovie$EventThread));
                }
                catch (Exception exception) {}
            } else {
                this.eventThread = new EventThread();
            }
        }
        this.eventThread.setController(this);
        this.eventThread.start();
    }

    public void doStop() {
        super.doStop();
        this.lastMediaTime = this.getMediaTime();
        if (this.amovie != null && !this.inEOM) {
            this.amovie.amStop();
            this.amovie.pause();
        }
        if (this.eventThread != null) {
            this.eventThread.pause();
        }
        this.startSource(false, false);
        if (!this.isFileStream) {
            this.nextRead = -2;
        }
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected synchronized void doDeallocate() {
        this.startSource(false, false);
        this.timeWhenMediaStopped = this.getMediaTime();
        this.mediaTimeChanged = true;
        this.requestedMediaTime = new Time(0L);
        this.lastMediaTime = this.timeWhenMediaStopped;
        if (this.amovie != null) {
            this.blockedOnRead = false;
            if (this.amovie.getVolume() == -10000) {
                this.amovie.setVolume(-5000);
            }
            this.amovie.kill();
            if (this.eventThread != null) {
                this.eventThread.kill();
                this.eventThread = null;
            }
        }
    }

    public void finalize() {
        if (this.amovie != null) {
            this.doClose();
        }
    }

    protected void doClose() {
        if (this.getState() == 200) {
            this.abortRealize();
        }
        Integer n2 = this.closeLock;
        synchronized (n2) {
            if (this.closed) {
                return;
            }
            this.doDeallocate();
            if (this.amovie != null) {
                this.amovie.dispose();
                this.amTimeBase = null;
                this.amovie = null;
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            this.source = null;
            this.closed = true;
        }
    }

    public void setMediaTime(Time time) {
        super.setMediaTime(time);
        AMController aMController = this;
        synchronized (aMController) {
            this.requestedMediaTime = time;
            this.mediaTimeChanged = true;
        }
        if (this.stream == null) {
            this.amovie.restart();
            if (this.trySetMediaTime(time) == 0) {
                this.mediaTimeChanged = false;
            }
        }
    }

    protected int trySetMediaTime(Time time) {
        if (this.amovie != null) {
            long duration = this.getDuration().getNanoseconds();
            long now = time.getNanoseconds();
            if (this.getDuration() == Duration.DURATION_UNKNOWN && now != 0L) {
                return 1;
            }
            if (now < 0L) {
                return 1;
            }
            if (now > duration) {
                return 2;
            }
            if (!this.isSeekable) {
                return 1;
            }
            double nowSeconds = (double)now * 1.0E-9;
            if (this.isRandomAccess) {
                this.amovie.setCurrentPosition(nowSeconds);
                return 0;
            }
            if (this.stream != null) {
                if (now != 0L) {
                    return 1;
                }
                ((Seekable)((Object)this.stream)).seek(0L);
                this.amovie.setCurrentPosition(0.0);
                return 0;
            }
        }
        return 1;
    }

    public float doSetRate(float factor) {
        if (this.amovie == null) {
            return 1.0f;
        }
        if ((double)factor < 0.1) {
            factor = 0.1f;
        }
        if ((double)factor > 10.0) {
            factor = 10.0f;
        }
        if ((float)this.amovie.getRate() != factor) {
            this.setRatePending = true;
            this.setRateValue = factor;
        }
        return factor;
    }

    Component createVisualComponent() {
        Component c2 = null;
        Class<?> visclass = null;
        try {
            visclass = Class.forName("com.sun.media.amovie.MSVisualComponent");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (visclass == null) {
            try {
                visclass = Class.forName("com.sun.media.amovie.VisualComponent");
            }
            catch (Throwable th) {
                return null;
            }
        }
        Class[] params = new Class[]{class$com$sun$media$amovie$AMController == null ? (class$com$sun$media$amovie$AMController = AMController.class$("com.sun.media.amovie.AMController")) : class$com$sun$media$amovie$AMController};
        Constructor<?> cons = null;
        try {
            cons = visclass.getConstructor(params);
            Object[] amparam = new AMController[]{this};
            c2 = (Component)cons.newInstance(amparam);
            return c2;
        }
        catch (Throwable tr) {
            return null;
        }
    }

    public Component getVisualComponent() {
        if (this.amovie == null) {
            return null;
        }
        if (this.visualComponent == null) {
            if (this.amovie.getVideoWidth() == 0 || this.amovie.getVideoHeight() == 0) {
                this.visualComponent = null;
            } else {
                this.visualComponent = this.createVisualComponent();
                this.visualComponent.addComponentListener(new ComponentAdapter(){
                    private int lastWidth = -1;
                    private int lastHeight = -1;

                    public void componentResized(ComponentEvent ce) {
                        if (AMController.this.amovie != null) {
                            Dimension csize = ce.getComponent().getSize();
                            if (csize.width == this.lastWidth && csize.height == this.lastHeight) {
                                return;
                            }
                            this.lastWidth = csize.width;
                            this.lastHeight = csize.height;
                            AMController.this.outputSizeSet = true;
                            AMController.this.zoom(this.lastWidth, this.lastHeight);
                        }
                    }
                });
            }
        }
        return this.visualComponent;
    }

    public Time getDuration() {
        Time d2;
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.source instanceof Duration && (d2 = this.source.getDuration()) != null && d2 != Duration.DURATION_UNKNOWN && d2 != Duration.DURATION_UNBOUNDED) {
            return d2;
        }
        if (this.amovie == null) {
            return Duration.DURATION_UNKNOWN;
        }
        double amduration = this.amovie.getDuration();
        if (this.isRandomAccess) {
            return new Time((long)(amduration * 1.0E9));
        }
        return Duration.DURATION_UNKNOWN;
    }

    void setOwner(Component parent) {
        try {
            if (this.amovie != null && parent != null) {
                this.appletWindowHandle = WindowUtil.getWindowHandle(parent);
                if (this.appletWindowHandle == 0) {
                    throw new NullPointerException("null peer");
                }
                this.amovie.setOwner(this.appletWindowHandle);
                this.amovie.setVisible(1);
                parent.getPreferredSize();
                this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void sendEOM() {
        if (this.amovie != null) {
            this.amovie.amPause();
            this.amovie.pause();
        }
        this.inEOM = true;
        super.stop();
        this.inEOM = false;
        Time earlier = this.eomDuration;
        this.eomDuration = new Time(this.getMediaTime().getNanoseconds());
        this.startSource(false, false);
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        if (earlier == Duration.DURATION_UNKNOWN) {
            this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
        }
        if (this.stream instanceof CachedStream && !this.isRandomAccess) {
            this.isRandomAccess = true;
            if (this.amovie != null) {
                this.amovie.setSeekable(true);
            }
        }
    }

    public boolean startSource(boolean on, boolean regardless) {
        if (this.sourceIsOn == on) {
            return true;
        }
        Integer n2 = this.sourceLock;
        synchronized (n2) {
            if (regardless) {
                try {
                    if (on) {
                        this.source.start();
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(false);
                        }
                    } else {
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(true);
                        }
                        this.source.stop();
                    }
                }
                catch (Exception ge) {
                    boolean bl = false;
                    return bl;
                }
                this.sourceIsOn = on;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void zoomChanged() {
        if (this.amovie == null) {
            return;
        }
        int width = this.amovie.getVideoWidth();
        int height = this.amovie.getVideoHeight();
        if (this.peerExists) {
            this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
        }
        if (this.pwidth != width || this.pheight != height) {
            this.pwidth = width;
            this.pheight = height;
        }
    }

    private void zoom(int width, int height) {
        this.outWidth = width;
        if (this.outWidth < 120) {
            this.outWidth = 120;
        }
        this.outHeight = height;
        if (this.outHeight < 1) {
            this.outHeight = 1;
        }
        this.zoomChanged();
    }

    public boolean audioEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasAudio();
        }
        return true;
    }

    public boolean videoEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasVideo();
        }
        return true;
    }

    public void gainChange(float g2) {
        if (this.amovie != null && !this.muted && this.gc != null) {
            float dB = this.gc.getDB();
            if (dB > 0.0f) {
                dB = 0.0f;
            }
            if (dB < -70.0f) {
                dB = -100.0f;
            }
            this.amovie.setVolume((int)(dB * 100.0f));
        }
    }

    public void muteChange(boolean state) {
        if (this.amovie != null) {
            if (state) {
                this.muted = true;
                this.amovie.setVolume(-10000);
            } else {
                this.muted = false;
                try {
                    float dB = this.gc.getDB();
                    if (dB > 0.0f) {
                        dB = 0.0f;
                    }
                    if (dB < -70.0f) {
                        dB = -100.0f;
                    }
                    this.amovie.setVolume((int)(dB * 100.0f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class GCA
    extends GainControlAdapter {
        GCA() {
            super(1.0f);
        }

        public void setMute(boolean mute) {
            super.setMute(mute);
            AMController.this.muteChange(mute);
        }

        public float setLevel(float g2) {
            float level = super.setLevel(g2);
            AMController.this.gainChange(g2);
            return level;
        }
    }

    class AMTimeBase
    extends MediaTimeBase {
        private AMController controller;

        public AMTimeBase(AMController controller) {
            this.controller = controller;
        }

        public long getNanoseconds() {
            return this.getMediaTime();
        }

        public long getMediaTime() {
            long time = 0L;
            if (this.controller.amovie != null) {
                time = this.controller.amovie.getTime() * 1000L;
            }
            return time;
        }
    }
}

