/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.memory;

import com.sun.electric.util.memory.MemoryUsage;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ObjSize
extends Enum<ObjSize> {
    public static final /* enum */ ObjSize COUNT = new ObjSize(0, 0){

        @Override
        public long sizeOf(Object o2) {
            return 1L;
        }

        @Override
        public long sizeOfClassInstance(Class cls) {
            return 1L;
        }

        @Override
        public long sizeOfArray(Class componentCls, int len) {
            return 1L;
        }
    };
    public static final /* enum */ ObjSize JDK32 = new ObjSize(4, 4);
    public static final /* enum */ ObjSize JDK64Compressed = new ObjSize(8, 4);
    public static final /* enum */ ObjSize JDK64Uncompressed = new ObjSize(8, 8);
    private final int vmtSize;
    private final int wordSize;
    private final int headerSize;
    private final int arrayHeaderSize;
    private final Map<Class, Integer> classInfoRegistry = new WeakHashMap<Class, Integer>();
    private static final IdentityHashMap<Class, Integer> primitiveSizeRegistry;
    private static volatile ObjSize detected;
    static boolean[][] detectArray;
    private static final /* synthetic */ ObjSize[] $VALUES;

    public static ObjSize[] values() {
        return (ObjSize[])$VALUES.clone();
    }

    public static ObjSize valueOf(String name) {
        return Enum.valueOf(ObjSize.class, name);
    }

    private ObjSize(int vmtSize, int wordSize) {
        this.vmtSize = vmtSize;
        this.wordSize = wordSize;
        this.headerSize = vmtSize + wordSize;
        this.arrayHeaderSize = this.align(this.headerSize + 4);
    }

    public long sizeOf(Object o2) {
        int classInfo = this.getClassInfo(o2.getClass());
        return this.alignHeap(classInfo > 0 ? (long)classInfo : (long)this.arrayHeaderSize - (long)classInfo * (long)Array.getLength(o2));
    }

    public long sizeOfClassInstance(Class cls) {
        int classInfo = this.getClassInfo(cls);
        if (classInfo < 0) {
            throw new IllegalArgumentException("Array class " + cls.getSimpleName());
        }
        return this.alignHeap(classInfo);
    }

    public long sizeOfArray(Class componentCls, int len) {
        return this.alignHeap((long)this.arrayHeaderSize + (long)this.typeSize(componentCls) * (long)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClassInfo(Class cls) {
        Integer classInfo;
        ObjSize objSize = this;
        synchronized (objSize) {
            classInfo = this.classInfoRegistry.get(cls);
        }
        if (classInfo != null) {
            return classInfo;
        }
        return this.computeClassInfo(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeClassInfo(Class cls) {
        Integer oldInfo;
        int classInfo = cls.isArray() ? -this.typeSize(cls.getComponentType()) : this.calcClsSizeImpl(cls);
        ObjSize objSize = this;
        synchronized (objSize) {
            oldInfo = this.classInfoRegistry.put(cls, classInfo);
        }
        assert (oldInfo == null || oldInfo == classInfo);
        return classInfo;
    }

    private int calcClsSizeImpl(Class cls) {
        if (cls == Object.class) {
            return this.vmtSize + this.wordSize;
        }
        assert (!cls.isArray());
        int size = this.getClassInfo(cls.getSuperclass());
        assert (size > 0);
        for (Field f2 : cls.getDeclaredFields()) {
            if ((f2.getModifiers() & 8) != 0) continue;
            size += this.typeSize(f2.getType());
        }
        return this.align(size);
    }

    private long alignHeap(long size) {
        return -(-size & 0xFFFFFFFFFFFFFFF8L);
    }

    private int align(int size) {
        return -(-size & -this.wordSize);
    }

    private int typeSize(Class cls) {
        Integer primitiveSize = primitiveSizeRegistry.get(cls);
        if (primitiveSize != null) {
            return primitiveSize;
        }
        assert (!cls.isPrimitive());
        return this.wordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjSize current() {
        if (detected != null) {
            return detected;
        }
        MemoryUsage memoryUsage = MemoryUsage.getInstance();
        int l2 = 1000000;
        detectArray = new boolean[l2][];
        double sz = Double.NaN;
        try {
            MemoryUsage.collectGarbage();
            MemoryUsage.collectGarbage();
            long mem0 = memoryUsage.getUsedMemory();
            for (int i2 = 0; i2 < l2; ++i2) {
                ObjSize.detectArray[i2] = new boolean[1];
            }
            long mem1 = memoryUsage.getUsedMemory();
            sz = (double)(mem1 - mem0) / (double)l2;
        }
        finally {
            detectArray = null;
        }
        ObjSize bestObjSize = null;
        double bestDiff = Double.NaN;
        for (ObjSize objSize : ObjSize.values()) {
            long osz = objSize.sizeOf(new boolean[1]);
            double diff = Math.abs(sz - (double)osz);
            if (bestObjSize != null && !(diff < bestDiff)) continue;
            bestObjSize = objSize;
            bestDiff = diff;
        }
        detected = bestObjSize;
        System.out.println("ObjSize." + String.valueOf((Object)ObjSize.current()) + " sz=" + sz);
        return bestObjSize;
    }

    private static /* synthetic */ ObjSize[] $values() {
        return new ObjSize[]{COUNT, JDK32, JDK64Compressed, JDK64Uncompressed};
    }

    static {
        $VALUES = ObjSize.$values();
        primitiveSizeRegistry = new IdentityHashMap();
        primitiveSizeRegistry.put(Boolean.TYPE, 1);
        primitiveSizeRegistry.put(Byte.TYPE, 1);
        primitiveSizeRegistry.put(Character.TYPE, 2);
        primitiveSizeRegistry.put(Short.TYPE, 2);
        primitiveSizeRegistry.put(Integer.TYPE, 4);
        primitiveSizeRegistry.put(Long.TYPE, 8);
        primitiveSizeRegistry.put(Float.TYPE, 4);
        primitiveSizeRegistry.put(Double.TYPE, 8);
        detected = null;
    }
}

