/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.FixpCoord;
import java.awt.geom.Rectangle2D;

public class FixpRectangle
extends AbstractFixpRectangle {
    private long fixpMinX;
    private long fixpMinY;
    private long fixpMaxX;
    private long fixpMaxY;

    private FixpRectangle(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        this.fixpMinX = fixpMinX;
        this.fixpMinY = fixpMinY;
        this.fixpMaxX = fixpMaxX;
        this.fixpMaxY = fixpMaxY;
    }

    public static FixpRectangle fromFixpDiagonal(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        return new FixpRectangle(fixpMinX, fixpMinY, fixpMaxX, fixpMaxY);
    }

    public static FixpRectangle from(Rectangle2D r) {
        if (r instanceof AbstractFixpRectangle) {
            AbstractFixpRectangle fr = (AbstractFixpRectangle)r;
            return new FixpRectangle(fr.getFixpMinX(), fr.getFixpMinY(), fr.getFixpMaxX(), fr.getFixpMaxY());
        }
        long x = FixpCoord.lambdaToFixp(r.getX());
        long y = FixpCoord.lambdaToFixp(r.getY());
        long w = FixpCoord.lambdaToFixp(r.getWidth());
        long h2 = FixpCoord.lambdaToFixp(r.getHeight());
        return new FixpRectangle(x, y, x + w, y + h2);
    }

    @Override
    public long getFixpMinX() {
        return this.fixpMinX;
    }

    @Override
    public long getFixpMinY() {
        return this.fixpMinY;
    }

    @Override
    public long getFixpMaxX() {
        return this.fixpMaxX;
    }

    @Override
    public long getFixpMaxY() {
        return this.fixpMaxY;
    }

    @Override
    public void setFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        this.fixpMinX = fixpMinX;
        this.fixpMinY = fixpMinY;
        this.fixpMaxX = fixpMaxX;
        this.fixpMaxY = fixpMaxY;
    }

    @Override
    public FixpRectangle createFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        return new FixpRectangle(fixpMinX, fixpMinY, fixpMaxX, fixpMaxY);
    }
}

