/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;

public class ImmutableArrayList<E>
extends ArrayList<E> {
    private static final ImmutableArrayList<?> EMPTY = new ImmutableArrayList<Object>(new Object[0]);

    public static <T> ImmutableArrayList<T> of(Collection<? extends T> c2) {
        if (c2.isEmpty()) {
            return EMPTY;
        }
        return new ImmutableArrayList<T>(c2);
    }

    public static <T> ImmutableArrayList<T> of(T ... elems) {
        if (elems.length == 0) {
            return EMPTY;
        }
        return new ImmutableArrayList<T>(elems);
    }

    private ImmutableArrayList(Collection<? extends E> c2) {
        super(c2.size());
        super.addAll(c2);
        if (this.size() != c2.size()) {
            throw new ConcurrentModificationException();
        }
    }

    @SafeVarargs
    private ImmutableArrayList(E ... a2) {
        super(a2.length);
        for (E e2 : a2) {
            super.add(e2);
        }
        assert (this.size() == a2.length);
    }

    public ImmutableArrayList(E[] a2, int fromIndex, int toIndex) {
        super(toIndex - fromIndex);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > a2.length) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            super.add(a2[i2]);
        }
        assert (this.size() == toIndex - fromIndex);
    }

    public ImmutableArrayList<E> with(E[] a2) {
        int l2;
        if (a2 == null) {
            return this;
        }
        for (l2 = a2.length; l2 > 0 && a2[l2 - 1] == null; --l2) {
        }
        if (l2 == this.size()) {
            int i2;
            for (i2 = 0; i2 < this.size() && a2[i2] == this.get(i2); ++i2) {
            }
            if (i2 == l2) {
                return this;
            }
        }
        return new ImmutableArrayList<E>(a2, 0, l2);
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public void ensureCapacity(int minCapacity) {
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

