/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private final int limit;
    private int cursor;
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private ArrayIterator(E[] array) {
        this.array = array;
        this.limit = array.length;
        this.cursor = 0;
    }

    private ArrayIterator(E[] array, int start, int limit) {
        this.array = array;
        this.limit = limit;
        this.cursor = start;
    }

    public static <E> Iterator<E> iterator(E[] array) {
        if (array != null && array.length > 0) {
            return new ArrayIterator<E>(array);
        }
        Iterator<E> emptyIterator = ArrayIterator.emptyIterator();
        return emptyIterator;
    }

    public static <E> Iterator<E> iterator(E[] array, int start, int limit) {
        if (array != null) {
            if (start >= 0 && limit <= array.length) {
                if (start < limit) {
                    return new ArrayIterator<E>(array, start, limit);
                }
                if (start == limit) {
                    Iterator<E> emptyIterator = ArrayIterator.emptyIterator();
                    return emptyIterator;
                }
            }
        } else if (start == 0 && limit == 0) {
            Iterator<E> emptyIterator = ArrayIterator.emptyIterator();
            return emptyIterator;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.limit;
    }

    @Override
    public E next() {
        if (this.cursor >= this.limit) {
            throw new NoSuchElementException();
        }
        E next = this.array[this.cursor];
        ++this.cursor;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <E> Iterator<E> singletonIterator(final E o2) {
        return new Iterator<E>(){
            boolean passed;

            @Override
            public boolean hasNext() {
                return !this.passed;
            }

            @Override
            public E next() {
                if (this.passed) {
                    throw new NoSuchElementException();
                }
                this.passed = true;
                return o2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> i2i(final Iterator<T> iterator) {
        return new Iterable<T>(){
            boolean used = false;

            @Override
            public Iterator<T> iterator() {
                if (this.used) {
                    throw new RuntimeException("i2i() produces single-use Iterables!");
                }
                this.used = true;
                return iterator;
            }
        };
    }

    public static <T> ArrayList<T> i2al(Iterator<T> iterator) {
        ArrayList<T> ret = new ArrayList<T>();
        while (iterator.hasNext()) {
            ret.add(iterator.next());
        }
        return ret;
    }

    private static class EmptyIterator
    extends ArrayIterator<Object> {
        EmptyIterator() {
            super(new Object[0]);
        }
    }
}

