/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Character;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Symbol;
import com.sun.electric.util.acl2.HonsManager;
import java.util.Map;

class ACL2Cons
extends ACL2Object {
    final ACL2Object car;
    final ACL2Object cdr;

    ACL2Cons(ACL2Object car, ACL2Object cdr) {
        this(null, car, cdr);
    }

    private ACL2Cons(HonsManager hm, ACL2Object car, ACL2Object cdr) {
        super(ACL2Cons.hashCodeOfCons(car.hashCode, cdr.hashCode), hm);
        this.car = car;
        this.cdr = cdr;
    }

    static ACL2Cons intern(ACL2Object car, ACL2Object cdr, HonsManager hm) {
        Map<Key, ACL2Cons> allNormed = hm.conses;
        car = car.honsOwner == hm ? car : car.internImpl(hm);
        Key key = new Key(car, cdr = cdr.honsOwner == hm ? cdr : cdr.internImpl(hm));
        ACL2Cons result = allNormed.get(key);
        if (result == null) {
            result = new ACL2Cons(hm, car, cdr);
            allNormed.put(key, result);
        }
        return result;
    }

    @Override
    int len() {
        ACL2Object o2 = this;
        int n2 = 0;
        while (o2 instanceof ACL2Cons) {
            ++n2;
            o2 = o2.cdr;
        }
        return n2;
    }

    @Override
    public String toString() {
        return "cons" + this.len();
    }

    @Override
    public String rep() {
        return "(" + this.car.rep() + " . " + this.cdr.rep() + ")";
    }

    @Override
    ACL2Object internImpl(HonsManager hm) {
        return ACL2Cons.intern(this.car, this.cdr, hm);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof ACL2Cons) {
            ACL2Cons x = this;
            ACL2Cons y = (ACL2Cons)o2;
            while (x.hashCode == y.hashCode && x.car.equals(y.car)) {
                if (x.cdr == y.cdr) {
                    return true;
                }
                if (x.cdr.honsOwner != null && x.cdr.honsOwner == y.cdr.honsOwner) break;
                if (!(x.cdr instanceof ACL2Cons) || !(y.cdr instanceof ACL2Cons)) {
                    return x.cdr.equals(y.cdr);
                }
                x = (ACL2Cons)x.cdr;
                y = (ACL2Cons)y.cdr;
            }
        }
        return false;
    }

    static class Key {
        final ACL2Object car;
        final ACL2Object cdr;

        Key(ACL2Object car, ACL2Object cdr) {
            this.car = car;
            this.cdr = cdr;
            assert (car.honsOwner != null && cdr.honsOwner != null);
            assert (car.honsOwner == cdr.honsOwner || car instanceof ACL2Symbol || car instanceof ACL2Character || cdr instanceof ACL2Symbol || cdr instanceof ACL2Character);
        }

        public boolean equals(Object o2) {
            if (o2 instanceof Key) {
                Key that = (Key)o2;
                assert (this.car.honsOwner == that.car.honsOwner || this.car instanceof ACL2Symbol || this.car instanceof ACL2Character || that.car instanceof ACL2Symbol || that.car instanceof ACL2Character);
                assert (this.cdr.honsOwner == that.cdr.honsOwner || this.cdr instanceof ACL2Symbol || this.cdr instanceof ACL2Character || that.cdr instanceof ACL2Symbol || that.cdr instanceof ACL2Character);
                return this.car == that.car && this.cdr == that.cdr;
            }
            return false;
        }

        public int hashCode() {
            return ACL2Object.hashCodeOfCons(this.car.hashCode, this.cdr.hashCode);
        }
    }
}

