/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util;

import com.sun.electric.database.text.Version;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class UsageFormatter
extends Formatter {
    private String extraInfo;

    UsageFormatter(String extra) {
        this.extraInfo = extra;
    }

    private String calcDate(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(this.calcDate(record.getMillis()) + " - " + UsageFormatter.getUserAndHostInfo() + " - " + String.valueOf(Version.getVersion()) + " - " + this.extraInfo + "\n");
        return buf.toString();
    }

    public static String getUser() {
        return System.getProperty("user.name", "unknownUser");
    }

    private static String getUserAndHostInfo() {
        String hostName = "unknownHost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return UsageFormatter.getUser() + "-" + hostName;
    }

    private static FileHandler getHandler(String path) {
        FileHandler fileHandler = null;
        try {
            fileHandler = new FileHandler(path, true);
        }
        catch (Exception e2) {
            System.out.println("Error in opening Logger '" + path + "'");
        }
        return fileHandler;
    }

    public static void logUsage(String name, String path, boolean tryHome, String extraInfo) {
        Logger logger = Logger.getLogger("global");
        logger.setLevel(Level.INFO);
        FileHandler fileHandler = UsageFormatter.getHandler(path + "/" + name);
        if (fileHandler == null && tryHome) {
            fileHandler = UsageFormatter.getHandler(System.getenv("HOME") + "/" + name);
        }
        if (fileHandler != null) {
            logger.addHandler(fileHandler);
            fileHandler.setFormatter(new UsageFormatter(extraInfo));
        }
        logger.info("Logging this session for '" + UsageFormatter.getUserAndHostInfo() + "'");
        if (fileHandler != null) {
            fileHandler.close();
        }
    }
}

