/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.patterns;

import com.sun.electric.tool.util.concurrent.patterns.PForTask;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange;
import java.util.List;

public class PForJob<T extends BlockedRange<T>>
extends PJob {
    public PForJob(T range, PForTask<T> task) {
        this.add(new SplitIntoTasks<T>(this, range, task), -1);
    }

    public PForJob(T range, PForTask<T> task, IThreadPool pool) {
        super(pool);
        this.add(new SplitIntoTasks<T>(this, range, task), -1);
    }

    public static final class SplitIntoTasks<T extends BlockedRange<T>>
    extends PTask {
        private T range;
        private PForTask<T> task;

        public SplitIntoTasks(PJob job, T range, PForTask<T> task) {
            super(job);
            this.range = range;
            this.task = task;
        }

        @Override
        public void execute() {
            int threadNum = this.job.getThreadPool().getPoolSize();
            for (int i2 = 0; i2 < threadNum; ++i2) {
                this.job.add(new SplitterTask<T>(this.job, this.range, this.task, i2, threadNum));
            }
        }
    }

    public static final class SplitterTask<T extends BlockedRange<T>>
    extends PTask {
        private T range;
        private PForTask<T> task;

        public SplitterTask(PJob job, T range, PForTask<T> task, int number, int total) {
            super(job);
            this.range = ((BlockedRange)range).createInstance(number, total);
            this.task = task;
        }

        @Override
        public void execute() {
            List tmpRange;
            int step = this.job.getThreadPool().getPoolSize();
            while ((tmpRange = ((BlockedRange)this.range).splitBlockedRange(step)) != null) {
                for (BlockedRange tr : tmpRange) {
                    try {
                        PForTask taskObj = (PForTask)this.task.clone();
                        taskObj.setRange(tr);
                        taskObj.setPJob(this.job);
                        this.job.add(taskObj, -1);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }
}

