/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.debug;

import com.sun.electric.tool.util.concurrent.debug.IDebug;
import com.sun.electric.tool.util.concurrent.runtime.WorkerStrategy;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;

public class LoadBalancing
implements IDebug {
    private static LoadBalancing instance = new LoadBalancing();
    private Set<WorkerStrategy> workers = ConcurrentCollectionFactory.createConcurrentHashSet();

    private LoadBalancing() {
    }

    public static LoadBalancing getInstance() {
        return instance;
    }

    public void registerWorker(WorkerStrategy worker) {
        this.workers.add(worker);
    }

    public void reset() {
        this.workers.clear();
    }

    @Override
    public void printStatistics() {
        Set<WorkerStrategy> workersLocalCopy = ConcurrentCollectionFactory.copySetToConcurrent(this.workers);
        int sum = 0;
        Iterator<WorkerStrategy> it = workersLocalCopy.iterator();
        while (it.hasNext()) {
            sum += it.next().getExecutedCounter();
        }
        double mean = (double)sum / (double)workersLocalCopy.size();
        double[] varField = new double[workersLocalCopy.size()];
        int i2 = 0;
        for (WorkerStrategy worker : workersLocalCopy) {
            System.out.print(worker);
            System.out.print(" - ");
            varField[i2] = (double)worker.getExecutedCounter() / (double)sum;
            System.out.println(this.getPercentageString(varField[i2]));
            ++i2;
        }
        double dev = this.standardDeviation(varField);
        System.out.print("mean value");
        System.out.print(" - ");
        System.out.println(this.getPercentageString(mean / (double)sum));
        System.out.print("deviation");
        System.out.print(" - ");
        System.out.println(this.getPercentageString(dev));
    }

    private double varianceEqualDistribution(double[] values, double mean) {
        double var = 0.0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            var += Math.pow(values[i2] - mean, 2.0);
        }
        return var / (double)values.length;
    }

    private double varianceEqualDistribution(double[] values) {
        double mean = this.meanEqualDistribution(values);
        return this.varianceEqualDistribution(values, mean);
    }

    private double meanEqualDistribution(double[] values) {
        double mean = 0.0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            mean += values[i2];
        }
        return mean / (double)values.length;
    }

    private double standardDeviation(double[] values) {
        double var = this.varianceEqualDistribution(values);
        return Math.sqrt(var);
    }

    private String getPercentageString(double value) {
        StringBuilder builder = new StringBuilder();
        DecimalFormat df2 = new DecimalFormat("##0.00");
        builder.append(df2.format(value * 100.0));
        builder.append("%");
        return builder.toString();
    }
}

