/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;

public class CircularArray<T>
extends IStructure<T> {
    private int logCapacity;
    private T[] currentElements;

    public CircularArray(int logCapacity) {
        this.logCapacity = logCapacity;
        this.currentElements = new Object[1 << logCapacity];
    }

    public int getCapacity() {
        return 1 << this.logCapacity;
    }

    @Override
    public T get(int i2) {
        return this.currentElements[i2 % this.getCapacity()];
    }

    @Override
    @Deprecated
    public void add(T item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T item, int i2) {
        this.currentElements[i2 % this.getCapacity()] = item;
    }

    public CircularArray<T> resize(int bottom, int top) {
        CircularArray<T> newArray = new CircularArray<T>(this.logCapacity + 1);
        for (int i2 = top; i2 < bottom; ++i2) {
            newArray.add(this.get(i2), i2);
        }
        return newArray;
    }

    @Override
    @Deprecated
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public T remove() {
        throw new UnsupportedOperationException();
    }
}

