/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.StepSize;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class HorizRuler
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Panel wavePanel;
    private WaveformWindow waveWindow;
    private double startX;

    HorizRuler(Panel wavePanel, WaveformWindow waveWindow) {
        this.wavePanel = wavePanel;
        this.waveWindow = waveWindow;
        Dimension sz = new Dimension(16, 20);
        this.setMinimumSize(sz);
        this.setPreferredSize(sz);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        new DropTarget(this, 0x40000000, waveWindow.waveformDropTarget, true);
    }

    public Panel getPanel() {
        return this.wavePanel;
    }

    public WaveformWindow getWaveformWindow() {
        return this.waveWindow;
    }

    @Override
    public void paint(Graphics g2) {
        this.renderRuler(g2, null, this.wavePanel);
    }

    public List<PolyBase> getPolysForPrinting(Panel drawHere) {
        ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
        this.renderRuler(null, polys, drawHere);
        return polys;
    }

    private void renderRuler(Graphics g2, List<PolyBase> polys, Panel drawHere) {
        StepSize ss;
        Dimension sz = this.getSize();
        int wid = sz.width;
        int hei = sz.height;
        int offX = 0;
        Signal<?> xAxisSig = this.waveWindow.getXAxisSignalAll();
        if (drawHere != null) {
            xAxisSig = drawHere.getXAxisSignal();
        }
        if (g2 != null) {
            if (drawHere != null) {
                Dimension tableSz = this.waveWindow.getWaveformTable().getSize();
                Point screenLoc = this.waveWindow.getWaveformTable().getLocationOnScreen();
                offX = this.waveWindow.getScreenHighX() - (screenLoc.x + tableSz.width);
            } else {
                Point screenLoc = this.getLocationOnScreen();
                offX = this.waveWindow.getScreenLowX() - screenLoc.x;
            }
            int newWid = this.waveWindow.getScreenHighX() - this.waveWindow.getScreenLowX();
            g2.setColor(this.waveWindow.getBackgroundColor());
            g2.fillRect(0, 0, wid, hei);
            if (newWid == 0 || this.waveWindow.getNumPanels() == 0) {
                return;
            }
            if (offX + newWid > wid) {
                newWid = wid - offX;
            }
            wid = newWid;
            if (drawHere == null) {
                drawHere = this.waveWindow.getPanels().next();
            }
            g2.setClip(offX, 0, wid, hei);
            g2.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_BACKGROUND)));
            g2.fillRect(offX, 0, wid, hei);
            g2.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_FOREGROUND)));
            g2.setFont(this.waveWindow.getFont());
        }
        String xAxisName = "Time";
        String xAxisPostfix = "s";
        if (xAxisSig != null) {
            xAxisName = xAxisSig.getSignalName();
            xAxisPostfix = null;
        }
        if (polys != null) {
            Poly poly = new Poly(Poly.fromLambda(drawHere.getVertAxisPos() + offX, hei - 1), Poly.fromLambda(wid + offX, hei - 1));
            polys.add(poly);
            poly = new Poly(Poly.fromLambda(wid / 2, 0.0));
            poly.setStyle(Poly.Type.TEXTBOT);
            poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(12));
            poly.setString(xAxisName);
            polys.add(poly);
        } else {
            g2.drawLine(drawHere.getVertAxisPos() + offX, hei - 1, wid + offX, hei - 1);
            g2.drawString(xAxisName, offX + 1, hei - 6);
        }
        double displayedLow = drawHere.convertXScreenToData(drawHere.getVertAxisPos());
        double displayedHigh = drawHere.convertXScreenToData(wid);
        if (displayedLow > displayedHigh) {
            double s = displayedLow;
            displayedLow = displayedHigh;
            displayedHigh = s;
        }
        if ((ss = new StepSize(displayedHigh, displayedLow, 10)).getSeparation() == 0.0) {
            return;
        }
        int lastX = -1;
        for (double xValue = ss.getLowValue(); !(xValue > ss.getHighValue()); xValue += ss.getSeparation()) {
            if (!(xValue >= displayedLow)) continue;
            int x = drawHere.convertXDataToScreen(xValue) + offX;
            if (polys != null) {
                polys.add(new Poly(Poly.fromLambda(x, 0.0), Poly.fromLambda(x, hei)));
            } else {
                g2.drawLine(x, 0, x, hei);
            }
            if (lastX >= 0) {
                if (x - lastX > 100) {
                    for (int i2 = 1; i2 < 5; ++i2) {
                        int intX = (x - lastX) / 5 * i2 + lastX;
                        if (polys != null) {
                            polys.add(new Poly(Poly.fromLambda(intX, hei / 2), Poly.fromLambda(intX, hei)));
                            continue;
                        }
                        g2.drawLine(intX, hei / 2, intX, hei);
                    }
                } else if (x - lastX > 25) {
                    int intX = (x - lastX) / 2 + lastX;
                    if (polys != null) {
                        polys.add(new Poly(Poly.fromLambda(intX, hei / 2), Poly.fromLambda(intX, hei)));
                    } else {
                        g2.drawLine(intX, hei / 2, intX, hei);
                    }
                }
            }
            String xValueVal = TextUtils.convertToEngineeringNotation(xValue, xAxisPostfix, ss.getStepScale() + 3);
            if (polys != null) {
                Poly poly = new Poly(Poly.fromLambda(x + 2, 4.0));
                poly.setStyle(Poly.Type.TEXTLEFT);
                poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(6));
                poly.setString(xValueVal);
                polys.add(poly);
            } else {
                g2.drawString(xValueVal, x + 2, 10);
            }
            lastX = x;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (ClickZoomWireListener.isRightMouse(evt)) {
            this.waveWindow.vcrClickStop();
            JPopupMenu menu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Linear");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    HorizRuler.this.makeLinear();
                }
            });
            menu.add(item);
            item = new JMenuItem("Logarithmic");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    HorizRuler.this.makeLogarithmic();
                }
            });
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem("Make the X axis show Time");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    HorizRuler.this.restoreTime();
                }
            });
            menu.add(item);
            menu.show(this, evt.getX(), evt.getY());
            return;
        }
        Panel pan = this.wavePanel;
        if (pan == null && this.waveWindow.getNumPanels() > 0) {
            pan = this.waveWindow.getPanel(0);
        }
        if (pan != null) {
            this.startX = pan.convertXScreenToData(evt.getX());
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Panel pan = this.wavePanel;
        if (pan == null && this.waveWindow.getNumPanels() > 0) {
            pan = this.waveWindow.getPanel(0);
        }
        if (pan != null) {
            double endX = pan.convertXScreenToData(evt.getX());
            double dXValue = endX - this.startX;
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                if (!this.waveWindow.isXAxisLocked() && wp != this.wavePanel) continue;
                wp.setXAxisRange(wp.getMinXAxis() - dXValue, wp.getMaxXAxis() - dXValue);
                wp.repaintWithRulers();
            }
            this.startX = endX;
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    private void makeLinear() {
        if (this.waveWindow.isXAxisLocked()) {
            this.waveWindow.setWaveWindowLogarithmic(false);
            this.waveWindow.redrawAllPanels();
        } else {
            this.wavePanel.setPanelLogarithmicHorizontally(false);
            this.wavePanel.repaintContents();
        }
    }

    private void makeLogarithmic() {
        if (this.waveWindow.isXAxisLocked()) {
            this.waveWindow.setWaveWindowLogarithmic(true);
            this.waveWindow.redrawAllPanels();
        } else {
            this.wavePanel.setPanelLogarithmicHorizontally(true);
            this.wavePanel.repaintContents();
        }
    }

    private void restoreTime() {
        double leftEdge = this.waveWindow.getSimData().getMinTime();
        double rightEdge = this.waveWindow.getSimData().getMaxTime();
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!this.waveWindow.isXAxisLocked() && wp != this.wavePanel) continue;
            wp.setXAxisSignal(null);
            wp.setXAxisRange(leftEdge, rightEdge);
            if (wp.getHorizRuler() != null) {
                wp.getHorizRuler().repaint();
            }
            wp.repaintContents();
        }
        if (this.waveWindow.isXAxisLocked()) {
            this.waveWindow.setXAxisSignalAll(null);
            this.waveWindow.getMainHorizRuler().repaint();
            this.waveWindow.redrawAllPanels();
        }
        this.waveWindow.saveSignalOrder();
    }
}

