/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.NewExport;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TechPalette;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PaletteFrame
implements MouseListener {
    private JPanel topPanel;
    private TechPalette techPalette;
    private JComboBox<String> techSelector;

    private PaletteFrame() {
    }

    public static PaletteFrame newInst(WindowFrame ww) {
        PaletteFrame palette = new PaletteFrame();
        palette.topPanel = new JPanel();
        palette.initComponents(ww);
        return palette;
    }

    public void loadTechnologies(boolean makeCurrent) {
        Technology cur = Technology.getCurrent();
        if (!makeCurrent) {
            cur = Technology.findTechnology((String)this.techSelector.getSelectedItem());
        }
        this.techSelector.removeAllItems();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech == Generic.tech()) continue;
            this.techSelector.addItem(tech.getTechName());
        }
        if (cur != null) {
            this.setSelectedItem(cur.getTechName());
        }
    }

    public void setSelectedItem(Object anObject) {
        this.techSelector.setSelectedItem(anObject);
    }

    private void initComponents(WindowFrame wf) {
        JPanel content = this.topPanel;
        content.setLayout(new GridBagLayout());
        this.techSelector = new JComboBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add(this.techSelector, gridBagConstraints);
        this.techPalette = new TechPalette();
        this.techPalette.setFocusable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.techPalette, gridBagConstraints);
        this.techSelector.setLightWeightPopupEnabled(false);
        this.loadTechnologies(true);
        this.techSelector.addActionListener(new WindowFrame.CurTechControlListener(wf));
    }

    public void setCursor(Cursor cursor) {
        this.techPalette.setCursor(cursor);
    }

    public TechPalette getTechPalette() {
        return this.techPalette;
    }

    public JPanel getMainPanel() {
        return this.topPanel;
    }

    public void arcProtoChanged() {
        this.techPalette.repaint();
    }

    public void loadForTechnology(Technology tech, WindowFrame ww) {
        String desiredTech;
        if (tech == null) {
            return;
        }
        String curSelectedTech = (String)this.techSelector.getSelectedItem();
        if (!curSelectedTech.equals(desiredTech = tech.getTechName())) {
            this.techSelector.setSelectedItem(desiredTech);
        }
        Dimension size = this.techPalette.loadForTechnology(tech, ww.getContent().getCell(), UserInterfaceMain.getEditingPreferences());
        if (this.techPalette.isVisible()) {
            this.setSize(size);
        }
    }

    private void setSize(Dimension size) {
        this.topPanel.setSize(size);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isShiftDown() || e2.isControlDown() || e2.isAltDown()) {
            return;
        }
    }

    public static PlaceNodeListener placeInstance(Object obj, PlaceNodeEventListener palette, boolean export) {
        NodeProto np = null;
        NodeInst ni = null;
        String placeText = null;
        Object whatToCreate = null;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return null;
        }
        if (obj instanceof String) {
            placeText = (String)obj;
            whatToCreate = Variable.betterVariableName(placeText);
            obj = Generic.tech().invisiblePinNode;
        }
        if (obj instanceof NodeProto) {
            Cell cell;
            Cell iconCell;
            np = (NodeProto)obj;
            if (np instanceof Cell && (iconCell = (cell = (Cell)np).iconView()) != null && iconCell != cell) {
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Don't you really want to place the icon " + iconCell.describe(true) + "?");
                if (response == 2) {
                    return null;
                }
                if (response == 0) {
                    np = iconCell;
                    obj = np;
                }
            }
        } else if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            np = ni.getProto();
            whatToCreate = String.valueOf((Object)ni.getFunction()) + " node";
        }
        if (np != null) {
            WindowFrame.ElectricEventListener oldListener = WindowFrame.getListener();
            Cursor oldCursor = TopLevel.getCurrentCursor();
            if (whatToCreate != null) {
                System.out.println("Click to create " + (String)whatToCreate);
            } else if (np instanceof Cell) {
                System.out.println("Click to create an instance of " + String.valueOf(np));
            } else {
                System.out.println("Click to create " + String.valueOf(np));
            }
            WindowFrame.ElectricEventListener newListener = oldListener;
            if (newListener != null && newListener instanceof PlaceNodeListener) {
                ((PlaceNodeListener)newListener).setParameter(obj);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
            } else {
                newListener = new PlaceNodeListener(obj, oldListener, oldCursor, palette);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
                WindowFrame.setListener(newListener);
            }
            if (placeText != null) {
                ((PlaceNodeListener)newListener).setTextNode(placeText);
            }
            if (palette != null) {
                palette.placeNodeStarted(obj);
            }
            TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(12));
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                wnd.getWindowFrame().requestFocus();
                wnd.zoomWindowToFitCellInstance(np);
            }
            return (PlaceNodeListener)newListener;
        }
        return null;
    }

    public static class PlaceNodeListener
    implements WindowFrame.ElectricEventListener {
        private int lastX;
        private int lastY;
        private Object toDraw;
        private WindowFrame.ElectricEventListener oldListener;
        private Cursor oldCursor;
        private String textNode;
        private boolean makePort;
        private PlaceNodeEventListener palette;
        private int extraRotation;

        private PlaceNodeListener(Object toDraw, WindowFrame.ElectricEventListener oldListener, Cursor oldCursor, PlaceNodeEventListener palette) {
            this.toDraw = toDraw;
            this.oldListener = oldListener;
            this.oldCursor = oldCursor;
            this.textNode = null;
            this.makePort = false;
            this.palette = palette;
            this.extraRotation = 0;
        }

        public void makePortWhenCreated(boolean m2) {
            this.makePort = m2;
        }

        public void setParameter(Object toDraw) {
            this.toDraw = toDraw;
        }

        public void setTextNode(String varName) {
            this.textNode = varName;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create node: this window has no cell in it");
                return;
            }
            this.getCoords(evt);
            Point2D where = wnd.screenToDatabase(this.lastX, this.lastY);
            EditWindow.gridAlign(where);
            NodeInst ni = null;
            NodeProto np = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            if (cell.isInTechnologyLibrary() && Manipulate.invalidCreation(np, cell)) {
                this.finished(wnd, false);
                return;
            }
            int defAngle = 0;
            Object descript = "Create ";
            if (np instanceof Cell) {
                descript = (String)descript + ((Cell)np).noLibDescribe();
            } else {
                descript = (String)descript + np.getName() + " Primitive";
                defAngle = User.getNewNodeRotation();
            }
            wnd.getHighlighter().clear();
            new PlaceNewNode(wnd, (String)descript, np, ni, defAngle, where, cell, this.textNode, this.makePort);
            this.finished(wnd, false);
        }

        public void finished(EditWindow wnd, boolean cancelled) {
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.finished();
            }
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
            if (this.palette != null) {
                this.palette.placeNodeFinished(cancelled);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                this.getCoords(evt);
                wnd.showDraggedBox(this.toDraw, this.lastX, this.lastY, this.extraRotation / 10);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                this.getCoords(evt);
                wnd.showDraggedBox(this.toDraw, this.lastX, this.lastY, this.extraRotation / 10);
            }
        }

        private void getCoords(MouseEvent evt) {
            EditWindow wnd = (EditWindow)evt.getSource();
            this.lastX = evt.getX();
            this.lastY = evt.getY();
            if (evt.isControlDown()) {
                Point2D drawnLoc = wnd.screenToDatabase(this.lastX, this.lastY);
                if (Math.abs(drawnLoc.getX()) > Math.abs(drawnLoc.getY())) {
                    ScreenPoint newPt = wnd.databaseToScreen(drawnLoc.getX(), 0.0);
                    this.lastX = newPt.getIntX();
                    this.lastY = newPt.getIntY();
                } else {
                    ScreenPoint newPt = wnd.databaseToScreen(0.0, drawnLoc.getY());
                    this.lastX = newPt.getIntX();
                    this.lastY = newPt.getIntY();
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
            int chr = evt.getKeyCode();
            if (chr == 65 || chr == 27) {
                this.finished(EditWindow.getCurrent(), true);
            }
            if (chr == 44 || chr == 46) {
                NodeProto oldNp;
                int deltaAng = 900;
                if (chr == 46) {
                    deltaAng = 2700;
                }
                this.extraRotation = (this.extraRotation + deltaAng) % 3600;
                int techBits = 0;
                int prevAngle = 0;
                if (this.toDraw instanceof NodeProto) {
                    oldNp = (NodeProto)this.toDraw;
                } else {
                    NodeInst oldNi = (NodeInst)this.toDraw;
                    oldNp = oldNi.getProto();
                    techBits = oldNi.getTechSpecific();
                    prevAngle = oldNi.getAngle();
                }
                Orientation orient = Orientation.fromAngle((prevAngle + deltaAng) % 3600);
                this.toDraw = NodeInst.makeDummyInstance(oldNp, ep, techBits, EPoint.fromLambda(0.0, 0.0), oldNp.getDefWidth(ep), oldNp.getDefHeight(ep), orient);
                if (evt.getSource() instanceof EditWindow) {
                    EditWindow wnd = (EditWindow)evt.getSource();
                    wnd.showDraggedBox(this.toDraw, this.lastX, this.lastY, this.extraRotation / 10);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent e2) {
        }
    }

    public static interface PlaceNodeEventListener {
        public void placeNodeStarted(Object var1);

        public void placeNodeFinished(boolean var1);
    }

    public static class PlaceNewNode
    extends Job {
        private NodeProto np;
        private Variable techEditVar;
        private int techBits = 0;
        private Orientation defOrient = Orientation.IDENT;
        private double[] angles = null;
        private EPoint where;
        private Cell cell;
        private String varName;
        private boolean export;
        private Variable.Key varKeyToHighlight;
        private ElectricObject objToHighlight;
        private transient EditWindow wnd;

        public PlaceNewNode(EditWindow wnd, String description, NodeProto np, NodeInst ni, int defAngle, Point2D where, Cell cell, String varName, boolean export) {
            super(description, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.np = np;
            this.wnd = wnd;
            if (ni != null) {
                this.defOrient = ni.getOrient();
                this.techBits = ni.getTechSpecific();
                this.angles = ni.getArcDegrees();
                this.techEditVar = ni.getVar(Info.OPTION_KEY);
            } else if (np instanceof PrimitiveNode) {
                this.defOrient = Orientation.fromJava(defAngle, defAngle >= 3600, false);
            }
            this.where = EPoint.snap(where);
            this.cell = cell;
            this.varName = varName;
            this.export = export;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst newNi;
            EditingPreferences ep = this.getEditingPreferences();
            double width = this.np.getDefWidth(ep);
            double height = this.np.getDefHeight(ep);
            if (this.varName != null) {
                height = 0.0;
                width = 0.0;
            }
            if ((newNi = NodeInst.makeInstance(this.np, ep, (Point2D)this.where, width, height, this.cell, this.defOrient, null, this.techBits)) == null) {
                return false;
            }
            if (this.np == Generic.tech().cellCenterNode || this.np == Generic.tech().essentialBoundsNode || this.np instanceof PrimitiveNode && ((PrimitiveNode)this.np).isPureWellNode()) {
                newNi.setHardSelect();
            }
            if (this.np == Generic.tech().routeNode) {
                Object ret = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Exclusion layers (examples: '1', '3,5', '2-6'):", "Routing Exclusion Layers", 3, null, null, "ALL");
                if (ret == null) {
                    ret = "";
                }
                newNi.newDisplayVar(Generic.ROUTING_EXCLUSION, ret, ep);
            }
            if (this.varName != null) {
                this.varKeyToHighlight = Variable.newKey(this.varName);
                newNi.newVar(this.varKeyToHighlight, (Object)"text", ep.getAnnotationTextDescriptor());
                this.objToHighlight = newNi;
                this.fieldVariableChanged("objToHighlight");
                this.fieldVariableChanged("varKeyToHighlight");
            } else {
                if (this.np == Schematics.tech().resistorNode || this.np.getFunction() == PrimitiveNode.Function.RESIST) {
                    newNi.newDisplayVar(Schematics.SCHEM_RESISTANCE, "100", ep);
                    if (newNi.getFunction().isComplexResistor()) {
                        td = ep.getNodeTextDescriptor();
                        td = td.getSize().isAbsolute() ? td.withAbsSize((int)(td.getSize().getSize() - 1.0)) : td.withRelSize(td.getSize().getSize() - 0.5);
                        td = td.withOff(1.5, 0.0);
                        newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2", td);
                        td = ep.getNodeTextDescriptor();
                        td = td.getSize().isAbsolute() ? td.withAbsSize((int)(td.getSize().getSize() - 2.0)) : td.withRelSize(td.getSize().getSize() - 0.7);
                        td = td.withOff(-1.5, 0.0);
                        newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2", td);
                    }
                } else if (this.np == Schematics.tech().capacitorNode) {
                    newNi.newDisplayVar(Schematics.SCHEM_CAPACITANCE, "100m", ep);
                } else if (this.np == Schematics.tech().inductorNode || this.np.getFunction() == PrimitiveNode.Function.INDUCT) {
                    newNi.newDisplayVar(Schematics.SCHEM_INDUCTANCE, "100", ep);
                } else if (this.np == Schematics.tech().diodeNode) {
                    newNi.newDisplayVar(Schematics.SCHEM_DIODE, "10", ep);
                } else if (this.np == Schematics.tech().josephsonNode) {
                    td = ep.getNodeTextDescriptor();
                    newNi.newVar(Schematics.ATTR_AREA, (Object)"5", td);
                } else if (this.np == Schematics.tech().transistorNode || this.np == Schematics.tech().transistor4Node) {
                    if (newNi.getFunction().isFET()) {
                        td = ep.getNodeTextDescriptor().withOff(0.5, -1.0);
                        newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2", td);
                        td = ep.getNodeTextDescriptor();
                        td = td.getSize().isAbsolute() ? td.withAbsSize((int)(td.getSize().getSize() - 2.0)) : td.withRelSize(td.getSize().getSize() - 0.5);
                        td = td.withOff(-0.5, -1.0);
                        newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2", td);
                    } else {
                        newNi.newDisplayVar(Schematics.ATTR_AREA, "10", ep);
                    }
                } else if (this.np instanceof PrimitiveNode && ((PrimitiveNode)this.np).isPartialCircle() && this.angles != null) {
                    newNi.setArcDegrees(this.angles[0], this.angles[1], ep);
                }
                this.objToHighlight = newNi;
                this.fieldVariableChanged("objToHighlight");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            Highlighter highlighter = this.wnd.getHighlighter();
            if (this.varKeyToHighlight != null) {
                highlighter.addText(this.objToHighlight, this.cell, this.varKeyToHighlight);
            } else {
                highlighter.addElectricObject(this.objToHighlight, this.cell);
            }
            highlighter.finished();
            this.wnd.getWindowFrame().requestFocus();
            if (this.cell.isInTechnologyLibrary()) {
                Manipulate.completeNodeCreation((NodeInst)this.objToHighlight, this.techEditVar);
            }
            if (this.export) {
                new NewExport(TopLevel.getCurrentJFrame());
            }
        }
    }
}

