/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.FixpTransform;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class OutlineListener
implements WindowFrame.ElectricEventListener {
    public static OutlineListener theOne = new OutlineListener();
    private double oldX;
    private double oldY;
    private boolean doingMotionDrag;
    private int point;
    private NodeInst outlineNode;
    private Highlighter highlighter;
    private Highlight high;

    private OutlineListener() {
    }

    public void setNode(Highlight highlight, NodeInst ni) {
        EditWindow wnd = EditWindow.getCurrent();
        this.highlighter = wnd.getHighlighter();
        this.high = highlight;
        this.point = 0;
        this.outlineNode = ni;
        EPoint[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null && ni.getFunction() == PrimitiveNode.Function.NODE) {
            new InitializePoints(this, ni);
            return;
        }
        this.setPoint(0);
        if (wnd != null) {
            wnd.fullRepaint();
        }
    }

    public void setPoint(int p) {
        if (this.highlighter != null && this.high != null) {
            this.highlighter.setPoint(this.high, this.high.getElectricObject(), p);
        }
        if (p < 0) {
            this.outlineNode = null;
            this.highlighter = null;
            this.high = null;
        }
    }

    public void deletePoint() {
        EPoint[] origPoints = this.outlineNode.getTrace();
        if (origPoints.length <= 2) {
            System.out.println("Cannot delete the last point on an outline");
            return;
        }
        FixpTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
        Point2D[] newPoints = new Point2D[origPoints.length - 1];
        int pt = this.point;
        int j2 = 0;
        for (int i2 = 0; i2 < origPoints.length; ++i2) {
            if (i2 == pt) continue;
            if (origPoints[j2] != null) {
                newPoints[j2] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + ((Point2D)origPoints[i2]).getX(), this.outlineNode.getAnchorCenterY() + ((Point2D)origPoints[i2]).getY());
                trans.transform(newPoints[j2], newPoints[j2]);
            }
            ++j2;
        }
        if (pt > 0) {
            --pt;
        }
        this.setNewPoints(newPoints, pt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        Highlighter highlighter = wnd.getHighlighter();
        if (evt.getClickCount() == 2 && highlighter.getNumHighlights() >= 1) {
            EditMenu.getInfoCommand(true);
            return;
        }
        if (ClickZoomWireListener.isRightMouse(evt)) {
            FixpTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
            EPoint[] origPoints = this.outlineNode.getTrace();
            if (origPoints == null) {
                Point2D[] newPoints = new Point2D[]{new Point2D.Double(this.outlineNode.getAnchorCenterX(), this.outlineNode.getAnchorCenterY())};
                EditWindow.gridAlign(newPoints[0]);
                this.setNewPoints(newPoints, 0);
                this.point = 0;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else if (origPoints.length == 1) {
                Point2D[] newPoints = new Point2D[2];
                newPoints[0] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + ((Point2D)origPoints[0]).getX(), this.outlineNode.getAnchorCenterY() + ((Point2D)origPoints[0]).getY());
                trans.transform(newPoints[0], newPoints[0]);
                EditWindow.gridAlign(newPoints[0]);
                newPoints[1] = new Point2D.Double(newPoints[0].getX() + 2.0, newPoints[0].getY() + 2.0);
                EditWindow.gridAlign(newPoints[1]);
                this.setNewPoints(newPoints, 1);
                this.point = 1;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else {
                if (this.point < 0 || this.point >= origPoints.length) {
                    System.out.println("Must select a point");
                    return;
                }
                Point2D[] newPoints = new Point2D[origPoints.length + 1];
                int j2 = 0;
                for (int i2 = 0; i2 < origPoints.length; ++i2) {
                    if (origPoints[i2] != null) {
                        newPoints[j2] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + ((Point2D)origPoints[i2]).getX(), this.outlineNode.getAnchorCenterY() + ((Point2D)origPoints[i2]).getY());
                    }
                    ++j2;
                    if (i2 != this.point) continue;
                    newPoints[j2] = wnd.screenToDatabase(x, y);
                    EditWindow.gridAlign(newPoints[j2]);
                    ++j2;
                }
                trans.transform(newPoints, 0, newPoints, 0, newPoints.length);
                this.setNewPoints(newPoints, this.point + 1);
                this.oldX = newPoints[this.point + 1].getX();
                this.oldY = newPoints[this.point + 1].getY();
            }
            this.doingMotionDrag = true;
            wnd.repaint();
            return;
        }
        Point2D pt = wnd.screenToDatabase(x, y);
        Highlight found = highlighter.findObject(pt, wnd, true, false, false, false, true, true, false, true);
        this.doingMotionDrag = false;
        if (found != null) {
            this.high = highlighter.getOneHighlight();
            assert (this.high == found);
            this.outlineNode = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
            if (this.high != null && this.outlineNode != null) {
                this.point = this.high.getPoint();
                EPoint[] origPoints = this.outlineNode.getTrace();
                if (origPoints != null) {
                    this.doingMotionDrag = true;
                    EditWindow.gridAlign(pt);
                    this.oldX = pt.getX();
                    this.oldY = pt.getY();
                }
            }
        }
        wnd.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (this.doingMotionDrag) {
            this.doingMotionDrag = false;
            int newX = evt.getX();
            int newY = evt.getY();
            Point2D curPt = wnd.screenToDatabase(newX, newY);
            EditWindow.gridAlign(curPt);
            highlighter.setHighlightOffset(0L, 0L);
            this.moveSelectedPoint(curPt.getX() - this.oldX, curPt.getY() - this.oldY);
            wnd.fullRepaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        int newX = evt.getX();
        int newY = evt.getY();
        Point2D curPt = wnd.screenToDatabase(newX, newY);
        EditWindow.gridAlign(curPt);
        ScreenPoint pt = wnd.databaseToScreen(curPt.getX(), curPt.getY());
        ScreenPoint gridPt = wnd.databaseToScreen(this.oldX, this.oldY);
        if (this.doingMotionDrag) {
            highlighter.setHighlightOffset(pt.getX() - gridPt.getX(), pt.getY() - gridPt.getY());
            wnd.repaint();
            return;
        }
        wnd.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 46) {
            int nextPoint = this.point + 1;
            EPoint[] origPoints = this.outlineNode.getTrace();
            if (nextPoint >= origPoints.length) {
                nextPoint = 0;
            }
            this.point = nextPoint;
            this.setPoint(this.point);
            wnd.repaint();
        } else if (chr == 44) {
            EPoint[] origPoints = this.outlineNode.getTrace();
            int prevPoint = this.point - 1;
            if (prevPoint < 0) {
                prevPoint = origPoints.length - 1;
            }
            this.point = prevPoint;
            this.setPoint(this.point);
            wnd.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e2) {
    }

    public void moveSelectedPoint(double dx, double dy) {
        EPoint[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null) {
            return;
        }
        Point2D[] newPoints = new Point2D[origPoints.length];
        for (int i2 = 0; i2 < origPoints.length; ++i2) {
            if (origPoints[i2] == null) continue;
            newPoints[i2] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + ((Point2D)origPoints[i2]).getX(), this.outlineNode.getAnchorCenterY() + ((Point2D)origPoints[i2]).getY());
        }
        FixpTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
        for (int i3 = 0; i3 < newPoints.length; ++i3) {
            if (newPoints[i3] == null) continue;
            trans.transform(newPoints[i3], newPoints[i3]);
        }
        if (newPoints[this.point] != null) {
            newPoints[this.point].setLocation(newPoints[this.point].getX() + dx, newPoints[this.point].getY() + dy);
        }
        this.setNewPoints(newPoints, this.point);
    }

    private void setNewPoints(Point2D[] newPoints, int newPoint) {
        EPoint[] pts = new EPoint[newPoints.length];
        for (int i2 = 0; i2 < newPoints.length; ++i2) {
            if (newPoints[i2] == null) continue;
            pts[i2] = EPoint.fromLambda(newPoints[i2].getX(), newPoints[i2].getY());
        }
        new SetPoints(this, this.outlineNode, pts, newPoint);
    }

    private static class InitializePoints
    extends Job {
        private transient OutlineListener listener;
        private NodeInst ni;

        protected InitializePoints(OutlineListener listener, NodeInst ni) {
            super("Initialize Outline Points", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.ni = ni;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EPoint[] points = new EPoint[4];
            double halfWid = this.ni.getXSize() / 2.0;
            double halfHei = this.ni.getYSize() / 2.0;
            double cX = this.ni.getAnchorCenterX();
            double cY = this.ni.getAnchorCenterY();
            points[0] = EPoint.fromLambda(cX - halfWid, cY - halfHei);
            points[1] = EPoint.fromLambda(cX - halfWid, cY + halfHei);
            points[2] = EPoint.fromLambda(cX + halfWid, cY + halfHei);
            points[3] = EPoint.fromLambda(cX + halfWid, cY - halfHei);
            this.ni.setTrace(points);
            return true;
        }

        @Override
        public void terminateOK() {
            this.listener.setPoint(0);
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                wnd.fullRepaint();
            }
        }
    }

    private static class SetPoints
    extends Job {
        private transient OutlineListener listener;
        private NodeInst ni;
        private EPoint[] pts;
        private int newPoint;

        protected SetPoints(OutlineListener listener, NodeInst ni, EPoint[] pts, int newPoint) {
            super("Change Outline Points", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.ni = ni;
            this.pts = pts;
            this.newPoint = newPoint;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.ni.getParent(), this.ni, true, false, true) != 0) {
                return false;
            }
            this.ni.setTrace(this.pts);
            return true;
        }

        @Override
        public void terminateOK() {
            this.listener.point = this.newPoint;
            this.listener.setPoint(this.listener.point);
        }
    }
}

