/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JobTree
extends DefaultMutableTreeNode {
    private static final String jobNodeName = "JOBS";
    private static final JobTree jobTree = new JobTree();
    private static final TreePath jobPath = new TreePath("Explorer").pathByAddingChild(jobTree);
    private final Vector<TreeNode> jobNodes = new Vector();
    private int[] indices = new int[1];
    private int indicesCount = 0;

    private JobTree() {
        super(jobNodeName);
        this.children = this.jobNodes;
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return jobTree;
    }

    public static void update(List<Job.Inform> jobs) {
        jobTree.updateJobs(jobs);
    }

    public static JPopupMenu getPopupStatus(EJobTreeNode jobNode) {
        JPopupMenu popup = new JPopupMenu();
        JobMenuActionListener a2 = new JobMenuActionListener(jobNode);
        JMenuItem m2 = new JMenuItem("Get Info");
        m2.addActionListener(a2);
        popup.add(m2);
        m2 = new JMenuItem("Abort");
        m2.addActionListener(a2);
        popup.add(m2);
        m2 = new JMenuItem("Delete");
        m2.addActionListener(a2);
        popup.add(m2);
        return popup;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int childIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndex(TreeNode aChild) {
        try {
            EJobTreeNode tn = (EJobTreeNode)aChild;
            return this.jobNodes.indexOf(tn);
        }
        catch (Exception e2) {
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            return -1;
        }
    }

    public List<Job.Inform> getChangeJobs() {
        ArrayList<Job.Inform> jobs = new ArrayList<Job.Inform>();
        for (int i2 = 0; i2 < this.jobNodes.size(); ++i2) {
            EJobTreeNode jtn = (EJobTreeNode)this.jobNodes.get(i2);
            Job.Inform ji = jtn.jobInfo;
            if (!ji.isChangeJobQueuedOrRunning()) continue;
            jobs.add(ji);
        }
        return jobs;
    }

    private void updateJobs(List<Job.Inform> newJobs) {
        Object[] children;
        assert (SwingUtilities.isEventDispatchThread());
        this.indicesClear();
        int newJ = 0;
        for (int oldJ = 0; oldJ < this.jobNodes.size(); ++oldJ) {
            int k2;
            EJobTreeNode oldJobNode = (EJobTreeNode)this.jobNodes.get(oldJ);
            Job.Key jobKey = oldJobNode.getKey();
            for (k2 = newJ; k2 < newJobs.size() && !newJobs.get(k2).getKey().equals(jobKey); ++k2) {
            }
            if (k2 == newJobs.size()) {
                this.indicesAdd(oldJ);
                continue;
            }
            newJ = k2 + 1;
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children = new Object[this.indicesCount];
            for (int i2 = this.indicesCount - 1; i2 >= 0; --i2) {
                childIndices[i2] = this.indices[i2];
                children[i2] = this.jobNodes.remove(this.indices[i2]);
            }
            ExplorerTreeModel.fireTreeNodesRemoved(jobTree, jobPath, childIndices, children);
        }
        this.indicesClear();
        for (int i3 = 0; i3 < newJobs.size(); ++i3) {
            EJobTreeNode jobNode;
            Job.Key jobKey = newJobs.get(i3).getKey();
            if (i3 < this.jobNodes.size() && (jobNode = (EJobTreeNode)this.jobNodes.get(i3)).getKey().equals(jobKey)) continue;
            this.jobNodes.add(i3, new EJobTreeNode(newJobs.get(i3)));
            this.indicesAdd(i3);
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children = new Object[this.indicesCount];
            for (int i4 = 0; i4 < this.indicesCount; ++i4) {
                childIndices[i4] = this.indices[i4];
                children[i4] = this.jobNodes.get(this.indices[i4]);
            }
            ExplorerTreeModel.fireTreeNodesInserted(jobTree, jobPath, childIndices, children);
        }
        assert (newJobs.size() == this.jobNodes.size());
        this.indicesClear();
        for (int i5 = 0; i5 < this.jobNodes.size(); ++i5) {
            EJobTreeNode node = (EJobTreeNode)this.jobNodes.get(i5);
            Job.Inform jobInfo = newJobs.get(i5);
            assert (node.getKey().equals(jobInfo.getKey()));
            if (!node.toString().equals(jobInfo.toString())) {
                this.indicesAdd(i5);
            }
            node.setInfo(jobInfo);
        }
        if (this.indicesCount != 0) {
            int[] childIndices = new int[this.indicesCount];
            children = new Object[this.indicesCount];
            for (int i6 = 0; i6 < this.indicesCount; ++i6) {
                childIndices[i6] = this.indices[i6];
                children[i6] = this.jobNodes.get(this.indices[i6]);
            }
            ExplorerTreeModel.fireTreeNodesChanged(jobTree, jobPath, childIndices, children);
        }
    }

    void indicesClear() {
        this.indicesCount = 0;
    }

    void indicesAdd(int index) {
        if (this.indicesCount >= this.indices.length) {
            int[] newIndices = new int[this.indices.length * 2];
            System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
            this.indices = newIndices;
        }
        this.indices[this.indicesCount++] = index;
    }

    private static class JobMenuActionListener
    implements ActionListener {
        private final EJobTreeNode jobNode;

        JobMenuActionListener(EJobTreeNode jobNode) {
            this.jobNode = jobNode;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JMenuItem source = (JMenuItem)e2.getSource();
            if (source.getText().equals("Get Info")) {
                System.out.println(this.jobNode.getInfo());
            }
            if (source.getText().equals("Abort")) {
                this.jobNode.jobInfo.abort();
            }
            if (source.getText().equals("Delete") && !this.jobNode.jobInfo.remove()) {
                System.out.println("Cannot delete running jobs.  Wait till it is finished, or abort it");
                return;
            }
        }
    }

    public static class EJobTreeNode
    implements TreeNode {
        private Job.Inform jobInfo;

        EJobTreeNode(Job.Inform jobInfo) {
            this.jobInfo = jobInfo;
        }

        private void setInfo(Job.Inform jobInfo) {
            assert (this.getKey().equals(jobInfo.getKey()));
            this.jobInfo = jobInfo;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException("argument is null");
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public String toString() {
            return this.jobInfo.toString();
        }

        public Job.Key getKey() {
            return this.jobInfo.getKey();
        }

        public String getInfo() {
            return this.jobInfo.getInfo();
        }
    }
}

