/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.util.ArrayList;
import java.util.List;

public class LogicalEffortTest
extends AbstractTest {
    public LogicalEffortTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        if (EvalJavaBsh.hasBeanShell()) {
            list.add(new LogicalEffortTest("LE"));
        }
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/LogicalEffort/output/";
    }

    public Boolean LE() {
        String libName = "LETest.jelib";
        String cellName = "total_core";
        int expectedSize = 2247;
        int expectedErrors = 0;
        int expectedWarnings = 770;
        boolean failed = LogicalEffortTest.runSizing("LogicalEffort", libName, cellName, this.getRegressionPath(), expectedSize, expectedErrors, expectedWarnings);
        return !failed;
    }

    public static boolean runSizing(String testName, String libName, String cellName, String rootPath, int expectedSize, int expectedErrors, int expectedWarnings) {
        boolean failed = false;
        try {
            String testParameter = LogicalEffortTest.properDirectory(rootPath, LogicalEffortTest.class);
            String testLibPath = LogicalEffortTest.dataDir(rootPath, testParameter) + libName;
            String outputDir = LogicalEffortTest.outputDir(rootPath, testParameter);
            LogicalEffortTest.ensureOutputDirectory(outputDir);
            MessagesStream.getMessagesStream().save(outputDir + testName + ".log");
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            Library lib = LayoutLib.openLibForRead(testLibPath, ep, true);
            if (lib == null) {
                System.out.println("ERROR: Cannot read library " + testLibPath);
                return true;
            }
            Cell lay = lib.findNodeProto(cellName + "{sch}");
            if (lay == null) {
                System.out.println("ERROR: Cannot find cell " + cellName + "{sch} in library " + lib.getName());
                return true;
            }
            LETool.AnalyzeCell job = new LETool.AnalyzeCell(LESizer.Alg.EQUALGATEDELAYS, lay, VarContext.globalContext, true);
            job.doIt();
            LENetlister netlister = job.getNetlister();
            ErrorLogger logger = netlister.getErrorLogger();
            if (expectedErrors != logger.getNumErrors()) {
                System.out.println("Error: found: " + logger.getNumErrors() + " errors but expected " + expectedErrors);
                failed = true;
            }
            if (expectedWarnings != logger.getNumWarnings()) {
                System.out.println("Error: found: " + logger.getNumWarnings() + " warnings but expected " + expectedWarnings);
                failed = true;
            }
            if (expectedSize != (int)netlister.getTotalLESize()) {
                System.out.println("Error: found: " + (int)netlister.getTotalLESize() + " size, but expected " + expectedSize);
                failed = true;
            }
        }
        catch (Exception e2) {
            System.out.println("Exception: " + String.valueOf(e2));
            e2.printStackTrace();
            failed = true;
        }
        return failed;
    }
}

