/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.MultiTaskJob;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobsTest
extends AbstractTest {
    EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
    private static Boolean multiTaskTestDone;

    public JobsTest(String name, boolean interactive) {
        super(name, false, interactive);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new JobsTest("Terminate", true));
        list.add(new JobsTest("MultiTask", true));
        list.add(new JobsTest("HangingReferenceJob", false));
        list.add(new JobsTest("PrintJob", false));
        list.add(new JobsTest("InfiniteLoopJob", true));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Database/output/";
    }

    public Boolean Terminate() {
        new FakeJob(Job.Type.CHANGE, false);
        new FakeJob(Job.Type.SERVER_EXAMINE, false);
        new FakeJob(Job.Type.CHANGE, true);
        new FakeJob(Job.Type.SERVER_EXAMINE, true);
        return Boolean.TRUE;
    }

    public Boolean MultiTask() {
        multiTaskTestDone = null;
        double expectedResult = 9900.0;
        Consumer<Double> consumer = new Consumer<Double>(){

            @Override
            public void consume(Double result) {
                System.out.println("Server " + result + " expected 9900.0");
                boolean good = result.equals(9900.0);
                multiTaskTestDone = good;
            }
        };
        LauncherJob lj = new LauncherJob(100, consumer);
        lj.startJob();
        try {
            do {
                lj.wait();
            } while (!lj.isFinished());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return multiTaskTestDone;
    }

    public Boolean HangingReferenceJob() {
        String libName = "hangRef";
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            lib = Library.newInst(libName, null);
        }
        Cell refCell = Cell.newInst(lib, "referenced{ic}");
        CellId refCellId = refCell.getId();
        Cell cell = Cell.newInst(lib, "hangRef{sch}");
        cell.newVar("ATTR_FOO", (Object)refCellId, this.ep);
        refCell.kill();
        return Boolean.TRUE;
    }

    public Boolean PrintJob() {
        String longString = "qqwqweqwerwefasdfvadg;ladfladjfl;gjadlfbvaldkmvalkml;vasvlkjaslkvjalskvjlakssjvlkasjvlkadfjvlkadjfvlkjadlkvjalkdjvlkadfjvlkadjvlkajvlakjvladkjvladkjvlkajvlkadjf";
        for (int i2 = 0; i2 < 1000; ++i2) {
            System.out.println(longString);
        }
        return Boolean.TRUE;
    }

    public Boolean InfiniteLoopJob() {
        while (!this.getStarterJob().checkAbort()) {
        }
        return Boolean.TRUE;
    }

    private static class FakeJob
    extends Job {
        Job.Type jobType;
        String field;
        boolean fail;

        FakeJob(Job.Type jobType, boolean fail) {
            super("JobTest", null, jobType, null, null, null);
            this.jobType = jobType;
            this.fail = fail;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            int x;
            int y;
            System.out.println("doIt " + String.valueOf((Object)this.jobType) + " fail=" + this.fail);
            this.field = "Value";
            this.fieldVariableChanged("field");
            return !this.fail || (y = 1 / (x = 0)) != 0;
        }

        @Override
        public void terminateOK() {
            System.out.println("TerminateOK " + String.valueOf((Object)this.jobType) + " fail=" + this.fail + " field=" + this.field);
        }

        @Override
        public void terminateFail(Throwable e2) {
            System.out.println("TerminateFail " + String.valueOf((Object)this.jobType) + " fail=" + this.fail + " e=" + String.valueOf(e2) + " field=" + this.field);
            super.terminateFail(e2);
        }
    }

    private static class LauncherJob
    extends MultiTaskJob<Integer, Point2D, Double> {
        private int numTasks;

        LauncherJob(int numTasks, Consumer<Double> consumer) {
            super("MultiTaskJobTest", User.getUserTool(), consumer);
            this.numTasks = numTasks;
        }

        @Override
        public void prepareTasks() {
            for (int i2 = 0; i2 < this.numTasks; ++i2) {
                this.startTask("Task " + i2, i2);
            }
        }

        @Override
        public Point2D runTask(Integer taskKey) {
            return new Point2D.Double(taskKey.intValue(), taskKey.intValue());
        }

        @Override
        public Double mergeTaskResults(Map<Integer, Point2D> taskResults) {
            double result = 0.0;
            for (Map.Entry<Integer, Point2D> e2 : taskResults.entrySet()) {
                Point2D p = e2.getValue();
                System.out.println(String.valueOf(e2.getKey()) + ": " + String.valueOf(p));
                result += p.getX() + p.getY();
            }
            return result;
        }
    }
}

