/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ERCTest
extends AbstractTest {
    public ERCTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new ERCTest("Well1"));
        list.add(new ERCTest("Well2"));
        list.add(new ERCTest("Antenna1"));
        list.add(new ERCTest("Antenna2"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/ERC/output/";
    }

    public Boolean Well1() {
        this.createMessageOutput();
        Boolean passed = Boolean.TRUE;
        if (!ERCTest.basicWellTest(this.getRegressionPath() + "/data/muddChip", "MIPS.jelib", "chip", "", 0, 0)) {
            passed = Boolean.FALSE;
        }
        return passed;
    }

    public Boolean Well2() {
        this.createMessageOutput();
        Boolean passed = Boolean.TRUE;
        if (!ERCTest.basicWellTest(this.getRegressionPath() + "/data/qThree", "qThreeTop.jelib", "qThreeTop", "", 390, 2)) {
            passed = Boolean.FALSE;
        }
        return passed;
    }

    public Boolean Antenna1() {
        this.createMessageOutput();
        Boolean passed = Boolean.TRUE;
        if (!ERCTest.basicERCAntennaTest(this.getRegressionPath() + "/data/muddChip", "MIPS.jelib", "chip", "", 1037)) {
            passed = Boolean.FALSE;
        }
        return passed;
    }

    public Boolean Antenna2() {
        this.createMessageOutput();
        Boolean passed = Boolean.TRUE;
        if (!ERCTest.basicERCAntennaTest(this.getRegressionPath() + "/data/qThree", "qThreeTop.jelib", "qThreeTop", "", 8)) {
            passed = Boolean.FALSE;
        }
        return passed;
    }

    public static boolean basicERCAntennaTest(String regressionData, String libNameIO, String cellName, String logName, int numErrors) {
        boolean passed;
        Cell lay = ERCTest.prepareERCTests(regressionData, libNameIO, cellName);
        if (lay == null) {
            System.out.println("Layout cell '" + cellName + "' not found");
            return false;
        }
        ERCAntenna.AntennaPreferences antennaPrefs = new ERCAntenna.AntennaPreferences(false, lay.getDatabase().getTechPool());
        antennaPrefs.disablePopups = true;
        int err = ERCAntenna.checkERCAntenna(lay, antennaPrefs, null);
        boolean bl = passed = numErrors == err;
        if (!passed) {
            System.out.println("ERC ANTENNA FOUND " + err + " ERRORS BUT EXPECTED " + numErrors);
        }
        return passed;
    }

    public static boolean basicWellTest(String regressionData, String libNameIO, String cellName, String logName, int numErrors, int numOfThreads) {
        boolean passed;
        System.out.println("Running ERC Well Check");
        Job.setDebug(true);
        Cell lay = ERCTest.prepareERCTests(regressionData, libNameIO, cellName);
        if (lay == null) {
            System.out.println("Layout cell '" + cellName + "' not found");
            return false;
        }
        ERCWellCheck.WellCheckPreferences prefs = new ERCWellCheck.WellCheckPreferences(true);
        prefs.drcCheck = false;
        prefs.pWellCheck = 1;
        prefs.nWellCheck = 1;
        prefs.maxProc = numOfThreads;
        prefs.disablePopups = true;
        int err = ERCWellCheck.checkERCWell(lay, prefs);
        boolean bl = passed = numErrors == err;
        if (!passed) {
            System.out.println("ERC FOUND " + err + " ERRORS BUT EXPECTED " + numErrors);
        }
        return passed;
    }

    private static Cell prepareERCTests(String regressionData, String libNameIO, String cellName) {
        Cell lay = null;
        try {
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            LayoutLib.openLibForRead(regressionData + "/" + libNameIO, ep, true);
            URL fileURL = TextUtils.makeURLToFile(libNameIO);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library rootLib = Library.findLibrary(libName);
            lay = rootLib.findNodeProto(cellName + "{lay}");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return lay;
    }
}

