/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeGroup;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.GenMath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class TechToLib {
    public static void makeLibFromTech() {
        ArrayList<Technology> techs = new ArrayList<Technology>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech.isNonStandard()) continue;
            techs.add(tech);
        }
        Object[] techChoices = new String[techs.size()];
        for (int i2 = 0; i2 < techs.size(); ++i2) {
            techChoices[i2] = ((Technology)techs.get(i2)).getTechName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Technology to Edit", "Choose a technology to edit", 3, null, techChoices, Technology.getCurrent().getTechName());
        if (chosen == null) {
            return;
        }
        Technology tech = Technology.findTechnology(chosen);
        Library already = Library.findLibrary(tech.getTechName());
        if (already != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There is already a library called '" + tech.getTechName() + "'.  Delete it first.", "Cannot Convert Technology", 0);
            System.out.println();
            return;
        }
        new LibFromTechJob(tech, false);
    }

    public static Library makeLibFromTech(Technology tech, EditingPreferences ep, GraphicsPreferences gp) {
        Library lib = Library.newInst(tech.getTechName(), null);
        if (lib == null) {
            System.out.println("Cannot create library " + tech.getTechName());
            return null;
        }
        System.out.println("Created library " + tech.getTechName() + "...");
        Cell fNp = Cell.newInst(lib, "factors");
        if (fNp == null) {
            return null;
        }
        fNp.setInTechnologyLibrary();
        int layerTotal = 0;
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            it.next();
            ++layerTotal;
        }
        GeneralInfo gi = new GeneralInfo();
        gi.shortName = tech.getTechShortName();
        if (gi.shortName == null) {
            gi.shortName = tech.getTechName();
        }
        gi.nonElectrical = tech.isNonElectrical();
        gi.scale = tech.getScale();
        gi.scaleRelevant = tech.isScaleRelevant();
        gi.resolution = tech.getFactoryResolution().getLambda();
        gi.defaultFoundry = tech.getPrefFoundry();
        gi.defaultNumMetals = tech.getNumMetals();
        gi.description = tech.getTechDesc();
        gi.minRes = tech.getMinResistanceSetting().getDoubleFactoryValue();
        gi.minCap = tech.getMinCapacitanceSetting().getDoubleFactoryValue();
        gi.maxSeriesResistance = tech.getMaxSeriesResistance();
        gi.gateShrinkage = tech.getGateLengthSubtraction();
        gi.includeGateInResistance = tech.isGateIncluded();
        gi.includeGround = tech.isGroundNetIncluded();
        gi.gateCapacitance = tech.getGateCapacitanceSetting().getDoubleFactoryValue();
        gi.wireRatio = tech.getWireRatioSetting().getDoubleFactoryValue();
        gi.diffAlpha = tech.getDiffAlphaSetting().getDoubleFactoryValue();
        Color[] wholeMap = gp.getColorMap(tech);
        int numLayers = gp.getNumTransparentLayers(tech);
        gi.transparentColors = new Color[numLayers];
        for (int i2 = 0; i2 < numLayers; ++i2) {
            gi.transparentColors[i2] = wholeMap[1 << i2];
        }
        gi.spiceLevel1Header = tech.getSpiceHeaderLevel1();
        gi.spiceLevel2Header = tech.getSpiceHeaderLevel2();
        gi.spiceLevel3Header = tech.getSpiceHeaderLevel3();
        XMLRules drcRules = tech.getFactoryDesignRules();
        if (drcRules != null) {
            int rulesSize = layerTotal * (layerTotal + 1) / 2;
            gi.conDist = new double[rulesSize];
            gi.unConDist = new double[rulesSize];
            Arrays.fill(gi.conDist, -1.0);
            Arrays.fill(gi.unConDist, -1.0);
            int ruleIndex = 0;
            for (int i1 = 0; i1 < layerTotal; ++i1) {
                for (int i2 = i1; i2 < layerTotal; ++i2) {
                    for (DRCTemplate t : drcRules.getSpacingRules(drcRules.getRuleIndex(i1, i2), DRCTemplate.DRCRuleType.SPACING, false)) {
                        if (t.ruleType == DRCTemplate.DRCRuleType.CONSPA) {
                            gi.conDist[ruleIndex] = t.getValue(0);
                            continue;
                        }
                        if (t.ruleType != DRCTemplate.DRCRuleType.UCONSPA) continue;
                        gi.unConDist[ruleIndex] = t.getValue(0);
                    }
                    ++ruleIndex;
                }
            }
        }
        gi.generate(fNp, ep);
        HashMap<Layer, Cell> layerCells = new HashMap<Layer, Cell>();
        System.out.println("Creating the layers...");
        ArrayList<String> layerSequence = new ArrayList<String>();
        LayerInfo[] lList = new LayerInfo[layerTotal];
        Map<Layer, String> gdsLayers = tech.getGDSLayers();
        int layIndex = 0;
        Iterator<Layer> it2 = tech.getLayers();
        while (it2.hasNext()) {
            Cell lNp;
            Layer layer = it2.next();
            EGraphics desc = gp.getGraphics(layer);
            String fName = "layer-" + layer.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((lNp = Cell.newInst(lib, fName)) == null) {
                return null;
            }
            lNp.setTechnology(Artwork.tech());
            lNp.setInTechnologyLibrary();
            layerCells.put(layer, lNp);
            LayerInfo li = new LayerInfo();
            lList[layIndex++] = li;
            li.name = layer.getName();
            li.fun = layer.getFunction();
            li.funExtra = layer.getFunctionExtras();
            li.desc = desc;
            li.cif = (String)layer.getCIFLayerSetting().getFactoryValue();
            li.dxf = (String)layer.getDXFLayerSetting().getFactoryValue();
            li.skill = (String)layer.getSkillLayerSetting().getFactoryValue();
            String gdsLayer = gdsLayers.get(layer);
            if (gdsLayer != null) {
                li.gds = gdsLayer;
            }
            li.spiRes = layer.getResistanceSetting().getDoubleFactoryValue();
            li.spiCap = layer.getCapacitanceSetting().getDoubleFactoryValue();
            li.spiECap = layer.getEdgeCapacitanceSetting().getDoubleFactoryValue();
            li.height3d = layer.getDistance();
            li.thick3d = layer.getThickness();
            li.generate(lNp, ep);
            layerSequence.add(lNp.getName().substring(6));
        }
        if (layIndex != layerTotal) {
            System.out.println("INTERNAL ERROR: ");
        }
        String[] layerSequenceArray = layerSequence.toArray(new String[layerSequence.size()]);
        lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)layerSequenceArray, ep);
        System.out.println("Creating the arcs...");
        int arcTotal = 0;
        Iterator<ArcProto> it3 = tech.getArcs();
        while (it3.hasNext()) {
            if (it3.next().isNotUsed()) continue;
            ++arcTotal;
        }
        ArcInfo[] aList = new ArcInfo[arcTotal];
        String[] arcSequence = new String[arcTotal];
        int arcCount = 0;
        HashMap<ArcProto, Cell> arcCells = new HashMap<ArcProto, Cell>();
        Iterator<ArcProto> it4 = tech.getArcs();
        while (it4.hasNext()) {
            Cell aNp;
            ArcInfo aIn;
            ArcProto ap = it4.next();
            if (ap.isNotUsed()) continue;
            aList[arcCount] = aIn = TechToLib.makeArcInfo(ap, lList);
            arcSequence[arcCount] = ap.getName();
            ++arcCount;
            String fName = "arc-" + ap.getName() + "{lay}";
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
            }
            if ((aNp = Cell.makeInstance(ep, lib, fName)) == null) {
                return null;
            }
            aNp.setTechnology(Artwork.tech());
            aNp.setInTechnologyLibrary();
            arcCells.put(ap, aNp);
            aIn.generate(aNp, ep);
            double wid = ap.getDefaultLambdaBaseWidth(ep);
            double widX4 = wid * 4.0;
            if (widX4 <= 0.0) {
                widX4 = 10.0;
            }
            Poly[] polys = ap.getShapeOfDummyArc(ep, widX4);
            double xOff = wid * 2.0 + ap.getMaxLayerExtend().getLambda();
            for (int i3 = 0; i3 < polys.length; ++i3) {
                Poly poly = polys[i3];
                Layer arcLayer = poly.getLayer();
                if (arcLayer == null) continue;
                EGraphics arcDesc = gp.getGraphics(arcLayer);
                PolyBase.Point[] points = poly.getPoints();
                for (int k2 = 0; k2 < points.length; ++k2) {
                    poly.setPoint(k2, ((Point2D)points[k2]).getX() - xOff - 20.0, ((Point2D)points[k2]).getY() - 5.0);
                }
                List<NodeInst> placedNodes = TechToLib.placeGeometry(poly, aNp, ep);
                if (placedNodes == null) continue;
                for (NodeInst ni : placedNodes) {
                    Manipulate.setPatch(ni, arcDesc, ep);
                    Cell layerCell = (Cell)layerCells.get(arcLayer);
                    if (layerCell != null) {
                        ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId(), ep);
                    }
                    ni.newVar(Info.OPTION_KEY, (Object)8, ep);
                }
            }
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, ep, new Point2D.Double(-20.0 - xOff, -5.0), wid * 5.0, wid, aNp);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_COLOR, (Object)2, ep);
            ni.newVar(Info.OPTION_KEY, (Object)19, ep);
            ArcInfo.compactCell(aNp);
        }
        lib.newVar(Info.ARCSEQUENCE_KEY, (Object)arcSequence, ep);
        System.out.println("Creating the nodes...");
        ArrayList<String> nodeSequence = new ArrayList<String>();
        ArrayList<NodeInfo> nList = new ArrayList<NodeInfo>();
        Cell dummyCell = Cell.newInst(lib, "dummyCell{lay}");
        ArrayList<PrimitiveNode> nodesToWrite = new ArrayList<PrimitiveNode>();
        Iterator<PrimitiveNode> it5 = tech.getNodes();
        while (it5.hasNext()) {
            PrimitiveNode pnp = it5.next();
            if (pnp.isNotUsed()) continue;
            if (pnp.getPrimitiveNodeGroup() == null) {
                nodesToWrite.add(pnp);
                continue;
            }
            if (pnp.getPrimitiveNodeGroup().getNodes().get(0) != pnp) continue;
            NodeInst ni = NodeInst.makeDummyInstance((NodeProto)pnp, ep);
            Poly[] polys = tech.getShapeOfNode(ni);
            HashSet<Layer> inPolys = new HashSet<Layer>();
            for (int i4 = 0; i4 < polys.length; ++i4) {
                inPolys.add(polys[i4].getLayer());
            }
            boolean differentLayers = false;
            for (PrimitiveNode alt : pnp.getPrimitiveNodeGroup().getNodes()) {
                if (alt == pnp) continue;
                NodeInst altNi = NodeInst.makeDummyInstance((NodeProto)alt, ep);
                Poly[] altPolys = tech.getShapeOfNode(altNi);
                HashSet<Layer> inAltPolys = new HashSet<Layer>();
                for (int i5 = 0; i5 < altPolys.length; ++i5) {
                    inAltPolys.add(altPolys[i5].getLayer());
                }
                for (Layer l2 : inPolys) {
                    if (inAltPolys.contains(l2)) {
                        inAltPolys.remove(l2);
                        continue;
                    }
                    differentLayers = true;
                    break;
                }
                if (inAltPolys.size() > 0) {
                    differentLayers = true;
                }
                if (!differentLayers) continue;
                break;
            }
            if (differentLayers) {
                for (PrimitiveNode alt : pnp.getPrimitiveNodeGroup().getNodes()) {
                    nodesToWrite.add(alt);
                }
            } else {
                nodesToWrite.add(pnp);
            }
            if (pnp.getPrimitiveNodeGroup().getNodes().get(0) == pnp) continue;
        }
        for (PrimitiveNode pnp : nodesToWrite) {
            int j2;
            Poly[] polys;
            NodeInst oNi;
            NodeInfo nIn = TechToLib.makeNodeInfo(pnp, lList, aList, ep);
            nList.add(nIn);
            nodeSequence.add(pnp.getName());
            boolean first = true;
            double xS = pnp.getDefWidth(ep) * 2.0;
            double yS = pnp.getDefHeight(ep) * 2.0;
            if (xS < 3.0) {
                xS = 3.0;
            }
            if (yS < 3.0) {
                yS = 3.0;
            }
            double nodeXPos = -xS * 2.0;
            Point2D[] pos = new Point2D[]{new Point2D.Double(nodeXPos - xS, -5.0 + yS), new Point2D.Double(nodeXPos + xS, -5.0 + yS), new Point2D.Double(nodeXPos - xS, -5.0 - yS), new Point2D.Double(nodeXPos + xS, -5.0 - yS)};
            SizeOffset so = pnp.getProtoSizeOffset();
            xS = pnp.getDefWidth(ep) - so.getLowXOffset() - so.getHighXOffset();
            yS = pnp.getDefHeight(ep) - so.getLowYOffset() - so.getHighYOffset();
            double[] xsc = new double[4];
            double[] ysc = new double[4];
            xsc[0] = xS * 1.0;
            ysc[0] = yS * 1.0;
            xsc[1] = xS * 2.0;
            ysc[1] = yS * 1.0;
            xsc[2] = xS * 1.0;
            ysc[2] = yS * 2.0;
            xsc[3] = xS * 2.0;
            ysc[3] = yS * 2.0;
            if (pnp.isMulticut()) {
                EPoint min2size = pnp.getMulticut2Size();
                double min2X = min2size.getLambdaX();
                double min2Y = min2size.getLambdaY();
                xsc[1] = min2X;
                xsc[3] = min2X;
                ysc[2] = min2Y;
                ysc[3] = min2Y;
            }
            Cell nNp = null;
            FixpRectangle mainBounds = null;
            for (int e2 = 0; e2 < 4; ++e2) {
                if (e2 != 0 && first || pnp.isSquare() && (e2 == 1 || e2 == 2)) continue;
                double newXSize = xsc[e2] + so.getLowXOffset() + so.getHighXOffset();
                double newYSize = ysc[e2] + so.getLowYOffset() + so.getHighYOffset();
                oNi = NodeInst.makeInstance(pnp, ep, EPoint.snap(pos[e2]), newXSize, newYSize, dummyCell);
                polys = tech.getShapeOfNode(oNi);
                j2 = polys.length;
                for (int i6 = 0; i6 < j2; ++i6) {
                    List<NodeInst> placedNodes;
                    Poly poly = polys[i6];
                    Layer nodeLayer = poly.getLayer();
                    if (nodeLayer == null) continue;
                    EGraphics desc = gp.getGraphics(nodeLayer);
                    if (e2 == 0) {
                        FixpRectangle polyBounds = poly.getBounds2D();
                        if (i6 == 0) {
                            mainBounds = polyBounds;
                        } else {
                            Rectangle2D.union(mainBounds, polyBounds, mainBounds);
                        }
                    }
                    if (first) {
                        first = false;
                        String fName = "node-" + pnp.getName() + "{lay}";
                        if (lib.findNodeProto(fName) != null) {
                            System.out.println("Warning: already a cell '" + fName + "'.  Creating a new version");
                        }
                        if ((nNp = Cell.newInst(lib, fName)) == null) {
                            return null;
                        }
                        nNp.setTechnology(Artwork.tech());
                        nNp.setInTechnologyLibrary();
                        nIn.generate(nNp, ep);
                    }
                    if ((placedNodes = TechToLib.placeGeometry(poly, nNp, ep)) == null) {
                        System.out.println("Error placing geometry " + String.valueOf((Object)poly.getStyle()) + " on " + String.valueOf(nNp));
                        continue;
                    }
                    for (NodeInst ni : placedNodes) {
                        Manipulate.setPatch(ni, desc, ep);
                        Cell layerCell = (Cell)layerCells.get(nodeLayer);
                        if (layerCell != null) {
                            ni.newVar(Info.LAYER_KEY, (Object)layerCell.getId(), ep);
                        }
                        ni.newVar(Info.OPTION_KEY, (Object)8, ep);
                    }
                }
                if (first) continue;
                xS = pnp.getDefWidth(ep) - so.getLowXOffset() - so.getHighXOffset();
                yS = pnp.getDefHeight(ep) - so.getLowYOffset() - so.getHighYOffset();
                Point2D.Double loc = new Point2D.Double(pos[e2].getX() + (so.getLowXOffset() - so.getHighXOffset()) / 2.0, pos[e2].getY() + (so.getLowYOffset() - so.getHighYOffset()) / 2.0);
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, ep, loc, xsc[e2], ysc[e2], nNp);
                if (ni == null) {
                    return null;
                }
                ni.newVar(Artwork.ART_COLOR, (Object)EGraphics.makeIndex(Color.WHITE), ep);
                ni.newVar(Info.OPTION_KEY, (Object)19, ep);
                if (TechToLib.addPortsToPrimitive(pnp, oNi, tech, arcCells, aList, nNp, ep)) {
                    return null;
                }
                oNi.kill();
            }
            PrimitiveNodeGroup primitiveNodeGroup = pnp.getPrimitiveNodeGroup();
            if (primitiveNodeGroup != null) {
                int yOffset = 0;
                for (int k3 = 1; k3 < primitiveNodeGroup.getNodes().size(); ++k3) {
                    Point2D.Double loc;
                    NodeInst ni;
                    PrimitiveNode altPNp = pnp.getPrimitiveNodeGroup().getNodes().get(k3);
                    if (nodesToWrite.contains(altPNp)) continue;
                    xS = altPNp.getDefWidth(ep) * 2.0;
                    yS = altPNp.getDefHeight(ep) * 2.0;
                    Point2D.Double nPos = new Point2D.Double(nodeXPos + xS * 5.0, -5.0 - yS * (double)(++yOffset * 2 - 3));
                    xS = altPNp.getDefWidth(ep);
                    yS = altPNp.getDefHeight(ep);
                    oNi = NodeInst.makeInstance(altPNp, ep, EPoint.snap(nPos), xS, yS, dummyCell);
                    polys = tech.getShapeOfNode(oNi);
                    j2 = polys.length;
                    NodeInst centerNI = null;
                    for (int i7 = 0; i7 < j2; ++i7) {
                        Poly poly = polys[i7];
                        Layer nodeLayer = poly.getLayer();
                        if (nodeLayer == null) continue;
                        EGraphics desc = gp.getGraphics(nodeLayer);
                        List<NodeInst> placedNodes = TechToLib.placeGeometry(poly, nNp, ep);
                        if (placedNodes == null) {
                            System.out.println("Error placing geometry " + String.valueOf((Object)poly.getStyle()) + " on " + String.valueOf(nNp));
                            continue;
                        }
                        for (NodeInst ni2 : placedNodes) {
                            if (nodeLayer.getFunction().isContact()) {
                                centerNI = ni2;
                            }
                            if (centerNI == null && ni2.getAnchorCenterX() == ((Point2D)nPos).getX() && ni2.getAnchorCenterY() == ((Point2D)nPos).getY()) {
                                centerNI = ni2;
                            }
                            Manipulate.setPatch(ni2, desc, ep);
                            Cell layerCell = (Cell)layerCells.get(nodeLayer);
                            if (layerCell != null) {
                                ni2.newVar(Info.LAYER_KEY, (Object)layerCell.getId(), ep);
                            }
                            ni2.newVar(Info.OPTION_KEY, (Object)8, ep);
                        }
                    }
                    if (centerNI != null) {
                        centerNI.setName(altPNp.getName());
                        TextDescriptor td = centerNI.getTextDescriptor(NodeInst.NODE_NAME).withOff(0.0, -altPNp.getFactoryDefaultBaseDimension().getLambdaHeight() * 1.5);
                        centerNI.setTextDescriptor(NodeInst.NODE_NAME, td);
                    }
                    if ((ni = NodeInst.makeInstance(Artwork.tech().boxNode, ep, loc = new Point2D.Double(((Point2D)nPos).getX() + (so.getLowXOffset() - so.getHighXOffset()) / 2.0, ((Point2D)nPos).getY() + (so.getLowYOffset() - so.getHighYOffset()) / 2.0), xS = altPNp.getDefWidth(ep) - so.getLowXOffset() - so.getHighXOffset(), yS = altPNp.getDefHeight(ep) - so.getLowYOffset() - so.getHighYOffset(), nNp)) == null) {
                        return null;
                    }
                    ni.newVar(Artwork.ART_COLOR, (Object)EGraphics.makeIndex(Color.WHITE), ep);
                    ni.newVar(Info.OPTION_KEY, (Object)19, ep);
                    if (TechToLib.addPortsToPrimitive(pnp, oNi, tech, arcCells, aList, nNp, ep)) {
                        return null;
                    }
                    oNi.kill();
                }
            }
            NodeInfo.compactCell(nNp);
        }
        dummyCell.kill();
        String[] nodeSequenceArray = new String[nodeSequence.size()];
        for (int i8 = 0; i8 < nodeSequence.size(); ++i8) {
            nodeSequenceArray[i8] = (String)nodeSequence.get(i8);
        }
        lib.newVar(Info.NODESEQUENCE_KEY, (Object)nodeSequenceArray, ep);
        gi.menuPalette = tech.getFactoryMenuPalette();
        System.out.println("Done.");
        return lib;
    }

    private static boolean addPortsToPrimitive(PrimitiveNode pnp, NodeInst oNi, Technology tech, Map<ArcProto, Cell> arcCells, ArcInfo[] aList, Cell nNp, EditingPreferences ep) {
        HashMap<PrimitivePort, NodeInst> portNodes = new HashMap<PrimitivePort, NodeInst>();
        Iterator<PortProto> pIt = pnp.getPorts();
        block0: while (pIt.hasNext()) {
            PrimitivePort opp;
            PrimitivePort pp = (PrimitivePort)pIt.next();
            Poly poly = tech.getShapeOfPort(oNi, pp);
            SizeOffset pSo = Generic.tech().portNode.getProtoSizeOffset();
            double width = poly.getBounds2D().getWidth() + pSo.getLowXOffset() + pSo.getHighXOffset();
            double height = poly.getBounds2D().getHeight() + pSo.getLowYOffset() + pSo.getHighYOffset();
            NodeInst pNi = NodeInst.makeInstance(Generic.tech().portNode, ep, new Point2D.Double(poly.getCenterX(), poly.getCenterY()), width, height, nNp);
            if (pNi == null) {
                return true;
            }
            portNodes.put(pp, pNi);
            pNi.newVar(Info.OPTION_KEY, (Object)8, ep);
            pNi.newDisplayVar(Info.PORTNAME_KEY, pp.getName(), ep);
            if (pp.getAngle() != 0 || pp.getAngleRange() != 180) {
                pNi.newVar(Info.PORTANGLE_KEY, (Object)pp.getAngle(), ep);
                pNi.newVar(Info.PORTRANGE_KEY, (Object)pp.getAngleRange(), ep);
            }
            ArcProto[] connects = pp.getConnections();
            ArrayList<Cell> validConns = new ArrayList<Cell>();
            for (int i2 = 0; i2 < connects.length; ++i2) {
                Cell cell;
                if (connects[i2].getTechnology() != tech || (cell = arcCells.get(connects[i2])) == null) continue;
                validConns.add(cell);
            }
            int meaning = 0;
            if (validConns.size() > 0) {
                CellId[] aplist = new CellId[validConns.size()];
                block2: for (int i3 = 0; i3 < validConns.size(); ++i3) {
                    Cell cell = (Cell)validConns.get(i3);
                    aplist[i3] = cell.getId();
                    String arcName = cell.getName().substring(4);
                    for (int l2 = 0; l2 < aList.length; ++l2) {
                        if (!aList[l2].name.equals(arcName)) continue;
                        if (aList[l2].func.isDiffusion()) {
                            meaning = 2;
                            continue block2;
                        }
                        if (!aList[l2].func.isPoly()) continue block2;
                        meaning = 1;
                        continue block2;
                    }
                }
                pNi.newVar(Info.CONNECTION_KEY, (Object)aplist, ep);
            }
            if (pnp.getFunction().isTransistor()) {
                pNi.newVar(Info.PORTMEANING_KEY, (Object)meaning, ep);
            }
            Iterator<PortProto> oPIt = pnp.getPorts();
            while (oPIt.hasNext() && (opp = (PrimitivePort)oPIt.next()) != pp) {
                NodeInst nni;
                if (opp.getTopology() != pp.getTopology() || (nni = (NodeInst)portNodes.get(opp)) == null) continue;
                PortInst head = nni.getOnlyPortInst();
                PortInst tail = pNi.getOnlyPortInst();
                ArcInst.newInstanceBase(Generic.tech().universal_arc, ep, 0.0, head, tail);
                continue block0;
            }
        }
        return false;
    }

    private static ArcInfo makeArcInfo(ArcProto ap, LayerInfo[] lList) {
        ArcInfo aIn = new ArcInfo();
        ImmutableArcInst defA = ap.getFactoryDefaultInst();
        aIn.name = ap.getName();
        aIn.func = ap.getFunction();
        aIn.widthOffset = ap.getLambdaElibWidthOffset();
        aIn.fixAng = defA.isFixedAngle();
        aIn.wipes = ap.isWipable();
        aIn.noExtend = !defA.isTailExtended();
        aIn.curvable = ap.isCurvable();
        aIn.special = ap.isSpecialArc();
        aIn.notUsed = ap.isNotUsed();
        aIn.skipSizeInPalette = ap.isSkipSizeInPalette();
        aIn.slidable = defA.isSlidable();
        aIn.angInc = ap.getFactoryAngleIncrement();
        aIn.antennaRatio = ap.getFactoryAntennaRatio();
        aIn.arcDetails = new ArcInfo.LayerDetails[ap.getNumArcLayers()];
        for (int i2 = 0; i2 < aIn.arcDetails.length; ++i2) {
            ArcInfo.LayerDetails ald;
            aIn.arcDetails[i2] = ald = new ArcInfo.LayerDetails();
            String layerName = ap.getLayer(i2).getName();
            for (int j2 = 0; j2 < lList.length; ++j2) {
                if (!lList[j2].name.equals(layerName)) continue;
                ald.layer = lList[j2];
                break;
            }
            ald.style = ap.getLayerStyle(i2);
            ald.width = ap.getLayerExtend(i2).getGrid();
        }
        return aIn;
    }

    private static NodeInfo makeNodeInfo(PrimitiveNode pnp, LayerInfo[] lList, ArcInfo[] aList, EditingPreferences ep) {
        Technology tech = pnp.getTechnology();
        NodeInfo nIn = new NodeInfo();
        nIn.name = pnp.getName();
        nIn.func = pnp.getFunction();
        nIn.serp = false;
        if (nIn.func.isFET() && pnp.isHoldsOutline()) {
            nIn.serp = true;
        }
        nIn.arcsShrink = pnp.isArcsShrink();
        assert (pnp.isArcsWipe() == nIn.arcsShrink);
        nIn.square = pnp.isSquare();
        assert (pnp.isHoldsOutline() == (pnp.getSpecialType() == 2 || pnp.getSpecialType() == 1));
        nIn.canBeZeroSize = pnp.isCanBeZeroSize();
        nIn.wipes = pnp.isWipeOn1or2();
        nIn.lockable = pnp.isLockedPrim();
        nIn.edgeSelect = pnp.isEdgeSelect();
        nIn.skipSizeInPalette = pnp.isSkipSizeInPalette();
        nIn.notUsed = pnp.isNotUsed();
        nIn.lowVt = pnp.isNodeBitOn(8);
        nIn.highVt = pnp.isNodeBitOn(16);
        nIn.nativeBit = pnp.isNodeBitOn(32);
        nIn.curvePin = pnp.isNodeBitOn(0x100000);
        nIn.od18 = pnp.isNodeBitOn(64);
        nIn.od25 = pnp.isNodeBitOn(128);
        nIn.od33 = pnp.isNodeBitOn(256);
        nIn.xSize = pnp.getDefWidth(ep);
        nIn.ySize = pnp.getDefHeight(ep);
        nIn.so = pnp.getProtoSizeOffset();
        if (nIn != null && nIn.so.getLowXOffset() == 0.0 && nIn.so.getHighXOffset() == 0.0 && nIn.so.getLowYOffset() == 0.0 && nIn.so.getHighYOffset() == 0.0) {
            nIn.so = null;
        }
        nIn.nodeSizeRule = pnp.getMinSizeRule();
        nIn.autoGrowth = pnp.getAutoGrowth();
        nIn.specialType = pnp.getSpecialType();
        nIn.specialValues = pnp.getSpecialValues();
        nIn.spiceTemplate = pnp.getSpiceTemplate();
        ArrayList<Object> nodeLayers = new ArrayList<Object>();
        for (Technology.NodeLayer nld : pnp.getNodeLayers()) {
            nodeLayers.add(nld);
        }
        ArrayList<Object> electricalNodeLayers = nodeLayers;
        if (pnp.getElectricalLayers() != null) {
            electricalNodeLayers = new ArrayList();
            for (Technology.NodeLayer nld : pnp.getElectricalLayers()) {
                electricalNodeLayers.add(nld);
            }
        }
        ArrayList<NodeInfo.LayerDetails> layerDetails = new ArrayList<NodeInfo.LayerDetails>();
        EPoint correction = EPoint.fromGrid(pnp.getFullRectangle().getGridWidth(), pnp.getFullRectangle().getGridHeight());
        int m2 = 0;
        for (Technology.NodeLayer nodeLayer : electricalNodeLayers) {
            int j2 = nodeLayers.indexOf(nodeLayer);
            if (j2 < 0) {
                layerDetails.add(TechToLib.makeNodeLayerDetails(nodeLayer, lList, correction, false, true));
                continue;
            }
            while (m2 < j2) {
                layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m2++), lList, correction, true, false));
            }
            layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m2++), lList, correction, true, true));
        }
        while (m2 < nodeLayers.size()) {
            layerDetails.add(TechToLib.makeNodeLayerDetails((Technology.NodeLayer)nodeLayers.get(m2++), lList, correction, true, false));
        }
        nIn.nodeLayers = layerDetails.toArray(new NodeInfo.LayerDetails[layerDetails.size()]);
        nIn.nodePortDetails = new NodeInfo.PortDetails[pnp.getNumPorts()];
        for (int i2 = 0; i2 < nIn.nodePortDetails.length; ++i2) {
            NodeInfo.PortDetails pd;
            PrimitivePort primitivePort = pnp.getPort(i2);
            nIn.nodePortDetails[i2] = pd = new NodeInfo.PortDetails();
            pd.name = primitivePort.getName();
            pd.netIndex = primitivePort.getTopology();
            pd.angle = primitivePort.getAngle();
            pd.range = primitivePort.getAngleRange();
            EdgeH left = new EdgeH(primitivePort.getLeft().getMultiplier(), primitivePort.getLeft().getAdder().getLambda() - primitivePort.getLeft().getMultiplier() * nIn.xSize);
            EdgeH right = new EdgeH(primitivePort.getRight().getMultiplier(), primitivePort.getRight().getAdder().getLambda() - primitivePort.getRight().getMultiplier() * nIn.xSize);
            EdgeV bottom = new EdgeV(primitivePort.getBottom().getMultiplier(), primitivePort.getBottom().getAdder().getLambda() - primitivePort.getBottom().getMultiplier() * nIn.ySize);
            EdgeV top = new EdgeV(primitivePort.getTop().getMultiplier(), primitivePort.getTop().getAdder().getLambda() - primitivePort.getTop().getMultiplier() * nIn.ySize);
            pd.values = new Technology.TechPoint[]{new Technology.TechPoint(left, bottom), new Technology.TechPoint(right, top)};
            pd.characterisitic = primitivePort.getCharacteristic();
            pd.isolated = primitivePort.isIsolated();
            pd.negatable = primitivePort.isNegatable();
            ArcProto[] connects = primitivePort.getConnections();
            ArrayList<ArcInfo> validArcInfoConns = new ArrayList<ArcInfo>();
            block6: for (int j3 = 0; j3 < connects.length; ++j3) {
                ArcProto ap = connects[j3];
                if (ap.getTechnology() != tech) continue;
                for (int k2 = 0; k2 < aList.length; ++k2) {
                    if (!aList[k2].name.equals(ap.getName())) continue;
                    validArcInfoConns.add(aList[k2]);
                    continue block6;
                }
            }
            pd.connections = validArcInfoConns.toArray(new ArcInfo[validArcInfoConns.size()]);
        }
        if (nIn.func == PrimitiveNode.Function.NODE) {
            assert (nIn.nodeLayers.length == 1);
            LayerInfo l2 = nIn.nodeLayers[0].layer;
            if (l2.pureLayerNode != null) {
                System.out.println("Warning: technology has two pure-layer nodes for layer " + l2.name + ": " + l2.pureLayerNode.name + " and " + nIn.name);
            }
            l2.pureLayerNode = nIn;
        }
        return nIn;
    }

    private static NodeInfo.LayerDetails makeNodeLayerDetails(Technology.NodeLayer nl, LayerInfo[] lList, EPoint correction, boolean inLayers, boolean inElectricalLayers) {
        int k2;
        NodeInfo.LayerDetails nld = new NodeInfo.LayerDetails();
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.style = nl.getStyle();
        nld.portIndex = nl.getPortNum();
        nld.representation = nl.getRepresentation();
        nld.values = (Technology.TechPoint[])nl.getPoints().clone();
        EPoint negCorrection = EPoint.fromGrid(-correction.getGridX(), -correction.getGridY());
        for (k2 = 0; k2 < nld.values.length; ++k2) {
            Technology.TechPoint p = nld.values[k2];
            EdgeH x = p.getX();
            x = x.withGridAdder(x.getGridValue(negCorrection));
            EdgeV y = p.getY();
            y = y.withGridAdder(y.getGridValue(negCorrection));
            nld.values[k2] = p.withX(x).withY(y);
        }
        for (k2 = 0; k2 < lList.length; ++k2) {
            if (!nl.getLayer().getName().equals(lList[k2].name)) continue;
            nld.layer = lList[k2];
            break;
        }
        nld.multiCut = nld.representation == 3;
        nld.multiXS = nl.getMulticutSizeX().getLambda();
        nld.multiYS = nl.getMulticutSizeY().getLambda();
        nld.multiSep = nl.getMulticutSep1D().getLambda();
        nld.multiSep2D = nl.getMulticutSep2D().getLambda();
        return nld;
    }

    private static List<NodeInst> placeGeometry(Poly poly, Cell cell, EditingPreferences ep) {
        ArrayList<NodeInst> placedNodes = new ArrayList<NodeInst>();
        FixpRectangle box = poly.getBox();
        FixpRectangle bounds = poly.getBounds2D();
        Poly.Type style = poly.getStyle();
        if (style == Poly.Type.FILLED) {
            if (box != null) {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledBoxNode, ep, new Point2D.Double(((RectangularShape)box).getCenterX(), ((RectangularShape)box).getCenterY()), ((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                placedNodes.add(ni);
            } else {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                ni.setTrace(poly.getPoints());
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CLOSED) {
            if (box != null) {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().boxNode, ep, new Point2D.Double(((RectangularShape)box).getCenterX(), ((RectangularShape)box).getCenterY()), ((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                placedNodes.add(ni);
            } else {
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().closedPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
                if (ni == null) {
                    return null;
                }
                ni.setTrace(poly.getPoints());
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CROSSED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().crossedBoxNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT1) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedDottedPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT2) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedDashedPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.OPENEDT3) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedThickerPolygonNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.VECTORS) {
            PolyBase.Point[] points = poly.getPoints();
            for (int i2 = 0; i2 < points.length; i2 += 2) {
                double hY;
                double lY;
                double hX;
                double lX = Math.min(((Point2D)points[i2]).getX(), ((Point2D)points[i2 + 1]).getX());
                NodeInst ni = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, ep, new Point2D.Double((lX + (hX = Math.max(((Point2D)points[i2]).getX(), ((Point2D)points[i2 + 1]).getX()))) / 2.0, ((lY = Math.min(((Point2D)points[i2]).getY(), ((Point2D)points[i2 + 1]).getY())) + (hY = Math.max(((Point2D)points[i2]).getY(), ((Point2D)points[i2 + 1]).getY()))) / 2.0), hX - lX, hY - lY, cell);
                if (ni == null) {
                    return null;
                }
                Point2D[] line = new Point2D[]{points[i2], points[i2 + 1]};
                ni.setTrace(line);
                placedNodes.add(ni);
            }
            return placedNodes;
        }
        if (style == Poly.Type.CIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().circleNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().thickCircleNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.DISC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledCircleNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.CIRCLEARC) {
            double endAngle;
            PolyBase.Point[] points = poly.getPoints();
            PolyBase.Point center = points[0];
            double radius = ((Point2D)points[1]).distance(center);
            double startAngle = GenMath.figureAngle(center, points[2]) / 10;
            double amt = startAngle > (endAngle = (double)(GenMath.figureAngle(center, points[1]) / 10)) ? endAngle - startAngle + 360.0 : endAngle - startAngle;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().circleNode, ep, center, radius * 2.0, radius * 2.0, cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(startAngle / 180.0 * Math.PI, amt / 180.0 * Math.PI, ep);
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.THICKCIRCLEARC) {
            double endAngle;
            PolyBase.Point[] points = poly.getPoints();
            PolyBase.Point center = points[0];
            double radius = ((Point2D)points[1]).distance(center);
            double startAngle = GenMath.figureAngle(center, points[2]) / 10;
            double amt = startAngle > (endAngle = (double)(GenMath.figureAngle(center, points[1]) / 10)) ? endAngle - startAngle + 360.0 : endAngle - startAngle;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech().thickCircleNode, ep, center, radius * 2.0, radius * 2.0, cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(startAngle / 180.0 * Math.PI, amt / 180.0 * Math.PI, ep);
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTCENT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), ep.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.CENT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOTLEFT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), ep.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPRIGHT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOTRIGHT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), ep.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.UPLEFT));
            placedNodes.add(ni);
            return placedNodes;
        }
        if (style == Poly.Type.TEXTBOX) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_MESSAGE, (Object)poly.getString(), ep.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.BOXED));
            placedNodes.add(ni);
            return placedNodes;
        }
        return null;
    }

    private static class LibFromTechJob
    extends Job {
        private Technology tech;
        private Library lib;
        private GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();

        private LibFromTechJob(Technology tech, boolean doItNow) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            if (!doItNow) {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() {
            this.lib = TechToLib.makeLibFromTech(this.tech, this.getEditingPreferences(), this.gp);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            return true;
        }

        @Override
        public void terminateOK() {
            User.setCurrentLibrary(this.lib);
        }
    }
}

