/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class LayerInfo
extends Info {
    String name = "";
    String javaName;
    EGraphics desc = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, false, new int[16]);
    Layer.Function fun = Layer.Function.UNKNOWN;
    int funExtra;
    NodeInfo pureLayerNode;
    String cif = "";
    String dxf;
    String skill;
    String gds = "";
    double spiRes;
    double spiCap;
    double spiECap;
    double inductanceAreaFactor;
    double inductanceLengthFactor;
    double height3d;
    double thick3d;
    double coverage;
    Layer generated;
    static Info.SpecialTextDescr[] layerTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(14.0, 18.0, 4), new Info.SpecialTextDescr(14.0, 15.0, 33), new Info.SpecialTextDescr(14.0, 12.0, 1), new Info.SpecialTextDescr(14.0, 9.0, 2), new Info.SpecialTextDescr(14.0, 6.0, 3), new Info.SpecialTextDescr(14.0, 3.0, 20), new Info.SpecialTextDescr(14.0, 0.0, 27), new Info.SpecialTextDescr(14.0, -3.0, 28), new Info.SpecialTextDescr(14.0, -6.0, 29), new Info.SpecialTextDescr(14.0, -9.0, 31), new Info.SpecialTextDescr(14.0, -12.0, 32), new Info.SpecialTextDescr(14.0, -15.0, 41)};

    LayerInfo() {
    }

    public static Cell[] getLayerCells(Library lib) {
        Library[] oneLib = new Library[]{lib};
        return LayerInfo.findCellSequence(oneLib, "layer-", LAYERSEQUENCE_KEY);
    }

    void generate(Cell np, EditingPreferences ep) {
        NodeInst ni;
        NodeInst stippleNode = null;
        NodeInst patClearNode = null;
        NodeInst patInvertNode = null;
        NodeInst patCopyNode = null;
        NodeInst patPasteNode = null;
        NodeInst patchNode = null;
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            int opt = Manipulate.getOptionOnNode(ni);
            if (ni.getProto() == Artwork.tech().filledBoxNode && opt != 6) {
                patchNode = ni;
            }
            switch (opt) {
                case 6: {
                    stippleNode = ni;
                    break;
                }
                case 34: {
                    patClearNode = ni;
                    break;
                }
                case 35: {
                    patInvertNode = ni;
                    break;
                }
                case 36: {
                    patCopyNode = ni;
                    break;
                }
                case 37: {
                    patPasteNode = ni;
                }
            }
        }
        if (patchNode == null) {
            NodeInst ni2 = NodeInst.makeInstance(Artwork.tech().filledBoxNode, ep, new Point2D.Double(-7.5, 7.5), 5.0, 5.0, np);
            if (ni2 == null) {
                return;
            }
            Manipulate.setPatch(ni2, this.desc, ep);
        }
        int[] stip = this.desc.getPattern();
        if (stippleNode == null) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    Point2D.Double ctr = new Point2D.Double((double)x - 19.5, 2.5 - (double)y);
                    NodeInst ni3 = NodeInst.makeInstance(Artwork.tech().filledBoxNode, ep, ctr, 1.0, 1.0, np);
                    if (ni3 == null) {
                        return;
                    }
                    if ((stip[y] & 1 << 15 - x) == 0) {
                        Short[] spattern = new Short[16];
                        for (int i2 = 0; i2 < 16; ++i2) {
                            spattern[i2] = 0;
                        }
                        ni3.newVar(Artwork.ART_PATTERN, (Object)spattern, ep);
                    }
                    ni3.newVar(OPTION_KEY, (Object)6, ep);
                }
            }
            ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(-12.0, 3.5), 0.0, 0.0, np);
            if (ni == null) {
                return;
            }
            TextDescriptor td = ep.getNodeTextDescriptor().withRelSize(0.5);
            ni.newVar(Artwork.ART_MESSAGE, (Object)"Stipple Pattern", td);
        }
        if (patClearNode == null) {
            ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(-12.0, -14.0), 0.0, 0.0, np);
            if (ni == null) {
                return;
            }
            ni.newDisplayVar(Artwork.ART_MESSAGE, "Clear Pattern", ep);
            ni.newVar(OPTION_KEY, (Object)34, ep);
        }
        if (patInvertNode == null) {
            ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(-12.0, -16.0), 0.0, 0.0, np);
            if (ni == null) {
                return;
            }
            ni.newDisplayVar(Artwork.ART_MESSAGE, "Invert Pattern", ep);
            ni.newVar(OPTION_KEY, (Object)35, ep);
        }
        if (patCopyNode == null) {
            ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(-12.0, -18.0), 0.0, 0.0, np);
            if (ni == null) {
                return;
            }
            ni.newDisplayVar(Artwork.ART_MESSAGE, "Copy Pattern", ep);
            ni.newVar(OPTION_KEY, (Object)36, ep);
        }
        if (patPasteNode == null) {
            ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(-12.0, -20.0), 0.0, 0.0, np);
            if (ni == null) {
                return;
            }
            ni.newDisplayVar(Artwork.ART_MESSAGE, "Paste Pattern", ep);
            ni.newVar(OPTION_KEY, (Object)37, ep);
        }
        LayerInfo.loadTableEntry(layerTextTable, 4, (Object)this.fun);
        LayerInfo.loadTableEntry(layerTextTable, 33, this.desc);
        LayerInfo.loadTableEntry(layerTextTable, 1, this.desc);
        LayerInfo.loadTableEntry(layerTextTable, 2, this.desc);
        LayerInfo.loadTableEntry(layerTextTable, 3, this.cif);
        LayerInfo.loadTableEntry(layerTextTable, 20, this.gds);
        LayerInfo.loadTableEntry(layerTextTable, 27, this.spiRes);
        LayerInfo.loadTableEntry(layerTextTable, 28, this.spiCap);
        LayerInfo.loadTableEntry(layerTextTable, 29, this.spiECap);
        LayerInfo.loadTableEntry(layerTextTable, 64, this.inductanceAreaFactor);
        LayerInfo.loadTableEntry(layerTextTable, 65, this.inductanceLengthFactor);
        LayerInfo.loadTableEntry(layerTextTable, 31, this.height3d);
        LayerInfo.loadTableEntry(layerTextTable, 32, this.thick3d);
        LayerInfo.loadTableEntry(layerTextTable, 59, this.desc);
        LayerInfo.loadTableEntry(layerTextTable, 60, this.desc);
        LayerInfo.loadTableEntry(layerTextTable, 41, this.coverage);
        for (int i3 = 0; i3 < layerTextTable.length; ++i3) {
            switch (LayerInfo.layerTextTable[i3].funct) {
                case 4: {
                    LayerInfo.layerTextTable[i3].value = this.fun;
                    LayerInfo.layerTextTable[i3].extra = this.funExtra;
                }
            }
        }
        LayerInfo.createSpecialText(np, layerTextTable, ep);
    }

    static LayerInfo parseCell(Cell np) {
        LayerInfo li = new LayerInfo();
        li.name = np.getName().substring(6);
        int patternCount = 0;
        Rectangle2D.Double patternBounds = null;
        boolean patternOnPrinter = false;
        boolean patternOnDisplay = false;
        EGraphics.Outline patternOutline = null;
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            String str = LayerInfo.getValueOnNode(ni);
            switch ((Integer)var.getObject()) {
                case 4: {
                    li.fun = Layer.Function.UNKNOWN;
                    li.funExtra = 0;
                    int commaPos = str.indexOf(44);
                    String extras = "";
                    if (commaPos >= 0) {
                        extras = str.substring(commaPos + 1);
                        str = str.substring(0, commaPos);
                    }
                    List<Layer.Function> allFuncs = Layer.Function.getFunctions();
                    for (Layer.Function fun : allFuncs) {
                        if (!fun.getName().equalsIgnoreCase(str)) continue;
                        li.fun = fun;
                        break;
                    }
                    int[] allExtraBits = Layer.Function.getFunctionExtras();
                    block17: while (extras.length() > 0) {
                        int cp = extras.indexOf(44);
                        String thisExtra = extras;
                        if (cp >= 0) {
                            thisExtra = extras.substring(0, cp);
                            extras = extras.substring(cp + 1);
                        } else {
                            extras = "";
                        }
                        for (int j2 = 0; j2 < allExtraBits.length; ++j2) {
                            if (!Layer.Function.getExtraName(allExtraBits[j2]).equalsIgnoreCase(thisExtra)) continue;
                            li.funExtra |= allExtraBits[j2];
                            continue block17;
                        }
                    }
                    break;
                }
                case 33: {
                    StringTokenizer st = new StringTokenizer(str, ",");
                    if (st.countTokens() != 5) {
                        System.out.println("Color information must have 5 fields, separated by commas");
                        break;
                    }
                    int r = TextUtils.atoi(st.nextToken());
                    int g2 = TextUtils.atoi(st.nextToken());
                    int b2 = TextUtils.atoi(st.nextToken());
                    double o2 = TextUtils.atof(st.nextToken());
                    boolean f2 = st.nextToken().equalsIgnoreCase("on");
                    li.desc = li.desc.withColor(new Color(r, g2, b2));
                    li.desc = li.desc.withOpacity(o2);
                    li.desc = li.desc.withForeground(f2);
                    break;
                }
                case 1: {
                    if (str.equalsIgnoreCase("none")) {
                        li.desc = li.desc.withTransparentLayer(0);
                        break;
                    }
                    int layerNum = TextUtils.atoi(str.substring(str.indexOf(45) + 1));
                    li.desc = li.desc.withTransparentLayer(layerNum);
                    break;
                }
                case 6: {
                    if (patternCount == 0) {
                        patternBounds = new Rectangle2D.Double();
                        ((Rectangle2D)patternBounds).setRect(ni.getBounds());
                    } else {
                        Rectangle2D.union(patternBounds, ni.getBounds(), patternBounds);
                    }
                    ++patternCount;
                    break;
                }
                case 2: {
                    patternOnPrinter = true;
                    int commaPos = str.indexOf(44);
                    if (commaPos >= 0) {
                        if (str.substring(commaPos + 1).equals("PrintSolid")) {
                            patternOnPrinter = false;
                        }
                        str = str.substring(0, commaPos);
                    }
                    if (str.equalsIgnoreCase("solid")) {
                        patternOnDisplay = false;
                        break;
                    }
                    if (str.equalsIgnoreCase("patterned")) {
                        patternOnDisplay = true;
                        patternOutline = EGraphics.Outline.NOPAT;
                        break;
                    }
                    if (str.equalsIgnoreCase("patterned/outlined")) {
                        patternOnDisplay = true;
                        patternOutline = EGraphics.Outline.PAT_S;
                        break;
                    }
                    if (!TextUtils.canonicString(str).startsWith("patterned/outline=")) break;
                    patternOnDisplay = true;
                    patternOutline = EGraphics.Outline.findOutline(str.substring(18));
                    break;
                }
                case 3: {
                    li.cif = str;
                    break;
                }
                case 20: {
                    if (str.equals("-1")) {
                        str = "";
                    }
                    li.gds = str;
                    break;
                }
                case 27: {
                    li.spiRes = TextUtils.atof(str);
                    break;
                }
                case 28: {
                    li.spiCap = TextUtils.atof(str);
                    break;
                }
                case 29: {
                    li.spiECap = TextUtils.atof(str);
                    break;
                }
                case 31: {
                    li.height3d = TextUtils.atof(str);
                    break;
                }
                case 32: {
                    li.thick3d = TextUtils.atof(str);
                    break;
                }
                case 41: {
                    li.coverage = TextUtils.atof(str);
                }
            }
        }
        if (patternCount != 256 && patternCount != 128) {
            System.out.println("Incorrect number of pattern boxes in " + String.valueOf(np) + " (has " + patternCount + ", not 256)");
            return null;
        }
        int[] newPat = new int[16];
        Iterator<NodeInst> it2 = np.getNodes();
        while (it2.hasNext()) {
            int y;
            Variable var;
            NodeInst ni = it2.next();
            if (ni.getProto() != Artwork.tech().filledBoxNode || (var = ni.getVar(OPTION_KEY)) == null || (Integer)var.getObject() != 6) continue;
            var = ni.getVar(Artwork.ART_PATTERN);
            if (var != null) {
                Short[] pat = (Short[])var.getObject();
                boolean nonZero = false;
                for (int i2 = 0; i2 < pat.length; ++i2) {
                    if (pat[i2] == 0) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
            }
            ERectangle niBounds = ni.getBounds();
            int x = (int)((((RectangularShape)niBounds).getMinX() - patternBounds.getMinX()) / (((RectangularShape)patternBounds).getWidth() / 16.0));
            int n2 = y = (int)((patternBounds.getMaxY() - ((RectangularShape)niBounds).getMaxY()) / (((RectangularShape)patternBounds).getHeight() / 16.0));
            newPat[n2] = newPat[n2] | 1 << 15 - x;
        }
        if (patternCount == 128) {
            for (int y = 0; y < 8; ++y) {
                newPat[y + 8] = newPat[y];
            }
        }
        li.desc = li.desc.withPattern(newPat);
        li.desc = li.desc.withPatternedOnPrinter(patternOnPrinter);
        li.desc = li.desc.withPatternedOnDisplay(patternOnDisplay);
        if (patternOutline != null) {
            li.desc = li.desc.withOutlined(patternOutline);
        }
        return li;
    }

    static String makeLayerFunctionName(Layer.Function fun, int extraBits) {
        Object str = fun.getName();
        int[] allExtraBits = Layer.Function.getFunctionExtras();
        for (int j2 = 0; j2 < allExtraBits.length; ++j2) {
            if ((allExtraBits[j2] & extraBits) == 0) continue;
            str = (String)str + "," + Layer.Function.getExtraName(allExtraBits[j2]);
        }
        return str;
    }
}

