/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Info {
    static final int LAYERTRANSPARENCY = 1;
    static final int LAYERSTYLE = 2;
    static final int LAYERCIF = 3;
    static final int LAYERFUNCTION = 4;
    static final int LAYERLETTERS = 5;
    static final int LAYERPATTERN = 6;
    static final int LAYERPATCONT = 7;
    static final int LAYERPATCH = 8;
    static final int ARCFUNCTION = 9;
    static final int NODEFUNCTION = 10;
    static final int ARCFIXANG = 11;
    static final int ARCWIPESPINS = 12;
    static final int ARCNOEXTEND = 13;
    static final int TECHSCALE = 14;
    static final int TECHDESCRIPT = 15;
    static final int NODESERPENTINE = 16;
    static final int LAYERDRCMINWID = 17;
    static final int PORTOBJ = 18;
    public static final int HIGHLIGHTOBJ = 19;
    static final int LAYERGDS = 20;
    static final int NODESQUARE = 21;
    static final int NODEWIPES = 22;
    static final int ARCINC = 23;
    static final int NODEMULTICUT = 24;
    static final int NODELOCKABLE = 25;
    static final int CENTEROBJ = 26;
    static final int LAYERSPIRES = 27;
    static final int LAYERSPICAP = 28;
    static final int LAYERSPIECAP = 29;
    static final int LAYERDXF = 30;
    static final int LAYER3DHEIGHT = 31;
    static final int LAYER3DTHICK = 32;
    static final int LAYERCOLOR = 33;
    static final int LAYERPATCLEAR = 34;
    static final int LAYERPATINVERT = 35;
    static final int LAYERPATCOPY = 36;
    static final int LAYERPATPASTE = 37;
    static final int TECHSPICEMINRES = 38;
    static final int TECHSPICEMINCAP = 39;
    static final int ARCANTENNARATIO = 40;
    static final int LAYERCOVERAGE = 41;
    static final int TECHGATESHRINK = 42;
    static final int TECHGATEINCLUDED = 43;
    static final int TECHGROUNDINCLUDED = 44;
    static final int TECHTRANSPCOLORS = 45;
    static final int TECHSHORTNAME = 46;
    static final int TECHFOUNDRY = 47;
    static final int TECHDEFMETALS = 48;
    static final int TECHMAXSERIESRES = 49;
    static final int TECHSPICELEVEL1 = 50;
    static final int TECHSPICELEVEL2 = 51;
    static final int TECHSPICELEVEL3 = 52;
    static final int TECHSCALERELEVANT = 53;
    static final int TECHCONDIST = 54;
    static final int TECHUNCONDIST = 55;
    static final int TECHPALETTE = 56;
    static final int ARCCURVABLE = 57;
    static final int NODESHRINKSARCS = 58;
    static final int LAYER3DMODE = 59;
    static final int LAYER3DFACTOR = 60;
    static final int NODESPICETEMPLATE = 61;
    static final int ARCWIDTHOFFSET = 62;
    static final int TECHRESOLUTION = 63;
    static final int LAYERINDAREAFAC = 64;
    static final int LAYERINDLENFAC = 65;
    public static final Variable.Key LAYER_KEY = Variable.newKey("EDTEC_layer");
    public static final Variable.Key OPTION_KEY = Variable.newKey("EDTEC_option");
    public static final Variable.Key COMPMENU_KEY = Variable.newKey("EDTEC_componentmenu");
    static final Variable.Key ARCSEQUENCE_KEY = Variable.newKey("EDTEC_arcsequence");
    static final Variable.Key NODESEQUENCE_KEY = Variable.newKey("EDTEC_nodesequence");
    static final Variable.Key LAYERSEQUENCE_KEY = Variable.newKey("EDTEC_layersequence");
    static final Variable.Key MINSIZEBOX_KEY = Variable.newKey("EDTEC_minbox");
    static final Variable.Key PORTNAME_KEY = Variable.newKey("EDTEC_portname");
    static final Variable.Key PORTANGLE_KEY = Variable.newKey("EDTEC_portangle");
    static final Variable.Key PORTRANGE_KEY = Variable.newKey("EDTEC_portrange");
    static final Variable.Key CONNECTION_KEY = Variable.newKey("EDTEC_connects");
    static final Variable.Key COLORMAP_KEY = Variable.newKey("EDTEC_colormap");
    static final Variable.Key DEPENDENTLIB_KEY = Variable.newKey("EDTEC_dependent_libraries");
    static final Variable.Key TRANSLAYER_KEY = Variable.newKey("EDTEC_transparent_layers");
    static final Variable.Key PORTMEANING_KEY = Variable.newKey("EDTEC_portmeaning");

    protected static void createSpecialText(Cell np, SpecialTextDescr[] table, EditingPreferences ep) {
        for (int i2 = 0; i2 < table.length; ++i2) {
            table[i2].ni = null;
        }
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            Info.foundNodeForFunction(ni, (Integer)var.getObject(), table);
        }
        for (int i3 = 0; i3 < table.length; ++i3) {
            if (table[i3].ni != null) continue;
            table[i3].ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(table[i3].x, table[i3].y), 0.0, 0.0, np);
            if (table[i3].ni == null) {
                return;
            }
            switch (table[i3].funct) {
                case 46: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "ShortName: " + (String)table[i3].value, ep);
                    break;
                }
                case 14: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Scale: " + (Double)table[i3].value, ep);
                    break;
                }
                case 47: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "DefaultFoundry: " + (String)table[i3].value, ep);
                    break;
                }
                case 48: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Default Number Of Metals: " + (Integer)table[i3].value, ep);
                    break;
                }
                case 15: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Description: " + (String)table[i3].value, ep);
                    break;
                }
                case 38: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Minimum Resistance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 39: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Minimum Capacitance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 49: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Max Series Resistance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 42: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Gate Shrinkage: " + (Double)table[i3].value, ep);
                    break;
                }
                case 43: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Gates Included in Resistance: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 44: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Parasitics Includes Ground: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 45: {
                    table[i3].ni.newVar(TRANSLAYER_KEY, (Object)GeneralInfo.makeTransparentColorsLine((Color[])table[i3].value), ep);
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Transparent Colors", ep);
                    break;
                }
                case 4: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Function: " + LayerInfo.makeLayerFunctionName((Layer.Function)((Object)table[i3].value), table[i3].extra), ep);
                    break;
                }
                case 33: {
                    EGraphics desc = (EGraphics)table[i3].value;
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Color: " + desc.getColor().getRed() + "," + desc.getColor().getGreen() + "," + desc.getColor().getBlue() + ", " + desc.getOpacity() + "," + (desc.getForeground() ? "on" : "off"), ep);
                    break;
                }
                case 1: {
                    EGraphics desc = (EGraphics)table[i3].value;
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Transparency: " + (String)(desc.getTransparentLayer() == 0 ? "none" : "layer-" + desc.getTransparentLayer()), ep);
                    break;
                }
                case 2: {
                    EGraphics desc = (EGraphics)table[i3].value;
                    Object str = "Style: ";
                    if (desc.isPatternedOnDisplay()) {
                        EGraphics.Outline o2 = desc.getOutlined();
                        str = (String)str + "Patterned/Outline=" + o2.getName();
                    } else {
                        str = (String)str + "Solid";
                    }
                    if (!desc.isPatternedOnPrinter()) {
                        str = (String)str + ",PrintSolid";
                    }
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, str, ep);
                    break;
                }
                case 3: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "CIF Layer: " + (String)table[i3].value, ep);
                    break;
                }
                case 20: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "GDS-II Layer: " + (String)table[i3].value, ep);
                    break;
                }
                case 27: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "SPICE Resistance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 28: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "SPICE Capacitance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 29: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "SPICE Edge Capacitance: " + (Double)table[i3].value, ep);
                    break;
                }
                case 31: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "3D Height: " + (Double)table[i3].value, ep);
                    break;
                }
                case 32: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "3D Thickness: " + (Double)table[i3].value, ep);
                    break;
                }
                case 41: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Coverage percent: " + (Double)table[i3].value, ep);
                    break;
                }
                case 9: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Function: " + ((ArcProto.Function)((Object)table[i3].value)).toString(), ep);
                    break;
                }
                case 11: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Fixed-angle: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 12: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Wipes pins: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 13: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Extend arcs: " + ((Boolean)table[i3].value != false ? "No" : "Yes"), ep);
                    break;
                }
                case 23: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Angle increment: " + (Integer)table[i3].value, ep);
                    break;
                }
                case 40: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Antenna Ratio: " + (Double)table[i3].value, ep);
                    break;
                }
                case 62: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "ELIB width offset: " + (Double)table[i3].value, ep);
                    break;
                }
                case 10: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Function: " + ((PrimitiveNode.Function)((Object)table[i3].value)).toString(), ep);
                    break;
                }
                case 16: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Serpentine transistor: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 21: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Square node: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 22: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Invisible with 1 or 2 arcs: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 25: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Lockable: " + ((Boolean)table[i3].value != false ? "Yes" : "No"), ep);
                    break;
                }
                case 61: {
                    table[i3].ni.newDisplayVar(Artwork.ART_MESSAGE, "Spice template: " + String.valueOf(table[i3].value == null ? "" : table[i3].value), ep);
                }
            }
            table[i3].ni.newVar(OPTION_KEY, (Object)table[i3].funct, ep);
        }
    }

    private static void foundNodeForFunction(NodeInst ni, int func, SpecialTextDescr[] table) {
        for (int i2 = 0; i2 < table.length; ++i2) {
            if (table[i2].funct != func) continue;
            table[i2].ni = ni;
            return;
        }
    }

    protected static void loadTableEntry(SpecialTextDescr[] table, int func, Object value) {
        for (int i2 = 0; i2 < table.length; ++i2) {
            if (func != table[i2].funct) continue;
            table[i2].value = value;
            return;
        }
    }

    static Library[] getDependentLibraries(Library lib) {
        int i2;
        ArrayList<Library> dependentLibs = new ArrayList<Library>();
        Variable var = lib.getVar(DEPENDENTLIB_KEY);
        if (var != null) {
            String[] libNames = (String[])var.getObject();
            for (i2 = 0; i2 < libNames.length; ++i2) {
                String pt = libNames[i2];
                Library dLib = Library.findLibrary(pt);
                if (dLib == null) {
                    System.out.println("Cannot find dependent technology library " + pt + ", ignoring");
                    continue;
                }
                if (dLib == lib) {
                    System.out.println("Library '" + lib.getName() + "' cannot depend on itself, ignoring dependency");
                    continue;
                }
                dependentLibs.add(dLib);
            }
        }
        dependentLibs.add(lib);
        Library[] theLibs = new Library[dependentLibs.size()];
        for (i2 = 0; i2 < dependentLibs.size(); ++i2) {
            theLibs[i2] = (Library)dependentLibs.get(i2);
        }
        return theLibs;
    }

    static Cell[] findCellSequence(Library[] dependentlibs, String match, Variable.Key seqKey) {
        ArrayList<Cell> npList = new ArrayList<Cell>();
        for (int i2 = dependentlibs.length - 1; i2 >= 0; --i2) {
            Library olderlib = dependentlibs[i2];
            Iterator<Cell> it = olderlib.getCells();
            while (it.hasNext()) {
                Cell np = it.next();
                if (!np.getName().startsWith(match)) continue;
                boolean foundInLater = false;
                for (int j2 = i2 + 1; j2 < dependentlibs.length; ++j2) {
                    Library laterLib = dependentlibs[j2];
                    Iterator<Cell> oIt = laterLib.getCells();
                    while (oIt.hasNext()) {
                        Cell lNp = oIt.next();
                        if (!lNp.getName().equals(np.getName())) continue;
                        foundInLater = true;
                        if (!lNp.getRevisionDate().before(np.getRevisionDate())) break;
                        System.out.println("Warning: " + String.valueOf(olderlib) + " has newer " + np.getName() + " than " + String.valueOf(laterLib));
                        break;
                    }
                    if (foundInLater) break;
                }
                if (foundInLater) continue;
                npList.add(np);
            }
        }
        Variable var = dependentlibs[dependentlibs.length - 1].getVar(seqKey);
        ArrayList<Cell> sequence = new ArrayList<Cell>();
        String[] sequenceNames = var != null ? (String[])var.getObject() : new String[]{};
        for (int i3 = 0; i3 < sequenceNames.length; ++i3) {
            Cell foundCell = null;
            for (int l2 = 0; l2 < npList.size(); ++l2) {
                Cell np = (Cell)npList.get(l2);
                if (!np.getName().substring(match.length()).equals(sequenceNames[i3])) continue;
                foundCell = np;
                break;
            }
            if (foundCell == null) continue;
            sequence.add(foundCell);
            npList.remove(foundCell);
        }
        for (Cell c2 : npList) {
            sequence.add(c2);
        }
        Cell[] theCells = new Cell[sequence.size()];
        for (int i4 = 0; i4 < sequence.size(); ++i4) {
            theCells[i4] = (Cell)sequence.get(i4);
        }
        return theCells;
    }

    static String getPortName(NodeInst ni) {
        Variable var = ni.getVar(PORTNAME_KEY);
        if (var != null) {
            return (String)var.getObject();
        }
        var = ni.getVar(NodeInst.NODE_NAME);
        if (var != null) {
            return (String)var.getObject();
        }
        return null;
    }

    static String getValueOnNode(NodeInst ni) {
        String initial = ni.getVarValue(Artwork.ART_MESSAGE, String.class, "");
        int colonPos = initial.indexOf(58);
        if (colonPos > 0) {
            initial = initial.substring(colonPos + 2);
        }
        return initial;
    }

    static String getSampleName(NodeProto layerCell) {
        if (layerCell == Generic.tech().portNode) {
            return "PORT";
        }
        if (layerCell == Generic.tech().cellCenterNode) {
            return "GRAB";
        }
        if (layerCell == null) {
            return "HIGHLIGHT";
        }
        return layerCell.getName().substring(6);
    }

    protected static class SpecialTextDescr {
        NodeInst ni = null;
        Object value = null;
        int extra;
        double x;
        double y;
        int funct;

        protected SpecialTextDescr(double x, double y, int funct) {
            this.x = x;
            this.y = y;
            this.funct = funct;
        }
    }
}

