/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotAnalyze;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VectorCache {
    private static final boolean USE_CELL_RTREE = true;
    private static final boolean USE_ELECTRICAL = false;
    private static final boolean WIPE_PINS = true;
    public static final boolean DEBUG = false;
    public static final VectorCache theCache = new VectorCache(EDatabase.clientDatabase());
    public final EDatabase database;
    private final ArrayList<VectorCellDef> cachedCells = new ArrayList();
    private final Map<CellId, List<VectorBase>> addPolyToCell = new HashMap<CellId, List<VectorBase>>();
    private final Map<CellId, List<VectorLine>> addInstToCell = new HashMap<CellId, List<VectorLine>>();
    private final ShapeBuilder shapeBuilder = new ShapeBuilder();
    private final ArrayList<List<VectorManhattanBox>> boxBuilders = new ArrayList();
    private final ArrayList<List<VectorManhattanBox>> pureBoxBuilders = new ArrayList();
    private VarContext varContext;
    private double curScale;
    private boolean clearFadeImages = false;
    private boolean clearCache = false;
    private long updateStep = 0L;
    private final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private EGraphics instanceGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private final EditWindow0 dummyWnd = new EditWindow0(){
        double globalScale = User.getGlobalTextScale();
        String defaultFont = User.getDefaultFont();

        @Override
        public Rectangle2D getGlyphBounds(String text, Font font) {
            return VectorCache.this.CENTERRECT;
        }

        @Override
        public VarContext getVarContext() {
            return VectorCache.this.varContext;
        }

        @Override
        public double getScale() {
            return VectorCache.this.curScale;
        }

        @Override
        public double getGlobalTextScale() {
            return this.globalScale;
        }

        @Override
        public String getDefaultFont() {
            return this.defaultFont;
        }
    };
    private static final PrimitivePortId busPinPortId = Schematics.tech().busPinNode.getPort(0).getId();
    public static Comparator<VectorBase> shapeByLayer = new Comparator<VectorBase>(){

        @Override
        public int compare(VectorBase vb1, VectorBase vb2) {
            Layer.Function fun;
            if (vb1.isFilled() != vb2.isFilled()) {
                return vb1.isFilled() ? 1 : -1;
            }
            int level1 = 1000;
            int level2 = 1000;
            boolean isContact1 = false;
            boolean isContact2 = false;
            if (vb1.layer != null) {
                fun = vb1.layer.getFunction();
                level1 = fun.getLevel();
                isContact1 = fun.isContact();
            }
            if (vb2.layer != null) {
                fun = vb2.layer.getFunction();
                level2 = fun.getLevel();
                isContact2 = fun.isContact();
            }
            if (isContact1 != isContact2) {
                return isContact1 ? -1 : 1;
            }
            return level1 - level2;
        }
    };

    VectorCellDef findCellGroup(CellId cellId) {
        int cellIndex = cellId.cellIndex;
        while (cellIndex >= this.cachedCells.size()) {
            this.cachedCells.add(null);
        }
        VectorCellDef vcd = this.cachedCells.get(cellIndex);
        if (vcd == null) {
            vcd = new VectorCellDef(cellId);
            this.cachedCells.set(cellIndex, vcd);
        }
        return vcd;
    }

    public VectorCache(EDatabase database) {
        this.database = database;
    }

    public VectorCell findVectorCell(CellId cellId, Orientation orient) {
        VectorCellDef vcd = this.findCellGroup(cellId);
        VectorCell vc = vcd.orientations.get(orient = orient.canonic());
        if (vc == null) {
            vc = new VectorCell(vcd, orient);
            vcd.orientations.put(orient, vc);
        }
        return vc;
    }

    public static Cell getCellFromId(CellId cellId) {
        Cell cell = VectorCache.theCache.database.getCell(cellId);
        if (cell == null) {
            String fullName = cellId.cellName.toString();
            Library lib = Library.getCurrent();
            cell = lib.findNodeProto(fullName);
        }
        return cell;
    }

    public VectorCell drawCell(CellId cellId, Orientation prevTrans, VarContext context, double scale, boolean makeTopLevel) {
        this.curScale = scale;
        Cell cell = VectorCache.getCellFromId(cellId);
        VectorCell vc = this.findVectorCell(cellId, prevTrans);
        VectorCellDef vcd = vc.vcd;
        if (vcd.isParameterized || vc.validStep != this.updateStep) {
            VarContext varContext = this.varContext = vcd.isParameterized ? context : null;
            if (cell == null) {
                if (Job.getDebug()) {
                    System.out.println("Cell is null in VectorCell.drawCell");
                }
            } else if (cell.isLinked()) {
                long startTime = 0L;
                vc.buildCache(cell);
                if (makeTopLevel) {
                    vc.buildTopOnlyShapes();
                }
            }
        }
        return vc;
    }

    public static VectorBase[] drawNode(NodeInst ni) {
        VectorCache cache = new VectorCache(EDatabase.clientDatabase());
        VectorCell vc = cache.newDummyVectorCell();
        cache.shapeBuilder.setup(ni.getCellBackup(), null, false, true, false, null);
        cache.shapeBuilder.vc = vc;
        cache.drawPrimitiveNode(ni, GenMath.MATID, vc);
        for (Layer layer : vc.organizedShapes.keySet()) {
            List<VectorBase> vbList = vc.organizedShapes.get(layer);
            if (vbList == null) continue;
            for (VectorBase vb : vbList) {
                vc.topOnlyShapes.add(vb);
            }
        }
        Collections.sort(vc.topOnlyShapes, shapeByLayer);
        return vc.topOnlyShapes.toArray(new VectorBase[vc.topOnlyShapes.size()]);
    }

    public static VectorBase[] drawPolys(ImmutableArcInst a2, Poly[] polys) {
        VectorCache cache = new VectorCache(EDatabase.clientDatabase());
        VectorCell vc = cache.newDummyVectorCell();
        cache.drawPolys(a2, polys, GenMath.MATID, vc, false, 4, false);
        assert (vc.topOnlyShapes.isEmpty());
        for (Layer layer : vc.organizedShapes.keySet()) {
            List<VectorBase> vbList = vc.organizedShapes.get(layer);
            if (vbList == null) continue;
            for (VectorBase vb : vbList) {
                vc.topOnlyShapes.add(vb);
            }
        }
        Collections.sort(vc.topOnlyShapes, shapeByLayer);
        return vc.topOnlyShapes.toArray(new VectorBase[vc.topOnlyShapes.size()]);
    }

    private VectorCell newDummyVectorCell() {
        return new VectorCell();
    }

    public void addBoxToCell(ImmutableElectricObject origin, double lX, double lY, double hX, double hY, Layer layer, CellId cellId) {
        List<VectorBase> addToThisCell = this.addPolyToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorBase>();
            this.addPolyToCell.put(cellId, addToThisCell);
        }
        VectorManhattan vm = new VectorManhattan(origin, lX, lY, hX, hY, layer, null, false);
        addToThisCell.add(vm);
    }

    public void addInstanceToCell(ImmutableElectricObject origin, double lX, double lY, double hX, double hY, CellId cellId) {
        List<VectorLine> addToThisCell = this.addInstToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorLine>();
            this.addInstToCell.put(cellId, addToThisCell);
        }
        addToThisCell.add(new VectorLine(origin, lX, lY, hX, lY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(origin, hX, lY, hX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(origin, hX, hY, lX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(origin, lX, hY, lX, lY, 0, null, this.instanceGraphics));
    }

    private static boolean isCellParameterized(CellRevision cellRevision) {
        Variable var;
        Iterator<Variable> vIt;
        if (cellRevision.d.getNumParameters() > 0) {
            return true;
        }
        for (ImmutableNodeInst n2 : cellRevision.nodes) {
            if (n2 instanceof ImmutableIconInst) {
                vIt = ((ImmutableIconInst)n2).getDefinedParameters();
                while (vIt.hasNext()) {
                    var = vIt.next();
                    if (!var.isCode()) continue;
                    return true;
                }
            }
            vIt = n2.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableArcInst a2 : cellRevision.arcs) {
            vIt = a2.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableExport e2 : cellRevision.exports) {
            if (e2.originalPortId != busPinPortId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void updateVectorCache(SnapshotAnalyze sa) {
        VectorCellDef vcd;
        ++this.updateStep;
        Object timer = null;
        List<CellId> killedCells = sa.getDeletedCells();
        for (CellId cid : killedCells) {
            VectorCellDef vectorCellDef = vcd = cid.cellIndex < this.cachedCells.size() ? this.cachedCells.get(cid.cellIndex) : null;
            if (vcd == null) continue;
            vcd.clear();
            this.cachedCells.set(cid.cellIndex, null);
        }
        for (CellId cid : sa.getChangedExportCells()) {
            vcd = this.findCellGroup(cid);
            vcd.updateExports();
        }
        for (CellId cid : sa.getChangedVariableCells()) {
            vcd = this.findCellGroup(cid);
            vcd.updateVariables();
        }
        Set<CellId> cellsToUpdate = sa.changedCells();
        for (CellId cid : cellsToUpdate) {
            VectorCellDef vcd2 = this.findCellGroup(cid);
            if (vcd2.isParameterized) continue;
            ERectangle newBounds = sa.getNewSnapshot().getCellBounds(cid);
            if (newBounds == null || !newBounds.equals(vcd2.bounds)) {
                vcd2.updateBounds(sa.getNewSnapshot());
            }
            Cell cell = VectorCache.getCellFromId(cid);
            Set<ImmutableElectricObject> addedToCell = sa.getAdded(cid);
            Set<ImmutableElectricObject> removedFromCell = sa.getRemoved(cid);
            for (Orientation o2 : vcd2.orientations.keySet()) {
                VectorCell vc = vcd2.orientations.get(o2);
                if (vc.validStep != this.updateStep) continue;
                if (removedFromCell.size() > 0) {
                    Iterator vsc;
                    void var16_24;
                    for (Layer layer : vc.organizedShapes.keySet()) {
                        List<VectorBase> vbList = vc.organizedShapes.get(layer);
                        if (vbList == null) continue;
                        for (int i2 = 0; i2 < vbList.size(); ++i2) {
                            VectorBase vb = vbList.get(i2);
                            if (!removedFromCell.contains(vb.origin)) continue;
                            int lastIndex = vbList.size() - 1;
                            if (i2 < lastIndex) {
                                vbList.set(i2, vbList.get(lastIndex));
                                --i2;
                            }
                            vbList.remove(lastIndex);
                        }
                    }
                    if (vc.topOnlyShapes != null) {
                        for (int i3 = 0; i3 < vc.topOnlyShapes.size(); ++i3) {
                            VectorBase vectorBase = vc.topOnlyShapes.get(i3);
                            if (!removedFromCell.contains(vectorBase.origin)) continue;
                            int lastIndex = vc.topOnlyShapes.size() - 1;
                            if (i3 < lastIndex) {
                                vc.topOnlyShapes.set(i3, vc.topOnlyShapes.get(lastIndex));
                                --i3;
                            }
                            vc.topOnlyShapes.remove(lastIndex);
                        }
                    }
                    ArrayList removeThese = new ArrayList();
                    if (vc.subCellTree == null) {
                        Iterator<VectorSubCell> iterator = vc.subCells.iterator();
                    } else {
                        RTNode.Search<VectorSubCell> search = new RTNode.Search<VectorSubCell>(vc.subCellTree);
                    }
                    while (var16_24.hasNext()) {
                        vsc = (VectorSubCell)var16_24.next();
                        if (!removedFromCell.contains(((VectorSubCell)((Object)vsc)).n)) continue;
                        removeThese.add(vsc);
                    }
                    if (vc.subCellTree == null) {
                        vsc = removeThese.iterator();
                        while (vsc.hasNext()) {
                            VectorSubCell vsc2 = (VectorSubCell)vsc.next();
                            vc.subCells.remove(vsc2);
                        }
                    } else {
                        vsc = removeThese.iterator();
                        while (vsc.hasNext()) {
                            VectorSubCell vsc3 = (VectorSubCell)vsc.next();
                            vc.subCellTree = RTNode.unLinkGeom(null, vc.subCellTree, vsc3);
                        }
                    }
                }
                for (List<VectorManhattanBox> list : this.boxBuilders) {
                    list.clear();
                }
                for (List list : this.pureBoxBuilders) {
                    list.clear();
                }
                this.shapeBuilder.setup(cell.backup(), o2, false, true, false, null);
                this.shapeBuilder.vc = vc;
                this.shapeBuilder.hideOnLowLevel = false;
                this.shapeBuilder.textType = 4;
                FixpTransform trans = o2.pureRotate();
                for (ImmutableElectricObject obj : addedToCell) {
                    if (obj instanceof ImmutableNodeInst) {
                        ImmutableNodeInst ini = (ImmutableNodeInst)obj;
                        NodeInst ni = cell.getNodeById(ini.nodeId);
                        if (ini.isCellInstance()) {
                            this.drawSubcell(ni, trans, vc);
                        } else {
                            boolean hideOnLowLevel;
                            boolean bl = hideOnLowLevel = ni.isVisInside() || Generic.isCellCenter(ni);
                            if (!hideOnLowLevel) {
                                this.drawPrimitiveNode(ni, trans, vc);
                            }
                        }
                        Iterator<Export> it = ni.getExports();
                        while (it.hasNext()) {
                            Export e2 = it.next();
                            if (vc.topOnlyShapes == null) {
                                vc.topOnlyShapes = new ArrayList();
                            }
                            vc.addExport(e2, trans);
                        }
                        continue;
                    }
                    ImmutableArcInst iai = (ImmutableArcInst)obj;
                    ArcInst ai = cell.getArcById(iai.arcId);
                    this.drawArc(ai, trans, vc);
                }
                this.addBoxesFromBuilder(vc, cell.getTechnology(), this.boxBuilders, false);
                this.addBoxesFromBuilder(vc, cell.getTechnology(), this.pureBoxBuilders, true);
                vc.validStep = this.updateStep;
            }
        }
    }

    public Set<CellId> updateChange(Set<CellId> topCells, SnapshotAnalyze sa) {
        HashSet<CellId> cellsToRedraw = new HashSet<CellId>();
        if (sa == null) {
            return cellsToRedraw;
        }
        this.updateVectorCache(sa);
        Set<CellId> cellsThatChanged = sa.changedCells();
        for (CellId cellId : sa.getChangedExportCells()) {
            cellsThatChanged.add(cellId);
        }
        Set<CellId> cellsThatChangedSize = sa.sizeChangedCells();
        for (CellId cid : cellsThatChanged) {
            cellsToRedraw.add(cid);
        }
        HashMap<CellId, Boolean> hashMap = new HashMap<CellId, Boolean>();
        for (CellId cid : topCells) {
            CellRevision cellRevision;
            if (cellsToRedraw.contains(cid) || !this.contentsChanged(cid, cellRevision = sa.getNewSnapshot().getCell((CellId)cid).cellRevision, cellsThatChanged, cellsThatChangedSize, hashMap, sa)) continue;
            cellsToRedraw.add(cid);
        }
        return cellsToRedraw;
    }

    private boolean contentsChanged(CellId cellId, CellRevision cellRevision, Set<CellId> cellsThatChanged, Set<CellId> cellsThatChangedSize, Map<CellId, Boolean> contentsState, SnapshotAnalyze sa) {
        Boolean decided = contentsState.get(cellId);
        if (decided != null) {
            return decided;
        }
        boolean changed = false;
        Cell cell = VectorCache.getCellFromId(cellId);
        for (ImmutableNodeInst n2 : cellRevision.nodes) {
            if (!(n2.protoId instanceof CellId)) continue;
            if (cell.isExpanded(n2.nodeId)) {
                try {
                    if (cellsThatChanged.contains(n2.protoId)) {
                        changed = true;
                        break;
                    }
                    if (!this.contentsChanged((CellId)n2.protoId, sa.getNewSnapshot().getCell((CellId)((CellId)n2.protoId)).cellRevision, cellsThatChanged, cellsThatChangedSize, contentsState, sa)) continue;
                    changed = true;
                    break;
                }
                catch (Error e2) {
                    System.out.println("Error StackOverflowError");
                    continue;
                }
            }
            if (!cellsThatChangedSize.contains(n2.protoId)) continue;
            changed = true;
            break;
        }
        contentsState.put(cellId, changed);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRedraw() {
        boolean clearFadeImages;
        boolean clearCache;
        VectorCache vectorCache = this;
        synchronized (vectorCache) {
            clearCache = this.clearCache;
            this.clearCache = false;
            clearFadeImages = this.clearFadeImages;
            this.clearFadeImages = false;
        }
        if (clearCache || clearFadeImages) {
            Snapshot snapshot = this.database.backup();
            int size = this.cachedCells.size();
            for (int cellIndex = 0; cellIndex < size; ++cellIndex) {
                ERectangle cellBounds;
                VectorCellDef vcd = this.cachedCells.get(cellIndex);
                if (vcd == null) continue;
                if (clearCache) {
                    vcd.clear();
                }
                if (clearFadeImages) {
                    for (VectorCell vc : vcd.orientations.values()) {
                        vc.fadeImageColors = null;
                        vc.fadeImage = false;
                        vc.hasFadeColor = false;
                    }
                }
                if ((cellBounds = snapshot.getCellBounds(cellIndex)) == null || cellBounds.equals(vcd.bounds)) continue;
                vcd.updateBounds(snapshot);
            }
        }
    }

    public synchronized void clearCache() {
        this.clearCache = true;
        this.forceRedraw();
    }

    public synchronized void clearFadeImages() {
        this.clearFadeImages = true;
    }

    private static long databaseToGrid(double lambdaValue) {
        return DBMath.lambdaToGrid(lambdaValue);
    }

    private void addBoxesFromBuilder(VectorCell vc, Technology tech, ArrayList<List<VectorManhattanBox>> boxBuilders, boolean pureArray) {
        int limit = Math.min(boxBuilders.size(), tech.getNumLayers());
        for (int layerIndex = 0; layerIndex < limit; ++layerIndex) {
            List<VectorManhattanBox> b2 = boxBuilders.get(layerIndex);
            if (b2.size() == 0) continue;
            Layer layer = tech.getLayer(layerIndex);
            for (VectorManhattanBox vmb : b2) {
                VectorManhattan vm = new VectorManhattan(vmb.origin, vmb.lX, vmb.lY, vmb.hX, vmb.hY, layer, null, pureArray);
                vc.addShape(vm);
            }
        }
    }

    private void drawSubcell(NodeInst ni, FixpTransform trans, VectorCell vc) {
        Export e2;
        PortInst pi;
        FixpTransform localTrans = ni.rotateOut(trans);
        assert (ni.isCellInstance());
        PolyBase.Point ctrShift = PolyBase.from(ni.getAnchorCenter());
        localTrans.transform(ctrShift, ctrShift);
        VectorSubCell vsc = new VectorSubCell(ni, ctrShift);
        vsc.shownPorts.clear();
        if (vc.subCellTree == null) {
            vc.subCells.add(vsc);
        } else {
            vc.subCellTree = RTNode.linkGeom(null, vc.subCellTree, vsc);
        }
        Iterator<Object> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            pi = con.getPortInst();
            e2 = (Export)pi.getPortProto();
            if (e2.isAlwaysDrawn()) continue;
            vsc.shownPorts.set(e2.getId().getChronIndex());
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            e2 = (Export)pi.getPortProto();
            if (e2.isAlwaysDrawn()) continue;
            vsc.shownPorts.set(e2.getId().getChronIndex());
        }
        Poly[] polys = ni.getDisplayableVariables(this.dummyWnd, true);
        this.drawTextPolys(ni.getD(), polys, localTrans, vc, false, 3, false, !ni.isUsernamed());
    }

    private void drawPrimitiveNode(NodeInst ni, FixpTransform trans, VectorCell vc) {
        assert (!ni.isCellInstance());
        PrimitiveNode pn = (PrimitiveNode)ni.getProto();
        FixpTransform localTrans = ni.rotateOut(trans);
        this.shapeBuilder.textType = pn == Generic.tech().invisiblePinNode ? 5 : 3;
        this.shapeBuilder.pureLayer = ni.getFunction() == PrimitiveNode.Function.NODE;
        this.shapeBuilder.hideOnLowLevel = ni.isVisInside() || pn == Generic.tech().cellCenterNode;
        pn.genShape(this.shapeBuilder, ni.getD());
        this.drawTextPolys(ni.getD(), ni.getDisplayableVariables(this.dummyWnd, true), localTrans, vc, this.shapeBuilder.hideOnLowLevel, this.shapeBuilder.textType, this.shapeBuilder.pureLayer, !ni.isUsernamed());
    }

    private void drawArc(ArcInst ai, FixpTransform trans, VectorCell vc) {
        ArcProto ap = ai.getProto();
        this.shapeBuilder.pureLayer = ap.getNumArcLayers() == 1;
        this.shapeBuilder.genShapeOfArc(ai.getD());
        this.drawTextPolys(ai.getD(), ai.getDisplayableVariables(this.dummyWnd, true), trans, vc, false, 4, false, !ai.isUsernamed());
    }

    private void drawPolys(ImmutableElectricObject origin, Poly[] polys, FixpTransform trans, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        if (polys == null) {
            return;
        }
        for (int i2 = 0; i2 < polys.length; ++i2) {
            Poly poly = polys[i2];
            if (poly == null) continue;
            poly.transform(trans);
            this.renderPoly(origin, poly, vc, hideOnLowLevel, textType, pureLayer, false);
        }
    }

    private void drawTextPolys(ImmutableElectricObject origin, Poly[] polys, FixpTransform trans, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer, boolean tempOwnerName) {
        if (polys == null) {
            return;
        }
        for (int i2 = 0; i2 < polys.length; ++i2) {
            Poly poly = polys[i2];
            if (poly == null) continue;
            poly.transform(trans);
            this.renderPoly(origin, poly, vc, hideOnLowLevel, textType, pureLayer, tempOwnerName);
        }
    }

    private void renderPoly(ImmutableElectricObject origin, Poly poly, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer, boolean tempOwnerName) {
        List<VectorBase> shapes;
        Point2D[] points = poly.getPoints();
        Layer layer = poly.getLayer();
        EGraphics graphicsOverride = poly.getGraphicsOverride();
        Poly.Type style = poly.getStyle();
        if (hideOnLowLevel) {
            if (vc.topOnlyShapes == null) {
                vc.topOnlyShapes = new ArrayList();
            }
            shapes = vc.topOnlyShapes;
        } else {
            shapes = vc.getShapeList(layer);
        }
        if (style == Poly.Type.FILLED) {
            FixpRectangle bounds = poly.getBox();
            if (bounds != null) {
                Layer.Function fun;
                double lX = ((RectangularShape)bounds).getMinX();
                double hX = ((RectangularShape)bounds).getMaxX();
                double lY = ((RectangularShape)bounds).getMinY();
                double hY = ((RectangularShape)bounds).getMaxY();
                float minSize = (float)Math.min(hX - lX, hY - lY);
                int layerIndex = -1;
                if (layer != null && graphicsOverride == null && vc.vcd != null && layer.getId().techId == vc.vcd.techId) {
                    layerIndex = layer.getIndex();
                }
                if (layerIndex >= 0) {
                    VectorCache.putBox(origin, layerIndex, pureLayer ? this.pureBoxBuilders : this.boxBuilders, VectorCache.databaseToGrid(lX), VectorCache.databaseToGrid(lY), VectorCache.databaseToGrid(hX), VectorCache.databaseToGrid(hY));
                } else {
                    VectorManhattan vm = new VectorManhattan(origin, lX, lY, hX, hY, layer, graphicsOverride, pureLayer);
                    shapes.add(vm);
                }
                if (layer != null && (fun = layer.getFunction()).isSubstrate()) {
                    minSize = 0.0f;
                }
                vc.maxFeatureSize = Math.max(vc.maxFeatureSize, minSize);
                return;
            }
            VectorPolygon vp = new VectorPolygon(origin, points, layer, graphicsOverride);
            shapes.add(vp);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            VectorLine vl1 = new VectorLine(origin, ((Point2D)points[0]).getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphicsOverride);
            VectorLine vl2 = new VectorLine(origin, points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), 0, layer, graphicsOverride);
            VectorLine vl3 = new VectorLine(origin, points[2].getX(), points[2].getY(), points[3].getX(), points[3].getY(), 0, layer, graphicsOverride);
            VectorLine vl4 = new VectorLine(origin, points[3].getX(), points[3].getY(), points[0].getX(), points[0].getY(), 0, layer, graphicsOverride);
            VectorLine vl5 = new VectorLine(origin, points[0].getX(), points[0].getY(), points[2].getX(), points[2].getY(), 0, layer, graphicsOverride);
            VectorLine vl6 = new VectorLine(origin, points[1].getX(), points[1].getY(), points[3].getX(), points[3].getY(), 0, layer, graphicsOverride);
            shapes.add(vl1);
            shapes.add(vl2);
            shapes.add(vl3);
            shapes.add(vl4);
            shapes.add(vl5);
            shapes.add(vl6);
            return;
        }
        if (style.isText()) {
            FixpRectangle bounds = poly.getBounds2D();
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            assert (graphicsOverride == null);
            DisplayedText dt = poly.getDisplayedText();
            boolean tempName = tempOwnerName && dt != null && (dt.getVariableKey() == NodeInst.NODE_NAME || dt.getVariableKey() == ArcInst.ARC_NAME);
            VectorText vt = new VectorText(origin, bounds, style, descript, str, textType, null, layer, tempName);
            shapes.add(vt);
            vc.maxFeatureSize = Math.max(vc.maxFeatureSize, vt.height);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j2 = 1; j2 < points.length; ++j2) {
                Point2D oldPt = points[j2 - 1];
                Point2D newPt = points[j2];
                VectorLine vl = new VectorLine(origin, oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphicsOverride);
                shapes.add(vl);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                Point2D newPt = points[0];
                VectorLine vl = new VectorLine(origin, oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphicsOverride);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j3 = 0; j3 < points.length; j3 += 2) {
                Point2D oldPt = points[j3];
                Point2D newPt = points[j3 + 1];
                VectorLine vl = new VectorLine(origin, oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), 0, layer, graphicsOverride);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            VectorCircle vci = new VectorCircle(origin, points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphicsOverride);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            VectorCircle vci = new VectorCircle(origin, points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 1, layer, graphicsOverride);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.DISC) {
            VectorCircle vci = new VectorCircle(origin, points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 2, layer, graphicsOverride);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            int endAngle;
            int startAngle = GenMath.figureAngle(points[0], points[1]);
            if (startAngle < (endAngle = GenMath.figureAngle(points[0], points[2]))) {
                startAngle += 3600;
            }
            boolean bigArc = startAngle - endAngle > 1800;
            VectorCircleArc vca = new VectorCircleArc(origin, points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), style == Poly.Type.THICKCIRCLEARC, bigArc, layer, graphicsOverride);
            shapes.add(vca);
            return;
        }
        if (style == Poly.Type.CROSS) {
            VectorCross vcr = new VectorCross(origin, points[0].getX(), points[0].getY(), true, layer, graphicsOverride);
            shapes.add(vcr);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            VectorCross vcr = new VectorCross(origin, points[0].getX(), points[0].getY(), false, layer, graphicsOverride);
            shapes.add(vcr);
            return;
        }
    }

    private static void putBox(ImmutableElectricObject origin, int layerIndex, ArrayList<List<VectorManhattanBox>> boxBuilders, long lX, long lY, long hX, long hY) {
        while (layerIndex >= boxBuilders.size()) {
            boxBuilders.add(new ArrayList());
        }
        List<VectorManhattanBox> b2 = boxBuilders.get(layerIndex);
        b2.add(new VectorManhattanBox(origin, lX, lY, hX, hY));
    }

    class VectorCellDef {
        private CellId cellId;
        private ERectangle bounds;
        private float cellArea;
        private float cellMinSize;
        private TechId techId;
        private boolean isParameterized;
        private Map<Orientation, VectorCell> orientations;
        private List<VectorCellExport> exports;

        VectorCellDef(CellId cellId) {
            this.cellId = cellId;
            this.orientations = new HashMap<Orientation, VectorCell>();
            this.updateBounds(VectorCache.this.database.backup());
            CellBackup cellBackup = VectorCache.this.database.backup().getCell(cellId);
            if (cellBackup != null) {
                this.techId = cellBackup.cellRevision.d.techId;
                this.isParameterized = VectorCache.isCellParameterized(cellBackup.cellRevision);
            }
            this.clear();
            this.updateExports();
        }

        public CellId getCellId() {
            return this.cellId;
        }

        public ERectangle getBounds() {
            return this.bounds;
        }

        public float getArea() {
            return this.cellArea;
        }

        public float getMinimumSize() {
            return this.cellMinSize;
        }

        public List<VectorCellExport> getPortShapes() {
            if (this.exports == null) {
                this.updateExports();
            }
            return this.exports;
        }

        public VectorCell getAnyCell() {
            for (VectorCell vc : this.orientations.values()) {
                if (vc.validStep != VectorCache.this.updateStep) continue;
                return vc;
            }
            return null;
        }

        private boolean updateBounds(Snapshot snapshot) {
            ERectangle newBounds;
            this.bounds = newBounds = snapshot.getCellBounds(this.cellId);
            if (this.bounds != null) {
                this.cellArea = (float)(this.bounds.getWidth() * this.bounds.getHeight());
                this.cellMinSize = (float)Math.min(this.bounds.getWidth(), this.bounds.getHeight());
            } else {
                this.cellArea = 0.0f;
                this.cellMinSize = 0.0f;
            }
            for (VectorCell vc : this.orientations.values()) {
                vc.updateBounds();
            }
            return true;
        }

        private void updateExports() {
            for (VectorCell vc : this.orientations.values()) {
                vc.clearExports();
            }
            Cell cell = VectorCache.getCellFromId(this.cellId);
            if (cell == null) {
                this.exports = null;
                return;
            }
            this.exports = new ArrayList<VectorCellExport>();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e2 = it.next();
                VectorCellExport vce = new VectorCellExport(e2);
                this.exports.add(vce);
            }
        }

        private void updateVariables() {
            for (VectorCell vc : this.orientations.values()) {
                vc.updateVariables();
            }
        }

        private void clear() {
            for (VectorCell vc : this.orientations.values()) {
                vc.clear();
            }
            this.exports = null;
        }
    }

    private class ShapeBuilder
    extends AbstractShapeBuilder {
        private VectorCell vc;
        private boolean hideOnLowLevel;
        private int textType;
        private boolean pureLayer;

        private ShapeBuilder() {
        }

        @Override
        public void addPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            switch (style) {
                case OPENED: {
                    this.addLine(numPoints, 0, layer, graphicsOverride);
                    break;
                }
                case OPENEDT1: {
                    this.addLine(numPoints, 1, layer, graphicsOverride);
                    break;
                }
                case OPENEDT2: {
                    this.addLine(numPoints, 2, layer, graphicsOverride);
                    break;
                }
                case OPENEDT3: {
                    this.addLine(numPoints, 3, layer, graphicsOverride);
                    break;
                }
                default: {
                    PolyBase.Point[] points = new PolyBase.Point[numPoints];
                    for (int i2 = 0; i2 < numPoints; ++i2) {
                        points[i2] = Poly.fromFixp(this.coords[i2 * 2], this.coords[i2 * 2 + 1]);
                    }
                    Poly poly = new Poly(points);
                    poly.setStyle(style);
                    poly.setLayer(layer);
                    poly.setGraphicsOverride(graphicsOverride);
                    VectorCache.this.renderPoly(this.getCurObj(), poly, this.vc, this.hideOnLowLevel, this.textType, this.pureLayer, false);
                }
            }
        }

        @Override
        public void addTextPoly(int numPoints, Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
            PolyBase.Point[] points = new PolyBase.Point[numPoints];
            for (int i2 = 0; i2 < numPoints; ++i2) {
                points[i2] = Poly.fromFixp(this.coords[i2 * 2], this.coords[i2 * 2 + 1]);
            }
            Poly poly = new Poly(points);
            poly.setStyle(style);
            poly.setLayer(layer);
            poly.setString(message);
            poly.setTextDescriptor(descriptor);
            VectorCache.this.renderPoly(this.getCurObj(), poly, this.vc, this.hideOnLowLevel, this.textType, this.pureLayer, false);
        }

        private void addLine(int numPoints, int lineType, Layer layer, EGraphics graphicsOverride) {
            List<VectorBase> shapes = this.hideOnLowLevel ? this.vc.topOnlyShapes : this.vc.getShapeList(layer);
            int x1 = (int)(this.coords[0] >> 20);
            int y1 = (int)(this.coords[1] >> 20);
            for (int i2 = 1; i2 < numPoints; ++i2) {
                int x2 = (int)(this.coords[i2 * 2] >> 20);
                int y2 = (int)(this.coords[i2 * 2 + 1] >> 20);
                VectorLine vl = new VectorLine(this.getCurObj(), x1, y1, x2, y2, lineType, layer, graphicsOverride);
                shapes.add(vl);
                x1 = x2;
                y1 = y2;
            }
        }

        @Override
        public void addBox(Layer layer) {
            Layer.Function fun;
            List<VectorBase> shapes = this.hideOnLowLevel ? this.vc.topOnlyShapes : this.vc.getShapeList(layer);
            long lX = (int)(this.coords[0] >> 20);
            long lY = (int)(this.coords[1] >> 20);
            long hX = (int)(this.coords[2] >> 20);
            long hY = (int)(this.coords[3] >> 20);
            int layerIndex = -1;
            if (this.vc.vcd != null && layer.getId().techId == this.vc.vcd.techId) {
                layerIndex = layer.getIndex();
            }
            if (layerIndex >= 0) {
                VectorCache.putBox(this.getCurObj(), layerIndex, this.pureLayer ? VectorCache.this.pureBoxBuilders : VectorCache.this.boxBuilders, lX, lY, hX, hY);
            } else {
                shapes.add(new VectorManhattan(this.getCurObj(), new long[]{lX, lY, hX, hY}, layer, null, this.pureLayer));
            }
            float minSize = (float)DBMath.gridToLambda(Math.min(hX - lX, hY - lY));
            if (layer != null && (fun = layer.getFunction()).isSubstrate()) {
                minSize = 0.0f;
            }
            this.vc.maxFeatureSize = Math.max(this.vc.maxFeatureSize, minSize);
        }
    }

    class VectorCell {
        private final VectorCellDef vcd;
        private final Orientation orient;
        private long[] outlinePoints = new long[8];
        private long lX;
        private long lY;
        private long hX;
        private long hY;
        private int[] portCenters;
        private long validStep;
        private Map<Layer, List<VectorBase>> organizedShapes = new HashMap<Layer, List<VectorBase>>();
        private ArrayList<VectorBase> topOnlyShapes;
        private ArrayList<VectorSubCell> subCells = new ArrayList();
        private RTNode<VectorSubCell> subCellTree = null;
        private boolean hasFadeColor;
        private int fadeColor;
        private float maxFeatureSize;
        private boolean fadeImage;
        private int fadeOffsetX;
        private int fadeOffsetY;
        private int[] fadeImageColors;
        private int fadeImageWid;
        private int fadeImageHei;

        VectorCell(VectorCellDef vcd, Orientation orient) {
            this.vcd = vcd;
            this.orient = orient;
            this.subCellTree = RTNode.makeTopLevel();
            this.updateBounds();
        }

        private VectorCell() {
            this.vcd = null;
            this.orient = null;
            this.topOnlyShapes = new ArrayList();
        }

        public VectorCellDef getCellDef() {
            return this.vcd;
        }

        public Orientation getOrientation() {
            return this.orient;
        }

        public RTNode<VectorSubCell> getSubCellTree() {
            return this.subCellTree;
        }

        public List<VectorSubCell> getSubCells() {
            return this.subCells;
        }

        public void setFadeOffset(int oX, int oY) {
            this.fadeOffsetX = oX;
            this.fadeOffsetY = oY;
        }

        public int getFadeOffsetX() {
            return this.fadeOffsetX;
        }

        public int getFadeOffsetY() {
            return this.fadeOffsetY;
        }

        public boolean isFadeImage() {
            return this.fadeImage;
        }

        public void setFadeImage(boolean f2) {
            this.fadeImage = f2;
        }

        public void setFadeImageSize(int wid, int hei) {
            this.fadeImageWid = wid;
            this.fadeImageHei = hei;
        }

        public int getFadeImageWidth() {
            return this.fadeImageWid;
        }

        public int getFadeImageHeight() {
            return this.fadeImageHei;
        }

        public void setFadeColors(int[] colors) {
            this.fadeImageColors = colors;
        }

        public int[] getFadeColors() {
            return this.fadeImageColors;
        }

        public void setFadeColor(int color) {
            this.fadeColor = color;
        }

        public int getFadeColor() {
            return this.fadeColor;
        }

        public void setHasFadeColor(boolean h2) {
            this.hasFadeColor = h2;
        }

        public boolean hasFadeColor() {
            return this.hasFadeColor;
        }

        public long getLX() {
            return this.lX;
        }

        public long getHX() {
            return this.hX;
        }

        public long getLY() {
            return this.lY;
        }

        public long getHY() {
            return this.hY;
        }

        public long[] getOutlinePoints() {
            return this.outlinePoints;
        }

        public float getMaxFeatureSize() {
            return this.maxFeatureSize;
        }

        public List<Layer> getKnownLayers() {
            ArrayList<Layer> knownLayers = new ArrayList<Layer>();
            for (Layer lay : this.organizedShapes.keySet()) {
                knownLayers.add(lay);
            }
            Layer.getLayersSortedByRule(knownLayers, Layer.LayerSortingType.ByFunctionLevel);
            return knownLayers;
        }

        public List<VectorBase> getShapes(Layer layer) {
            return this.organizedShapes.get(layer);
        }

        private void buildCache(Cell cell) {
            List<VectorLine> addTheseInsts;
            NodeInst ni;
            this.updateBounds();
            this.clear();
            this.maxFeatureSize = 0.0f;
            FixpTransform trans = this.orient.pureRotate();
            for (List<VectorManhattanBox> b2 : VectorCache.this.boxBuilders) {
                b2.clear();
            }
            for (List<VectorManhattanBox> b2 : VectorCache.this.pureBoxBuilders) {
                b2.clear();
            }
            VectorCache.this.shapeBuilder.setup(cell.backup(), this.orient, false, true, false, null);
            VectorCache.this.shapeBuilder.vc = this;
            VectorCache.this.shapeBuilder.hideOnLowLevel = false;
            VectorCache.this.shapeBuilder.textType = 4;
            Iterator<ArcInst> arcs = cell.getArcs();
            while (arcs.hasNext()) {
                ArcInst ai = arcs.next();
                VectorCache.this.drawArc(ai, trans, this);
            }
            Iterator<NodeInst> nodes = cell.getNodes();
            while (nodes.hasNext()) {
                boolean hideOnLowLevel;
                ni = nodes.next();
                if (ni.isCellInstance() || (hideOnLowLevel = ni.isVisInside() || Generic.isCellCenter(ni))) continue;
                VectorCache.this.drawPrimitiveNode(ni, trans, this);
            }
            nodes = cell.getNodes();
            while (nodes.hasNext()) {
                ni = nodes.next();
                if (!ni.isCellInstance()) continue;
                VectorCache.this.drawSubcell(ni, trans, this);
            }
            CellId cellId = cell.getId();
            List<VectorBase> addThesePolys = VectorCache.this.addPolyToCell.get(cellId);
            if (addThesePolys != null) {
                for (VectorBase vb : addThesePolys) {
                    this.addShape(vb);
                }
            }
            if ((addTheseInsts = VectorCache.this.addInstToCell.get(cellId)) != null) {
                for (VectorLine vl : addTheseInsts) {
                    this.addShape(vl);
                }
            }
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.boxBuilders, false);
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.pureBoxBuilders, true);
            if (cell.isIcon()) {
                this.maxFeatureSize = 0.0f;
            }
            this.validStep = VectorCache.this.updateStep;
        }

        private void addShape(VectorBase vb) {
            List<VectorBase> vbList;
            Layer layer = vb.getLayer();
            if (layer == null) {
                layer = Generic.tech().glyphLay;
            }
            if ((vbList = this.organizedShapes.get(layer)) == null) {
                vbList = new ArrayList<VectorBase>();
                this.organizedShapes.put(layer, vbList);
            }
            vbList.add(vb);
        }

        private List<VectorBase> getShapeList(Layer layer) {
            List<VectorBase> shapes;
            if (layer == null) {
                layer = Generic.tech().glyphLay;
            }
            if ((shapes = this.organizedShapes.get(layer)) == null) {
                shapes = new ArrayList<VectorBase>();
                this.organizedShapes.put(layer, shapes);
            }
            return shapes;
        }

        private void updateBounds() {
            this.lY = Integer.MAX_VALUE;
            this.lX = Integer.MAX_VALUE;
            this.hY = Integer.MIN_VALUE;
            this.hX = Integer.MIN_VALUE;
            ERectangle bounds = this.vcd.bounds;
            if (bounds == null) {
                return;
            }
            double[] points = new double[8];
            points[0] = points[6] = bounds.getMinX();
            points[1] = points[3] = bounds.getMinY();
            points[2] = points[4] = bounds.getMaxX();
            points[5] = points[7] = bounds.getMaxY();
            this.orient.pureRotate().transform(points, 0, points, 0, 4);
            for (int i2 = 0; i2 < 4; ++i2) {
                long x = VectorCache.databaseToGrid(points[i2 * 2]);
                long y = VectorCache.databaseToGrid(points[i2 * 2 + 1]);
                this.lX = Math.min(this.lX, x);
                this.lY = Math.min(this.lY, y);
                this.hX = Math.max(this.hX, x);
                this.hY = Math.max(this.hY, y);
                this.outlinePoints[i2 * 2] = x;
                this.outlinePoints[i2 * 2 + 1] = y;
            }
        }

        private void clear() {
            this.clearExports();
            this.fadeImage = false;
            this.hasFadeColor = false;
            this.organizedShapes.clear();
            this.subCellTree = null;
            this.subCellTree = RTNode.makeTopLevel();
            this.fadeImageColors = null;
        }

        private void addExport(Export e2, FixpTransform trans) {
            Poly poly = e2.getNamePoly();
            Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
            TextDescriptor descript = poly.getTextDescriptor();
            Poly.Type style = descript.getPos().getPolyType();
            style = Poly.rotateType(style, e2);
            VectorText vt = new VectorText(e2.getOriginalPort().getNodeInst().getD(), poly.getBounds2D(), style, descript, e2.getName(), 2, e2, null, false);
            this.topOnlyShapes.add(vt);
            Poly[] polys = e2.getDisplayableVariables(rect, VectorCache.this.dummyWnd, true, true);
            VectorCache.this.drawTextPolys(e2.getOriginalPort().getNodeInst().getD(), polys, trans, this, true, 2, false, false);
        }

        private void clearExports() {
            this.portCenters = null;
        }

        private void updateVariables() {
            Cell cell = VectorCache.getCellFromId(this.vcd.cellId);
            if (cell == null) {
                return;
            }
            if (this.topOnlyShapes != null) {
                for (int i2 = 0; i2 < this.topOnlyShapes.size(); ++i2) {
                    VectorBase vb = this.topOnlyShapes.get(i2);
                    if (!(vb.origin instanceof ImmutableCell)) continue;
                    int lastIndex = this.topOnlyShapes.size() - 1;
                    if (i2 < lastIndex) {
                        this.topOnlyShapes.set(i2, this.topOnlyShapes.get(lastIndex));
                        --i2;
                    }
                    this.topOnlyShapes.remove(lastIndex);
                }
            }
            Poly[] polys = cell.getDisplayableVariables(VectorCache.this.CENTERRECT, VectorCache.this.dummyWnd, true, true);
            VectorCache.this.drawTextPolys(cell.getD(), polys, DBMath.MATID, this, true, 1, false, false);
        }

        public int[] getPortCenters() {
            if (this.portCenters == null) {
                this.initPortCenters();
            }
            return this.portCenters;
        }

        private void initPortCenters() {
            List<VectorCellExport> portShapes = this.vcd.getPortShapes();
            this.portCenters = new int[portShapes.size() * 2];
            FixpTransform trans = this.orient.pureRotate();
            PolyBase.Point tmpPt = Poly.fromFixp(0L, 0L);
            int numPorts = portShapes.size();
            for (int i2 = 0; i2 < numPorts; ++i2) {
                VectorCellExport vce = portShapes.get(i2);
                trans.transform(vce.exportCtr, tmpPt);
                this.portCenters[i2 * 2] = (int)(tmpPt.getFixpX() >> 20);
                this.portCenters[i2 * 2 + 1] = (int)(tmpPt.getFixpY() >> 20);
            }
        }

        public ArrayList<VectorBase> getTopOnlyShapes() {
            if (this.topOnlyShapes == null) {
                this.buildTopOnlyShapes();
            }
            return this.topOnlyShapes;
        }

        private void buildTopOnlyShapes() {
            this.topOnlyShapes = new ArrayList();
            Cell cell = VectorCache.getCellFromId(this.vcd.cellId);
            if (cell == null) {
                return;
            }
            Poly[] polys = cell.getDisplayableVariables(VectorCache.this.CENTERRECT, VectorCache.this.dummyWnd, true, true);
            VectorCache.this.drawTextPolys(cell.getD(), polys, DBMath.MATID, this, true, 1, false, false);
            FixpTransform trans = this.orient.pureRotate();
            VectorCache.this.shapeBuilder.setup(cell.backup(), this.orient, false, true, false, null);
            VectorCache.this.shapeBuilder.vc = this;
            VectorCache.this.shapeBuilder.hideOnLowLevel = false;
            VectorCache.this.shapeBuilder.textType = 4;
            Iterator<NodeInst> nodes = cell.getNodes();
            while (nodes.hasNext()) {
                boolean hideOnLowLevel;
                NodeInst ni = nodes.next();
                if (ni.isCellInstance() || !(hideOnLowLevel = ni.isVisInside() || Generic.isCellCenter(ni))) continue;
                VectorCache.this.drawPrimitiveNode(ni, trans, this);
            }
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e2 = it.next();
                this.addExport(e2, trans);
            }
            Collections.sort(this.topOnlyShapes, shapeByLayer);
        }
    }

    public static abstract class VectorBase {
        private Layer layer;
        private EGraphics graphicsOverride;
        private ImmutableElectricObject origin;

        VectorBase(ImmutableElectricObject origin, Layer layer, EGraphics graphicsOverride) {
            this.origin = origin;
            this.layer = layer;
            this.graphicsOverride = graphicsOverride;
        }

        boolean isFilled() {
            return false;
        }

        public EGraphics getGraphics() {
            return this.graphicsOverride;
        }

        public Layer getLayer() {
            return this.layer;
        }
    }

    static class VectorText
    extends VectorBase {
        public static final int TEXTTYPECELL = 1;
        public static final int TEXTTYPEEXPORT = 2;
        public static final int TEXTTYPENODE = 3;
        public static final int TEXTTYPEARC = 4;
        public static final int TEXTTYPEANNOTATION = 5;
        public static final int TEXTTYPEINSTANCE = 6;
        private long cX;
        private long cY;
        private long wid;
        private long hei;
        private Poly.Type style;
        private TextDescriptor descript;
        private String str;
        private float height;
        private int textType;
        private PrimitivePort basePort;
        private boolean tempName;

        VectorText(ImmutableElectricObject origin, Rectangle2D bounds, Poly.Type style, TextDescriptor descript, String str, int textType, Export e2, Layer layer, boolean tempName) {
            super(origin, layer, null);
            AbstractTextDescriptor.Size tds;
            this.cX = VectorCache.databaseToGrid(bounds.getX());
            this.cY = VectorCache.databaseToGrid(bounds.getY());
            this.wid = VectorCache.databaseToGrid(bounds.getWidth());
            this.hei = VectorCache.databaseToGrid(bounds.getHeight());
            this.style = style;
            this.descript = descript;
            this.str = str;
            this.textType = textType;
            if (e2 != null) {
                this.basePort = e2.getBasePort();
            }
            this.tempName = tempName;
            this.height = 1.0f;
            if (descript != null && !(tds = descript.getSize()).isAbsolute()) {
                this.height = (float)tds.getSize();
            }
        }

        public float getHeight() {
            return this.height;
        }

        public boolean isTempName() {
            return this.tempName;
        }

        public TextDescriptor getTextDescriptor() {
            return this.descript;
        }

        public int getTextType() {
            return this.textType;
        }

        public long getCX() {
            return this.cX;
        }

        public long getCY() {
            return this.cY;
        }

        public long getWid() {
            return this.wid;
        }

        public long getHei() {
            return this.hei;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public PrimitivePort getBasePort() {
            return this.basePort;
        }

        public String getString() {
            return this.str;
        }

        public String toString() {
            return "VectorText(" + this.cX + "<=X<=" + (this.cX + this.wid) + " and" + this.cY + "<=Y<=" + (this.cY + this.hei) + "): " + this.str;
        }
    }

    static class VectorManhattan
    extends VectorBase {
        private long[] coords;
        private boolean pureLayer;

        VectorManhattan(ImmutableElectricObject origin, double c1X, double c1Y, double c2X, double c2Y, Layer layer, EGraphics graphicsOverride, boolean pureLayer) {
            this(origin, new long[]{VectorCache.databaseToGrid(c1X), VectorCache.databaseToGrid(c1Y), VectorCache.databaseToGrid(c2X), VectorCache.databaseToGrid(c2Y)}, layer, graphicsOverride, pureLayer);
        }

        VectorManhattan(ImmutableElectricObject origin, long c1X, long c1Y, long c2X, long c2Y, Layer layer, EGraphics graphicsOverride, boolean pureLayer) {
            this(origin, new long[]{c1X, c1Y, c2X, c2Y}, layer, graphicsOverride, pureLayer);
        }

        private VectorManhattan(ImmutableElectricObject origin, long[] coords, Layer layer, EGraphics graphicsOverride, boolean pureLayer) {
            super(origin, layer, graphicsOverride);
            this.coords = coords;
            this.pureLayer = pureLayer;
        }

        public long[] getCoords() {
            return this.coords;
        }

        public boolean isPureLayer() {
            return this.pureLayer;
        }

        @Override
        boolean isFilled() {
            return true;
        }

        public String toString() {
            Object msg = "VectorManhattan";
            if (this.pureLayer) {
                msg = (String)msg + "Pure";
            }
            msg = (String)msg + " " + this.getLayer().getName();
            for (int i2 = 0; i2 < this.coords.length; i2 += 4) {
                msg = (String)msg + " (" + this.coords[i2] + "<=X<=" + this.coords[i2 + 2] + " and " + this.coords[i2 + 1] + "<=Y<=" + this.coords[i2 + 3] + ")";
            }
            return msg;
        }
    }

    static class VectorLine
    extends VectorBase {
        private long fX;
        private long fY;
        private long tX;
        private long tY;
        private int texture;

        VectorLine(ImmutableElectricObject origin, long fX, long fY, long tX, long tY, int texture, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.fX = fX;
            this.fY = fY;
            this.tX = tX;
            this.tY = tY;
            this.texture = texture;
        }

        VectorLine(ImmutableElectricObject origin, double fX, double fY, double tX, double tY, int texture, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.fX = VectorCache.databaseToGrid(fX);
            this.fY = VectorCache.databaseToGrid(fY);
            this.tX = VectorCache.databaseToGrid(tX);
            this.tY = VectorCache.databaseToGrid(tY);
            this.texture = texture;
        }

        public long getFromX() {
            return this.fX;
        }

        public long getFromY() {
            return this.fY;
        }

        public long getToX() {
            return this.tX;
        }

        public long getToY() {
            return this.tY;
        }

        public int getTexture() {
            return this.texture;
        }

        public String toString() {
            return "VectorLine(" + this.fX + "," + this.fY + ")-to-(" + this.tX + "," + this.tY + ")";
        }
    }

    static class VectorSubCell
    implements RTBounds {
        private ImmutableNodeInst n;
        private CellId subCellId;
        private long offsetX;
        private long offsetY;
        private AbstractFixpRectangle bounds;
        private BitSet shownPorts = new BitSet();

        VectorSubCell(NodeInst ni, Point2D offset) {
            this.n = ni.getD();
            Cell subCell = (Cell)ni.getProto();
            this.subCellId = subCell.getId();
            this.offsetX = VectorCache.databaseToGrid(offset.getX());
            this.offsetY = VectorCache.databaseToGrid(offset.getY());
            this.bounds = ni.getBounds();
        }

        public long getOffsetX() {
            return this.offsetX;
        }

        public long getOffsetY() {
            return this.offsetY;
        }

        public CellId getCellId() {
            return this.subCellId;
        }

        @Override
        public AbstractFixpRectangle getBounds() {
            return this.bounds;
        }

        public boolean isPortShown(int index) {
            return this.shownPorts.get(index);
        }

        public ImmutableNodeInst getNode() {
            return this.n;
        }
    }

    static class VectorManhattanBox {
        private ImmutableElectricObject origin;
        private long lX;
        private long lY;
        private long hX;
        private long hY;

        public VectorManhattanBox(ImmutableElectricObject origin, long lX, long lY, long hX, long hY) {
            this.origin = origin;
            this.lX = lX;
            this.lY = lY;
            this.hX = hX;
            this.hY = hY;
        }
    }

    static class VectorPolygon
    extends VectorBase {
        private EPoint[] points;

        VectorPolygon(ImmutableElectricObject origin, Point2D[] points, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.points = new EPoint[points.length];
            for (int i2 = 0; i2 < points.length; ++i2) {
                Point2D p = points[i2];
                this.points[i2] = EPoint.fromGrid(VectorCache.databaseToGrid(p.getX()), VectorCache.databaseToGrid(p.getY()));
            }
        }

        public EPoint[] getPoints() {
            return this.points;
        }

        @Override
        boolean isFilled() {
            return true;
        }
    }

    static class VectorCircle
    extends VectorBase {
        private long cX;
        private long cY;
        private long eX;
        private long eY;
        private int nature;

        VectorCircle(ImmutableElectricObject origin, double cX, double cY, double eX, double eY, int nature, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX = VectorCache.databaseToGrid(eX);
            this.eY = VectorCache.databaseToGrid(eY);
            this.nature = nature;
        }

        public long getCenterX() {
            return this.cX;
        }

        public long getCenterY() {
            return this.cY;
        }

        public long getEdgeX() {
            return this.eX;
        }

        public long getEdgeY() {
            return this.eY;
        }

        public int getNature() {
            return this.nature;
        }

        @Override
        boolean isFilled() {
            return this.nature == 2;
        }
    }

    static class VectorCircleArc
    extends VectorBase {
        private long cX;
        private long cY;
        private long eX1;
        private long eY1;
        private long eX2;
        private long eY2;
        private boolean thick;
        private boolean bigArc;

        VectorCircleArc(ImmutableElectricObject origin, double cX, double cY, double eX1, double eY1, double eX2, double eY2, boolean thick, boolean bigArc, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX1 = VectorCache.databaseToGrid(eX1);
            this.eY1 = VectorCache.databaseToGrid(eY1);
            this.eX2 = VectorCache.databaseToGrid(eX2);
            this.eY2 = VectorCache.databaseToGrid(eY2);
            this.thick = thick;
            this.bigArc = bigArc;
        }

        public long getCenterX() {
            return this.cX;
        }

        public long getCenterY() {
            return this.cY;
        }

        public long getEdge1X() {
            return this.eX1;
        }

        public long getEdge1Y() {
            return this.eY1;
        }

        public long getEdge2X() {
            return this.eX2;
        }

        public long getEdge2Y() {
            return this.eY2;
        }

        public boolean isThick() {
            return this.thick;
        }

        public boolean isBigArc() {
            return this.bigArc;
        }
    }

    static class VectorCross
    extends VectorBase {
        private long x;
        private long y;
        private boolean small;

        VectorCross(ImmutableElectricObject origin, double x, double y, boolean small, Layer layer, EGraphics graphicsOverride) {
            super(origin, layer, graphicsOverride);
            this.x = VectorCache.databaseToGrid(x);
            this.y = VectorCache.databaseToGrid(y);
            this.small = small;
        }

        public long getCenterX() {
            return this.x;
        }

        public long getCenterY() {
            return this.y;
        }

        public boolean isSmall() {
            return this.small;
        }

        public String toString() {
            return "VectorCross " + this.getLayer().getName() + " (" + this.x + "," + this.y + ")";
        }
    }

    static class VectorCellExport {
        private PolyBase.Point exportCtr;
        private ImmutableExport e;
        private Poly.Type style;
        private TextDescriptor descript;
        private float height;
        private PrimitivePort basePort;

        VectorCellExport(Export e2) {
            this.e = e2.getD();
            this.descript = this.e.nameDescriptor;
            Poly portPoly = e2.getNamePoly();
            assert (portPoly.getPoints().length == 1);
            this.exportCtr = portPoly.getPoints()[0];
            this.style = Poly.Type.TEXTCENT;
            this.height = 1.0f;
            if (this.descript != null) {
                this.style = this.descript.getPos().getPolyType();
                AbstractTextDescriptor.Size tds = this.descript.getSize();
                if (!tds.isAbsolute()) {
                    this.height = (float)tds.getSize();
                }
            }
            this.e = e2.getD();
            this.basePort = e2.getBasePort();
        }

        public int getChronIndex() {
            return this.e.exportId.chronIndex;
        }

        public String getName(boolean shortName) {
            String name = this.e.name.toString();
            if (shortName) {
                int len = name.length();
                for (int i2 = 0; i2 < len; ++i2) {
                    char ch = name.charAt(i2);
                    if (TextUtils.isLetterOrDigit(ch)) continue;
                    return name.substring(0, i2);
                }
            }
            return name;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public TextDescriptor getTextDescriptor() {
            return this.descript;
        }

        public float getHeight() {
            return this.height;
        }

        public PrimitivePort getBasePort() {
            return this.basePort;
        }
    }
}

