/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AbstractLayerDrawing {
    final Dimension sz;
    double scale;
    double originX;
    double originY;
    private double scale_;
    private float factorX;
    private float factorY;
    int clipLX;
    int clipHX;
    int clipLY;
    int clipHY;
    ERectangle drawLimitBounds;
    final Point tempPt1 = new Point();
    final Point tempPt2 = new Point();
    final Point tempPt3 = new Point();
    final Point tempPt4 = new Point();
    final FixpRectangle tempFixpRect = FixpRectangle.fromFixpDiagonal(0L, 0L, 0L, 0L);
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private ERaster arcRaster;
    private boolean arcThick;

    public AbstractLayerDrawing(Dimension sz) {
        this.sz = new Dimension(sz);
        this.setClip(null);
    }

    void initOrigin(double scale, int originX, int originY) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = originX;
        this.originY = originY;
        this.factorX = (float)((double)(-originX) / this.scale_);
        this.factorY = (float)((double)originY / this.scale_);
    }

    void initOrigin(double scale, Point2D offset) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = (double)(this.sz.width / 2) - offset.getX() * scale;
        this.originY = (double)(this.sz.height / 2) + offset.getY() * scale;
        this.factorX = (float)(offset.getX() * 400.0 - (double)(this.sz.width / 2) / this.scale_);
        this.factorY = (float)(offset.getY() * 400.0 + (double)(this.sz.height / 2) / this.scale_);
    }

    Rectangle setClip(ERectangle drawLimitBounds) {
        Rectangle renderBounds = null;
        ERectangle screenDb = ERectangle.fromLambda(-this.originX / this.scale, (this.originY - (double)this.sz.height) / this.scale, (double)this.sz.width / this.scale, (double)this.sz.height / this.scale);
        if (drawLimitBounds != null) {
            this.drawLimitBounds = (ERectangle)screenDb.createIntersection(drawLimitBounds);
            renderBounds = this.databaseToScreen(drawLimitBounds);
            this.setClip(Math.max(renderBounds.x, 0), Math.min(renderBounds.x + renderBounds.width, this.sz.width) - 1, Math.max(renderBounds.y, 0), Math.min(renderBounds.y + renderBounds.height, this.sz.height) - 1);
        } else {
            this.drawLimitBounds = screenDb;
            this.setClip(0, this.sz.width - 1, 0, this.sz.height - 1);
        }
        return renderBounds;
    }

    private void setClip(int clipLX, int clipHX, int clipLY, int clipHY) {
        this.clipLX = clipLX;
        this.clipHX = clipHX;
        this.clipLY = clipLY;
        this.clipHY = clipHY;
    }

    FixpRectangle getSearchBounds(long oX, long oY, Orientation orient) {
        long fpX = oX << 20;
        long fpY = oY << 20;
        this.tempFixpRect.setFixp(this.drawLimitBounds.getFixpMinX() - fpX, this.drawLimitBounds.getFixpMinY() - fpY, this.drawLimitBounds.getFixpMaxX() - fpX, this.drawLimitBounds.getFixpMaxY() - fpY);
        orient.inverse().rectangleBounds(this.tempFixpRect, EPoint.ORIGIN, this.tempFixpRect);
        return this.tempFixpRect;
    }

    public void drawBox(long gridLX, long gridLY, long gridHX, long gridHY, ERaster raster) {
        block26: {
            EGraphics.Outline o2;
            int lY;
            int hX;
            int hY;
            int lX;
            block25: {
                this.gridToScreen(gridLX, gridLY, this.tempPt1);
                this.gridToScreen(gridHX, gridHY, this.tempPt2);
                lX = this.tempPt1.x;
                hY = this.tempPt1.y;
                hX = this.tempPt2.x;
                lY = this.tempPt2.y;
                if (lX < this.clipLX) {
                    lX = this.clipLX;
                }
                if (hX > this.clipHX) {
                    hX = this.clipHX;
                }
                if (lY < this.clipLY) {
                    lY = this.clipLY;
                }
                if (hY > this.clipHY) {
                    hY = this.clipHY;
                }
                if (lX > hX || lY > hY) {
                    return;
                }
                o2 = raster.getOutline();
                if (lY == hY) {
                    if (lX == hX) {
                        if (o2 == null) {
                            raster.fillPoint(lX, lY);
                        } else {
                            raster.drawPoint(lX, lY);
                        }
                    } else if (o2 == null) {
                        raster.fillHorLine(lY, lX, hX);
                    } else {
                        raster.drawHorLine(lY, lX, hX);
                    }
                    return;
                }
                if (lX == hX) {
                    if (o2 == null) {
                        raster.fillVerLine(lX, lY, hY);
                    } else {
                        raster.drawVerLine(lX, lY, hY);
                    }
                    return;
                }
                raster.fillBox(lX, hX, lY, hY);
                if (o2 == null) {
                    return;
                }
                if (!o2.isSolidPattern()) break block25;
                raster.drawVerLine(lX, lY, hY);
                raster.drawHorLine(hY, lX, hX);
                raster.drawVerLine(hX, lY, hY);
                raster.drawHorLine(lY, lX, hX);
                if (o2.getThickness() == 1) break block26;
                for (int i2 = 1; i2 < o2.getThickness(); ++i2) {
                    if (lX + i2 <= this.clipHX) {
                        raster.drawVerLine(lX + i2, lY, hY);
                    }
                    if (hY - i2 >= this.clipLX) {
                        raster.drawHorLine(hY - i2, lX, hX);
                    }
                    if (hX - i2 >= this.clipLY) {
                        raster.drawVerLine(hX - i2, lY, hY);
                    }
                    if (lY + i2 > this.clipHY) continue;
                    raster.drawHorLine(lY + i2, lX, hX);
                }
                break block26;
            }
            int pattern = o2.getPattern();
            int len = o2.getLen();
            AbstractLayerDrawing.drawVerOutline(lX, lY, hY, pattern, len, raster);
            AbstractLayerDrawing.drawHorOutline(hY, lX, hX, pattern, len, raster);
            AbstractLayerDrawing.drawVerOutline(hX, lY, hY, pattern, len, raster);
            AbstractLayerDrawing.drawHorOutline(lY, lX, hX, pattern, len, raster);
            if (o2.getThickness() != 1) {
                for (int i3 = 1; i3 < o2.getThickness(); ++i3) {
                    if (lX + i3 <= this.clipHX) {
                        AbstractLayerDrawing.drawVerOutline(lX + i3, lY, hY, pattern, len, raster);
                    }
                    if (hY - i3 >= this.clipLX) {
                        AbstractLayerDrawing.drawHorOutline(hY - i3, lX, hX, pattern, len, raster);
                    }
                    if (hX - i3 >= this.clipLY) {
                        AbstractLayerDrawing.drawVerOutline(hX - i3, lY, hY, pattern, len, raster);
                    }
                    if (lY + i3 > this.clipHY) continue;
                    AbstractLayerDrawing.drawHorOutline(lY + i3, lX, hX, pattern, len, raster);
                }
            }
        }
    }

    private static void drawHorOutline(int y, int lX, int hX, int pattern, int len, ERaster raster) {
        int i2 = 0;
        for (int x = lX; x <= hX; ++x) {
            if ((pattern & 1 << i2) != 0) {
                raster.drawPoint(x, y);
            }
            if (++i2 != len) continue;
            i2 = 0;
        }
    }

    private static void drawVerOutline(int x, int lY, int hY, int pattern, int len, ERaster raster) {
        int i2 = 0;
        for (int y = lY; y <= hY; ++y) {
            if ((pattern & 1 << i2) != 0) {
                raster.drawPoint(x, y);
            }
            if (++i2 != len) continue;
            i2 = 0;
        }
    }

    public void drawLine(long gridX1, long gridY1, long gridX2, long gridY2, int texture, ERaster raster) {
        this.gridToScreen(gridX1, gridY1, this.tempPt1);
        this.gridToScreen(gridX2, gridY2, this.tempPt2);
        this.drawLine(this.tempPt1, this.tempPt2, texture, raster);
    }

    private void drawLine(Point pt1, Point pt2, int texture, ERaster raster) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 136, 8, raster);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 231, 8, raster);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
            }
        }
    }

    public void drawCross(long gridX, long gridY, int size, ERaster raster) {
        int hY;
        int lY;
        int hX;
        int lX;
        this.gridToScreen(gridX, gridY, this.tempPt1);
        int cX = this.tempPt1.x;
        int cY = this.tempPt1.y;
        if (this.clipLY <= cY && cY <= this.clipHY && (lX = Math.max(this.clipLX, cX - size)) <= (hX = Math.min(this.clipHX, cX + size))) {
            raster.drawHorLine(cY, lX, hX);
        }
        if (this.clipLX <= cX && cX <= this.clipHX && (lY = Math.max(this.clipLY, cY - size)) <= (hY = Math.min(this.clipHY, cY + size))) {
            raster.drawVerLine(cX, lY, hY);
        }
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d2 = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x, y);
            while (x < xend) {
                ++x;
                if (d2 < 0) {
                    d2 += incr1;
                } else {
                    y += yincr;
                    d2 += incr2;
                }
                raster.drawPoint(x, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d3 = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            raster.drawPoint(x, y);
            while (y < yend) {
                ++y;
                if (d3 < 0) {
                    d3 += incr1;
                } else {
                    x += xincr;
                    d3 += incr2;
                }
                raster.drawPoint(x, y);
            }
        }
    }

    private void drawOutline(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        this.tempPt3.x = x1;
        this.tempPt3.y = y1;
        this.tempPt4.x = x2;
        this.tempPt4.y = y2;
        if (GenMath.clipLine(this.tempPt3, this.tempPt4, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        this.drawPatLine(this.tempPt3.x, this.tempPt3.y, this.tempPt4.x, this.tempPt4.y, pattern, len, raster);
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        int dy;
        int i2 = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d2 = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x, y);
            while (x < xend) {
                ++x;
                if (d2 < 0) {
                    d2 += incr1;
                } else {
                    y += yincr;
                    d2 += incr2;
                }
                if (++i2 == len) {
                    i2 = 0;
                }
                if ((pattern & 1 << i2) == 0) continue;
                raster.drawPoint(x, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d3 = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            raster.drawPoint(x, y);
            while (y < yend) {
                ++y;
                if (d3 < 0) {
                    d3 += incr1;
                } else {
                    x += xincr;
                    d3 += incr2;
                }
                if (++i2 == len) {
                    i2 = 0;
                }
                if ((pattern & 1 << i2) == 0) continue;
                raster.drawPoint(x, y);
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d2 = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, raster);
            while (x < xend) {
                ++x;
                if (d2 < 0) {
                    d2 += incr1;
                } else {
                    y += yincr;
                    d2 += incr2;
                }
                this.drawThickPoint(x, y, raster);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d3 = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, raster);
            while (y < yend) {
                ++y;
                if (d3 < 0) {
                    d3 += incr1;
                } else {
                    x += xincr;
                    d3 += incr2;
                }
                this.drawThickPoint(x, y, raster);
            }
        }
    }

    void drawPolygon(long gridOX, long gridOY, EPoint[] gridPoints, ERaster raster) {
        int i2;
        Point[] intPoints = new Point[gridPoints.length];
        for (int i3 = 0; i3 < gridPoints.length; ++i3) {
            intPoints[i3] = new Point();
            this.gridToScreen(gridPoints[i3].getGridX() + gridOX, gridPoints[i3].getGridY() + gridOY, intPoints[i3]);
        }
        Point[] points = GenMath.clipPoly(intPoints, this.clipLX, this.clipHX, this.clipLY, this.clipHY);
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i2 = 0; i2 < points.length; ++i2) {
            polySegs[i2] = new PolySeg();
            if (i2 == 0) {
                polySegs[i2].fx = points[points.length - 1].x;
                polySegs[i2].fy = points[points.length - 1].y;
            } else {
                polySegs[i2].fx = points[i2 - 1].x;
                polySegs[i2].fy = points[i2 - 1].y;
            }
            polySegs[i2].tx = points[i2].x;
            polySegs[i2].ty = points[i2].y;
        }
        block2: for (i2 = 0; i2 < points.length; ++i2) {
            int j2 = polySegs[i2].ty - polySegs[i2].fy;
            polySegs[i2].direction = j2 > 0 ? 1 : (j2 < 0 ? -1 : 0);
            if (j2 == 0) {
                polySegs[i2].increment = 0;
            } else {
                polySegs[i2].increment = polySegs[i2].tx - polySegs[i2].fx;
                if (polySegs[i2].increment != 0) {
                    polySegs[i2].increment = (polySegs[i2].increment * 65536 - j2 + 1) / j2;
                }
            }
            polySegs[i2].tx <<= 16;
            polySegs[i2].fx <<= 16;
            if (polySegs[i2].fy > polySegs[i2].ty) {
                j2 = polySegs[i2].tx;
                polySegs[i2].tx = polySegs[i2].fx;
                polySegs[i2].fx = j2;
                j2 = polySegs[i2].ty;
                polySegs[i2].ty = polySegs[i2].fy;
                polySegs[i2].fy = j2;
            }
            if (edgelist == null) {
                edgelist = polySegs[i2];
                polySegs[i2].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i2].fy) {
                polySegs[i2].nextedge = edgelist;
                edgelist = polySegs[i2];
                continue;
            }
            PolySeg a2 = edgelist;
            while (a2 != null) {
                if (a2.nextedge == null || a2.nextedge.fy > polySegs[i2].fy) {
                    polySegs[i2].nextedge = a2.nextedge;
                    a2.nextedge = polySegs[i2];
                    continue block2;
                }
                a2 = a2.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block5: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a3 = active;
                while (a3 != null) {
                    if (a3.nextactive == null || a3.nextactive.fx > edgelist.fx || a3.nextactive.fx == edgelist.fx && a3.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a3.nextactive;
                        a3.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block5;
                    }
                    a3 = a3.nextactive;
                }
            }
            int wrap = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap += edge.direction) == 0) {
                    int j3 = left.fx + 32768 >> 16;
                    int k2 = edge.fx + 32768 >> 16;
                    raster.fillHorLine(ycur, j3, k2);
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
        EGraphics.Outline o2 = raster.getOutline();
        if (o2 == null) {
            return;
        }
        for (int i4 = 0; i4 < points.length; ++i4) {
            int last = i4 - 1;
            if (last < 0) {
                last = points.length - 1;
            }
            int fX = points[last].x;
            int fY = points[last].y;
            int tX = points[i4].x;
            int tY = points[i4].y;
            this.drawOutline(fX, fY, tX, tY, o2.getPattern(), o2.getLen(), raster);
            if (o2.getThickness() == 1) continue;
            int ang = GenMath.figureAngle(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY));
            double sin = DBMath.sin(ang + 900);
            double cos = DBMath.cos(ang + 900);
            for (int t = 1; t < o2.getThickness(); ++t) {
                int dX = (int)(cos * (double)t + 0.5);
                int dY = (int)(sin * (double)t + 0.5);
                this.drawOutline(fX + dX, fY + dY, tX + dX, tY + dY, o2.getPattern(), o2.getLen(), raster);
            }
        }
    }

    void drawCircle(long gridCenterX, long gridCenterY, long gridEdgeX, long gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawCircle(this.tempPt1, this.tempPt2, raster);
    }

    private void drawCircle(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d2 = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                raster.drawPoint(center.x + x, center.y + y);
                raster.drawPoint(center.x - x, center.y + y);
                raster.drawPoint(center.x + x, center.y - y);
                raster.drawPoint(center.x - x, center.y - y);
                raster.drawPoint(center.x + y, center.y + x);
                raster.drawPoint(center.x - y, center.y + x);
                raster.drawPoint(center.x + y, center.y - x);
                raster.drawPoint(center.x - y, center.y - x);
                if (d2 < 0) {
                    d2 += 4 * x + 6;
                    continue;
                }
                d2 += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if (d2 < 0) {
                    d2 += 4 * x + 6;
                } else {
                    d2 += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    void drawThickCircle(long gridCenterX, long gridCenterY, long gridEdgeX, long gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawThickCircle(this.tempPt1, this.tempPt2, raster);
    }

    private void drawThickCircle(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        int y = radius;
        int d2 = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if (d2 < 0) {
                d2 += 4 * x + 6;
                continue;
            }
            d2 += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, ERaster raster) {
        if (thisy < this.clipLY || thisy > this.clipHY) {
            return;
        }
        if (startx < this.clipLX) {
            startx = this.clipLX;
        }
        if (endx > this.clipHX) {
            endx = this.clipHX;
        }
        if (startx > endx) {
            return;
        }
        raster.fillHorLine(thisy, startx, endx);
    }

    void drawDisc(long gridCenterX, long gridCenterY, long gridEdgeX, long gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawDisc(this.tempPt1, this.tempPt2, raster);
    }

    public void drawOval(int gridCenterX, int gridCenterY, int pixelRadius, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.drawDisc(this.tempPt1, pixelRadius, raster);
    }

    private void drawDisc(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        EGraphics.Outline o2 = raster.getOutline();
        if (o2 != null) {
            this.drawCircle(center, edge, raster);
        }
        this.drawDisc(center, radius, raster);
    }

    private void drawDisc(Point center, int radius, ERaster raster) {
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    raster.drawPoint(x, y);
                }
            }
            return;
        }
        int y = radius;
        int d2 = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, raster);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, raster);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, raster);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, raster);
            if (d2 < 0) {
                d2 += 4 * x + 6;
                continue;
            }
            d2 += 4 * (x - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < this.clipLX || x > this.clipHX || y < this.clipLY || y > this.clipHY) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcRaster);
        } else {
            this.arcRaster.drawPoint(x, y);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d2 = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d2 < 0) {
                d2 += 4 * pt.x + 6;
            } else {
                d2 += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d2 = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d2 < 0) {
                d2 += 4 * pt.x + 6;
            } else {
                d2 += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d2 = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d2 > 0) {
                d2 += 6 - 4 * pt.x;
            } else {
                d2 += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d2 = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d2 > 0) {
                d2 += 6 - 4 * pt.x;
            } else {
                d2 += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    void drawCircleArc(long gridCenterX, long gridCenterY, long gridX1, long gridY1, long gridX2, long gridY2, boolean thick, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridX1, gridY1, this.tempPt2);
        this.gridToScreen(gridX2, gridY2, this.tempPt3);
        this.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, thick, raster);
    }

    private void drawCircleArc(Point center, Point p1, Point p2, boolean thick, ERaster raster) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcRaster = raster;
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff;
                }
            }
        }
        for (int i2 = 1; i2 < 9; ++i2) {
            this.arcOctTable[i2] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i3 = this.MODP(start_oct + 1);
                    while (i3 != end_oct) {
                        this.arcOctTable[i3] = true;
                        i3 = this.MODP(i3 + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    void drawThickPoint(int x, int y, ERaster raster) {
        raster.drawPoint(x, y);
        if (x > this.clipLX) {
            raster.drawPoint(x - 1, y);
        }
        if (x < this.clipHX) {
            raster.drawPoint(x + 1, y);
        }
        if (y > this.clipLY) {
            raster.drawPoint(x, y - 1);
        }
        if (y < this.sz.height - 1) {
            raster.drawPoint(x, y + 1);
        }
    }

    public void databaseToScreen(double dbX, double dbY, Point result) {
        double scrX = this.originX + dbX * this.scale;
        double scrY = this.originY - dbY * this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    void gridToScreen(long dbX, long dbY, Point result) {
        double scrX = (double)((float)dbX - this.factorX) * this.scale_;
        double scrY = (double)(this.factorY - (float)dbY) * this.scale_;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    void screenToGrid(int scrX, int scrY, Point result) {
        double dbX = (double)scrX / this.scale_ + (double)this.factorX;
        double dbY = (double)this.factorY - (double)scrY / this.scale_;
        result.x = (int)(dbX >= 0.0 ? dbX + 0.5 : dbX - 0.5);
        result.y = (int)(dbY >= 0.0 ? dbY + 0.5 : dbY - 0.5);
    }

    void screenToDatabase(int x, int y, Point2D result) {
        result.setLocation(((double)x - this.originX) / this.scale, (this.originY - (double)y) / this.scale);
    }

    Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.tempPt1;
        Point urPt = this.tempPt2;
        this.databaseToScreen(db.getMinX(), db.getMinY(), llPt);
        this.databaseToScreen(db.getMaxX(), db.getMaxY(), urPt);
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

