/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.LayerDrawing;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.redisplay.VectorDrawing;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class AbstractDrawing {
    public final EditWindow wnd;
    public WindowFrame.DisplayAttributes da;

    protected AbstractDrawing(EditWindow wnd) {
        this.wnd = wnd;
    }

    public static AbstractDrawing createDrawing(EditWindow wnd, AbstractDrawing drawing, Cell cell) {
        boolean isLayerDrawing = User.getDisplayAlgorithm() == 2 && cell != null && !cell.isIcon() && !cell.isSchematic() && cell.getTechnology().isLayout();
        drawing = isLayerDrawing ? new LayerDrawing.Drawing(wnd) : new PixelDrawing.Drawing(wnd);
        return drawing;
    }

    public abstract boolean paintComponent(Graphics2D var1, LayerVisibility var2, Dimension var3);

    public abstract void render(Dimension var1, WindowFrame.DisplayAttributes var2, GraphicsPreferences var3, DrawingPreferences var4, boolean var5, ERectangle var6);

    void setupEditWindowCoordinates(Dimension sz, WindowFrame.DisplayAttributes da) {
        this.wnd.setupCoordinates(sz, da);
    }

    public void abortRendering() {
    }

    public void opacityChanged() {
    }

    public boolean visibilityChanged() {
        return true;
    }

    public boolean hasOpacity() {
        return false;
    }

    public void testJogl() {
    }

    public static void clearSubCellCache(boolean layerAlso) {
        PixelDrawing.clearSubCellCache();
        if (layerAlso) {
            LayerDrawing.clearSubCellCache();
        }
    }

    public static void forceRedraw(Cell cell) {
        PixelDrawing.forceRedraw(cell);
        LayerDrawing.forceRedraw(cell);
    }

    public static void drawShapes(Graphics2D g2, GraphicsPreferences gp, int imgX, int imgY, double scale, VectorCache.VectorBase[] shapes, PixelDrawing offscreen, Rectangle entryRect) {
        if (User.getDisplayAlgorithm() < 2 || User.isLegacyComposite()) {
            PixelDrawing.gp = gp;
            offscreen.initDrawing(scale);
            VectorDrawing vd = new VectorDrawing(false);
            vd.render(offscreen, scale, EPoint.ORIGIN, shapes);
            Image img = offscreen.composite(null);
            g2.drawImage(img, imgX, imgY, null);
        } else {
            LayerDrawing.drawTechPalette(g2, gp, imgX, imgY, entryRect, scale, shapes);
        }
    }

    public static class DrawingPreferences {
        boolean gridAxesShown = User.isGridAxesShown();
        double gridXBoldFrequency = User.getDefGridXBoldFrequency();
        double gridYBoldFrequency = User.getDefGridYBoldFrequency();
        double globalTextScale = User.getGlobalTextScale();
        boolean highlightConnectedObjects = User.isHighlightConnectedObjects();
    }

    public static class LayerColor {
        public final Layer layer;
        public final float premultipliedRed;
        public final float premultipliedGreen;
        public final float premultipliedBlue;
        public final float inverseAlpha;

        public LayerColor(Layer layer, float premultipliedRed, float premultipliedGreen, float premultipliedBlue, float inverseAlpha) {
            this.layer = layer;
            this.premultipliedRed = premultipliedRed;
            this.premultipliedGreen = premultipliedGreen;
            this.premultipliedBlue = premultipliedBlue;
            this.inverseAlpha = inverseAlpha;
        }

        public LayerColor(Color color) {
            this.layer = null;
            float[] compArray = color.getRGBColorComponents(null);
            this.premultipliedRed = compArray[0];
            this.premultipliedGreen = compArray[1];
            this.premultipliedBlue = compArray[2];
            this.inverseAlpha = 0.0f;
        }
    }
}

