/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.projectSettings;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

class ProjSettingsNode
implements Serializable {
    private final String path;
    final LinkedHashMap<String, Object> data = new LinkedHashMap();

    ProjSettingsNode() {
        this.path = "";
    }

    private ProjSettingsNode(ProjSettingsNode parent, String key) {
        this.path = String.valueOf(parent) + key + ".";
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public ProjSettingsNode getNode(String key) {
        Object obj = this.data.get(key);
        if (obj == null) {
            obj = new ProjSettingsNode(this, key);
            this.data.put(key, obj);
        }
        if (obj instanceof ProjSettingsNode) {
            return (ProjSettingsNode)obj;
        }
        return null;
    }

    protected Object get(String key) {
        return this.data.get(key);
    }

    protected void put(String key, Object node) {
        this.data.put(key, node);
    }

    public boolean equals(Object node) {
        if (!(node instanceof ProjSettingsNode)) {
            return false;
        }
        ProjSettingsNode otherNode = (ProjSettingsNode)node;
        Set<String> myKeys = this.getKeys();
        Set<String> otherKeys = otherNode.getKeys();
        if (myKeys.size() != otherKeys.size()) {
            return false;
        }
        for (String myKey : myKeys) {
            if (!otherKeys.contains(myKey)) {
                return false;
            }
            Object myObj = this.get(myKey);
            Object otherObj = otherNode.get(myKey);
            if (myObj.getClass() != otherObj.getClass()) {
                return false;
            }
            if (myObj.equals(otherObj)) continue;
            return false;
        }
        return true;
    }

    public boolean printDifferences(Object node) {
        return this.printDifferences(node, new Stack<String>());
    }

    private boolean printDifferences(Object node, Stack<String> context) {
        if (!(node instanceof ProjSettingsNode)) {
            return true;
        }
        boolean differencesFound = false;
        ProjSettingsNode otherNode = (ProjSettingsNode)node;
        Set<String> myKeys = this.getKeys();
        Set<String> otherKeys = otherNode.getKeys();
        TreeSet<String> allKeys = new TreeSet<String>();
        allKeys.addAll(myKeys);
        allKeys.addAll(otherKeys);
        for (String key : allKeys) {
            if (!myKeys.contains(key)) {
                System.out.println("Warning: Key " + this.getKey(context, key) + " is missing from other settings");
                differencesFound = true;
                continue;
            }
            if (!otherKeys.contains(key)) {
                System.out.println("Warning: Key " + this.getKey(context, key) + " is missing from current settings");
                differencesFound = true;
                continue;
            }
            Object myObj = this.get(key);
            Object otherObj = otherNode.get(key);
            if (myObj.getClass() != otherObj.getClass()) {
                System.out.println("Warning: Value type mismatch for key " + this.getKey(context, key) + ": " + myObj.getClass().getName() + " vs " + otherObj.getClass().getName());
                differencesFound = true;
                continue;
            }
            if (myObj instanceof ProjSettingsNode) {
                context.push(key);
                if (((ProjSettingsNode)myObj).printDifferences(otherObj, context)) {
                    differencesFound = true;
                }
                context.pop();
                continue;
            }
            if (myObj.equals(otherObj)) continue;
            System.out.println("Warning: Values not equal for key " + this.getKey(context, key) + ": " + String.valueOf(myObj) + " vs " + String.valueOf(otherObj));
            differencesFound = true;
        }
        return differencesFound;
    }

    private String getKey(Stack<String> context, String key) {
        return ProjSettingsNode.describeContext(context) + "." + key;
    }

    public static String describeContext(Stack<String> context) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String name : context) {
            if (first) {
                first = false;
            } else {
                buf.append(".");
            }
            buf.append(name);
        }
        if (buf.length() == 0) {
            return "RootContext";
        }
        return buf.toString();
    }
}

