/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.PartReport;
import com.sun.electric.tool.ncc.result.SizeMismatch;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.HighlightTools;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class SizeMismatchPane
extends JPanel
implements HyperlinkListener,
AdjustmentListener {
    public static final int MAXROWS = 200;
    private static final Border border = BorderFactory.createEmptyBorder();
    private static final Insets insets = new Insets(0, 0, 0, 0);
    private static final int HALF_INF = 0x3FFFFFFF;
    private Dimension dimErrCol;
    private Dimension dimWidCol;
    private Dimension dimLenCol;
    private JScrollPane headScrPane;
    private Color bkgndColor;
    private Font font = new Font("Helvetica", 0, 12);
    private NccGuiInfo result;
    private SizeMismatch.Mismatch[] mismatches;
    private PartReport[][] parts;

    public SizeMismatchPane(NccGuiInfo res) {
        super(new BorderLayout());
        this.result = res;
        this.mismatches = this.result.getSizeMismatches().toArray(new SizeMismatch.Mismatch[0]);
        int size = Math.min(this.mismatches.length, 200);
        if (size == 0) {
            return;
        }
        this.parts = new PartReport[size][2];
        int errColWidth = 7;
        int widColWidth = 3;
        int lenColWidth = 3;
        for (int i2 = 0; i2 < size; ++i2) {
            String err = NccUtils.round(this.mismatches[i2].relErr() * 100.0, 1) + " %";
            errColWidth = Math.max(errColWidth, err.length());
            String rErr = "" + NccUtils.round(this.mismatches[i2].ratioErr(), 1);
            errColWidth = Math.max(errColWidth, rErr.length());
            String w1 = NccUtils.roundedString(this.mismatches[i2].minPart.getWidth());
            String w2 = NccUtils.roundedString(this.mismatches[i2].maxPart.getWidth());
            int wid = Math.max(w1.length(), w2.length());
            widColWidth = Math.max(widColWidth, wid + 1);
            String l1 = NccUtils.roundedString(this.mismatches[i2].minPart.getLength());
            String l2 = NccUtils.roundedString(this.mismatches[i2].maxPart.getLength());
            int len = Math.max(l1.length(), l2.length());
            lenColWidth = Math.max(lenColWidth, len + 1);
        }
        this.dimErrCol = new Dimension(errColWidth * 7, 40);
        this.dimWidCol = new Dimension(widColWidth * 7, 16);
        this.dimLenCol = new Dimension(lenColWidth * 7, 16);
        JSeparator sep = new JSeparator(0);
        Box topBox = new Box(1);
        topBox.setAlignmentY(0.0f);
        sep.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        int maxRowWid = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            JPanel row = this.createRow(i3);
            maxRowWid = Math.max(maxRowWid, row.getPreferredSize().width + 16);
            topBox.add(row);
            topBox.add(Box.createVerticalStrut(2));
            topBox.add(sep);
            topBox.add(Box.createVerticalStrut(2));
        }
        JScrollPane bodyScrPane = new JScrollPane(topBox);
        bodyScrPane.setBorder(border);
        bodyScrPane.setAlignmentX(0.0f);
        bodyScrPane.setAlignmentY(0.0f);
        bodyScrPane.getHorizontalScrollBar().addAdjustmentListener(this);
        JPanel header = this.createRow(-1);
        Dimension dim = header.getPreferredSize();
        dim.width = maxRowWid;
        header.setPreferredSize(dim);
        Box headBox = new Box(1);
        headBox.add(header);
        headBox.add(Box.createVerticalStrut(2));
        headBox.add(sep);
        headBox.add(Box.createVerticalStrut(2));
        this.headScrPane = new JScrollPane(headBox, 21, 31);
        this.headScrPane.setBorder(border);
        this.headScrPane.setAlignmentX(0.0f);
        this.headScrPane.setAlignmentY(0.0f);
        this.add((Component)this.headScrPane, "North");
        this.add((Component)bodyScrPane, "Center");
        this.setBorder(border);
        JScrollBar scrBar = bodyScrPane.getVerticalScrollBar();
        scrBar.invalidate();
        scrBar.validate();
        scrBar.setValue(scrBar.getMinimum());
    }

    private JPanel createRow(int rowNdx) {
        Object relErr;
        JPanel row = new JPanel(new BorderLayout());
        Object ratioErr = null;
        if (rowNdx < 0) {
            this.bkgndColor = row.getBackground();
            relErr = "Error percent";
            ratioErr = "Error ratio";
        } else {
            this.bkgndColor = Color.WHITE;
            row.setBackground(this.bkgndColor);
            int firstCellNdx = 0;
            if (this.result.isSwapCells()) {
                firstCellNdx = 1;
            }
            if (this.mismatches[rowNdx].minNdx == firstCellNdx) {
                this.parts[rowNdx][0] = this.mismatches[rowNdx].minPart;
                this.parts[rowNdx][1] = this.mismatches[rowNdx].maxPart;
            } else {
                this.parts[rowNdx][1] = this.mismatches[rowNdx].minPart;
                this.parts[rowNdx][0] = this.mismatches[rowNdx].maxPart;
            }
            relErr = this.mismatches[rowNdx].relErr() * 100.0 < 0.1 ? "< 0.01 %" : NccUtils.round(this.mismatches[rowNdx].relErr() * 100.0, 1) + " %";
            ratioErr = "" + NccUtils.round(this.mismatches[rowNdx].ratioErr(), 1);
        }
        Box errSubPanel = new Box(1);
        errSubPanel.setMinimumSize(this.dimErrCol);
        errSubPanel.setMaximumSize(this.dimErrCol);
        errSubPanel.setPreferredSize(this.dimErrCol);
        String[] edge = new String[]{relErr, ratioErr};
        for (int line = 0; line < 2; ++line) {
            JPanel subRow = this.createDoubleRow(edge[line], line);
            subRow.setBackground(this.bkgndColor);
            errSubPanel.add(subRow);
        }
        JPanel errPanel = new JPanel();
        errPanel.setLayout(new BoxLayout(errPanel, 0));
        errPanel.add(Box.createHorizontalStrut(4));
        errPanel.add(errSubPanel);
        errPanel.add(Box.createHorizontalStrut(4));
        errPanel.add(new JSeparator(1));
        errPanel.add(Box.createHorizontalStrut(2));
        errPanel.setBackground(this.bkgndColor);
        Box subRowsPanel = new Box(1);
        Dimension[] paramDims = new Dimension[]{this.dimWidCol, this.dimLenCol};
        String[] params = new String[2];
        for (int line = 0; line < 2; ++line) {
            Object name;
            if (rowNdx < 0) {
                params[0] = "Wid";
                params[1] = "Len";
                String[] titles = this.result.getNames();
                name = "Name in " + titles[line];
            } else {
                params[0] = NccUtils.roundedString(this.parts[rowNdx][line].getWidth());
                params[1] = NccUtils.roundedString(this.parts[rowNdx][line].getLength());
                name = this.parts[rowNdx][line].instanceDescription();
                if (this.parts[rowNdx][line] instanceof PartReport) {
                    PartReport pr = this.parts[rowNdx][line];
                    Nodable no = pr.pContext.getNodable();
                    if (no != null) {
                        name = (String)name + " (in subcell " + no.getNodeInst().getProto().describe(false) + ")";
                    }
                }
            }
            JPanel subRow = this.createSubRow(params, paramDims, (String)name, rowNdx, line);
            subRow.setBackground(this.bkgndColor);
            subRowsPanel.add(subRow);
        }
        row.add((Component)errPanel, "West");
        row.add((Component)subRowsPanel, "Center");
        Dimension dim = new Dimension(row.getPreferredSize());
        dim.width = 0x3FFFFFFF;
        row.setMaximumSize(dim);
        row.setAlignmentX(0.0f);
        row.setAlignmentY(0.0f);
        return row;
    }

    private JPanel createDoubleRow(String name, int lineNdx) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setBorder(border);
        panel.setBackground(this.bkgndColor);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.createNamePane(name, -1, lineNdx));
        return panel;
    }

    private JPanel createSubRow(String[] params, Dimension[] paramDims, String name, int rowNdx, int lineNdx) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setBorder(border);
        panel.setBackground(this.bkgndColor);
        for (int i2 = 0; i2 < 2; ++i2) {
            JLabel label = new JLabel(params[i2]);
            label.setHorizontalAlignment(11);
            label.setFont(this.font);
            if (rowNdx >= 0) {
                boolean red;
                boolean bl = red = i2 == 0 && this.mismatches[rowNdx] instanceof SizeMismatch.WidthMismatch || i2 == 1 && this.mismatches[rowNdx] instanceof SizeMismatch.LengthMismatch;
                if (red) {
                    label.setForeground(Color.RED);
                }
            }
            label.setBorder(border);
            label.setMinimumSize(paramDims[i2]);
            label.setMaximumSize(paramDims[i2]);
            label.setPreferredSize(paramDims[i2]);
            if (rowNdx >= 0) {
                label.setAlignmentY(1.0f);
                label.setVerticalAlignment(3);
                label.setVerticalTextPosition(3);
            }
            panel.add(label);
        }
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.createNamePane(name, rowNdx, lineNdx));
        return panel;
    }

    private JComponent createNamePane(String name, int rowNdx, int lineNdx) {
        int ind;
        StringBuffer text = new StringBuffer(128);
        String href = "<a style=\"text-decoration: none;\" href=\"";
        text.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
        if (rowNdx < 0) {
            JLabel label = new JLabel(name);
            label.setFont(this.font);
            label.setBorder(border);
            return label;
        }
        if (name.startsWith("Wire: ") || name.startsWith("Part: ")) {
            name = name.substring(6);
        }
        if ((ind = name.indexOf(" Cell instance:")) > 0) {
            name = name.substring(0, ind).trim();
        }
        text.append(href + (rowNdx * 10 + lineNdx) + "\">" + name + "</a>");
        text.append("</font></html>");
        JEditorPane pane = new JEditorPane();
        pane.setBackground(this.bkgndColor);
        pane.setEditable(false);
        pane.addHyperlinkListener(this);
        pane.setContentType("text/html");
        pane.setText(text.toString());
        pane.setMargin(insets);
        pane.setBorder(border);
        pane.moveCaretPosition(0);
        return pane;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.highlight(Integer.parseInt(event.getDescription()));
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e2) {
        this.headScrPane.getHorizontalScrollBar().setValue(e2.getValue());
    }

    private void highlight(int index) {
        VarContext context;
        int row = index / 10;
        int col = index % 2;
        PartReport part = this.parts[row][col];
        Cell cell = part.getNameProxy().leafCell();
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context = part.getNameProxy().getContext());
        if (highlighter == null) {
            return;
        }
        HighlightTools.highlightPart(highlighter, cell, part);
        highlighter.finished();
    }
}

