/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.MinArea;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.JELIB2;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.simulation.acl2.modsext.ACL2DesignJobs;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsmNew;
import com.sun.electric.tool.simulation.acl2.modsext.TraceSvtvJobs;
import com.sun.electric.tool.simulation.acl2.modsext.TutorialHints;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import com.sun.electric.util.acl2.GenPkgImports;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;

public class PublicDebugMenu {
    static EMenuItem makeMenu() {
        return new EMenu("Debug", new EMenu("ACL2", new EMenuItem("Gen phase FSM for Tutorial"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                GenFsmNew.genFsm(TutorialHints.class, f2, designName);
            }
        }, new EMenuItem("Import _SAO..."){

            @Override
            public void run() {
                FileMenu.importLibraryCommand(FileType.SAO, false, false, false, false);
            }
        }, new EMenuItem("Count objects in SAO file"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized ACL2", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String saoName = TextUtils.getFileNameWithoutPath(saoPath);
                try {
                    ACL2Object.initHonsMananger(saoName);
                    System.out.println(saoName + " contains " + new ACL2Reader(f2).getStats());
                }
                catch (IOException e2) {
                    System.out.println(e2);
                }
                finally {
                    ACL2Object.closeHonsManager();
                }
            }
        }, new EMenuItem("Generate pkg-imports.dat"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized pkg-imports", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                GenPkgImports.gen(f2);
            }
        }, new EMenuItem("Dump SVEX design"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String defaultOutName = User.getWorkingDirectory() + File.separator + TextUtils.getFileNameWithoutExtension(saoPath) + ".txt";
                String outPath = OpenFile.chooseOutputFile(FileType.TEXT, "SVEX design dump", defaultOutName);
                if (outPath == null) {
                    return;
                }
                ACL2DesignJobs.dump(DesignHints.Dummy.class, f2, outPath);
            }
        }, new EMenuItem("Dump SVEX design from Tutorial"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String defaultOutName = User.getWorkingDirectory() + File.separator + TextUtils.getFileNameWithoutExtension(saoPath) + ".txt";
                String outPath = OpenFile.chooseOutputFile(FileType.TEXT, "SVEX design dump", defaultOutName);
                if (outPath == null) {
                    return;
                }
                ACL2DesignJobs.dump(TutorialHints.class, f2, outPath);
            }
        }, new EMenuItem("Make Trace Svtv script for Tutorial"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                TraceSvtvJobs.makeTraceSvtv(TutorialHints.class, f2, designName);
            }
        }, new EMenuItem("Read Trace Svtv for Tutorial"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                TraceSvtvJobs.readTraceSvtv(TutorialHints.class, f2);
            }
        }, new EMenuItem("Test Trace Svtv for Tutorial"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                TraceSvtvJobs.testTraceSvtv(TutorialHints.class, f2);
            }
        }, new EMenuItem("Dedup SVEX design"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                String defaultOutName = User.getWorkingDirectory() + File.separator + designName + "-dedup.lisp";
                String outPath = OpenFile.chooseOutputFile(FileType.LISP, "LISP with deduplication of SVEX", defaultOutName);
                if (outPath == null) {
                    return;
                }
                ACL2DesignJobs.dedup(f2, designName, outPath);
            }
        }, new EMenuItem("Show SVEX assigns"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                String defaultOutName = User.getWorkingDirectory() + File.separator + designName + "-assignes.lisp";
                String outPath = OpenFile.chooseOutputFile(FileType.LISP, "LISP with assigns of SVEX", defaultOutName);
                if (outPath == null) {
                    return;
                }
                ACL2DesignJobs.showAssigns(f2, designName, outPath);
            }
        }, new EMenuItem("Named -> Indexed"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                ACL2DesignJobs.namedToIndexed(f2, designName);
            }
        }, new EMenuItem("Normalize named assigns"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                ACL2DesignJobs.normalizeAssigns(f2, designName, false);
            }
        }, new EMenuItem("Normalize indexed assigns"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized SVEX design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String designName = TextUtils.getFileNameWithoutExtension(saoPath);
                ACL2DesignJobs.normalizeAssigns(f2, designName, true);
            }
        }, new EMenuItem("Gen FSM for ALU"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized ALU design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                String defaultOutName = "alu-auto.lisp";
                String outPath = OpenFile.chooseOutputFile(FileType.LISP, "ALU FSM in ACL2", defaultOutName);
                if (outPath == null) {
                    return;
                }
                ACL2DesignJobs.genAlu(f2, outPath);
            }
        }, new EMenuItem("Show Tutorial Libs"){

            @Override
            public void run() {
                String saoPath = OpenFile.chooseInputFile(FileType.SAO, "Serialized Tutorial design", false);
                if (saoPath == null) {
                    return;
                }
                URL fileURL = TextUtils.makeURLToFile(saoPath);
                File f2 = TextUtils.getFile(fileURL);
                ACL2DesignJobs.showTutorialSvexLibs(f2);
            }
        }), new EMenu("Spice", new EMenuItem("Read Spice"){

            @Override
            public void run() {
                String spicePath = OpenFile.chooseInputFile(FileType.SPICE, "Spice deck", false);
                if (spicePath == null) {
                    return;
                }
                SpiceNetlistReader reader = new SpiceNetlistReader(true);
                try {
                    reader.readFile(spicePath, true);
                }
                catch (FileNotFoundException e2) {
                    System.out.println(e2.getMessage());
                }
                reader.writeFile("/tmp/output.spi");
            }
        }), new EMenu("DRC", new EMenuItem("Check _Minimum Area..."){

            @Override
            public void run() {
                MinArea.checkMinareaLay();
            }
        }, new EMenuItem("Import Minimum Area _Test..."){

            @Override
            public void run() {
                MinArea.readMinareaLay();
            }
        }, new EMenuItem("E_xport Minimum Area Test..."){

            @Override
            public void run() {
                MinArea.writeMinareaLay();
            }
        }), new EMenu("Fast JELIB reader", PublicDebugMenu.jelibItem("Database", true, true, true, true, true), PublicDebugMenu.jelibItem("Snapshot", true, true, true, true, false), PublicDebugMenu.jelibItem("primitiveBounds", true, true, true, false, false), PublicDebugMenu.jelibItem("doBackup", true, true, false, false, false), PublicDebugMenu.jelibItem("instantiate", true, false, false, false, false), PublicDebugMenu.jelibItem("only parse", false, false, false, false, false)), new EMenu("SeaOfGatesRouter", PublicDebugMenu.sogItem("Animation", SeaOfGatesHandlers.Save.SAVE_SNAPSHOTS), PublicDebugMenu.sogItem("Partial-Animation", SeaOfGatesHandlers.Save.SAVE_PERIODIC), PublicDebugMenu.sogItem("Once", SeaOfGatesHandlers.Save.SAVE_ONCE), EMenuItem.SEPARATOR, PublicDebugMenu.sogItem("Dummy on CHANGE", Job.Type.CHANGE), PublicDebugMenu.sogItem("Dummy on SERVER_EXAMINE", Job.Type.SERVER_EXAMINE), PublicDebugMenu.sogItem("Dummy on CLIENT_EXAMINE", Job.Type.CLIENT_EXAMINE), new EMenuItem("Dummy on client"){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell == null) {
                    return;
                }
                PublicDebugMenu.routeIt(cell, UserInterfaceMain.getEditingPreferences(), System.out);
            }
        }, new EMenuItem("Dummy in Thread"){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell == null) {
                    return;
                }
                new SeaOfGatesThread(cell, UserInterfaceMain.getEditingPreferences()).start();
            }
        }));
    }

    private static EMenuItem jelibItem(String text, final boolean instantiate, final boolean doBackup, final boolean getPrimitiveBounds, final boolean doSnapshot, final boolean doDatabase) {
        return new EMenuItem(text){

            @Override
            public void run() {
                JELIB2.newJelibReader(instantiate, doBackup, getPrimitiveBounds, doSnapshot, doDatabase);
            }
        };
    }

    private static EMenuItem sogItem(String text, final SeaOfGatesHandlers.Save save) {
        return new EMenuItem(text){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell != null) {
                    SeaOfGatesHandlers.startInJob(cell, null, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion, save);
                }
            }
        };
    }

    private static EMenuItem sogItem(String text, final Job.Type jobType) {
        return new EMenuItem(text){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell != null) {
                    new SeaOfGatesJob(cell, jobType).startJob();
                }
            }
        };
    }

    private static void routeIt(Cell cell, EditingPreferences ep, PrintStream out) {
        SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine();
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.useParallelRoutes = true;
        router.setPrefs(prefs);
        SeaOfGatesEngine.Handler handler = SeaOfGatesHandlers.getDummy(ep, out);
        router.routeIt(handler, cell, false);
    }

    private static class SeaOfGatesThread
    extends Thread {
        private final Snapshot snapshot;
        private final CellId cellId;
        private final EditingPreferences ep;

        private SeaOfGatesThread(Cell cell, EditingPreferences ep) {
            this.snapshot = cell.getDatabase().backup();
            this.cellId = cell.getId();
            this.ep = ep;
        }

        @Override
        public void run() {
            EDatabase database = new EDatabase(this.snapshot, "dummy");
            Cell cell = database.getCell(this.cellId);
            PublicDebugMenu.routeIt(cell, this.ep, System.err);
        }
    }

    private static class SeaOfGatesJob
    extends Job {
        private final Cell cell;

        protected SeaOfGatesJob(Cell cell, Job.Type jobType) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), jobType, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        @Override
        public boolean doIt() throws JobException {
            PublicDebugMenu.routeIt(this.cell, this.getEditingPreferences(), System.out);
            return true;
        }
    }
}

