/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EMenuBar
extends EMenu {
    private Preferences prefs;
    Map<String, EMenuItem> menuItems = new HashMap<String, EMenuItem>();
    public final KeyBindingManager keyBindingManager;
    private final EMenu hiddenMenu;
    private final List<EMenuItem> updatableItems = new ArrayList<EMenuItem>();

    EMenuBar(String name, EMenu hiddenMenu, List<EMenuItem> items) {
        super(name, items);
        this.hiddenMenu = hiddenMenu;
        this.prefs = Preferences.userNodeForPackage(EMenuBar.class);
        this.keyBindingManager = new KeyBindingManager(name + "MenuKeyBinding-", this.prefs);
        this.path = new int[0];
        int indexInParent = 0;
        for (EMenuItem item : items) {
            if (item == null) continue;
            item.registerTree(this, this.path, indexInParent++);
        }
        if (hiddenMenu != null) {
            hiddenMenu.registerTree(this, this.path, -1);
        }
    }

    public EMenu getHiddenMenu() {
        return this.hiddenMenu;
    }

    public String getDescription(int[] path) {
        StringBuilder sb = new StringBuilder();
        int topIndex = path[0];
        EMenuItem item = topIndex >= 0 ? (EMenuItem)this.items.get(topIndex) : this.hiddenMenu;
        sb.append(item.getText());
        for (int i2 = 1; i2 < path.length; ++i2) {
            EMenu menu = item;
            item = menu.items.get(path[i2]);
            sb.append(" | ");
            sb.append(item.getText());
        }
        return sb.toString();
    }

    void registerKeyBindings(EMenuItem menuItem) {
        String key = menuItem.getDescription();
        this.menuItems.put(key, menuItem);
        KeyStroke[] bindings = menuItem.getAccelerators();
        for (int i2 = 0; i2 < bindings.length; ++i2) {
            this.addDefaultKeyBinding(menuItem, bindings[i2]);
        }
        this.keyBindingManager.addActionListener(key, menuItem);
    }

    void registerUpdatable(EMenuItem menuItem) {
        this.updatableItems.add(menuItem);
    }

    public void updateAllButtons() {
        for (EMenuItem item : this.updatableItems) {
            item.updateJMenuItems();
        }
    }

    public KeyBindings getKeyBindings(EMenuItem item) {
        return this.keyBindingManager.getKeyBindings(item.getDescription());
    }

    private void addDefaultKeyBinding(EMenuItem item, KeyStroke stroke) {
        String description = item.getDescription();
        this.keyBindingManager.addDefaultKeyBinding(description, KeyStrokePair.getKeyStrokePair(null, stroke));
    }

    public void addUserKeyBinding(EMenuItem item, KeyStroke stroke, KeyStroke prefixStroke) {
        String description = item.getDescription();
        this.keyBindingManager.addUserKeyBinding(description, KeyStrokePair.getKeyStrokePair(prefixStroke, stroke));
        this.updateAccelerator(item);
    }

    public void resetKeyBindings(EMenuItem item) {
        this.keyBindingManager.resetKeyBindings(item.getDescription());
        this.updateAccelerator(item);
    }

    public void resetAllKeyBindings() {
        for (EMenuItem item : this.menuItems.values()) {
            this.resetKeyBindings(item);
        }
    }

    public void removeKeyBinding(String actionDesc, KeyStrokePair pair) {
        this.keyBindingManager.removeKeyBinding(actionDesc, pair);
        EMenuItem item = this.menuItems.get(actionDesc);
        if (item != null) {
            this.updateAccelerator(item);
        }
    }

    public void restoreSavedBindings(boolean initialCall) {
        this.keyBindingManager.restoreSavedBindings(initialCall);
        for (EMenuItem item : this.menuItems.values()) {
            this.updateAccelerator(item);
        }
    }

    private void updateAccelerator(EMenuItem item) {
        String actionDesc = item.getDescription();
        KeyBindings bindings = this.keyBindingManager.getKeyBindings(actionDesc);
        KeyStroke accelerator = null;
        if (bindings != null) {
            Iterator<KeyStrokePair> it = bindings.getUsingDefaultKeys() ? bindings.getDefaultKeyStrokePairs() : bindings.getKeyStrokePairs();
            while (it.hasNext()) {
                KeyStrokePair pair = it.next();
                if (pair.getPrefixStroke() != null) continue;
                accelerator = pair.getStroke();
                break;
            }
        }
        item.setAccelerator(accelerator);
    }

    public KeyBindingManager.KeyMaps getKeyMaps() {
        return this.keyBindingManager.getKeyMaps();
    }

    public Instance genInstance() {
        return new Instance();
    }

    public class Instance
    extends JMenuBar {
        boolean ignoreKeyBindings = false;
        boolean ignoreTextEditKeys = false;

        public Instance() {
            for (EMenuItem item : EMenuBar.this.getItems()) {
                this.add(item.genMenu());
            }
        }

        public EMenuBar getMenuBarGroup() {
            return EMenuBar.this;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e2, int condition, boolean pressed) {
            int code = e2.getKeyCode();
            char ch = e2.getKeyChar();
            ActivityLogger.logMessage("ProcessKeyBinding " + e2.getID() + " when=" + e2.getWhen() + " modifiers=" + Integer.toHexString(e2.getModifiersEx()) + " code=" + Integer.toHexString(code) + " char=" + Integer.toHexString(ch) + (String)(' ' < ch && ch < '\u007f' ? "(" + ch + ")" : "") + " " + this.ignoreKeyBindings + " " + this.ignoreTextEditKeys);
            if (this.ignoreKeyBindings) {
                return false;
            }
            if (this.ignoreTextEditKeys && !e2.isControlDown() && !e2.isMetaDown() && !e2.isAltDown()) {
                return false;
            }
            boolean retValue = false;
            if (!retValue) {
                retValue = EMenuBar.this.keyBindingManager.processKeyEvent(e2);
            }
            return retValue;
        }

        public void setIgnoreKeyBindings(boolean b2) {
            this.ignoreKeyBindings = b2;
        }

        public boolean getIgnoreKeyBindings() {
            return this.ignoreKeyBindings;
        }

        public void setIgnoreTextEditKeys(boolean b2) {
            this.ignoreTextEditKeys = b2;
        }

        public boolean getIgnoreTextEditKeys() {
            return this.ignoreTextEditKeys;
        }

        JMenuItem findMenuItem(int[] path) {
            int topIndex = path[0];
            if (topIndex < 0) {
                return null;
            }
            JMenuItem item = (JMenuItem)this.getComponent(topIndex);
            for (int i2 = 1; i2 < path.length; ++i2) {
                JMenu menu = (JMenu)item;
                item = (JMenuItem)menu.getMenuComponent(path[i2]);
            }
            return item;
        }

        public void finished() {
            for (int i2 = 0; i2 < this.getMenuCount(); ++i2) {
                JMenu menu = this.getMenu(i2);
                if (menu == null) continue;
                this.disposeofMenu(menu);
            }
            this.removeAll();
        }

        private void disposeofMenu(JMenu menu) {
            for (int j2 = 0; j2 < menu.getItemCount(); ++j2) {
                JMenuItem item = menu.getItem(j2);
                if (item == null) continue;
                if (item instanceof JMenu) {
                    this.disposeofMenu((JMenu)item);
                    continue;
                }
                this.disposeofMenuItem(item);
            }
            menu.removeAll();
        }

        private void disposeofMenuItem(JMenuItem item) {
            ActionListener[] listeners = item.getActionListeners();
            for (int k2 = 0; k2 < listeners.length; ++k2) {
                ActionListener listener = listeners[k2];
                item.removeActionListener(listener);
            }
        }
    }
}

