/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextInfoPanel
extends JPanel {
    private boolean updateChangesInstantly;
    private boolean loading = false;
    private AbstractTextDescriptor.Position initialPos;
    private AbstractTextDescriptor.Size initialSize;
    private AbstractTextDescriptor.Rotation initialRotation;
    private boolean initialItalic;
    private boolean initialBold;
    private boolean initialUnderline;
    private boolean initialInvisibleOutsideCell;
    private int initialFont;
    private double initialXOffset;
    private double initialYOffset;
    private double initialBoxedWidth;
    private double initialBoxedHeight;
    private int initialColorIndex;
    private TextDescriptor td;
    private Variable.Key varKey;
    private ElectricObject owner;
    private NodeInst unTransformNi;
    private JCheckBox bold;
    private JTextField boxedHeight;
    private JTextField boxedWidth;
    private JComboBox font;
    private JLabel globalTextScale;
    private JCheckBox invisibleOutsideCell;
    private JCheckBox italic;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelX;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton pointsButton;
    private JTextField pointsSize;
    private JComboBox rotation;
    private JButton seeNode;
    private ButtonGroup sizes;
    private JComboBox textAnchor;
    private JComboBox textColorComboBox;
    private JCheckBox underline;
    private JRadioButton unitsButton;
    private JTextField unitsSize;
    private JTextField xOffset;
    private JTextField yOffset;

    public TextInfoPanel(boolean updateChangesInstantly, boolean paramDialog) {
        int i2;
        this.updateChangesInstantly = updateChangesInstantly;
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.pointsSize);
        EDialog.makeTextFieldSelectAllOnTab(this.unitsSize);
        EDialog.makeTextFieldSelectAllOnTab(this.xOffset);
        EDialog.makeTextFieldSelectAllOnTab(this.yOffset);
        EDialog.makeTextFieldSelectAllOnTab(this.boxedHeight);
        EDialog.makeTextFieldSelectAllOnTab(this.boxedWidth);
        if (paramDialog) {
            this.remove(this.seeNode);
        }
        this.font.addItem("DEFAULT FONT");
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (i2 = 0; i2 < fonts.length; ++i2) {
            this.font.addItem(fonts[i2].getFontName());
        }
        for (i2 = 0; i2 < AbstractTextDescriptor.Rotation.getNumRotations(); ++i2) {
            AbstractTextDescriptor.Rotation rot = AbstractTextDescriptor.Rotation.getRotationAt(i2);
            this.rotation.addItem(rot.getAngle());
        }
        Iterator<AbstractTextDescriptor.Position> it = AbstractTextDescriptor.Position.getPositions();
        while (it.hasNext()) {
            AbstractTextDescriptor.Position pos = it.next();
            this.textAnchor.addItem(pos);
        }
        int[] colorIndices = EGraphics.getColorIndices();
        this.textColorComboBox.addItem("DEFAULT COLOR");
        for (int i3 = 0; i3 < colorIndices.length; ++i3) {
            String str = EGraphics.getColorIndexName(colorIndices[i3]);
            this.textColorComboBox.addItem(str);
        }
        this.initialYOffset = 0.0;
        this.initialXOffset = 0.0;
        this.xOffset.setText("0");
        this.yOffset.setText("0");
        this.initialInvisibleOutsideCell = false;
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.unitsButton.setText("Units (min 0.25, max 127.75)");
        this.initialSize = AbstractTextDescriptor.Size.newRelSize(1.0);
        this.unitsButton.setSelected(true);
        this.unitsSize.setText("1.0");
        this.pointsButton.setText("Points (min 1, max 63)");
        this.initialPos = AbstractTextDescriptor.Position.CENT;
        this.textAnchor.setSelectedItem(this.initialPos);
        this.initialFont = 0;
        this.font.setSelectedIndex(this.initialFont);
        this.initialItalic = false;
        this.italic.setEnabled(false);
        this.initialBold = false;
        this.bold.setEnabled(false);
        this.initialUnderline = false;
        this.underline.setEnabled(false);
        this.initialRotation = AbstractTextDescriptor.Rotation.ROT0;
        this.rotation.setSelectedItem(this.initialRotation);
        this.initialColorIndex = 0;
        this.setTextDescriptor(null, null);
        this.unitsSize.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.pointsSize.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.xOffset.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.yOffset.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.boxedWidth.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.boxedHeight.getDocument().addDocumentListener(new TextInfoDocumentListener(this));
        this.unitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.italic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.bold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.underline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.invisibleOutsideCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.rotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.textAnchor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
        this.textColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.fieldChanged();
            }
        });
    }

    public synchronized void setTextDescriptor(Variable.Key varKey, ElectricObject owner) {
        if (varKey != null && varKey.getName().trim().equals("")) {
            varKey = null;
        }
        this.varKey = varKey;
        this.owner = owner;
        boolean enabled = owner != null && varKey != null;
        this.pointsSize.setEnabled(enabled);
        this.unitsSize.setEnabled(enabled);
        this.pointsButton.setEnabled(enabled);
        this.unitsButton.setEnabled(enabled);
        this.xOffset.setEnabled(enabled);
        this.yOffset.setEnabled(enabled);
        this.font.setEnabled(enabled);
        this.textAnchor.setEnabled(enabled);
        this.rotation.setEnabled(enabled);
        this.bold.setEnabled(enabled);
        this.italic.setEnabled(enabled);
        this.underline.setEnabled(enabled);
        this.invisibleOutsideCell.setEnabled(enabled);
        this.seeNode.setEnabled(enabled && !(owner instanceof Cell));
        this.boxedWidth.setEnabled(false);
        this.boxedHeight.setEnabled(false);
        this.textColorComboBox.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        this.td = owner.getTextDescriptor(varKey);
        if (this.td == null) {
            return;
        }
        this.loading = true;
        NodeInst ni = null;
        if (owner != null && owner instanceof NodeInst && (ni = (NodeInst)owner).getProto() != Generic.tech().invisiblePinNode) {
            ni = null;
        }
        this.unTransformNi = null;
        if (owner != null) {
            if (owner instanceof NodeInst) {
                this.unTransformNi = (NodeInst)owner;
            } else if (owner instanceof Export) {
                this.unTransformNi = ((Export)owner).getOriginalPort().getNodeInst();
            }
        }
        if (ni != null) {
            this.initialXOffset = ni.getAnchorCenterX();
            this.initialYOffset = ni.getAnchorCenterY();
        } else {
            this.initialXOffset = this.td.getXOff();
            this.initialYOffset = this.td.getYOff();
            if (this.unTransformNi != null) {
                Point2D.Double off = new Point2D.Double(this.initialXOffset, this.initialYOffset);
                FixpTransform trans = this.unTransformNi.pureRotateOut();
                trans.transform(off, off);
                this.initialXOffset = ((Point2D)off).getX();
                this.initialYOffset = ((Point2D)off).getY();
            }
        }
        Cell cell = WindowFrame.getCurrentCell();
        Technology tech = cell == null ? null : cell.getTechnology();
        this.xOffset.setText(TextUtils.formatDistance(this.initialXOffset, tech));
        this.yOffset.setText(TextUtils.formatDistance(this.initialYOffset, tech));
        this.initialInvisibleOutsideCell = this.td.isInterior();
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.initialSize = this.td.getSize();
        EditWindow wnd = EditWindow.getCurrent();
        if (this.initialSize.isAbsolute()) {
            this.pointsButton.setSelected(true);
            this.pointsSize.setText(TextUtils.formatDouble(this.initialSize.getSize()));
            this.unitsSize.setText("");
            if (wnd != null) {
                double unitSize = this.initialSize.getSize() / wnd.getScale();
                if (unitSize > 127.75) {
                    unitSize = 127.75;
                } else if (unitSize < 0.25) {
                    unitSize = 0.25;
                }
                this.unitsSize.setText(TextUtils.formatDouble(unitSize));
            }
        } else {
            this.unitsButton.setSelected(true);
            this.unitsSize.setText(TextUtils.formatDouble(this.initialSize.getSize()));
            this.pointsSize.setText("");
            if (wnd != null) {
                double pointSize = this.initialSize.getSize() * wnd.getScale();
                if (pointSize > 63.0) {
                    pointSize = 63.0;
                } else if (pointSize < 1.0) {
                    pointSize = 1.0;
                }
                this.pointsSize.setText(String.valueOf((int)pointSize));
            }
        }
        this.initialPos = this.td.getPos();
        this.boxedWidth.setText("");
        this.boxedHeight.setText("");
        this.initialBoxedWidth = -1.0;
        this.initialBoxedHeight = -1.0;
        boolean ownerIsNodeInst = false;
        if (owner instanceof NodeInst) {
            ownerIsNodeInst = true;
        }
        if (ownerIsNodeInst) {
            boolean found = false;
            for (int i2 = 0; i2 < this.textAnchor.getModel().getSize(); ++i2) {
                AbstractTextDescriptor.Position pos = (AbstractTextDescriptor.Position)this.textAnchor.getModel().getElementAt(i2);
                if (pos != AbstractTextDescriptor.Position.BOXED) continue;
                found = true;
                break;
            }
            if (!found) {
                this.textAnchor.addItem(AbstractTextDescriptor.Position.BOXED);
            }
            NodeInst ni2 = (NodeInst)owner;
            this.initialBoxedWidth = ni2.getXSize();
            this.initialBoxedHeight = ni2.getYSize();
            this.boxedWidth.setText(TextUtils.formatDouble(ni2.getXSize()));
            this.boxedHeight.setText(TextUtils.formatDouble(ni2.getYSize()));
        }
        if (!ownerIsNodeInst) {
            this.textAnchor.removeItem(AbstractTextDescriptor.Position.BOXED);
        }
        Poly.Type type = this.td.getPos().getPolyType();
        type = Poly.rotateType(type, owner);
        AbstractTextDescriptor.Position pos = AbstractTextDescriptor.Position.getPosition(type);
        this.textAnchor.setSelectedItem(pos);
        this.textAnchorItemStateChanged(null);
        this.initialFont = this.td.getFace();
        if (this.initialFont == 0) {
            this.font.setSelectedIndex(0);
        } else {
            AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(this.initialFont);
            if (af != null) {
                String fontName = af.getName();
                EDialog.ensureComboBoxFont(this.font, fontName);
                this.font.setSelectedItem(fontName);
            }
        }
        this.initialItalic = this.td.isItalic();
        this.italic.setSelected(this.initialItalic);
        this.initialBold = this.td.isBold();
        this.bold.setSelected(this.initialBold);
        this.initialUnderline = this.td.isUnderline();
        this.underline.setSelected(this.initialUnderline);
        this.initialRotation = this.td.getRotation();
        this.rotation.setSelectedIndex(this.td.getRotation().getIndex());
        this.initialColorIndex = this.td.getColorIndex();
        int[] colorIndices = EGraphics.getColorIndices();
        int colorComboIndex = -1;
        for (int i3 = 0; i3 < colorIndices.length; ++i3) {
            if (colorIndices[i3] != this.initialColorIndex) continue;
            colorComboIndex = i3;
            break;
        }
        colorComboIndex = colorComboIndex != -1 ? colorComboIndex + 1 : 0;
        this.textColorComboBox.setSelectedIndex(colorComboIndex);
        double textScale = wnd != null ? wnd.getGlobalTextScale() : User.getGlobalTextScale();
        this.globalTextScale.setText("Scaled by " + TextUtils.formatDouble(textScale * 100.0) + "%");
        this.loading = false;
    }

    private void fieldChanged() {
        if (!this.updateChangesInstantly) {
            return;
        }
        if (this.loading) {
            return;
        }
        this.applyChanges(false);
    }

    public TextDescriptor withPanelValues(TextDescriptor td) {
        if (this.pointsButton.isSelected()) {
            s = this.pointsSize.getText().trim();
            if (s.length() > 0) {
                td = td.withAbsSize(TextUtils.atoi(s));
            }
        } else {
            s = this.unitsSize.getText().trim();
            if (s.length() > 0) {
                td = td.withRelSize(TextUtils.atof(s));
            }
        }
        Cell cell = WindowFrame.getCurrentCell();
        Technology tech = cell == null ? null : cell.getTechnology();
        double xd = TextUtils.atofDistance(this.xOffset.getText(), tech);
        double yd = TextUtils.atofDistance(this.yOffset.getText(), tech);
        td = td.withOff(xd, yd);
        int index = this.rotation.getSelectedIndex();
        AbstractTextDescriptor.Rotation r = AbstractTextDescriptor.Rotation.getRotationAt(index);
        td = td.withRotation(r);
        AbstractTextDescriptor.Position p = (AbstractTextDescriptor.Position)this.textAnchor.getSelectedItem();
        td = td.withPos(p);
        int f2 = this.font.getSelectedIndex();
        td = td.withFace(f2);
        boolean it = this.italic.isSelected();
        td = td.withItalic(it);
        boolean bo = this.bold.isSelected();
        td = td.withBold(bo);
        boolean ul = this.underline.isSelected();
        td = td.withUnderline(ul);
        boolean invis = this.invisibleOutsideCell.isSelected();
        td = td.withInterior(invis);
        int colorIndex = this.textColorComboBox.getSelectedIndex();
        if (colorIndex > 0) {
            int[] colorIndices = EGraphics.getColorIndices();
            td = td.withColorIndex(colorIndices[colorIndex - 1]);
        }
        return td;
    }

    public synchronized boolean applyChanges(boolean adjustErrors) {
        boolean newInvis;
        boolean newUnderlined;
        boolean newBold;
        boolean newItalic;
        int newFont;
        int index;
        AbstractTextDescriptor.Rotation newRotation;
        Cell cell;
        String value;
        if (this.varKey == null) {
            return false;
        }
        boolean changed = false;
        AbstractTextDescriptor.Size newSize = null;
        if (this.pointsButton.isSelected()) {
            value = this.pointsSize.getText();
            int size = TextUtils.atoi(value);
            if (size != 0) {
                newSize = AbstractTextDescriptor.Size.newAbsSize(size);
            }
        } else {
            value = this.unitsSize.getText();
            double size = TextUtils.atof(value);
            if (size != 0.0) {
                newSize = AbstractTextDescriptor.Size.newRelSize(size);
            }
        }
        if (newSize == null) {
            if (adjustErrors) {
                this.pointsSize.setText(String.valueOf(63));
            }
            System.out.println("Error: text size '" + value + "' is invalid or out of range. Setting default value.");
            newSize = AbstractTextDescriptor.Size.newRelSize(1.0);
        }
        if (!newSize.equals(this.initialSize)) {
            changed = true;
        }
        Technology tech = (cell = WindowFrame.getCurrentCell()) == null ? null : cell.getTechnology();
        double currentXOffset = TextUtils.atofDistance(this.xOffset.getText(), tech);
        double currentYOffset = TextUtils.atofDistance(this.yOffset.getText(), tech);
        if (!DBMath.doublesEqual(currentXOffset, this.initialXOffset) || !DBMath.doublesEqual(currentYOffset, this.initialYOffset)) {
            changed = true;
        }
        AbstractTextDescriptor.Position newPosition = (AbstractTextDescriptor.Position)this.textAnchor.getSelectedItem();
        Poly.Type type = newPosition.getPolyType();
        newPosition = AbstractTextDescriptor.Position.getPosition(type = Poly.unRotateType(type, this.owner));
        if (newPosition != this.initialPos) {
            changed = true;
        }
        double newBoxedWidth = 10.0;
        double newBoxedHeight = 10.0;
        if (newPosition == AbstractTextDescriptor.Position.BOXED) {
            block29: {
                try {
                    Double width = Double.valueOf(this.boxedWidth.getText());
                    Double height = Double.valueOf(this.boxedHeight.getText());
                    newBoxedWidth = width;
                    newBoxedHeight = height;
                }
                catch (NumberFormatException e2) {
                    if (!(this.owner instanceof NodeInst)) break block29;
                    NodeInst ni = (NodeInst)this.owner;
                    newBoxedWidth = ni.getXSize();
                    newBoxedHeight = ni.getYSize();
                }
            }
            if (newBoxedWidth != this.initialBoxedWidth) {
                changed = true;
            }
            if (newBoxedHeight != this.initialBoxedHeight) {
                changed = true;
            }
        }
        if ((newRotation = AbstractTextDescriptor.Rotation.getRotationAt(index = this.rotation.getSelectedIndex())) != this.initialRotation) {
            changed = true;
        }
        if ((newFont = this.font.getSelectedIndex()) != this.initialFont) {
            changed = true;
        }
        if ((newItalic = this.italic.isSelected()) != this.initialItalic) {
            changed = true;
        }
        if ((newBold = this.bold.isSelected()) != this.initialBold) {
            changed = true;
        }
        if ((newUnderlined = this.underline.isSelected()) != this.initialUnderline) {
            changed = true;
        }
        if ((newInvis = this.invisibleOutsideCell.isSelected()) != this.initialInvisibleOutsideCell) {
            changed = true;
        }
        int newColorIndex = 0;
        int[] colorIndices = EGraphics.getColorIndices();
        int newColorComboIndex = this.textColorComboBox.getSelectedIndex();
        if (newColorComboIndex > 0) {
            newColorIndex = colorIndices[newColorComboIndex - 1];
        }
        if (newColorIndex != this.initialColorIndex) {
            changed = true;
        }
        if (this.td != null) {
            if (!changed) {
                return false;
            }
        } else if (this.owner instanceof Cell) {
            Point2D offset = ((Cell)this.owner).newVarOffset();
            currentYOffset = offset.getY();
            currentXOffset = offset.getX();
        }
        Integer absSize = null;
        Double relSize = null;
        if (newSize.isAbsolute()) {
            absSize = (int)newSize.getSize();
        } else {
            relSize = newSize.getSize();
        }
        new ChangeText(this.owner, this.unTransformNi, this.varKey, absSize, relSize, newPosition.getIndex(), newBoxedWidth, newBoxedHeight, newRotation.getIndex(), (String)this.font.getSelectedItem(), currentXOffset, currentYOffset, newItalic, newBold, newUnderlined, newInvis, newColorIndex);
        this.initialSize = newSize;
        this.initialXOffset = currentXOffset;
        this.initialYOffset = currentYOffset;
        this.initialPos = newPosition;
        this.initialRotation = newRotation;
        this.initialFont = newFont;
        this.initialItalic = newItalic;
        this.initialUnderline = newUnderlined;
        this.initialBold = newBold;
        this.initialInvisibleOutsideCell = newInvis;
        this.initialBoxedWidth = newBoxedWidth;
        this.initialBoxedHeight = newBoxedHeight;
        this.initialColorIndex = newColorIndex;
        return true;
    }

    private void initComponents() {
        this.sizes = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.pointsSize = new JTextField();
        this.unitsSize = new JTextField();
        this.pointsButton = new JRadioButton();
        this.unitsButton = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.font = new JComboBox();
        this.italic = new JCheckBox();
        this.bold = new JCheckBox();
        this.underline = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.rotation = new JComboBox();
        this.jLabel8 = new JLabel();
        this.xOffset = new JTextField();
        this.jLabel9 = new JLabel();
        this.yOffset = new JTextField();
        this.invisibleOutsideCell = new JCheckBox();
        this.seeNode = new JButton();
        this.textAnchor = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.boxedWidth = new JTextField();
        this.boxedHeight = new JTextField();
        this.jLabelX = new JLabel();
        this.jLabel3 = new JLabel();
        this.textColorComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.globalTextScale = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel12 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.setName("");
        this.jLabel4.setText("Text Size:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.pointsSize.setColumns(8);
        this.pointsSize.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 2, 1, 4);
        this.add((Component)this.pointsSize, gridBagConstraints);
        this.unitsSize.setColumns(8);
        this.unitsSize.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 2, 4, 4);
        this.add((Component)this.unitsSize, gridBagConstraints);
        this.sizes.add(this.pointsButton);
        this.pointsButton.setText("Points (max 63)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.pointsButton, gridBagConstraints);
        this.sizes.add(this.unitsButton);
        this.unitsButton.setText("Units (max 127.75)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.unitsButton, gridBagConstraints);
        this.jLabel5.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.font, gridBagConstraints);
        this.italic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.italic, gridBagConstraints);
        this.bold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.bold, gridBagConstraints);
        this.underline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.underline, gridBagConstraints);
        this.jLabel6.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.rotation, gridBagConstraints);
        this.jLabel8.setText("X offset:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 3, 0);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.xOffset.setColumns(8);
        this.xOffset.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 2, 1, 4);
        this.add((Component)this.xOffset, gridBagConstraints);
        this.jLabel9.setText("Y offset:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.yOffset.setColumns(8);
        this.yOffset.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 2, 0, 4);
        this.add((Component)this.yOffset, gridBagConstraints);
        this.invisibleOutsideCell.setText("Invisible outside cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 2, 0);
        this.add((Component)this.invisibleOutsideCell, gridBagConstraints);
        this.seeNode.setText("Highlight Owner");
        this.seeNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.seeNodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.seeNode, gridBagConstraints);
        this.textAnchor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextInfoPanel.this.textAnchorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textAnchor, gridBagConstraints);
        this.jLabel1.setText("Anchor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText("Boxed width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.boxedWidth.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.boxedWidth, gridBagConstraints);
        this.boxedHeight.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.boxedHeight, gridBagConstraints);
        this.jLabelX.setText("height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel3.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorComboBox, gridBagConstraints);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jLabel10.setText("All Text Sizes are");
        this.jPanel2.add(this.jLabel10);
        this.globalTextScale.setText("Scaled by 100%");
        this.jPanel2.add(this.globalTextScale);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jLabel7.setText("(0.25 increments,");
        this.jPanel3.add(this.jLabel7);
        this.jLabel12.setText("maximum 4088)");
        this.jPanel3.add(this.jLabel12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void textAnchorItemStateChanged(ItemEvent evt) {
        AbstractTextDescriptor.Position pos = (AbstractTextDescriptor.Position)this.textAnchor.getSelectedItem();
        if (pos == AbstractTextDescriptor.Position.BOXED) {
            NodeInst ni;
            this.boxedWidth.setEnabled(true);
            this.boxedWidth.setBackground(Color.WHITE);
            this.boxedHeight.setEnabled(true);
            this.boxedHeight.setBackground(Color.WHITE);
            this.xOffset.setEnabled(false);
            this.yOffset.setEnabled(false);
            if (this.owner instanceof NodeInst && (ni = (NodeInst)this.owner).getProto() == Generic.tech().invisiblePinNode) {
                this.xOffset.setEnabled(true);
                this.yOffset.setEnabled(true);
            }
        } else {
            this.boxedWidth.setEnabled(false);
            this.boxedWidth.setBackground(this.getBackground());
            this.boxedHeight.setEnabled(false);
            this.boxedHeight.setBackground(this.getBackground());
            this.xOffset.setEnabled(true);
            this.yOffset.setEnabled(true);
        }
    }

    private void seeNodeActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        Cell cell = wf.getContent().getCell();
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        if (this.owner instanceof Export) {
            wnd.getHighlighter().addElectricObject(((Export)this.owner).getOriginalPort(), cell);
        } else {
            wnd.getHighlighter().addElectricObject(this.owner, cell);
        }
        wnd.getHighlighter().finished();
    }

    private static class TextInfoDocumentListener
    implements DocumentListener {
        TextInfoPanel dialog;

        TextInfoDocumentListener(TextInfoPanel dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.dialog.fieldChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.dialog.fieldChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.dialog.fieldChanged();
        }
    }

    private static class ChangeText
    extends Job {
        private ElectricObject owner;
        private NodeInst unTransformNi;
        private Variable.Key varKey;
        private Integer absSize;
        private Double relSize;
        private int position;
        private double boxedWidth;
        private double boxedHeight;
        private int rotation;
        private String font;
        private double xoffset;
        private double yoffset;
        private boolean italic;
        private boolean bold;
        private boolean underline;
        private boolean invis;
        private int newColorIndex;

        private ChangeText(ElectricObject owner, NodeInst unTransformNi, Variable.Key varKey, Integer absSize, Double relSize, int position, double boxedWidth, double boxedHeight, int rotation, String font, double xoffset, double yoffset, boolean italic, boolean bold, boolean underline, boolean invis, int newColorIndex) {
            super("Modify Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.unTransformNi = unTransformNi;
            this.varKey = varKey;
            this.absSize = absSize;
            this.relSize = relSize;
            this.position = position;
            this.boxedWidth = boxedWidth;
            this.boxedHeight = boxedHeight;
            this.rotation = rotation;
            this.font = font;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
            this.italic = italic;
            this.bold = bold;
            this.underline = underline;
            this.invis = invis;
            this.newColorIndex = newColorIndex;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst ni;
            MutableTextDescriptor td = this.owner.getMutableTextDescriptor(this.varKey);
            if (td == null) {
                return false;
            }
            if (this.absSize != null) {
                td.setAbsSize(this.absSize);
            } else {
                td.setRelSize(this.relSize);
            }
            AbstractTextDescriptor.Position realPos = AbstractTextDescriptor.Position.getPositionAt(this.position);
            td.setPos(realPos);
            if (this.owner instanceof NodeInst) {
                ni = (NodeInst)this.owner;
                if (realPos == AbstractTextDescriptor.Position.BOXED) {
                    ni.resize(this.boxedWidth - ni.getXSize(), this.boxedHeight - ni.getYSize());
                    if (ni.getProto() == Generic.tech().invisiblePinNode && (ni.getXSize() != 0.0 || ni.getYSize() != 0.0)) {
                        ni.resize(-ni.getXSize(), -ni.getYSize());
                    }
                }
            }
            td.setRotation(AbstractTextDescriptor.Rotation.getRotationAt(this.rotation));
            ni = null;
            if (this.owner != null && this.owner instanceof NodeInst && (ni = (NodeInst)this.owner).getProto() != Generic.tech().invisiblePinNode) {
                ni = null;
            }
            if (ni != null) {
                double dX = this.xoffset - ni.getAnchorCenterX();
                double dY = this.yoffset - ni.getAnchorCenterY();
                ni.move(dX, dY);
            } else {
                if (this.unTransformNi != null) {
                    Point2D.Double off = new Point2D.Double(this.xoffset, this.yoffset);
                    FixpTransform trans = this.unTransformNi.pureRotateIn();
                    trans.transform(off, off);
                    this.xoffset = ((Point2D)off).getX();
                    this.yoffset = ((Point2D)off).getY();
                }
                td.setOff(this.xoffset, this.yoffset);
            }
            td.setInterior(this.invis);
            td.setFaceWithActiveFont(this.font);
            td.setItalic(this.italic);
            td.setBold(this.bold);
            td.setUnderline(this.underline);
            td.setColorIndex(this.newColorIndex);
            this.owner.setTextDescriptor(this.varKey, TextDescriptor.newTextDescriptor(td));
            return true;
        }
    }
}

