/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.FixpRectangle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RectangularShape;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Spread
extends EDialog {
    private NodeInst currentNode;
    private static char defDirection = (char)117;
    private static double defAmount = 1.0;
    private JButton cancel;
    private ButtonGroup direction;
    private JLabel jLabel1;
    private JButton ok;
    private JTextField spreadAmount;
    private JRadioButton spreadDown;
    private JRadioButton spreadLeft;
    private JRadioButton spreadRight;
    private JRadioButton spreadUp;

    public static void showSpreadDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        NodeInst ni = (NodeInst)wnd.getHighlighter().getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        Spread dialog = new Spread((Frame)TopLevel.getCurrentJFrame(), ni);
        dialog.setVisible(true);
    }

    public Spread(Frame parent, NodeInst ni) {
        super(parent, true);
        this.currentNode = ni;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.spreadAmount);
        switch (defDirection) {
            case 'u': {
                this.spreadUp.setSelected(true);
                break;
            }
            case 'd': {
                this.spreadDown.setSelected(true);
                break;
            }
            case 'l': {
                this.spreadLeft.setSelected(true);
                break;
            }
            case 'r': {
                this.spreadRight.setSelected(true);
            }
        }
        this.spreadAmount.setText(TextUtils.formatDistance(defAmount, this.currentNode.getParent().getTechnology()));
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private void rememberDefaults() {
        defDirection = '\u0000';
        if (this.spreadUp.isSelected()) {
            defDirection = (char)117;
        } else if (this.spreadDown.isSelected()) {
            defDirection = (char)100;
        } else if (this.spreadLeft.isSelected()) {
            defDirection = (char)108;
        } else if (this.spreadRight.isSelected()) {
            defDirection = (char)114;
        }
        defAmount = TextUtils.atofDistance(this.spreadAmount.getText(), this.currentNode.getParent().getTechnology());
    }

    private void initComponents() {
        this.direction = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.spreadAmount = new JTextField();
        this.spreadUp = new JRadioButton();
        this.spreadDown = new JRadioButton();
        this.spreadLeft = new JRadioButton();
        this.spreadRight = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spread About Highlighted");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Spread.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Spread.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Spread.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Distance to spread:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.spreadAmount.setColumns(8);
        this.spreadAmount.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadAmount, gridBagConstraints);
        this.spreadUp.setText("Spread up");
        this.direction.add(this.spreadUp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadUp, gridBagConstraints);
        this.spreadDown.setText("Spread down");
        this.direction.add(this.spreadDown);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadDown, gridBagConstraints);
        this.spreadLeft.setText("Spread left");
        this.direction.add(this.spreadLeft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadLeft, gridBagConstraints);
        this.spreadRight.setText("Spread right");
        this.direction.add(this.spreadRight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadRight, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.rememberDefaults();
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.rememberDefaults();
        if (this.currentNode != null) {
            new SpreadJob(this.currentNode, defDirection, defAmount);
        }
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SpreadJob
    extends Job {
        private NodeInst ni;
        private char dir;
        private double amt;

        private SpreadJob(NodeInst ni, char dir2, double amt) {
            super("Spread Circuitry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.dir = dir2;
            this.amt = amt;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            FixpRectangle r = this.ni.getBaseShape().getBounds2D();
            double sLx = ((RectangularShape)r).getMinX();
            double sHx = ((RectangularShape)r).getMaxX();
            double sLy = ((RectangularShape)r).getMinY();
            double sHy = ((RectangularShape)r).getMaxY();
            CircuitChangeJobs.spreadCircuitry(this.ni.getParent(), this.ni, this.dir, this.amt, sLx, sHx, sLy, sHy);
            return true;
        }
    }
}

