/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class OptionReconcile
extends EDialog {
    private Map<Setting, Object> settingsThatChanged;
    private Map<JRadioButton, Setting> changedSettings = new HashMap<JRadioButton, Setting>();
    private List<AbstractButton> currentSettings = new ArrayList<AbstractButton>();
    private FileMenu.ReadLibrary job;
    private JButton ignoreLibraryOptions;
    private JButton ok;
    private JLabel optionHeader;
    private JScrollPane optionPane;
    private JButton useLibraryOptions;

    public static boolean reconcileSettings(Map<String, Object> settingsNondefault, String libName, FileMenu.ReadLibrary job) {
        EDatabase database = EDatabase.clientDatabase();
        Map<Setting, Object> originalSettings = database.getSettings();
        HashMap<Setting, Object> settingsToReconcile = new HashMap<Setting, Object>();
        for (Map.Entry<Setting, Object> e2 : originalSettings.entrySet()) {
            Setting setting = e2.getKey();
            Object oldValue = e2.getValue();
            Object newValue = settingsNondefault.get(setting.getXmlPath());
            if (newValue == null) {
                newValue = setting.getFactoryValue();
            }
            Object factoryValue = setting.getFactoryValue();
            if (newValue.getClass() != factoryValue.getClass()) {
                if (newValue instanceof Integer && factoryValue instanceof Boolean) {
                    newValue = (Integer)newValue != 0;
                } else {
                    if (!(newValue instanceof Float) || !(factoryValue instanceof Double)) continue;
                    newValue = ((Float)newValue).doubleValue();
                }
            }
            if (DBMath.objectsReallyEqual(oldValue, newValue) || !setting.isValidOption()) continue;
            settingsToReconcile.put(setting, newValue);
        }
        if (settingsToReconcile.isEmpty()) {
            return false;
        }
        OptionReconcile dialog = new OptionReconcile(TopLevel.getCurrentJFrame(), originalSettings, settingsToReconcile, libName, job);
        dialog.setVisible(true);
        return true;
    }

    private OptionReconcile(Frame parent, Map<Setting, Object> originalSettings, Map<Setting, Object> settingsThatChanged, String libname, FileMenu.ReadLibrary job) {
        super(parent, true);
        this.settingsThatChanged = settingsThatChanged;
        this.job = job;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        JPanel optionBox = new JPanel();
        optionBox.setLayout(new GridBagLayout());
        this.optionPane.setViewportView(optionBox);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("SETTING"), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("CURRENT VALUE"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("LIBRARY VALUE"), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("SETTING LOCATION"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        optionBox.add((Component)new JSeparator(), gbc);
        int rowNumber = 2;
        for (Map.Entry<Setting, Object> e2 : settingsThatChanged.entrySet()) {
            Object settingValue;
            Setting setting = e2.getKey();
            Object obj = e2.getValue();
            if (obj == null) {
                obj = setting.getFactoryValue();
            }
            if (GenMath.objectsReallyEqual(obj, settingValue = originalSettings.get(setting))) continue;
            Object oldValue = OptionReconcile.getObjectValue(settingValue);
            Object newValue = OptionReconcile.getObjectValue(obj);
            String[] trueMeaning = setting.getTrueMeaning();
            if (settingValue instanceof Boolean) {
                Object object = oldValue = setting.getBoolean() ? "ON" : "OFF";
                boolean b2 = obj instanceof Boolean ? (Boolean)obj : (Integer)obj != 0;
                newValue = b2 ? "ON" : "OFF";
            } else if (trueMeaning != null) {
                oldValue = trueMeaning[setting.getInt()];
                newValue = trueMeaning[(Integer)obj];
            }
            gbc.gridx = 1;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            optionBox.add((Component)new JLabel(setting.getDescription()), gbc);
            gbc.gridx = 2;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            String toolTip = oldValue;
            if (((String)oldValue).length() > 30) {
                oldValue = ((String)oldValue).substring(0, 30) + "...";
            }
            JRadioButton curValue = new JRadioButton((String)oldValue, false);
            curValue.setToolTipText(toolTip);
            this.currentSettings.add(curValue);
            optionBox.add((Component)curValue, gbc);
            gbc.gridx = 3;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            toolTip = newValue;
            if (((String)newValue).length() > 30) {
                newValue = ((String)newValue).substring(0, 30) + "...";
            }
            JRadioButton libValue = new JRadioButton((String)newValue, true);
            libValue.setToolTipText(toolTip);
            this.changedSettings.put(libValue, setting);
            optionBox.add((Component)libValue, gbc);
            ButtonGroup group = new ButtonGroup();
            group.add(curValue);
            group.add(libValue);
            gbc.gridx = 4;
            gbc.gridy = rowNumber++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            optionBox.add((Component)new JLabel(setting.getLocation()), gbc);
        }
        this.optionHeader.setText("Library \"" + libname + "\" wants to use the following project preferences which differ from the current project preferences");
        this.pack();
        this.finishInitialization();
    }

    private void termDialog() {
        HashMap<Setting, Object> settingsToReconcile = new HashMap<Setting, Object>();
        for (JRadioButton cb : this.changedSettings.keySet()) {
            if (!cb.isSelected()) continue;
            Setting setting = this.changedSettings.get(cb);
            settingsToReconcile.put(setting, this.settingsThatChanged.get(setting));
        }
        new DoReconciliation(settingsToReconcile, this.job);
    }

    private static String getObjectValue(Object o2) {
        if (o2 instanceof Double) {
            double d2 = (Double)o2;
            return TextUtils.formatDouble(d2);
        }
        if (o2 instanceof Float) {
            float f2 = ((Float)o2).floatValue();
            return TextUtils.formatDouble(f2);
        }
        return o2.toString();
    }

    private void initComponents() {
        this.ok = new JButton();
        this.optionPane = new JScrollPane();
        this.optionHeader = new JLabel();
        this.ignoreLibraryOptions = new JButton();
        this.useLibraryOptions = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Project Preferences Reconciliation");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionReconcile.this.closeDialog(evt);
            }
        });
        this.ok.setText("Use Above Settings");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ok(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.optionPane.setMinimumSize(new Dimension(500, 150));
        this.optionPane.setPreferredSize(new Dimension(650, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionPane, gridBagConstraints);
        this.optionHeader.setText("The new Project Preferences are different from the current Project Preferences:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionHeader, gridBagConstraints);
        this.ignoreLibraryOptions.setText("Use All Current Settings");
        this.ignoreLibraryOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ignoreLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignoreLibraryOptions, gridBagConstraints);
        this.useLibraryOptions.setText("Use All New Settings");
        this.useLibraryOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.useLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.useLibraryOptions, gridBagConstraints);
        this.pack();
    }

    private void useLibraryOptionsActionPerformed(ActionEvent evt) {
        for (JRadioButton b2 : this.changedSettings.keySet()) {
            b2.setSelected(true);
        }
        this.ok(null);
    }

    private void ignoreLibraryOptionsActionPerformed(ActionEvent evt) {
        for (AbstractButton b2 : this.currentSettings) {
            b2.setSelected(true);
        }
        this.ok(null);
    }

    private void ok(ActionEvent evt) {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class DoReconciliation
    extends Job {
        private Map<String, Object> settingsToSerialize = new HashMap<String, Object>();
        private transient FileMenu.ReadLibrary job;

        private DoReconciliation(Map<Setting, Object> settingsToReconcile, FileMenu.ReadLibrary job) {
            super("Reconcile Project Preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.job = job;
            for (Map.Entry<Setting, Object> e2 : settingsToReconcile.entrySet()) {
                Setting setting = e2.getKey();
                Object newValue = e2.getValue();
                this.settingsToSerialize.put(setting.getXmlPath(), newValue);
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Setting.SettingChangeBatch reconcileBatch = new Setting.SettingChangeBatch();
            for (Setting setting : this.getDatabase().getSettings().keySet()) {
                String xmlPath = setting.getXmlPath();
                if (!this.settingsToSerialize.containsKey(xmlPath)) continue;
                reconcileBatch.add(setting, this.settingsToSerialize.get(xmlPath));
            }
            this.getDatabase().implementSettingChanges(reconcileBatch);
            return true;
        }

        @Override
        public void terminateOK() {
            this.getDatabase().getEnvironment().saveToPreferences();
            this.job.startJob();
        }
    }
}

