/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.BatchChanges;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class Change
extends EModelessDialog
implements HighlightListener {
    private static final int CHANGE_SELECTED = 1;
    private static final int CHANGE_CONNECTED = 2;
    private static final int CHANGE_CELL = 3;
    private static final int CHANGE_LIBRARY = 4;
    private static final int CHANGE_EVERYWHERE = 5;
    private static Change theDialog = null;
    private static boolean lastChangeNodesWithArcs = false;
    private static boolean lastIgnorePortNames = false;
    private static boolean lastAllowMissingPorts = false;
    private static boolean lastPreserveParameters = true;
    private static boolean lastEvaluateNumbers = true;
    private static int whatToChange = 1;
    private static String libSelected = null;
    private static Map<PrimitiveNode, Map<PrimitiveNode.Function, String>> specialSchematics = null;
    private DefaultMutableTreeNode rootNode;
    private DefaultMutableTreeNode rootCells;
    private DefaultMutableTreeNode rootPrims;
    private DefaultMutableTreeNode rootArcs;
    private DefaultMutableTreeNode currentlySelected;
    private DefaultTreeModel treeModel;
    private JTree changeTree;
    private List<Geometric> geomsToChange;
    private Map<DefaultMutableTreeNode, NodeProto> changeNodeProtoList;
    private Map<DefaultMutableTreeNode, ArcProto> changeArcProtoList;
    private Map<DefaultMutableTreeNode, PrimitiveNode.Function> changeNodeProtoFunctionList;
    private EditWindow wnd;
    private static final Pattern dummyName = Pattern.compile("(.*?)FROM(.*?)\\{(.*)");
    private boolean dontReload = false;
    private JCheckBox allowMissingPorts;
    private JButton apply;
    private JRadioButton changeConnected;
    private JLabel changeCount;
    private JRadioButton changeEverywhere;
    private JRadioButton changeInCell;
    private JRadioButton changeInLibrary;
    private JCheckBox changeNodesWithArcs;
    private ButtonGroup changeOption;
    private JRadioButton changeSelected;
    private JCheckBox preserveParameters;
    private JButton done;
    private JCheckBox evaluateNumbers;
    private JCheckBox ignorePortNames;
    private JLabel jLabel1;
    private JComboBox librariesPopup;
    private JScrollPane listPane;
    private JCheckBox showCells;
    private JCheckBox showPrimitives;

    public static void showChangeDialog() {
        if (ClientOS.isOSLinux() && theDialog != null) {
            theDialog.closeDialog(null);
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new Change(jf);
        }
        theDialog.loadInfo(true);
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    private void setupSpecialPrimitives() {
        if (specialSchematics != null) {
            return;
        }
        specialSchematics = new HashMap<PrimitiveNode, Map<PrimitiveNode.Function, String>>();
        HashMap<PrimitiveNode.Function, String> specialTransistor = new HashMap<PrimitiveNode.Function, String>();
        HashMap<PrimitiveNode.Function, String> special4Transistor = new HashMap<PrimitiveNode.Function, String>();
        List<PrimitiveNode.Function> functions = PrimitiveNode.Function.getFunctions();
        for (PrimitiveNode.Function fun : functions) {
            if (!fun.isTransistor()) continue;
            PrimitiveNode.Function altFun = fun.make3PortTransistor();
            if (altFun != null) {
                special4Transistor.put(fun, fun.getShortName());
                continue;
            }
            specialTransistor.put(fun, fun.getShortName());
        }
        specialSchematics.put(Schematics.tech().transistorNode, specialTransistor);
        specialSchematics.put(Schematics.tech().transistor4Node, special4Transistor);
        HashMap<PrimitiveNode.Function, String> specialResistor = new HashMap<PrimitiveNode.Function, String>();
        specialResistor.put(PrimitiveNode.Function.RESIST, "normal");
        specialResistor.put(PrimitiveNode.Function.RESISTBIAS, "bias");
        specialResistor.put(PrimitiveNode.Function.RESNPOLY, "n-poly");
        specialResistor.put(PrimitiveNode.Function.RESPPOLY, "p-poly");
        specialResistor.put(PrimitiveNode.Function.RESNNSPOLY, "n-poly-no-silicide");
        specialResistor.put(PrimitiveNode.Function.RESPNSPOLY, "p-poly-no-silicide");
        specialResistor.put(PrimitiveNode.Function.RESNWELL, "n-well");
        specialResistor.put(PrimitiveNode.Function.RESPWELL, "p-well");
        specialResistor.put(PrimitiveNode.Function.RESNACTIVE, "n-active");
        specialResistor.put(PrimitiveNode.Function.RESPACTIVE, "p-active");
        specialResistor.put(PrimitiveNode.Function.RESHIRESPOLY2, "hi-res-poly-2");
        specialSchematics.put(Schematics.tech().resistorNode, specialResistor);
        HashMap<PrimitiveNode.Function, String> specialDiode = new HashMap<PrimitiveNode.Function, String>();
        specialDiode.put(PrimitiveNode.Function.DIODE, "normal");
        specialDiode.put(PrimitiveNode.Function.DIODEZ, "zener");
        specialSchematics.put(Schematics.tech().diodeNode, specialDiode);
        HashMap<PrimitiveNode.Function, String> specialCapacitor = new HashMap<PrimitiveNode.Function, String>();
        specialCapacitor.put(PrimitiveNode.Function.CAPAC, "normal");
        specialCapacitor.put(PrimitiveNode.Function.ECAPAC, "electrolytic");
        specialCapacitor.put(PrimitiveNode.Function.POLY2CAPAC, "poly-2");
        specialSchematics.put(Schematics.tech().capacitorNode, specialCapacitor);
        HashMap<PrimitiveNode.Function, String> specialFlipFlop = new HashMap<PrimitiveNode.Function, String>();
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPRSMS, "RS-ms");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPRSP, "RS-p");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPRSN, "RS-n");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPJKMS, "JK-ms");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPJKP, "JK-p");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPJKN, "JK-n");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPDMS, "D-ms");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPDP, "D-p");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPDN, "D-n");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPTMS, "T-ms");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPTP, "T-p");
        specialFlipFlop.put(PrimitiveNode.Function.FLIPFLOPTN, "T-n");
        specialSchematics.put(Schematics.tech().flipflopNode, specialFlipFlop);
        HashMap<PrimitiveNode.Function, String> specialTwoport = new HashMap<PrimitiveNode.Function, String>();
        specialTwoport.put(PrimitiveNode.Function.VCCS, PrimitiveNode.Function.VCCS.getShortName());
        specialTwoport.put(PrimitiveNode.Function.CCVS, PrimitiveNode.Function.CCVS.getShortName());
        specialTwoport.put(PrimitiveNode.Function.VCVS, PrimitiveNode.Function.VCVS.getShortName());
        specialTwoport.put(PrimitiveNode.Function.CCCS, PrimitiveNode.Function.CCCS.getShortName());
        specialTwoport.put(PrimitiveNode.Function.TLINE, "transmission");
        specialSchematics.put(Schematics.tech().twoportNode, specialTwoport);
    }

    private Change(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.apply.setMnemonic('A');
        this.done.setMnemonic('D');
        this.setupSpecialPrimitives();
        this.currentlySelected = null;
        this.rootNode = new DefaultMutableTreeNode("");
        this.rootCells = new DefaultMutableTreeNode("Cells");
        this.rootPrims = new DefaultMutableTreeNode("Primitives");
        this.rootArcs = new DefaultMutableTreeNode("Arcs");
        this.rootNode.add(this.rootCells);
        this.rootNode.add(this.rootPrims);
        this.rootNode.add(this.rootArcs);
        this.treeModel = new MyDefaultTreeModel(this.rootNode);
        this.changeTree = new JTree(this.treeModel);
        this.changeTree.setRootVisible(false);
        this.changeTree.setShowsRootHandles(true);
        this.changeTree.addMouseListener(new TreeHandler());
        this.listPane.setViewportView(this.changeTree);
        this.changeNodeProtoList = new HashMap<DefaultMutableTreeNode, NodeProto>();
        this.changeArcProtoList = new HashMap<DefaultMutableTreeNode, ArcProto>();
        this.changeNodeProtoFunctionList = new HashMap<DefaultMutableTreeNode, PrimitiveNode.Function>();
        List<Library> libList = Library.getVisibleLibraries();
        int curIndex = libList.indexOf(Library.getCurrent());
        for (Library lib : libList) {
            this.librariesPopup.addItem(lib.getName());
            if (!lib.getName().equals(libSelected)) continue;
            curIndex = -1;
            this.librariesPopup.setSelectedItem(libSelected);
        }
        if (curIndex >= 0) {
            this.librariesPopup.setSelectedIndex(curIndex);
        }
        this.librariesPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.ignorePortNames.setSelected(lastIgnorePortNames);
        this.allowMissingPorts.setSelected(lastAllowMissingPorts);
        this.preserveParameters.setSelected(lastPreserveParameters);
        this.evaluateNumbers.setSelected(lastEvaluateNumbers);
        this.ignorePortNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.allowMissingPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.preserveParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.evaluateNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
                Change.this.reload(false);
            }
        });
        this.showPrimitives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.showCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeNodesWithArcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeConnected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        switch (whatToChange) {
            case 1: {
                this.changeSelected.setSelected(true);
                break;
            }
            case 2: {
                this.changeConnected.setSelected(true);
                break;
            }
            case 3: {
                this.changeInCell.setSelected(true);
                break;
            }
            case 4: {
                this.changeInLibrary.setSelected(true);
                break;
            }
            case 5: {
                this.changeEverywhere.setSelected(true);
            }
        }
        this.finishInitialization();
        Highlighter.addHighlightListener(this);
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(true);
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(false);
    }

    @Override
    protected void escapePressed() {
        this.done(null);
    }

    private void whatToChangeChanged(ActionEvent evt) {
        JRadioButton src = (JRadioButton)evt.getSource();
        if (src == this.changeSelected) {
            whatToChange = 1;
        } else if (src == this.changeConnected) {
            whatToChange = 2;
        } else if (src == this.changeInCell) {
            whatToChange = 3;
        } else if (src == this.changeInLibrary) {
            whatToChange = 4;
        } else if (src == this.changeEverywhere) {
            whatToChange = 5;
        }
        Geometric geomToChange = this.geomsToChange.get(0);
        if (whatToChange == 5) {
            if (geomToChange instanceof ArcInst) {
                if (this.changeNodesWithArcs.isSelected()) {
                    this.changeNodesWithArcs.setSelected(false);
                    this.reload(false);
                }
                this.changeNodesWithArcs.setEnabled(false);
            }
        } else if (geomToChange instanceof ArcInst) {
            this.changeNodesWithArcs.setEnabled(true);
        }
        this.updateChangeCount();
    }

    private void countAllArcs(Cell cell, List<Geometric> highs, ArcInst oldAi, boolean connected, boolean thiscell, Set<Geometric> changedAlready) {
        Iterator<Geometric> it;
        ArcInst ai;
        ArrayList<NodeInst> changePins = new ArrayList<NodeInst>();
        for (Geometric geom : highs) {
            if (!(geom instanceof ArcInst) || (ai = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
            changedAlready.add(ai);
        }
        if (connected) {
            Netlist netlist = cell.getNetlist();
            Iterator<ArcInst> it2 = cell.getArcs();
            while (it2.hasNext()) {
                ai = it2.next();
                if (ai.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai, oldAi)) continue;
                changedAlready.add(ai);
            }
        }
        if (thiscell) {
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai2 = (ArcInst)it.next();
                if (ai2.getProto() != oldAi.getProto()) continue;
                changedAlready.add(ai2);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.isCellInstance() || !ni.getFunction().isPin()) continue;
            boolean allArcs = true;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                if (changedAlready.contains(con.getArc())) continue;
                allArcs = false;
                break;
            }
            if (!ni.hasConnections() || !allArcs) continue;
            changePins.add(ni);
        }
    }

    private void updateChangeCount() {
        HashSet<Geometric> changedAlready = new HashSet<Geometric>();
        Cell cell = WindowFrame.getCurrentCell();
        String toChange = "";
        for (Geometric geomToChange : this.geomsToChange) {
            Iterator<ElectricObject> it;
            Netlist netlist;
            Iterator<Geometric> nIt;
            Cell c2;
            Iterator<Cell> cIt;
            Library lib;
            Iterator<Geometric> nIt2;
            Iterator<Cell> cIt2;
            Library lib2;
            Iterator<Library> it2;
            if (geomToChange instanceof NodeInst) {
                toChange = "nodes";
                NodeInst ni = (NodeInst)geomToChange;
                NodeProto oldNType = ni.getProto();
                changedAlready.add(ni);
                if (this.changeEverywhere.isSelected()) {
                    it2 = Library.getLibraries();
                    while (it2.hasNext()) {
                        lib2 = it2.next();
                        cIt2 = lib2.getCells();
                        while (cIt2.hasNext()) {
                            Cell c3 = cIt2.next();
                            nIt2 = c3.getNodes();
                            while (nIt2.hasNext()) {
                                NodeInst lNi = nIt2.next();
                                if (lNi.getProto() != oldNType) continue;
                                changedAlready.add(lNi);
                            }
                        }
                    }
                    continue;
                }
                if (this.changeInLibrary.isSelected()) {
                    lib = cell.getLibrary();
                    cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        c2 = cIt.next();
                        Iterator<NodeInst> nIt3 = c2.getNodes();
                        while (nIt3.hasNext()) {
                            NodeInst lNi = nIt3.next();
                            if (lNi.getProto() != oldNType) continue;
                            changedAlready.add(lNi);
                        }
                    }
                    continue;
                }
                if (this.changeInCell.isSelected()) {
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst lNi = nIt.next();
                        if (lNi.getProto() != oldNType) continue;
                        changedAlready.add(lNi);
                    }
                    continue;
                }
                if (!this.changeConnected.isSelected()) continue;
                netlist = cell.getNetlist();
                it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst lNi = (NodeInst)it.next();
                    if (lNi.getProto() != oldNType) continue;
                    boolean found = false;
                    Iterator<PortInst> pIt = ni.getPortInsts();
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        Iterator<PortInst> lPIt = lNi.getPortInsts();
                        while (lPIt.hasNext()) {
                            PortInst lPi = lPIt.next();
                            if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    changedAlready.add(lNi);
                }
                continue;
            }
            toChange = "arcs";
            ArcInst ai = (ArcInst)geomToChange;
            ArcProto oldAType = ai.getProto();
            if (this.changeNodesWithArcs.isSelected()) {
                List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
                if (this.changeInLibrary.isSelected()) {
                    it = Library.getCurrent().getCells();
                    while (it.hasNext()) {
                        Cell e2 = it.next();
                        this.countAllArcs(e2, highs, ai, false, true, changedAlready);
                    }
                    continue;
                }
                this.countAllArcs(ai.getParent(), highs, ai, this.changeConnected.isSelected(), this.changeInCell.isSelected(), changedAlready);
                continue;
            }
            changedAlready.add(ai);
            if (this.changeEverywhere.isSelected()) {
                it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    lib2 = it2.next();
                    cIt2 = lib2.getCells();
                    while (cIt2.hasNext()) {
                        Cell c4 = cIt2.next();
                        nIt2 = c4.getArcs();
                        while (nIt2.hasNext()) {
                            ArcInst lAi = (ArcInst)nIt2.next();
                            if (lAi.getProto() != oldAType) continue;
                            changedAlready.add(lAi);
                        }
                    }
                }
                continue;
            }
            if (this.changeInLibrary.isSelected()) {
                lib = Library.getCurrent();
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    c2 = cIt.next();
                    Iterator<ArcInst> nIt4 = c2.getArcs();
                    while (nIt4.hasNext()) {
                        ArcInst lAi = nIt4.next();
                        if (lAi.getProto() != oldAType) continue;
                        changedAlready.add(lAi);
                    }
                }
                continue;
            }
            if (this.changeInCell.isSelected()) {
                nIt = cell.getArcs();
                while (nIt.hasNext()) {
                    ArcInst lAi = (ArcInst)nIt.next();
                    if (lAi.getProto() != oldAType) continue;
                    changedAlready.add(lAi);
                }
                continue;
            }
            if (!this.changeConnected.isSelected()) continue;
            netlist = cell.getNetlist();
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst lAi = (ArcInst)it.next();
                if (!netlist.sameNetwork(ai, lAi)) continue;
                changedAlready.add(lAi);
            }
        }
        int num = changedAlready.size();
        this.changeCount.setText("Selected " + num + " " + toChange);
    }

    private void loadInfo(boolean showHighlighted) {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null) {
            this.wnd = curWnd;
        }
        this.geomsToChange = new ArrayList<Geometric>();
        if (this.wnd != null) {
            List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
            boolean hasArcs = false;
            boolean hasCells = false;
            boolean hasPrimitives = false;
            for (Geometric geom : highs) {
                this.geomsToChange.add(geom);
                if (geom instanceof ArcInst) {
                    hasArcs = true;
                    continue;
                }
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) {
                    hasCells = true;
                    continue;
                }
                hasPrimitives = true;
            }
            if (hasArcs && hasCells) {
                System.out.println("The 'Change' dialog cannot handle selection of both arcs and cells.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            } else if (hasArcs && hasPrimitives) {
                System.out.println("The 'Change' dialog cannot handle selection of both arcs and primitives.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            } else if (hasCells && hasPrimitives) {
                System.out.println("The 'Change' dialog cannot handle selection of both cells and primitives.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            }
        }
        if (this.geomsToChange.size() == 0) {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.preserveParameters.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(false);
            this.apply.setEnabled(false);
            this.changeSelected.setEnabled(false);
            this.changeConnected.setEnabled(false);
            this.changeInCell.setEnabled(false);
            this.changeInLibrary.setEnabled(false);
            this.changeEverywhere.setEnabled(false);
            return;
        }
        this.apply.setEnabled(true);
        this.changeSelected.setEnabled(true);
        this.changeConnected.setEnabled(true);
        this.changeInCell.setEnabled(true);
        this.changeInLibrary.setEnabled(true);
        this.changeEverywhere.setEnabled(true);
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            this.librariesPopup.setEnabled(true);
            this.ignorePortNames.setEnabled(true);
            this.allowMissingPorts.setEnabled(true);
            this.preserveParameters.setEnabled(true);
            this.showPrimitives.setEnabled(true);
            this.showCells.setEnabled(true);
            NodeInst ni = (NodeInst)geomToChange;
            if (ni.isCellInstance()) {
                this.showCells.setSelected(true);
            } else {
                this.showPrimitives.setSelected(true);
            }
            this.changeNodesWithArcs.setSelected(false);
            this.changeNodesWithArcs.setEnabled(false);
        } else {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.preserveParameters.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(true);
            this.changeNodesWithArcs.setSelected(lastChangeNodesWithArcs);
        }
        this.reload(true);
    }

    private void rememberState() {
        lastIgnorePortNames = this.ignorePortNames.isSelected();
        lastAllowMissingPorts = this.allowMissingPorts.isSelected();
        lastPreserveParameters = this.preserveParameters.isSelected();
        lastEvaluateNumbers = this.evaluateNumbers.isSelected();
    }

    private void reload(boolean canSwitchLibraries) {
        ExplorerTree.KeepTreeExpansion kte;
        block24: {
            Technology arcTech;
            ArcProto ap;
            Geometric geomToChange;
            Technology curTech;
            block23: {
                String geomName;
                Matcher mat;
                lastChangeNodesWithArcs = this.changeNodesWithArcs.isSelected();
                if (this.dontReload) {
                    return;
                }
                kte = new ExplorerTree.KeepTreeExpansion(this.changeTree, this.rootNode, this.treeModel, new TreePath(this.rootNode));
                this.rootCells.removeAllChildren();
                this.rootPrims.removeAllChildren();
                this.rootArcs.removeAllChildren();
                this.changeNodeProtoList.clear();
                this.changeArcProtoList.clear();
                this.changeNodeProtoFunctionList.clear();
                if (this.geomsToChange.size() == 0) {
                    return;
                }
                curTech = Technology.getCurrent();
                geomToChange = this.geomsToChange.get(0);
                if (!(geomToChange instanceof NodeInst)) break block23;
                NodeInst ni = (NodeInst)geomToChange;
                if (this.showCells.isSelected()) {
                    if (ni.isCellInstance() && canSwitchLibraries) {
                        Cell parent = (Cell)ni.getProto();
                        Library lib = parent.getLibrary();
                        this.dontReload = true;
                        this.librariesPopup.setSelectedItem(lib.getName());
                        this.dontReload = false;
                    }
                    Object origView = null;
                    if (ni.isCellInstance()) {
                        origView = ((Cell)ni.getProto()).getView();
                    }
                    String libName = (String)this.librariesPopup.getSelectedItem();
                    Library lib = Library.findLibrary(libName);
                    ArrayList<Cell> cellsToShow = new ArrayList<Cell>();
                    Iterator<Object> it = lib.getCells();
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        if (origView != null && (origView == View.ICON ? cell.getView() != View.ICON : (origView == View.LAYOUT || origView == View.LAYOUTCOMP || origView == View.LAYOUTSKEL) && cell.getView() != View.LAYOUT && cell.getView() != View.LAYOUTCOMP && cell.getView() != View.LAYOUTSKEL)) continue;
                        cellsToShow.add(cell);
                    }
                    if (this.evaluateNumbers.isSelected()) {
                        Collections.sort(cellsToShow, new Comparator<Cell>(){

                            @Override
                            public int compare(Cell c1, Cell c2) {
                                return TextUtils.STRING_NUMBER_ORDER.compare(c1.getName(), c2.getName());
                            }
                        });
                    } else {
                        Collections.sort(cellsToShow, new TextUtils.CellsByName());
                    }
                    for (Cell cell : cellsToShow) {
                        DefaultMutableTreeNode dmtn2 = new DefaultMutableTreeNode(cell.noLibDescribe());
                        this.rootCells.add(dmtn2);
                        this.changeNodeProtoList.put(dmtn2, cell);
                    }
                }
                if (this.showPrimitives.isSelected()) {
                    for (PrimitiveNode np : curTech.getNodesSortedByName()) {
                        if (np.isNotUsed()) continue;
                        Map<PrimitiveNode.Function, String> specialList = specialSchematics.get(np);
                        if (specialList != null) {
                            TreeMap<String, PrimitiveNode.Function> subNames = new TreeMap<String, PrimitiveNode.Function>();
                            for (PrimitiveNode.Function function : specialList.keySet()) {
                                subNames.put(specialList.get((Object)function), function);
                            }
                            DefaultMutableTreeNode subPrims = new DefaultMutableTreeNode(np.describe(false));
                            this.rootPrims.add(subPrims);
                            for (String subName : subNames.keySet()) {
                                PrimitiveNode.Function fun3 = (PrimitiveNode.Function)((Object)subNames.get(subName));
                                DefaultMutableTreeNode dmtn3 = new DefaultMutableTreeNode(subName);
                                subPrims.add(dmtn3);
                                this.changeNodeProtoList.put(dmtn3, np);
                                this.changeNodeProtoFunctionList.put(dmtn3, fun3);
                            }
                            continue;
                        }
                        DefaultMutableTreeNode dmtn4 = new DefaultMutableTreeNode(np.describe(false));
                        this.rootPrims.add(dmtn4);
                        this.changeNodeProtoList.put(dmtn4, np);
                    }
                    if (curTech != Generic.tech()) {
                        Object dmtn5 = new DefaultMutableTreeNode("Generic:Universal-Pin");
                        this.rootPrims.add((MutableTreeNode)dmtn5);
                        this.changeNodeProtoList.put((DefaultMutableTreeNode)dmtn5, Generic.tech().universalPinNode);
                        dmtn5 = new DefaultMutableTreeNode("Generic:Invisible-Pin");
                        this.rootPrims.add((MutableTreeNode)dmtn5);
                        this.changeNodeProtoList.put((DefaultMutableTreeNode)dmtn5, Generic.tech().invisiblePinNode);
                        dmtn5 = new DefaultMutableTreeNode("Generic:Unrouted-Pin");
                        this.rootPrims.add((MutableTreeNode)dmtn5);
                        this.changeNodeProtoList.put((DefaultMutableTreeNode)dmtn5, Generic.tech().unroutedPinNode);
                    }
                }
                for (DefaultMutableTreeNode dmtn6 : this.changeNodeProtoList.keySet()) {
                    NodeProto np = this.changeNodeProtoList.get(dmtn6);
                    PrimitiveNode.Function fun = this.changeNodeProtoFunctionList.get(dmtn6);
                    if (np != ni.getProto()) continue;
                    TreePath path = new TreePath(this.rootNode);
                    path = ni.isCellInstance() ? path.pathByAddingChild(this.rootCells) : path.pathByAddingChild(this.rootPrims);
                    if (fun != null) {
                        if (ni.getFunction() != fun) continue;
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)dmtn6.getParent();
                        path = path.pathByAddingChild(defaultMutableTreeNode);
                    }
                    path = path.pathByAddingChild(dmtn6);
                    this.changeTree.expandPath(path);
                    this.changeTree.setSelectionPath(path);
                    this.currentlySelected = dmtn6;
                    SwingUtilities.invokeLater(new MyRunnable(path));
                    break;
                }
                if (!this.showCells.isSelected() || !(mat = dummyName.matcher(geomName = ((NodeInst)geomToChange).getProto().describe(false))).matches()) break block24;
                this.librariesPopup.setSelectedItem(mat.group(2));
                break block24;
            }
            ArcInst ai = (ArcInst)geomToChange;
            PortProto pp1 = ai.getHeadPortInst().getPortProto();
            PortProto pp2 = ai.getTailPortInst().getPortProto();
            Iterator<ArcProto> it = curTech.getArcs();
            while (it.hasNext()) {
                ap = it.next();
                if (ap.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                DefaultMutableTreeNode dmtn8 = new DefaultMutableTreeNode(ap.describe());
                this.rootArcs.add(dmtn8);
                this.changeArcProtoList.put(dmtn8, ap);
            }
            if (curTech != Generic.tech()) {
                it = Generic.tech().getArcs();
                while (it.hasNext()) {
                    ap = it.next();
                    if (ap.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                    DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(ap.describe());
                    this.rootArcs.add(dmtn);
                    this.changeArcProtoList.put(dmtn, ap);
                }
            }
            if ((arcTech = ai.getProto().getTechnology()) != curTech && arcTech != Generic.tech()) {
                Iterator<ArcProto> it2 = arcTech.getArcs();
                while (it2.hasNext()) {
                    ArcProto ap2 = it2.next();
                    if (ap2.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap2) || !pp2.connectsTo(ap2))) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ap2.describe());
                    this.rootArcs.add(defaultMutableTreeNode);
                    this.changeArcProtoList.put(defaultMutableTreeNode, ap2);
                }
            }
            for (DefaultMutableTreeNode dmtn : this.changeArcProtoList.keySet()) {
                ArcProto arcProto = this.changeArcProtoList.get(dmtn);
                if (arcProto != ai.getProto()) continue;
                TreePath path = new TreePath(this.rootNode);
                path = path.pathByAddingChild(this.rootArcs);
                path = path.pathByAddingChild(dmtn);
                this.changeTree.expandPath(path);
                this.changeTree.setSelectionPath(path);
                this.currentlySelected = dmtn;
                SwingUtilities.invokeLater(new MyRunnable(path));
                break;
            }
        }
        this.changeTree.updateUI();
        kte.restore();
        this.updateChangeCount();
    }

    private void doTheChange(EditingPreferences ep) {
        if (this.geomsToChange.size() == 0) {
            return;
        }
        NodeProto np = null;
        ArcProto ap = null;
        PrimitiveNode.Function func = null;
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            np = this.changeNodeProtoList.get(this.currentlySelected);
            if (np == null) {
                System.out.println("Nothing to change");
                return;
            }
            func = this.changeNodeProtoFunctionList.get(this.currentlySelected);
        } else {
            ap = this.changeArcProtoList.get(this.currentlySelected);
            if (ap == null) {
                System.out.println("Nothing is selected");
                return;
            }
        }
        List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
        new ChangeObject(ep, this.geomsToChange, highs, this.getLibSelected(), np, func, ap, this.ignorePortNames.isSelected(), this.allowMissingPorts.isSelected(), this.preserveParameters.isSelected(), this.changeNodesWithArcs.isSelected(), this.changeInCell.isSelected(), this.changeInLibrary.isSelected(), this.changeEverywhere.isSelected(), this.changeConnected.isSelected());
    }

    private String getLibSelected() {
        return (String)this.librariesPopup.getSelectedItem();
    }

    private void initComponents() {
        this.changeOption = new ButtonGroup();
        this.done = new JButton();
        this.apply = new JButton();
        this.listPane = new JScrollPane();
        this.changeSelected = new JRadioButton();
        this.changeConnected = new JRadioButton();
        this.changeInCell = new JRadioButton();
        this.changeInLibrary = new JRadioButton();
        this.changeEverywhere = new JRadioButton();
        this.changeNodesWithArcs = new JCheckBox();
        this.showPrimitives = new JCheckBox();
        this.showCells = new JCheckBox();
        this.ignorePortNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.librariesPopup = new JComboBox();
        this.allowMissingPorts = new JCheckBox();
        this.changeCount = new JLabel();
        this.evaluateNumbers = new JCheckBox();
        this.preserveParameters = new JCheckBox();
        this.setTitle("Change");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Change.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.apply.setText("Change");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Change.this.apply(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(150, 22));
        this.listPane.setPreferredSize(new Dimension(250, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.changeOption.add(this.changeSelected);
        this.changeSelected.setText("Change selected ones only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.changeSelected, gridBagConstraints);
        this.changeOption.add(this.changeConnected);
        this.changeConnected.setText("Change all connected to this");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeConnected, gridBagConstraints);
        this.changeOption.add(this.changeInCell);
        this.changeInCell.setText("Change all in this cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInCell, gridBagConstraints);
        this.changeOption.add(this.changeInLibrary);
        this.changeInLibrary.setText("Change all in this library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInLibrary, gridBagConstraints);
        this.changeOption.add(this.changeEverywhere);
        this.changeEverywhere.setText("Change all in all libraries");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 10, 4);
        this.getContentPane().add((Component)this.changeEverywhere, gridBagConstraints);
        this.changeNodesWithArcs.setText("Change nodes with arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 2, 4);
        this.getContentPane().add((Component)this.changeNodesWithArcs, gridBagConstraints);
        this.showPrimitives.setText("Show primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.showPrimitives, gridBagConstraints);
        this.showCells.setText("Show cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.showCells, gridBagConstraints);
        this.ignorePortNames.setText("Ignore port names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.ignorePortNames, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.librariesPopup, gridBagConstraints);
        this.allowMissingPorts.setText("Allow missing ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.allowMissingPorts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.changeCount, gridBagConstraints);
        this.evaluateNumbers.setText("Evaluate numbers when sorting names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        this.getContentPane().add((Component)this.evaluateNumbers, gridBagConstraints);
        this.preserveParameters.setText("Preserve parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.getContentPane().add((Component)this.preserveParameters, gridBagConstraints);
        this.pack();
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void apply(ActionEvent evt) {
        this.doTheChange(UserInterfaceMain.getEditingPreferences());
        libSelected = (String)this.librariesPopup.getSelectedItem();
    }

    private void closeDialog(WindowEvent evt) {
        Highlighter.removeHighlightListener(this);
        this.setVisible(false);
        this.dispose();
        theDialog = null;
    }

    private class MyDefaultTreeModel
    extends DefaultTreeModel {
        MyDefaultTreeModel(DefaultMutableTreeNode dmtn) {
            super(dmtn);
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == Change.this.rootArcs || node == Change.this.rootCells || node == Change.this.rootPrims) {
                return false;
            }
            return super.isLeaf(node);
        }
    }

    private class TreeHandler
    implements MouseListener {
        private TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                Change.this.apply(null);
                return;
            }
            Change.this.currentlySelected = null;
            TreePath currentPath = Change.this.changeTree.getPathForLocation(e2.getX(), e2.getY());
            if (currentPath == null) {
                return;
            }
            Change.this.currentlySelected = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
        }
    }

    private class MyRunnable
    implements Runnable {
        private TreePath path;

        MyRunnable(TreePath path) {
            this.path = path;
        }

        @Override
        public void run() {
            Change.this.changeTree.scrollPathToVisible(this.path);
        }
    }

    private static class ChangeObject
    extends Job {
        private List<Geometric> geomsToChange;
        private List<Geometric> highs;
        private String libName;
        private NodeProto np;
        private ArcProto ap;
        private Cell cell;
        private boolean ignorePortNames;
        private boolean allowMissingPorts;
        private boolean preserveParameters;
        private boolean changeNodesWithArcs;
        private boolean changeInCell;
        private boolean changeInLibrary;
        private boolean changeEverywhere;
        private boolean changeConnected;
        private PrimitiveNode.Function func;
        private List<Geometric> highlightThese;
        private List<NodeInst.ChangeError> replacementErrors;
        private List<NodeInst> nodesToExpand = new ArrayList<NodeInst>();
        private Map<NodeInst, BatchChanges.NodeReplacement> replacements = new LinkedHashMap<NodeInst, BatchChanges.NodeReplacement>();
        private NodeProto[] contactStack = new NodeProto[100];
        private ArcProto[] contactStackArc = new ArcProto[100];
        private Technology connectionTech = null;
        private Map<ArcProto, Map<ArcProto, PrimitivePort>> connectionMap;

        private ChangeObject(EditingPreferences ep, List<Geometric> geomsToChange, List<Geometric> highs, String libName, NodeProto np, PrimitiveNode.Function func, ArcProto ap, boolean ignorePortNames, boolean allowMissingPorts, boolean preserveParameters, boolean changeNodesWithArcs, boolean changeInCell, boolean changeInLibrary, boolean changeEverywhere, boolean changeConnected) {
            super("Change type", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.geomsToChange = geomsToChange;
            this.highs = highs;
            this.libName = libName;
            this.np = np;
            this.func = func;
            this.ap = ap;
            this.cell = WindowFrame.getCurrentCell();
            this.ignorePortNames = ignorePortNames;
            this.allowMissingPorts = allowMissingPorts;
            this.preserveParameters = preserveParameters;
            this.changeNodesWithArcs = changeNodesWithArcs;
            this.changeInCell = changeInCell;
            this.changeInLibrary = changeInLibrary;
            this.changeEverywhere = changeEverywhere;
            this.changeConnected = changeConnected;
            this.highlightThese = new ArrayList<Geometric>();
            this.replacementErrors = new ArrayList<NodeInst.ChangeError>();
            if (this.scheduleNodes(ep)) {
                this.startJob();
            }
        }

        private boolean scheduleNodes(EditingPreferences ep) {
            for (Geometric geomToChange : this.geomsToChange) {
                if (!(geomToChange instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geomToChange;
                NodeProto oldNType = ni.getProto();
                if (CircuitChangeJobs.cantEdit(ni.getParent(), ni, true, false, true) != 0) {
                    return false;
                }
                Library library = Library.findLibrary(this.libName);
                if (library == null) {
                    return false;
                }
                if (this.np == null) {
                    return false;
                }
                this.schedule(ni);
                if (this.changeEverywhere) {
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = it.next();
                        Iterator<Cell> cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = cIt.next();
                            this.scheduleInCell(cell, oldNType);
                        }
                    }
                    continue;
                }
                if (this.changeInLibrary) {
                    Library lib = this.cell.getLibrary();
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = cIt.next();
                        this.scheduleInCell(cell, oldNType);
                    }
                    continue;
                }
                if (this.changeInCell) {
                    this.scheduleInCell(this.cell, oldNType);
                    continue;
                }
                if (!this.changeConnected) continue;
                Netlist netlist = this.cell.getNetlist();
                Iterator<NodeInst> it = this.cell.getNodes();
                while (it.hasNext()) {
                    NodeInst lNi = it.next();
                    if (lNi.getProto() != oldNType || lNi == ni) continue;
                    boolean found = false;
                    Iterator<PortInst> pIt = ni.getPortInsts();
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        Iterator<PortInst> lPIt = lNi.getPortInsts();
                        while (lPIt.hasNext()) {
                            PortInst lPi = lPIt.next();
                            if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    this.schedule(lNi);
                }
            }
            Iterator<NodeInst> it = this.replacements.keySet().iterator();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, ni, true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode <= 0) continue;
                it.remove();
            }
            return true;
        }

        private void scheduleInCell(Cell cell, NodeProto oldNType) {
            Iterator<NodeInst> nIt = cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst lNi = nIt.next();
                if (lNi.getProto() != oldNType) continue;
                if (lNi.isIconOfParent()) {
                    System.out.println("Example icon in " + String.valueOf(cell) + " not replaced");
                    continue;
                }
                this.schedule(lNi);
            }
        }

        private void schedule(NodeInst lNi) {
            EditingPreferences ep = this.getEditingPreferences();
            if (lNi.getProto() == this.np && lNi.getFunction() == this.func) {
                return;
            }
            PrimitiveNode.Function fun = this.func != null ? this.func : PrimitiveNode.Function.UNKNOWN;
            BatchChanges.NodeReplacement nr = new BatchChanges.NodeReplacement(lNi, this.np, fun, null);
            lNi.checkReplacementErrors(nr, ep, this.ignorePortNames, this.allowMissingPorts, this.replacementErrors);
            if (this.replacementErrors.size() == 0) {
                this.replacements.put(lNi, nr);
            } else {
                System.out.println("Node " + this.np.describe(false) + " does not fit in the place of node " + lNi.getProto().describe(false));
                for (NodeInst.ChangeError ce : this.replacementErrors) {
                    ce.printError();
                    ArcInst ai = ce.getConAI();
                    if (ai == null) continue;
                    this.highlightThese.add(ai);
                }
            }
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.replacementErrors.size() > 0) {
                return true;
            }
            EDatabase database = this.getDatabase();
            EditingPreferences ep = this.getEditingPreferences();
            this.fieldVariableChanged("highlightThese");
            MutableInteger nodeFailures = new MutableInteger(0);
            String replacedWithNode = "node " + (this.np != null ? this.np.describe(false) : "No NODE");
            if (this.func != null) {
                replacedWithNode = replacedWithNode + " (" + this.func.getShortName() + ")";
            }
            HashMap<NodeInst, NodeProto> oldProtos = new HashMap<NodeInst, NodeProto>();
            LinkedHashMap totalByNodeProto = new LinkedHashMap();
            for (BatchChanges.NodeReplacement nodeReplacement : this.replacements.values()) {
                NodeInst oldNode = database.getCell(nodeReplacement.cellId).getNodeById(nodeReplacement.nodeId);
                NodeProto oldProto = oldNode.getProto();
                oldProtos.put(oldNode, oldProto);
                MutableInteger.addToBag(totalByNodeProto, oldProto);
            }
            if (!this.replacements.isEmpty()) {
                CircuitChangeJobs.replaceNodeInsts(this.replacements.values(), this.allowMissingPorts, this.preserveParameters, ep);
            }
            for (Geometric geometric : this.geomsToChange) {
                ArcInst newAi;
                if (geometric instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geometric;
                    NodeProto oldNType = (NodeProto)oldProtos.get(ni);
                    NodeInst newNi = database.getCell(ni.getParent().getId()).getNodeById(ni.getNodeId());
                    assert (newNi != null);
                    this.highlightThese.add(newNi);
                    System.out.println(String.valueOf(oldNType) + " replaced with " + replacedWithNode);
                    continue;
                }
                ArcInst ai = (ArcInst)geometric;
                if (this.ap == null) {
                    System.out.println("Arc " + ai.getName() + " skipped");
                    continue;
                }
                if (CircuitChangeJobs.cantEdit(ai.getParent(), null, true, false, true) != 0) {
                    return false;
                }
                ArcProto oldAType = ai.getProto();
                if (oldAType == this.ap) {
                    System.out.println("Arc '" + ai.getName() + "' already of type " + this.ap.describe());
                    continue;
                }
                if (this.changeNodesWithArcs) {
                    if (this.changeInLibrary) {
                        Iterator<Cell> it = Library.getCurrent().getCells();
                        while (it.hasNext()) {
                            Cell cell = it.next();
                            this.replaceAllArcs(cell, this.highs, ai, this.ap, false, true, ep);
                        }
                    } else {
                        this.replaceAllArcs(ai.getParent(), this.highs, ai, this.ap, this.changeConnected, this.changeInCell, ep);
                    }
                    return true;
                }
                ArcInst onlyNewAi = ai.replace(this.ap, ep);
                if (onlyNewAi == null) {
                    System.out.println(String.valueOf(this.ap) + " does not fit in the place of " + String.valueOf(oldAType));
                    return false;
                }
                this.highlightThese.add(onlyNewAi);
                int total = 1;
                if (this.changeEverywhere) {
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = it.next();
                        Iterator<Cell> cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = cIt.next();
                            boolean found = true;
                            block5: while (found) {
                                found = false;
                                Iterator<ArcInst> nIt = cell.getArcs();
                                while (nIt.hasNext()) {
                                    ArcInst newAi2;
                                    ArcInst lAi = nIt.next();
                                    if (lAi.getProto() != oldAType) continue;
                                    int errorCode = CircuitChangeJobs.cantEdit(cell, null, true, false, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newAi2 = lAi.replace(this.ap, ep)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block5;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in the library replaced with " + String.valueOf(this.ap));
                    continue;
                }
                if (this.changeInLibrary) {
                    Library lib = Library.getCurrent();
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = cIt.next();
                        boolean found = true;
                        block8: while (found) {
                            found = false;
                            Iterator<ArcInst> nIt = cell.getArcs();
                            while (nIt.hasNext()) {
                                ArcInst newAi3;
                                ArcInst lAi = nIt.next();
                                if (lAi.getProto() != oldAType) continue;
                                int errorCode = CircuitChangeJobs.cantEdit(cell, null, true, false, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newAi3 = lAi.replace(this.ap, ep)) == null) continue;
                                ++total;
                                found = true;
                                continue block8;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + String.valueOf(lib) + " replaced with " + String.valueOf(this.ap));
                    continue;
                }
                if (this.changeInCell) {
                    boolean found = true;
                    block10: while (found) {
                        found = false;
                        Iterator<ArcInst> nIt = this.cell.getArcs();
                        while (nIt.hasNext()) {
                            ArcInst lAi = nIt.next();
                            if (lAi.getProto() != oldAType) continue;
                            int errorCode = CircuitChangeJobs.cantEdit(this.cell, null, true, false, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newAi = lAi.replace(this.ap, ep)) == null) continue;
                            ++total;
                            found = true;
                            continue block10;
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + String.valueOf(this.cell) + " replaced with " + String.valueOf(this.ap));
                    continue;
                }
                if (this.changeConnected) {
                    ArrayList<ArcInst> others = new ArrayList<ArcInst>();
                    Netlist netlist = this.cell.getNetlist();
                    Iterator<ArcInst> it = this.cell.getArcs();
                    while (it.hasNext()) {
                        ArcInst lAi = it.next();
                        if (lAi == onlyNewAi || !netlist.sameNetwork(onlyNewAi, lAi)) continue;
                        others.add(lAi);
                    }
                    for (ArcInst lAi : others) {
                        newAi = lAi.replace(this.ap, ep);
                        if (newAi == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs connected to this replaced with " + String.valueOf(this.ap));
                    continue;
                }
                System.out.println(String.valueOf(oldAType) + " replaced with " + String.valueOf(this.ap));
            }
            for (Map.Entry entry : totalByNodeProto.entrySet()) {
                NodeProto oldNType = (NodeProto)entry.getKey();
                String msg = null;
                if (this.changeEverywhere) {
                    msg = oldNType.describe(true) + " nodes in all libraries";
                } else if (this.changeInLibrary) {
                    msg = oldNType.describe(true) + " nodes in " + String.valueOf(this.cell.getLibrary());
                } else if (this.changeInCell) {
                    msg = oldNType.describe(true) + " nodes in " + String.valueOf(this.cell);
                } else {
                    if (!this.changeConnected) continue;
                    msg = oldNType.describe(true) + " nodes connected to this";
                }
                System.out.println("All " + String.valueOf(entry.getValue()) + " " + msg + " replaced with " + replacedWithNode);
            }
            if (nodeFailures.intValue() > 0) {
                Job.getUserInterface().showErrorMessage("There were " + nodeFailures.intValue() + " nodes that could not be replaced with " + String.valueOf(this.np), "Change failed");
            }
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            for (NodeInst ni : this.nodesToExpand) {
                ni.setExpanded(true);
            }
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                for (Geometric geom : this.highlightThese) {
                    highlighter.addElectricObject(geom, geom.getParent());
                }
                highlighter.finished();
            }
            if (this.nodesToExpand.size() > 0) {
                EditWindow.repaintAllContents();
            }
        }

        private void replaceAllArcs(Cell cell, List<Geometric> highs, ArcInst oldAi, ArcProto ap, boolean connected, boolean thiscell, EditingPreferences ep) {
            ArcInst ai;
            Iterator<Geometric> it;
            HashSet<ArcInst> geomMarked = new HashSet<ArcInst>();
            ArrayList<NodeInst> changePins = new ArrayList<NodeInst>();
            for (Geometric geom : highs) {
                ArcInst ai2;
                if (!(geom instanceof ArcInst) || (ai2 = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
                geomMarked.add(ai2);
            }
            if (connected) {
                Netlist netlist = cell.getNetlist();
                Iterator<ArcInst> it2 = cell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai2 = it2.next();
                    if (ai2.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai2, oldAi)) continue;
                    geomMarked.add(ai2);
                }
            }
            if (thiscell) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai3 = (ArcInst)it.next();
                    if (ai3.getProto() != oldAi.getProto()) continue;
                    geomMarked.add(ai3);
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.isCellInstance() || !ni.getFunction().isPin()) continue;
                boolean allArcs = true;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    if (geomMarked.contains(con.getArc())) continue;
                    allArcs = false;
                    break;
                }
                if (!ni.hasConnections() || !allArcs) continue;
                changePins.add(ni);
            }
            PrimitiveNode pin = ap.findOverridablePinProto(ep);
            double xS = pin.getDefWidth(ep);
            double yS = pin.getDefHeight(ep);
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            for (NodeInst nodeInst : changePins) {
                NodeInst newNi = NodeInst.makeInstance(pin, ep, nodeInst.getAnchorCenter(), xS, yS, cell);
                if (newNi == null) {
                    return;
                }
                newNodes.put(nodeInst, newNi);
                Iterator<Export> eIt = nodeInst.getExports();
                while (eIt.hasNext()) {
                    Export oldExport = eIt.next();
                    if (!oldExport.move(newNi.getOnlyPortInst())) continue;
                    System.out.println("Unable to move export " + oldExport.getName() + " from old pin " + nodeInst.describe(true) + " to new pin " + String.valueOf(newNi));
                }
            }
            for (Geometric geometric : geomMarked) {
                ArcInst newAi;
                if (!(geometric instanceof ArcInst)) continue;
                ai = (ArcInst)geometric;
                PortInst pi0 = null;
                NodeInst newNi0 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (newNi0 != null) {
                    pi0 = newNi0.getOnlyPortInst();
                } else {
                    pi0 = this.makeContactStack(ai, 1, ap, ep);
                    if (pi0 == null) {
                        return;
                    }
                }
                PortInst pi1 = null;
                NodeInst newNi1 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                if (newNi1 != null) {
                    pi1 = newNi1.getOnlyPortInst();
                } else {
                    pi1 = this.makeContactStack(ai, 0, ap, ep);
                    if (pi1 == null) {
                        return;
                    }
                }
                double wid = ap.getDefaultLambdaBaseWidth(ep);
                if (ai.getLambdaBaseWidth() > wid) {
                    wid = ai.getLambdaBaseWidth();
                }
                if ((newAi = ArcInst.makeInstanceBase(ap, ep, wid, pi0, pi1, ai.getHeadLocation(), ai.getTailLocation(), ai.getName())) == null) {
                    return;
                }
                newAi.copyPropertiesFrom(ai);
                geomMarked.remove(newAi);
            }
            for (Geometric geometric : geomMarked) {
                if (!(geometric instanceof ArcInst)) continue;
                ai = (ArcInst)geometric;
                ai.kill();
            }
            for (NodeInst nodeInst : changePins) {
                if (nodeInst.hasExports()) continue;
                String niName = nodeInst.getName();
                nodeInst.kill();
                NodeInst newNi = (NodeInst)newNodes.get(nodeInst);
                newNi.setName(niName);
            }
        }

        private PortInst makeContactStack(ArcInst ai, int end, ArcProto ap, EditingPreferences ep) {
            NodeInst lastNi = ai.getPortInst(end).getNodeInst();
            PortProto lastPp = ai.getPortInst(end).getPortProto();
            PortInst lastPi = lastNi.findPortInstFromEquivalentProto(lastPp);
            EPoint center = ai.getLocation(end);
            Cell cell = ai.getParent();
            this.setupConnections(ap.getTechnology());
            HashSet<ArcProto> markedArcs = new HashSet<ArcProto>();
            int depth = this.findOtherPathToArc(lastPp, ai.getProto(), ap, 0, markedArcs);
            if (depth < 0) {
                return null;
            }
            for (int i2 = 0; i2 < depth; ++i2) {
                ArcProto typ = this.contactStackArc[i2];
                double wid = ai.getLambdaBaseWidth();
                double xS = this.contactStack[i2].getDefWidth(ep);
                double yS = this.contactStack[i2].getDefHeight(ep);
                SizeOffset so = this.contactStack[i2].getProtoSizeOffset();
                NodeInst newNi = NodeInst.makeInstance(this.contactStack[i2], ep, center, xS = Math.max(xS - so.getLowXOffset() - so.getHighXOffset(), wid) + so.getLowXOffset() + so.getHighXOffset(), yS = Math.max(yS - so.getLowYOffset() - so.getHighYOffset(), wid) + so.getLowYOffset() + so.getHighYOffset(), cell);
                if (newNi == null) {
                    return null;
                }
                PortInst thisPi = newNi.findPortInstFromEquivalentProto(this.contactStack[i2].getPort(0));
                ArcInst newAi = ArcInst.newInstanceBase(typ, ep, wid, thisPi, lastPi, center, center, null, ai.getAngle());
                lastPi = thisPi;
                if (newAi == null) {
                    return null;
                }
                newAi.setFixedAngle(true);
            }
            return lastPi;
        }

        private void setupConnections(Technology tech) {
            if (this.connectionTech == tech) {
                return;
            }
            this.connectionTech = tech;
            this.connectionMap = new HashMap<ArcProto, Map<ArcProto, PrimitivePort>>();
            Iterator<PrimitiveNode> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode.Function fun;
                PrimitiveNode np = it.next();
                if (np.isNotUsed() || !(fun = np.getFunction()).isContact()) continue;
                PrimitivePort pp = np.getPort(0);
                ArcProto[] arcs = pp.getConnections();
                ArcProto ap1 = null;
                ArcProto ap2 = null;
                for (int i2 = 0; i2 < arcs.length; ++i2) {
                    ArcProto ap = arcs[i2];
                    if (ap.getTechnology() != tech) continue;
                    if (ap1 == null) {
                        ap1 = ap;
                        continue;
                    }
                    if (ap2 != null) continue;
                    ap2 = ap;
                }
                if (ap1 == null || ap2 == null) continue;
                this.addConnection(ap1, ap2, null);
                this.addConnection(ap2, ap1, null);
            }
        }

        private void addConnection(ArcProto ap1, ArcProto ap2, PrimitivePort np) {
            Map<ArcProto, PrimitivePort> arcMap = this.connectionMap.get(ap1);
            if (arcMap == null) {
                arcMap = new HashMap<ArcProto, PrimitivePort>();
                this.connectionMap.put(ap1, arcMap);
            }
            if (arcMap.get(ap2) == null) {
                PrimitivePort pp = User.getUserTool().getPreferredContactPortProto(ap1, ap2);
                if (pp == null) {
                    System.out.println("NULL PORT CONNECTING " + ap1.describe() + " AND " + ap2.describe());
                }
                arcMap.put(ap2, pp);
            }
        }

        private int findOtherPathToArc(PortProto pp, ArcProto sourceAp, ArcProto destAp, int depth, Set<ArcProto> markedArcs) {
            if (pp.connectsTo(destAp)) {
                return depth;
            }
            PrimitiveNode bestNp = null;
            ArcProto bestAp = null;
            int bestDepth = 0;
            Map<ArcProto, PrimitivePort> arcMap = this.connectionMap.get(sourceAp);
            for (ArcProto nextAp : arcMap.keySet()) {
                PortProto nextPp;
                if (markedArcs.contains(nextAp) || (nextPp = (PortProto)arcMap.get(nextAp)) == null) continue;
                PrimitiveNode nextNp = (PrimitiveNode)nextPp.getParent();
                this.contactStack[depth] = nextNp;
                markedArcs.add(nextAp);
                int newDepth = this.findOtherPathToArc(nextPp, nextAp, destAp, depth + 1, markedArcs);
                markedArcs.remove(nextAp);
                if (newDepth < 0 || bestNp != null && newDepth >= bestDepth) continue;
                bestDepth = newDepth;
                bestNp = nextNp;
                bestAp = nextAp;
            }
            if (bestNp != null) {
                this.contactStack[depth] = bestNp;
                this.contactStackArc[depth] = sourceAp;
                markedArcs.add(bestAp);
                int newDepth = this.findOtherPathToArc(bestNp.getPort(0), bestAp, destAp, depth + 1, markedArcs);
                markedArcs.remove(bestAp);
                return newDepth;
            }
            return -1;
        }
    }
}

