/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightEOBJ;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Set;

class HighlightText
extends Highlight {
    protected final ElectricObject eobj;
    protected final Variable.Key varKey;

    public HighlightText(ElectricObject e2, Cell c2, Variable.Key key) {
        super(c2, null, false);
        this.eobj = e2;
        this.varKey = key;
        Class cls = null;
        if (key == NodeInst.NODE_NAME || key == NodeInst.NODE_PROTO) {
            cls = NodeInst.class;
        } else if (key == ArcInst.ARC_NAME) {
            cls = ArcInst.class;
        } else if (key == Export.EXPORT_NAME) {
            cls = Export.class;
        } else if (key == null) {
            throw new NullPointerException();
        }
        if (cls != null && !cls.isInstance(e2)) {
            throw new IllegalArgumentException(String.valueOf(key) + " in " + String.valueOf(e2));
        }
    }

    @Override
    void internalDescribe(StringBuffer desc) {
        if (this.varKey != null) {
            if (this.varKey == NodeInst.NODE_NAME) {
                desc.append("name: ");
                desc.append(((NodeInst)this.eobj).getName());
            } else if (this.varKey == NodeInst.NODE_PROTO) {
                desc.append("instance: ");
                desc.append(((NodeInst)this.eobj).getProto().getName());
            } else if (this.varKey == ArcInst.ARC_NAME) {
                desc.append("name: ");
                desc.append(((ArcInst)this.eobj).getName());
            } else if (this.varKey == Export.EXPORT_NAME) {
                desc.append("export: ");
                desc.append(((Export)this.eobj).getName());
            } else {
                desc.append("var: ");
                desc.append(this.eobj.getParameterOrVariable(this.varKey).describe(-1));
            }
        }
    }

    @Override
    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    @Override
    public boolean isHighlightText() {
        return true;
    }

    @Override
    public Variable.Key getVarKey() {
        return this.varKey;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.eobj == null || this.varKey == null) {
            return false;
        }
        if (!this.eobj.isLinked()) {
            return false;
        }
        if (this.varKey == NodeInst.NODE_NAME || this.varKey == ArcInst.ARC_NAME || this.varKey == NodeInst.NODE_PROTO || this.varKey == Export.EXPORT_NAME) {
            return true;
        }
        return this.eobj.getParameterOrVariable(this.varKey) != null;
    }

    @Override
    public boolean sameThing(Highlight obj, boolean exact) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightText other = (HighlightText)obj;
        if (this.eobj != other.eobj) {
            return false;
        }
        if (this.cell != other.cell) {
            return false;
        }
        return this.varKey == other.varKey;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g2, long highOffX, long highOffY, boolean onlyHighlight) {
        Geometric geom;
        ElectricObject eObj;
        Graphics2D g22 = (Graphics2D)g2;
        Point2D[] points = Highlighter.describeHighlightText(wnd, this.eobj, this.varKey);
        if (points == null) {
            return;
        }
        Point2D[] linePoints = new Point2D[2];
        for (int i2 = 0; i2 < points.length; i2 += 2) {
            linePoints[0] = points[i2];
            linePoints[1] = points[i2 + 1];
            HighlightText.drawOutlineFromPoints(wnd, g2, linePoints, highOffX, highOffY, false, false);
        }
        if (onlyHighlight && (eObj = this.eobj) != null && eObj instanceof Geometric && ((geom = (Geometric)eObj) instanceof ArcInst || !((NodeInst)geom).isInvisiblePinWithText())) {
            Point2D objCtr = geom.getTrueCenter();
            ScreenPoint c2 = wnd.databaseToScreen(objCtr);
            TextDescriptor td = this.eobj.getTextDescriptor(this.varKey);
            Point2D.Double offset = new Point2D.Double(td.getXOff(), td.getYOff());
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                FixpTransform trans = ni.pureRotateOut();
                trans.transform(offset, offset);
            }
            double locX = objCtr.getX() + ((Point2D)offset).getX();
            double locY = objCtr.getY() + ((Point2D)offset).getY();
            Point2D.Double txtAnchor = new Point2D.Double(locX, locY);
            ScreenPoint a2 = wnd.databaseToScreen(txtAnchor);
            long cX = a2.getX();
            long cY = a2.getY();
            if (Math.abs(cX - c2.getX()) > 4L || Math.abs(cY - c2.getY()) > 4L) {
                g2.fillOval(c2.getIntX() - 4, c2.getIntY() - 4, 8, 8);
                g22.setStroke(dottedLine);
                HighlightText.drawLine(g2, wnd, c2.getX(), c2.getY(), cX, cY);
                g22.setStroke(solidLine);
            }
        }
    }

    @Override
    public Geometric getGeometric() {
        if (DisplayedText.objectMovesWithText(this.eobj, this.varKey, User.isMoveNodeWithExport())) {
            if (this.eobj instanceof Export) {
                return ((Export)this.eobj).getOriginalPort().getNodeInst();
            }
            if (this.eobj instanceof Geometric) {
                return (Geometric)this.eobj;
            }
        }
        return null;
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        HighlightText.getHighlightedEObjsInternal(this.getGeometric(), list, wantNodes, wantArcs);
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, Set<NodeInst> set) {
        HighlightText.getHighlightedNodesInternal(this.getGeometric(), set);
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, Set<ArcInst> set) {
        HighlightText.getHighlightedArcsInternal(this.getGeometric(), set);
    }

    @Override
    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
        if (this.eobj instanceof Export) {
            Export pp = (Export)this.eobj;
            int width = netlist.getBusWidth(pp);
            for (int i2 = 0; i2 < width; ++i2) {
                Network net = netlist.getNetwork(pp, i2);
                if (net == null) continue;
                nets.add(net);
            }
        }
    }

    DisplayedText makeDisplayedText() {
        if (this.varKey != null) {
            return new DisplayedText(this.eobj, this.varKey);
        }
        return null;
    }

    @Override
    void getHighlightedText(List<DisplayedText> list, boolean unique, List<Highlight> getHighlights) {
        DisplayedText dt = this.makeDisplayedText();
        if (dt == null) {
            return;
        }
        if (list.contains(dt)) {
            return;
        }
        if (unique) {
            ElectricObject onObj = null;
            if (this.varKey != null) {
                if (this.eobj instanceof Export) {
                    onObj = ((Export)this.eobj).getOriginalPort().getNodeInst();
                } else if (this.eobj instanceof PortInst) {
                    onObj = ((PortInst)this.eobj).getNodeInst();
                } else if (this.eobj instanceof Geometric) {
                    onObj = this.eobj;
                }
            }
            if (this.eobj != null) {
                boolean found = false;
                for (Highlight oH : getHighlights) {
                    if (!(oH instanceof HighlightEOBJ)) continue;
                    ElectricObject fobj = ((HighlightEOBJ)oH).eobj;
                    if (fobj instanceof PortInst) {
                        fobj = ((PortInst)fobj).getNodeInst();
                    }
                    if (fobj != onObj) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return;
                }
            }
        }
        list.add(dt);
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        Poly poly;
        if (wnd != null && (poly = this.eobj.computeTextPoly(wnd, this.varKey)) != null) {
            return poly.getBounds2D();
        }
        return null;
    }

    @Override
    Highlight overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter, boolean change) {
        Point2D start = wnd.screenToDatabase(x, y);
        Poly poly = this.eobj.computeTextPoly(wnd, this.varKey);
        if (poly != null && poly.isInside(start)) {
            return this;
        }
        return null;
    }

    @Override
    public String describe() {
        Object description = "Unknown";
        if (this.varKey != null && this.eobj != null) {
            if (this.varKey == NodeInst.NODE_NAME) {
                description = "Node name for " + ((NodeInst)this.eobj).describe(true);
            } else if (this.varKey == ArcInst.ARC_NAME) {
                description = "Arc name for " + ((ArcInst)this.eobj).describe(true);
            } else if (this.varKey == Export.EXPORT_NAME) {
                description = "Export '" + ((Export)this.eobj).getName() + "'";
            } else if (this.varKey == NodeInst.NODE_PROTO) {
                description = "Cell instance name " + ((NodeInst)this.eobj).describe(true);
            } else {
                Variable var = this.eobj.getParameterOrVariable(this.varKey);
                if (var != null) {
                    description = this.eobj.getFullDescription(var);
                }
            }
        }
        return description;
    }

    @Override
    public String getInfo() {
        return "Text: " + this.describe();
    }
}

