/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

class HighlightPoly
extends Highlight {
    private final Poly polygon;

    HighlightPoly(Cell c2, Poly p, Color col) {
        super(c2, col, false);
        this.polygon = p;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g2, long highOffX, long highOffY, boolean onlyHighlight) {
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g2.getColor();
            g2.setColor(this.color);
        }
        Point2D[] points = this.polygon.getPoints();
        if (this.polygon.getStyle() == Poly.Type.FILLED) {
            int[] xPoints = new int[points.length];
            int[] yPoints = new int[points.length];
            for (int i2 = 0; i2 < points.length; ++i2) {
                ScreenPoint p = wnd.databaseToScreen(((Point2D)points[i2]).getX(), points[i2].getY());
                xPoints[i2] = p.getIntX();
                yPoints[i2] = p.getIntY();
            }
            g2.fillPolygon(xPoints, yPoints, points.length);
        } else if (this.polygon.getStyle() == Poly.Type.DISC) {
            long radius = Math.round(((Point2D)points[0]).distance(points[1]) * wnd.getScale());
            ScreenPoint ctr = wnd.databaseToScreen(points[0].getX(), points[0].getY());
            g2.fillOval((int)(ctr.getX() - radius), (int)(ctr.getY() - radius), (int)radius * 2, (int)radius * 2);
        } else {
            boolean opened = this.polygon.getStyle() == Poly.Type.OPENED;
            HighlightPoly.drawOutlineFromPoints(wnd, g2, points, highOffX, highOffY, opened, false);
        }
        if (oldColor != null) {
            g2.setColor(oldColor);
        }
    }
}

