/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.AbstractLayerDrawing;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class HighlightEOBJ
extends Highlight {
    protected final ElectricObject eobj;
    private final boolean highlightConnected;
    protected final int point;

    public HighlightEOBJ(ElectricObject e2, Cell c2, boolean connected, int p) {
        super(c2, null, false);
        this.eobj = e2;
        this.highlightConnected = connected;
        this.point = p;
    }

    public HighlightEOBJ(ElectricObject e2, Cell c2, boolean connected, int p, boolean isError) {
        super(c2, null, isError);
        this.eobj = e2;
        this.highlightConnected = connected;
        this.point = p;
    }

    public HighlightEOBJ(ElectricObject e2, Cell c2, boolean connected, int p, Color col) {
        super(c2, col, false);
        this.eobj = e2;
        this.highlightConnected = connected;
        this.point = p;
    }

    public HighlightEOBJ(HighlightEOBJ h2, ElectricObject eobj, int p) {
        super(h2.cell, h2.color, h2.isError);
        this.eobj = eobj;
        this.highlightConnected = h2.highlightConnected;
        this.point = p;
    }

    @Override
    void internalDescribe(StringBuffer desc) {
        if (this.eobj instanceof PortInst) {
            desc.append(((PortInst)this.eobj).describe(true));
        }
        if (this.eobj instanceof NodeInst) {
            desc.append(((NodeInst)this.eobj).describe(true));
        }
        if (this.eobj instanceof ArcInst) {
            desc.append(((ArcInst)this.eobj).describe(true));
        }
    }

    @Override
    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    @Override
    public boolean isHighlightEOBJ() {
        return true;
    }

    @Override
    public int getPoint() {
        return this.point;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.eobj.isLinked();
    }

    @Override
    public boolean showInRaster() {
        return !this.isError && this.color == null && this.eobj instanceof NodeInst && this.point < 0;
    }

    @Override
    public boolean sameThing(Highlight obj, boolean exact) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElectricObject realEObj = this.eobj;
        if (!exact && realEObj instanceof PortInst) {
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        HighlightEOBJ other = (HighlightEOBJ)obj;
        ElectricObject realOtherEObj = other.eobj;
        if (!exact && realOtherEObj instanceof PortInst) {
            realOtherEObj = ((PortInst)realOtherEObj).getNodeInst();
        }
        return realEObj == realOtherEObj;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g2, long highOffX, long highOffY, boolean onlyHighlight) {
        if (this.eobj == null || !this.eobj.isLinked()) {
            return;
        }
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g2.getColor();
            g2.setColor(this.color);
        }
        if (this.eobj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
            if (poly == null) {
                return;
            }
            HighlightEOBJ.drawOutlineFromPoints(wnd, g2, poly.getPoints(), highOffX, highOffY, false, false);
            if (onlyHighlight) {
                String constraints = "X";
                if (ai.isRigid()) {
                    constraints = "R";
                } else if (ai.isFixedAngle()) {
                    constraints = ai.isSlidable() ? "FS" : "F";
                } else if (ai.isSlidable()) {
                    constraints = "S";
                }
                ScreenPoint p = wnd.databaseToScreen(ai.getTrueCenterX(), ai.getTrueCenterY());
                Font font = wnd.getFont(null);
                if (font != null) {
                    GlyphVector gv = wnd.getGlyphs(constraints, font);
                    Rectangle2D glyphBounds = gv.getVisualBounds();
                    g2.drawString(constraints, (int)((double)p.getX() - glyphBounds.getWidth() / 2.0 + (double)highOffX), (int)(p.getY() + (long)(font.getSize() / 2) + highOffY));
                }
            }
            return;
        }
        PortProto pp = null;
        ElectricObject realEObj = this.eobj;
        PortInst originalPi = null;
        if (realEObj instanceof PortInst) {
            originalPi = (PortInst)realEObj;
            pp = originalPi.getPortProto();
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        if (realEObj instanceof NodeInst) {
            Point2D[] points;
            EPoint[] points2;
            NodeInst ni = (NodeInst)realEObj;
            FixpTransform trans = ni.rotateOutAboutTrueCenter();
            long offX = highOffX;
            long offY = highOffY;
            if (this.point >= 0 && (points2 = ni.getTrace()) != null) {
                if (points2.length <= this.point) {
                    System.err.println("Invalid index " + this.point + " in trace point ");
                    return;
                }
                if (ni.getProto() == Artwork.tech().splineNode) {
                    EPoint[] changedPoints = new EPoint[points2.length];
                    for (int i2 = 0; i2 < points2.length; ++i2) {
                        changedPoints[i2] = points2[i2];
                        if (i2 != this.point) continue;
                        double x = ni.getAnchorCenterX() + points2[this.point].getX();
                        double y = ni.getAnchorCenterY() + points2[this.point].getY();
                        Point2D.Double thisPt = new Point2D.Double(x, y);
                        trans.transform(thisPt, thisPt);
                        ScreenPoint cThis = wnd.databaseToScreen(thisPt);
                        Point2D db = wnd.screenToDatabase(cThis.getX() + offX, cThis.getY() + offY);
                        changedPoints[i2] = EPoint.fromLambda(db.getX() - ni.getAnchorCenterX(), db.getY() - ni.getAnchorCenterY());
                    }
                    PolyBase.Point[] spPoints = Artwork.tech().fillSpline(ni.getAnchorCenter(), changedPoints);
                    ScreenPoint cLast = wnd.databaseToScreen(spPoints[0]);
                    for (int i3 = 1; i3 < spPoints.length; ++i3) {
                        ScreenPoint cThis = wnd.databaseToScreen(spPoints[i3]);
                        HighlightEOBJ.drawLine(g2, wnd, cLast.getX(), cLast.getY(), cThis.getX(), cThis.getY());
                        cLast = cThis;
                    }
                }
                if (points2[this.point] != null) {
                    int nextPoint;
                    double x = ni.getAnchorCenterX() + points2[this.point].getX();
                    double y = ni.getAnchorCenterY() + points2[this.point].getY();
                    Point2D.Double thisPt = new Point2D.Double(x, y);
                    trans.transform(thisPt, thisPt);
                    ScreenPoint cThis = wnd.databaseToScreen(thisPt);
                    int size = 3;
                    HighlightEOBJ.drawLine(g2, wnd, cThis.getX() + (long)size + offX, cThis.getY() + (long)size + offY, cThis.getX() - (long)size + offX, cThis.getY() - (long)size + offY);
                    HighlightEOBJ.drawLine(g2, wnd, cThis.getX() + (long)size + offX, cThis.getY() - (long)size + offY, cThis.getX() - (long)size + offX, cThis.getY() + (long)size + offY);
                    boolean showWrap = ni.traceWraps();
                    Point2D.Double prevPt = null;
                    Point2D.Double nextPt = null;
                    int prevPoint = this.point - 1;
                    if (prevPoint < 0 && showWrap) {
                        prevPoint = points2.length - 1;
                    }
                    if (prevPoint >= 0 && points2[prevPoint] != null) {
                        prevPt = new Point2D.Double(ni.getAnchorCenterX() + points2[prevPoint].getX(), ni.getAnchorCenterY() + points2[prevPoint].getY());
                        trans.transform(prevPt, prevPt);
                        if (((Point2D)prevPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)prevPt).getY() == ((Point2D)thisPt).getY()) {
                            prevPoint = -1;
                        } else {
                            ScreenPoint cPrev = wnd.databaseToScreen(prevPt);
                            HighlightEOBJ.drawLine(g2, wnd, cThis.getX() + offX, cThis.getY() + offY, cPrev.getX(), cPrev.getY());
                        }
                    }
                    if ((nextPoint = this.point + 1) >= points2.length) {
                        nextPoint = showWrap ? 0 : -1;
                    }
                    if (nextPoint >= 0 && points2[nextPoint] != null) {
                        nextPt = new Point2D.Double(ni.getAnchorCenterX() + points2[nextPoint].getX(), ni.getAnchorCenterY() + points2[nextPoint].getY());
                        trans.transform(nextPt, nextPt);
                        if (((Point2D)nextPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)nextPt).getY() == ((Point2D)thisPt).getY()) {
                            nextPoint = -1;
                        } else {
                            ScreenPoint cNext = wnd.databaseToScreen(nextPt);
                            HighlightEOBJ.drawLine(g2, wnd, cThis.getX() + offX, cThis.getY() + offY, cNext.getX(), cNext.getY());
                        }
                    }
                    if (offX == 0L && offY == 0L && points2.length > 2 && prevPt != null && nextPt != null) {
                        double arrowLen = Double.MAX_VALUE;
                        if (prevPoint >= 0) {
                            arrowLen = Math.min(thisPt.distance(prevPt), arrowLen);
                        }
                        if (nextPoint >= 0) {
                            arrowLen = Math.min(thisPt.distance(nextPt), arrowLen);
                        }
                        arrowLen /= 10.0;
                        double angleOfArrow = 2.5132741228718345;
                        if (prevPoint >= 0) {
                            Point2D.Double prevCtr = new Point2D.Double((((Point2D)prevPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)prevPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                            double prevAngle = DBMath.figureAngleRadians(prevPt, thisPt);
                            Point2D.Double prevArrow1 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle + angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle + angleOfArrow) * arrowLen);
                            Point2D.Double prevArrow2 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle - angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle - angleOfArrow) * arrowLen);
                            ScreenPoint cPrevCtr = wnd.databaseToScreen(prevCtr);
                            ScreenPoint cPrevArrow1 = wnd.databaseToScreen(prevArrow1);
                            ScreenPoint cPrevArrow2 = wnd.databaseToScreen(prevArrow2);
                            HighlightEOBJ.drawLine(g2, wnd, cPrevCtr.getX(), cPrevCtr.getY(), cPrevArrow1.getX(), cPrevArrow1.getY());
                            HighlightEOBJ.drawLine(g2, wnd, cPrevCtr.getX(), cPrevCtr.getY(), cPrevArrow2.getX(), cPrevArrow2.getY());
                        }
                        if (nextPoint >= 0) {
                            Point2D.Double nextCtr = new Point2D.Double((((Point2D)nextPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)nextPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                            double nextAngle = DBMath.figureAngleRadians(thisPt, nextPt);
                            Point2D.Double nextArrow1 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle + angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle + angleOfArrow) * arrowLen);
                            Point2D.Double nextArrow2 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle - angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle - angleOfArrow) * arrowLen);
                            ScreenPoint cNextCtr = wnd.databaseToScreen(nextCtr);
                            ScreenPoint cNextArrow1 = wnd.databaseToScreen(nextArrow1);
                            ScreenPoint cNextArrow2 = wnd.databaseToScreen(nextArrow2);
                            HighlightEOBJ.drawLine(g2, wnd, cNextCtr.getX(), cNextCtr.getY(), cNextArrow1.getX(), cNextArrow1.getY());
                            HighlightEOBJ.drawLine(g2, wnd, cNextCtr.getX(), cNextCtr.getY(), cNextArrow2.getX(), cNextArrow2.getY());
                        }
                    }
                }
                offY = 0L;
                offX = 0L;
            }
            if (offX == 0L && offY == 0L || this.point < 0) {
                Poly niPoly = HighlightEOBJ.getNodeInstOutline(ni);
                boolean niOpened = niPoly.getStyle() == Poly.Type.OPENED;
                points = niPoly.getPoints();
                HighlightEOBJ.drawOutlineFromPoints(wnd, g2, points, offX, offY, niOpened, false);
            }
            if (pp != null) {
                Poly poly = ni.getShapeOfPort(pp);
                boolean opened = true;
                points = poly.getPoints();
                if (poly.getStyle() == Poly.Type.FILLED || poly.getStyle() == Poly.Type.CLOSED) {
                    opened = false;
                }
                if (poly.getStyle() == Poly.Type.CIRCLE || poly.getStyle() == Poly.Type.THICKCIRCLE || poly.getStyle() == Poly.Type.DISC) {
                    double sX = points[0].distance(points[1]) * 2.0;
                    PolyBase.Point[] pts = Artwork.fillEllipse(points[0], sX, sX, 0.0, 360.0);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points = poly.getPoints();
                } else if (poly.getStyle() == Poly.Type.CIRCLEARC) {
                    double[] angles = ni.getArcDegrees();
                    double sX = points[0].distance(points[1]) * 2.0;
                    PolyBase.Point[] pts = Artwork.fillEllipse(points[0], sX, sX, angles[0], angles[1]);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points = poly.getPoints();
                }
                HighlightEOBJ.drawOutlineFromPoints(wnd, g2, points, offX, offY, opened, false);
                if (ni.isCellInstance() && g2 instanceof Graphics2D) {
                    boolean wired = false;
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        wired = true;
                        break;
                    }
                    if (wired) {
                        Font font = new Font(User.getDefaultFont(), 0, (int)(1.5 * (double)EditWindow.getDefaultFontSize()));
                        GlyphVector v = wnd.getGlyphs(pp.getName(), font);
                        ScreenPoint point = wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                        ((Graphics2D)g2).drawGlyphVector(v, (float)point.getX() + (float)offX, (float)point.getY() + (float)offY);
                    }
                }
            }
        }
        if (oldColor != null) {
            g2.setColor(oldColor);
        }
    }

    @Override
    void showHighlightsConnected(Graphics2D g2, EditWindow wnd) {
        NodeInst oNi;
        Export equiv;
        NodeInst ni;
        if (!(this.isValid() && this.eobj instanceof PortInst && this.highlightConnected)) {
            return;
        }
        PortInst originalPi = (PortInst)this.eobj;
        Netlist netlist = this.cell.getNetlist();
        if (netlist == null) {
            return;
        }
        NodeInst originalNI = ni = originalPi.getNodeInst();
        PortProto pp = originalPi.getPortProto();
        if (ni.isIconOfParent() && (equiv = (Export)this.cell.findPortProto(pp.getName())) != null) {
            originalPi = equiv.getOriginalPort();
            ni = originalPi.getNodeInst();
            pp = originalPi.getPortProto();
        }
        Set<Network> networks = new HashSet<Network>();
        networks = NetworkTool.getNetworksOnPort(originalPi, netlist, networks);
        HashSet<Geometric> markObj = new HashSet<Geometric>();
        Iterator<Object> it = this.cell.getArcs();
        block0: while (it.hasNext()) {
            ArcInst ai = it.next();
            Name arcName = ai.getNameKey();
            for (int i2 = 0; i2 < arcName.busWidth(); ++i2) {
                if (!networks.contains(netlist.getNetwork(ai, i2))) continue;
                markObj.add(ai);
                markObj.add(ai.getHeadPortInst().getNodeInst());
                markObj.add(ai.getTailPortInst().getNodeInst());
                continue block0;
            }
        }
        it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            oNi = no.getNodeInst();
            if (oNi == originalNI || markObj.contains(ni)) continue;
            boolean highlightNo = false;
            Iterator<PortProto> eIt = no.getProto().getPorts();
            while (eIt.hasNext()) {
                PortProto oPp = eIt.next();
                Name opName = oPp.getNameKey();
                for (int j2 = 0; j2 < opName.busWidth(); ++j2) {
                    if (!networks.contains(netlist.getNetwork(no, oPp, j2))) continue;
                    highlightNo = true;
                    break;
                }
                if (!highlightNo) continue;
                break;
            }
            if (!highlightNo) continue;
            markObj.add(oNi);
        }
        Stroke origStroke = g2.getStroke();
        g2.setStroke(dashedLine);
        Iterator<Geometric> it2 = this.cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = it2.next();
            if (!markObj.contains(ai)) continue;
            ScreenPoint c1 = wnd.databaseToScreen(ai.getHeadLocation());
            ScreenPoint c2 = wnd.databaseToScreen(ai.getTailLocation());
            HighlightEOBJ.drawLine(g2, wnd, c1.getX(), c1.getY(), c2.getX(), c2.getY());
        }
        g2.setStroke(solidLine);
        it2 = this.cell.getNodes();
        while (it2.hasNext()) {
            oNi = (NodeInst)it2.next();
            if (!markObj.contains(oNi)) continue;
            ScreenPoint c2 = wnd.databaseToScreen(oNi.getTrueCenter());
            g2.fillOval(c2.getIntX() - 4, c2.getIntY() - 4, 8, 8);
            Point2D nodeCenter = oNi.getTrueCenter();
            Iterator<Connection> pIt = oNi.getConnections();
            while (pIt.hasNext()) {
                EPoint arcEnd;
                Connection con = pIt.next();
                ArcInst ai = con.getArc();
                if (!markObj.contains(ai) || ((Point2D)(arcEnd = con.getLocation())).getX() == nodeCenter.getX() && ((Point2D)arcEnd).getY() == nodeCenter.getY()) continue;
                ScreenPoint c1 = wnd.databaseToScreen(arcEnd);
                ScreenPoint c22 = wnd.databaseToScreen(nodeCenter);
                HighlightEOBJ.drawLine(g2, wnd, c1.getX(), c1.getY(), c22.getX(), c22.getY());
            }
        }
        g2.setStroke(origStroke);
    }

    @Override
    public void showHighlight(FixpTransform outOfPlaceTransform, AbstractLayerDrawing ald, ERaster raster) {
        if (this.eobj == null || !this.eobj.isLinked()) {
            return;
        }
        NodeInst ni = (NodeInst)this.eobj;
        assert (this.color == null);
        Poly niPoly = HighlightEOBJ.getNodeInstOutline(ni);
        boolean niOpened = niPoly.getStyle() == Poly.Type.OPENED;
        HighlightEOBJ.drawOutlineFromPoints(outOfPlaceTransform, ald, raster, niPoly.getPoints(), 0, 0, niOpened, false);
    }

    @Override
    public void showHighlightsConnected(FixpTransform outOfPlaceTransform, AbstractLayerDrawing ald, ERaster raster) {
        ArcInst ai;
        Export equiv;
        NodeInst ni;
        if (!(this.isValid() && this.eobj instanceof PortInst && this.highlightConnected)) {
            return;
        }
        PortInst originalPi = (PortInst)this.eobj;
        Netlist netlist = this.cell.getNetlist();
        if (netlist == null) {
            return;
        }
        NodeInst originalNI = ni = originalPi.getNodeInst();
        PortProto pp = originalPi.getPortProto();
        if (ni.isIconOfParent() && (equiv = (Export)this.cell.findPortProto(pp.getName())) != null) {
            originalPi = equiv.getOriginalPort();
            ni = originalPi.getNodeInst();
            pp = originalPi.getPortProto();
        }
        Set<Network> networks = new HashSet<Network>();
        networks = NetworkTool.getNetworksOnPort(originalPi, netlist, networks);
        HashSet<Geometric> markObj = new HashSet<Geometric>();
        Iterator<Object> it = this.cell.getArcs();
        block0: while (it.hasNext()) {
            ai = it.next();
            Name arcName = ai.getNameKey();
            for (int i2 = 0; i2 < arcName.busWidth(); ++i2) {
                if (!networks.contains(netlist.getNetwork(ai, i2))) continue;
                markObj.add(ai);
                markObj.add(ai.getHeadPortInst().getNodeInst());
                markObj.add(ai.getTailPortInst().getNodeInst());
                continue block0;
            }
        }
        it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            NodeInst oNi = no.getNodeInst();
            if (oNi == originalNI || markObj.contains(ni)) continue;
            boolean highlightNo = false;
            Iterator<PortProto> eIt = no.getProto().getPorts();
            while (eIt.hasNext()) {
                PortProto oPp = eIt.next();
                Name opName = oPp.getNameKey();
                for (int j2 = 0; j2 < opName.busWidth(); ++j2) {
                    if (!networks.contains(netlist.getNetwork(no, oPp, j2))) continue;
                    highlightNo = true;
                    break;
                }
                if (!highlightNo) continue;
                break;
            }
            if (!highlightNo) continue;
            markObj.add(oNi);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            if (!markObj.contains(ai)) continue;
            EPoint c1 = ai.getHeadLocation();
            EPoint c2 = ai.getTailLocation();
            if (outOfPlaceTransform != null) {
                c1 = (EPoint)outOfPlaceTransform.transform(c1, null);
                c2 = (EPoint)outOfPlaceTransform.transform(c2, null);
            }
            ald.drawLine((int)c1.getGridX(), (int)c1.getGridY(), (int)c2.getGridX(), (int)c2.getGridY(), 2, raster);
        }
        it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst oNi = (NodeInst)it.next();
            if (!markObj.contains(oNi)) continue;
            EPoint c2 = EPoint.snap(oNi.getTrueCenter());
            if (outOfPlaceTransform != null) {
                c2 = (EPoint)outOfPlaceTransform.transform(c2, null);
            }
            ald.drawOval((int)c2.getGridX(), (int)c2.getGridY(), 4, raster);
            Point2D nodeCenter = oNi.getTrueCenter();
            Iterator<Connection> pIt = oNi.getConnections();
            while (pIt.hasNext()) {
                EPoint arcEnd;
                Connection con = pIt.next();
                ArcInst ai2 = con.getArc();
                if (!markObj.contains(ai2) || (double)(arcEnd = con.getLocation()).getGridX() == nodeCenter.getX() && arcEnd.getY() == nodeCenter.getY()) continue;
                EPoint c1 = arcEnd;
                EPoint c22 = EPoint.snap(nodeCenter);
                if (outOfPlaceTransform != null) {
                    c1 = (EPoint)outOfPlaceTransform.transform(c1, null);
                    c22 = (EPoint)outOfPlaceTransform.transform(c22, null);
                }
                ald.drawLine((int)c1.getGridX(), (int)c1.getGridY(), (int)c22.getGridX(), (int)c22.getGridY(), 0, raster);
            }
        }
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        HighlightEOBJ.getHighlightedEObjsInternal(this.getGeometric(), list, wantNodes, wantArcs);
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, Set<NodeInst> set) {
        HighlightEOBJ.getHighlightedNodesInternal(this.getGeometric(), set);
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, Set<ArcInst> set) {
        HighlightEOBJ.getHighlightedArcsInternal(this.getGeometric(), set);
    }

    @Override
    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
        PortInst pi;
        NodeInst ni;
        ElectricObject eObj = this.eobj;
        if (eObj instanceof NodeInst && (ni = (NodeInst)eObj).getNumPortInsts() == 1 && (pi = ni.getOnlyPortInst()) != null) {
            eObj = pi;
        }
        if (eObj instanceof PortInst) {
            PortInst pi2 = (PortInst)eObj;
            nets = NetworkTool.getNetworksOnPort(pi2, netlist, nets);
        } else if (eObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)eObj;
            int width = netlist.getBusWidth(ai);
            for (int i2 = 0; i2 < width; ++i2) {
                Network net = netlist.getNetwork((ArcInst)eObj, i2);
                if (net == null) continue;
                nets.add(net);
            }
        }
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        ElectricObject eObj = this.eobj;
        if (eObj instanceof PortInst) {
            eObj = ((PortInst)eObj).getNodeInst();
        }
        if (eObj instanceof Geometric) {
            Geometric geom = (Geometric)eObj;
            return geom.getBounds();
        }
        return null;
    }

    @Override
    public Geometric getGeometric() {
        Geometric retVal = null;
        if (this.eobj instanceof PortInst) {
            retVal = ((PortInst)this.eobj).getNodeInst();
        } else if (this.eobj instanceof Geometric) {
            retVal = (Geometric)this.eobj;
        }
        return retVal;
    }

    @Override
    Highlight overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter, boolean change) {
        Point2D slop = wnd.deltaScreenToDatabase(10, 10);
        double directHitDist = slop.getX();
        Point2D start = wnd.screenToDatabase(x, y);
        Rectangle2D.Double searchArea = new Rectangle2D.Double(start.getX(), start.getY(), 0.0, 0.0);
        ElectricObject eobj = this.eobj;
        if (eobj instanceof PortInst) {
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (eobj instanceof Geometric) {
            boolean specialSelect = ToolBar.isSelectSpecial();
            List<Highlight> gotAll = Highlighter.checkOutObject((Geometric)eobj, true, false, specialSelect, searchArea, wnd, directHitDist, false, wnd.getGraphicsPreferences().isShowTempNames());
            if (gotAll.isEmpty()) {
                return null;
            }
            boolean found = false;
            Highlight result = this;
            for (Highlight got : gotAll) {
                ElectricObject hObj;
                ElectricObject hReal;
                if (!(got instanceof HighlightEOBJ)) {
                    System.out.println("Error?");
                }
                if ((hReal = (hObj = got.getElectricObject())) instanceof PortInst) {
                    hReal = ((PortInst)hReal).getNodeInst();
                }
                for (Highlight alreadyDone : highlighter.getHighlights()) {
                    if (!(alreadyDone instanceof HighlightEOBJ)) continue;
                    HighlightEOBJ alreadyHighlighted = (HighlightEOBJ)alreadyDone;
                    ElectricObject aHObj = alreadyHighlighted.getElectricObject();
                    ElectricObject aHReal = aHObj;
                    if (aHReal instanceof PortInst) {
                        aHReal = ((PortInst)aHReal).getNodeInst();
                    }
                    if (hReal != aHReal) continue;
                    found = true;
                    if (hObj == aHObj && alreadyHighlighted.point == ((HighlightEOBJ)got).point) break;
                    if (change) {
                        Highlight updated = highlighter.setPoint(alreadyHighlighted, got.getElectricObject(), ((HighlightEOBJ)got).point);
                        if (alreadyHighlighted != this) break;
                        result = updated;
                        break;
                    }
                    result = new HighlightEOBJ(alreadyHighlighted, got.getElectricObject(), ((HighlightEOBJ)got).point);
                    break;
                }
                if (!found) continue;
                break;
            }
            return result;
        }
        return null;
    }

    @Override
    public String getInfo() {
        Object description = "";
        ElectricObject realObj = this.eobj;
        if (realObj instanceof PortInst) {
            realObj = ((PortInst)realObj).getNodeInst();
        }
        if (realObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)realObj;
            description = "Node " + ni.describe(true);
        } else if (realObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            description = "Arc " + ai.describe(true);
        }
        return description;
    }
}

