/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightEOBJ;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Set;

class HighlightArea
extends Highlight {
    protected Rectangle2D bounds = new Rectangle2D.Double();

    HighlightArea(Cell c2, Color col, Rectangle2D area) {
        super(c2, col, false);
        this.bounds.setRect(area);
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g2, long highOffX, long highOffY, boolean onlyHighlight) {
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g2.getColor();
            g2.setColor(this.color);
        }
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY())};
        HighlightArea.drawOutlineFromPoints(wnd, g2, points, highOffX, highOffY, false, false);
        if (oldColor != null) {
            g2.setColor(oldColor);
        }
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            if (!(ah instanceof HighlightEOBJ)) continue;
            ElectricObject eobj = ((HighlightEOBJ)ah).eobj;
            if (eobj instanceof ArcInst) {
                if (!wantArcs) continue;
                list.add((ArcInst)eobj);
                continue;
            }
            if (eobj instanceof NodeInst) {
                if (!wantNodes) continue;
                list.add((NodeInst)eobj);
                continue;
            }
            if (!(eobj instanceof PortInst) || !wantNodes) continue;
            list.add(((PortInst)eobj).getNodeInst());
        }
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, Set<NodeInst> set) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            if (!(ah instanceof HighlightEOBJ)) continue;
            ElectricObject eobj = ((HighlightEOBJ)ah).eobj;
            if (eobj instanceof NodeInst) {
                set.add((NodeInst)eobj);
                continue;
            }
            if (!(eobj instanceof PortInst)) continue;
            set.add(((PortInst)eobj).getNodeInst());
        }
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, Set<ArcInst> set) {
        List<Highlight> inArea = Highlighter.findAllInArea(highlighter, this.cell, false, false, false, false, false, this.bounds, null);
        for (Highlight ah : inArea) {
            ElectricObject eobj;
            if (!(ah instanceof HighlightEOBJ) || !((eobj = ((HighlightEOBJ)ah).eobj) instanceof ArcInst)) continue;
            set.add((ArcInst)eobj);
        }
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return this.bounds;
    }

    @Override
    public String getInfo() {
        String description = "Area from " + this.bounds.getMinX() + "<=X<=" + this.bounds.getMaxX() + " and " + this.bounds.getMinY() + "<=Y<=" + this.bounds.getMaxY();
        return description;
    }
}

